/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.table.ITableExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.table.TableChains;
import org.eclipse.scout.rt.client.res.AttachmentSupport;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.TableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTableRowBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.CheckableStyle;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.DefaultTableEventHistory;
import org.eclipse.scout.rt.client.ui.basic.table.GroupingStyle;
import org.eclipse.scout.rt.client.ui.basic.table.HierarchicalStyle;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.IReloadHandler;
import org.eclipse.scout.rt.client.ui.basic.table.ISummaryCellBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableCompactHandler;
import org.eclipse.scout.rt.client.ui.basic.table.ITableCompactHandlerProvider;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowTileMapping;
import org.eclipse.scout.rt.client.ui.basic.table.ITableTileGridMediator;
import org.eclipse.scout.rt.client.ui.basic.table.ITableTileGridMediatorProvider;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;
import org.eclipse.scout.rt.client.ui.basic.table.ITileTableHeader;
import org.eclipse.scout.rt.client.ui.basic.table.MobileSummaryCellBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.SummaryCellBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableEventBuffer;
import org.eclipse.scout.rt.client.ui.basic.table.TableListeners;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowTileMapping;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.controls.AbstractTableControl;
import org.eclipse.scout.rt.client.ui.basic.table.controls.ITableControl;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizerProvider;
import org.eclipse.scout.rt.client.ui.basic.table.internal.InternalTableRow;
import org.eclipse.scout.rt.client.ui.basic.table.menus.OrganizeColumnsMenu;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.ITableOrganizer;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.ITableOrganizerProvider;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.TableUserFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.UserTableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IColumnAwareUserFilterState;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilter;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilterState;
import org.eclipse.scout.rt.client.ui.dnd.TextTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.classid.ITypeWithClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.platform.util.visitor.CollectingVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeTraversals;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="e88f7f88-9747-40ea-88bd-744803aef7a7")
public abstract class AbstractTable
extends AbstractWidget
implements ITable,
IContributionOwner,
IExtensibleObject {
    private static final String AUTO_DISCARD_ON_DELETE = "AUTO_DISCARD_ON_DELETE";
    private static final String SORT_VALID = "SORT_VALID";
    private static final String INITIAL_MULTI_LINE_TEXT = "INITIAL_MULTI_LINE_TEXT";
    private static final String ACTION_RUNNING = "ACTION_RUNNING";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTable.class);
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"AUTO_DISCARD_ON_DELETE", "SORT_VALID", "INITIAL_MULTI_LINE_TEXT", "ACTION_RUNNING"});
    private final OptimisticLock m_initLock;
    private List<ITableRow> m_rows;
    private List<ITableRow> m_rootRows;
    private final Object m_cachedRowsLock;
    private final Map<CompositeObject, ITableRow> m_rowsByKey;
    private final Map<CompositeObject, ITableRow> m_deletedRows;
    private final List<ITableRowFilter> m_rowFilters;
    private final AttachmentSupport m_attachmentSupport;
    private final TableListeners m_listeners;
    private final Object m_cachedFilteredRowsLock;
    private final ObjectExtensions<AbstractTable, ITableExtension<? extends AbstractTable>> m_objectExtensions;
    private byte m_flags;
    private ColumnSet m_columnSet;
    private List<ITableRow> m_cachedRows;
    private List<ITableRow> m_selectedRows = new ArrayList<ITableRow>();
    private Set<ITableRow> m_checkedRows = new LinkedHashSet<ITableRow>();
    private Map<Class<?>, Class<? extends IMenu>> m_menuReplacementMapping;
    private ITableUIFacade m_uiFacade;
    private String m_userPreferenceContext;
    private int m_tableChanging;
    private AbstractEventBuffer<TableEvent> m_eventBuffer;
    private int m_eventBufferLoopDetection;
    private Set<ITableRow> m_rowDecorationBuffer = new HashSet<ITableRow>();
    private Map<Integer, Set<ITableRow>> m_rowValueChangeBuffer = new HashMap<Integer, Set<ITableRow>>();
    private P_CellEditorContext m_editContext;
    private IBooleanColumn m_checkableColumn;
    private List<ITableRow> m_cachedFilteredRows;
    private IEventHistory<TableEvent> m_eventHistory;
    private ContributionComposite m_contributionHolder;
    private List<ITableControl> m_tableControls;
    private IReloadHandler m_reloadHandler;
    private ITableCompactHandler m_compactHandler;
    private ISummaryCellBuilder m_summaryCellBuilder;
    private int m_valueChangeTriggerEnabled = 1;
    private boolean m_treeStructureDirty;

    public AbstractTable() {
        this(true);
    }

    public AbstractTable(boolean callInitializer) {
        super(false);
        this.m_listeners = new TableListeners();
        this.m_cachedRowsLock = new Object();
        this.m_cachedFilteredRowsLock = new Object();
        this.m_rows = Collections.synchronizedList(new ArrayList(1));
        this.m_rootRows = Collections.synchronizedList(new ArrayList(1));
        this.m_rowsByKey = Collections.synchronizedMap(new HashMap());
        this.m_deletedRows = new HashMap<CompositeObject, ITableRow>();
        this.m_rowFilters = new ArrayList<ITableRowFilter>(1);
        this.m_attachmentSupport = (AttachmentSupport)BEANS.get(AttachmentSupport.class);
        this.m_initLock = new OptimisticLock();
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        this.addTableListener(e -> {
            try {
                this.interceptRowsSelected(e.getRows());
            }
            catch (Exception ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
            }
        }, new Integer[]{103});
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<? extends ITableExtension<? extends AbstractTable>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ITableExtension<? extends AbstractTable> createLocalExtension() {
        return new LocalTableExtension<AbstractTable>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @Override
    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        ITypeWithClassId container = this.getContainer();
        if (container != null) {
            return simpleClassId + "_" + container.classId();
        }
        return simpleClassId;
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    protected String getConfiguredDefaultIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=25.0)
    protected boolean getConfiguredRowIconVisible() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=27.0)
    protected int getConfiguredRowIconColumnWidth() {
        return 34;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredMultiSelect() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=32.0)
    protected boolean getConfiguredMultiCheck() {
        return true;
    }

    @ConfigProperty(value="MENU_CLASS")
    @Order(value=35.0)
    protected Class<? extends IMenu> getConfiguredDefaultMenu() {
        return null;
    }

    protected Class<? extends IMenu> getDefaultMenuInternal() {
        return this.getConfiguredDefaultMenu();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredAutoDiscardOnDelete() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredSortEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredHeaderEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=75.0)
    protected boolean getConfiguredHeaderMenusEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=77.0)
    protected boolean getConfiguredClientUiPreferencesEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredAutoResizeColumns() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="TABLE_COLUMN")
    @Order(value=102.0)
    protected Class<? extends AbstractBooleanColumn> getConfiguredCheckableColumn() {
        return null;
    }

    @ConfigProperty(value="LONG")
    @Order(value=190.0)
    protected long getConfiguredDropMaximumSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=190.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=190.0)
    protected final int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredKeyboardNavigation() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredScrollToSelection() {
        return false;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=240.0)
    protected GroupingStyle getConfiguredGroupingStyle() {
        return GroupingStyle.TOP;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=250.0)
    protected HierarchicalStyle getConfiguredHierarchicalStyle() {
        return HierarchicalStyle.DEFAULT;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=260.0)
    protected CheckableStyle getConfiguredCheckableStyle() {
        return CheckableStyle.CHECKBOX;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected TriState getConfiguredTruncatedCellTooltipEnabled() {
        return TriState.UNDEFINED;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredTileMode() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=290.0)
    protected boolean getConfiguredCompact() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected final TransferObject execDrag(List<ITableRow> rows) {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execDrop(ITableRow row, TransferObject t) {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected TransferObject execCopy(List<? extends ITableRow> rows) {
        if (!CollectionUtility.hasElements(rows)) {
            return null;
        }
        StringBuilder plainText = new StringBuilder();
        List<IColumn<?>> columns = this.getColumnSet().getVisibleColumns();
        boolean firstRow = true;
        for (ITableRow iTableRow : rows) {
            this.appendCopyTextForRow(plainText, iTableRow, firstRow, columns);
            firstRow = false;
        }
        TextTransferObject textTransferObject = new TextTransferObject(plainText.toString());
        return textTransferObject;
    }

    protected void appendCopyTextForRow(StringBuilder clipboardPlainText, ITableRow row, boolean firstRow, List<IColumn<?>> columns) {
        if (!firstRow) {
            clipboardPlainText.append(System.getProperty("line.separator"));
        }
        boolean firstColumn = true;
        for (IColumn<?> column : columns) {
            this.appendCopyTextForColumn(clipboardPlainText, row, column, firstColumn);
            firstColumn = false;
        }
    }

    protected void appendCopyTextForColumn(StringBuilder clipboardPlainText, ITableRow row, IColumn<?> column, boolean firstColumn) {
        boolean value;
        String text = column instanceof IBooleanColumn ? ((value = BooleanUtility.nvl((Boolean)((Boolean)((IBooleanColumn)column).getValue(row)), (boolean)false)) ? "X" : "") : StringUtility.emptyIfNull((Object)row.getCell(column).getText());
        if (text != null && row.getCell(column).isHtmlEnabled()) {
            text = HTML.raw((CharSequence[])new CharSequence[]{text}).toPlainText();
        }
        if (!firstColumn) {
            clipboardPlainText.append("\t");
        }
        clipboardPlainText.append(this.unwrapText(text));
    }

    protected String unwrapText(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return Arrays.stream(s.split("[\n\r]")).map(line -> line.replaceAll("\t", " ")).map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.joining(" "));
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execContentChanged() {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateCell(Cell view, ITableRow row, IColumn<?> col) {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execInitTable() {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execDisposeTable() {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execRowClick(ITableRow row, MouseButton mouseButton) {
        TableEvent e = new TableEvent((ITable)this, 810, CollectionUtility.arrayList((Object)row));
        this.fireTableEventInternal(e);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execRowAction(ITableRow row) {
        Class<? extends IMenu> defaultMenuType = this.getDefaultMenuInternal();
        if (defaultMenuType != null) {
            try {
                this.runMenu(defaultMenuType);
            }
            catch (Exception ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
            }
        } else {
            TableEvent e = new TableEvent((ITable)this, 104, CollectionUtility.arrayList((Object)row));
            this.fireTableEventInternal(e);
        }
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execRowsSelected(List<? extends ITableRow> rows) {
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execDecorateRow(ITableRow row) {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execAppLinkAction(String ref) {
    }

    @ConfigOperation
    @Order(value=130.0)
    protected void execRowsChecked(Collection<? extends ITableRow> rows) {
    }

    @ConfigOperation
    @Order(value=140.0)
    protected ITile execCreateTile(ITableRow row) {
        return null;
    }

    protected void addHeaderMenus(OrderedCollection<IMenu> menus) {
        menus.addLast((IOrdered)new OrganizeColumnsMenu(this));
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    protected List<Class<? extends ITableControl>> getConfiguredTableControls() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, ITableControl.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    private List<Class<? extends IColumn>> getConfiguredColumns() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List columns = ConfigurationUtility.filterClasses((Class[])dca, IColumn.class);
        return ConfigurationUtility.removeReplacedClasses((List)columns);
    }

    private List<Class<? extends IKeyStroke>> getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    private Class<? extends ITileTableHeader> getConfiguredTileTableHeader() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, ITileTableHeader.class);
        return (Class)CollectionUtility.firstElement((List)ConfigurationUtility.removeReplacedClasses((List)fca));
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_eventHistory = this.createEventHistory();
        this.m_eventBuffer = this.createEventBuffer();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(this.createUIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setLoading(false);
        this.setGroupingStyle(this.getConfiguredGroupingStyle());
        this.setHierarchicalStyle(this.getConfiguredHierarchicalStyle());
        this.setCheckableStyle(this.getConfiguredCheckableStyle());
        this.setTitle(this.getConfiguredTitle());
        this.setAutoDiscardOnDelete(this.getConfiguredAutoDiscardOnDelete());
        this.setSortEnabled(this.getConfiguredSortEnabled());
        this.setDefaultIconId(this.getConfiguredDefaultIconId());
        this.setCssClass(this.getConfiguredCssClass());
        this.setRowIconVisible(this.getConfiguredRowIconVisible());
        this.setRowIconColumnWidth(this.getConfiguredRowIconColumnWidth());
        this.setHeaderVisible(this.getConfiguredHeaderVisible());
        this.setHeaderEnabled(this.getConfiguredHeaderEnabled());
        this.setHeaderMenusEnabled(this.getConfiguredHeaderMenusEnabled());
        this.setAutoResizeColumns(this.getConfiguredAutoResizeColumns());
        this.setCheckable(this.getConfiguredCheckable());
        this.setMultiCheck(this.getConfiguredMultiCheck());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setInitialMultilineText(this.getConfiguredMultilineText());
        this.setMultilineText(this.getConfiguredMultilineText());
        this.setKeyboardNavigation(this.getConfiguredKeyboardNavigation());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setDropMaximumSize(this.getConfiguredDropMaximumSize());
        this.setScrollToSelection(this.getConfiguredScrollToSelection());
        this.setTableStatusVisible(this.getConfiguredTableStatusVisible());
        this.setTextFilterEnabled(this.getConfiguredTextFilterEnabled());
        this.setTruncatedCellTooltipEnabled(this.getConfiguredTruncatedCellTooltipEnabled());
        this.setClientUiPreferencesEnabled(this.getConfiguredClientUiPreferencesEnabled());
        if (this.getTableCustomizer() == null) {
            this.setTableCustomizer(this.createTableCustomizer());
        }
        this.createColumnsInternal();
        this.createTableControlsInternal();
        this.initMenus();
        List<Class<? extends IKeyStroke>> ksClasses = this.getConfiguredKeyStrokes();
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>(ksClasses.size());
        for (Class<? extends IKeyStroke> clazz : ksClasses) {
            IKeyStroke ks = (IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, clazz);
            ks.init();
            if (ks.getKeyStroke() == null) continue;
            ksList.add(ks);
        }
        Class<? extends IMenu> defaultMenuType = this.getDefaultMenuInternal();
        if (defaultMenuType != null || ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"execRowAction", (Class[])new Class[]{ITableRow.class}, this.getClass())) {
            ksList.add(new KeyStroke("ENTER"){

                @Override
                protected void execAction() {
                    AbstractTable.this.fireRowAction(AbstractTable.this.getSelectedRow());
                }
            });
        }
        List contributedKeyStrokes = this.m_contributionHolder.getContributionsByClass(IKeyStroke.class);
        ksList.addAll(contributedKeyStrokes);
        this.setKeyStrokes(ksList);
        this.setTableOrganizer(this.createTableOrganizer());
        this.setTileMode(this.getConfiguredTileMode());
        this.setSummaryCellBuilder(this.createSummaryCellBuilder());
        this.setCompactHandler(this.createCompactHandler());
        this.setCompact(this.getConfiguredCompact());
        this.addTableListener(new TableAdapter(){

            @Override
            public void tableChanged(TableEvent e) {
                IEventHistory<TableEvent> h = AbstractTable.this.getEventHistory();
                if (h != null) {
                    h.notifyEvent(e);
                }
                switch (e.getType()) {
                    case 730: {
                        if (e.getDragObject() != null) break;
                        try {
                            e.setDragObject(AbstractTable.this.interceptDrag(e.getRows()));
                        }
                        catch (RuntimeException ex) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                        }
                        break;
                    }
                    case 740: {
                        if (e.getDropObject() == null || !AbstractTable.this.isEnabled()) break;
                        try {
                            AbstractTable.this.interceptDrop(e.getFirstRow(), e.getDropObject());
                        }
                        catch (RuntimeException ex) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                        }
                        break;
                    }
                    case 760: {
                        if (e.getCopyObject() != null) break;
                        try {
                            e.setCopyObject(AbstractTable.this.interceptCopy(e.getRows()));
                        }
                        catch (RuntimeException ex) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                        }
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 105: {
                        if (!AbstractTable.this.isValueChangeTriggerEnabled()) break;
                        try {
                            AbstractTable.this.interceptContentChanged();
                        }
                        catch (RuntimeException ex) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                        }
                        break;
                    }
                    case 850: {
                        try {
                            AbstractTable.this.interceptRowsChecked(e.getRows());
                        }
                        catch (RuntimeException ex) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                        }
                        break;
                    }
                    case 1: 
                    case 780: {
                        AbstractTable.this.checkIfColumnPreventsUiSortForTable();
                    }
                }
            }
        }, new Integer[]{730, 740, 760, 105, 102, 100, 101, 850, 780, 1});
    }

    protected void initMenus() {
        List<Class<? extends IMenu>> ma = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        Map replacements = ConfigurationUtility.getReplacementMapping(ma);
        if (!replacements.isEmpty()) {
            this.m_menuReplacementMapping = replacements;
        }
        for (Class<? extends IMenu> clazz : ma) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, clazz);
            menus.addOrdered((IOrdered)menu);
        }
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        this.addHeaderMenus((OrderedCollection<IMenu>)menus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.setContextMenu(new TableContextMenu(this, (List<? extends IMenu>)menus.getOrderedList()));
    }

    @Override
    public AbstractEventBuffer<TableEvent> createEventBuffer() {
        return (AbstractEventBuffer)BEANS.get(TableEventBuffer.class);
    }

    protected AbstractEventBuffer<TableEvent> getEventBuffer() {
        return this.m_eventBuffer;
    }

    private void initColumnsInternal() {
        this.getColumnSet().initColumns();
    }

    private void disposeColumnsInternal() {
        this.getColumnSet().disposeColumns();
    }

    private void createTableControlsInternal() {
        List<Class<? extends ITableControl>> tcs = this.getConfiguredTableControls();
        OrderedCollection tableControls = new OrderedCollection();
        for (Class<? extends ITableControl> clazz : tcs) {
            ITableControl tableControl = (ITableControl)ConfigurationUtility.newInnerInstance((Object)this, clazz);
            ((AbstractTableControl)tableControl).setTable(this);
            tableControls.addOrdered((IOrdered)tableControl);
        }
        this.m_tableControls = tableControls.getOrderedList();
    }

    protected ITileTableHeader createTileTableHeader() {
        ITileTableHeader tileTableHeader = null;
        Class<? extends ITileTableHeader> tth = this.getConfiguredTileTableHeader();
        if (tth != null) {
            tileTableHeader = (ITileTableHeader)ConfigurationUtility.newInnerInstance((Object)this, tth);
            tileTableHeader.setParentInternal(this);
            tileTableHeader.init();
            if (tileTableHeader instanceof IGroupBox) {
                ((IGroupBox)((Object)tileTableHeader)).rebuildFieldGrid();
            }
        }
        return tileTableHeader;
    }

    @Override
    public ITileTableHeader getTileTableHeader() {
        return (ITileTableHeader)this.propertySupport.getProperty("tileTableHeader");
    }

    @Override
    public void setTileTableHeader(ITileTableHeader tileTableHeader) {
        this.propertySupport.setProperty("tileTableHeader", (Object)tileTableHeader);
    }

    protected ITableTileGridMediator createTableTileGridMediator() {
        return ((ITableTileGridMediatorProvider)BEANS.get(ITableTileGridMediatorProvider.class)).createTableTileGridMediator(this);
    }

    @Override
    public ITableTileGridMediator getTableTileGridMediator() {
        return (ITableTileGridMediator)this.propertySupport.getProperty("tableTileGridMediator");
    }

    @Override
    public void setTableTileGridMediator(ITableTileGridMediator mediator) {
        this.propertySupport.setProperty("tableTileGridMediator", (Object)mediator);
    }

    private void createColumnsInternal() {
        List<Class<? extends IColumn>> ca = this.getConfiguredColumns();
        OrderedCollection columns = new OrderedCollection();
        for (Class<? extends IColumn> clazz : ca) {
            IColumn<?> column = (IColumn)ConfigurationUtility.newInnerInstance((Object)this, clazz);
            columns.addOrdered((IOrdered)column);
        }
        List contributedColumns = this.m_contributionHolder.getContributionsByClass(IColumn.class);
        for (IColumn c : contributedColumns) {
            columns.addOrdered((IOrdered)c);
        }
        this.injectColumnsInternal(columns);
        ExtensionUtility.moveModelObjects((Iterable)columns);
        this.m_columnSet = new ColumnSet(this, columns.getOrderedList());
        if (this.getConfiguredCheckableColumn() != null) {
            AbstractBooleanColumn checkableColumn = this.getColumnSet().getColumnByClass(this.getConfiguredCheckableColumn());
            this.setCheckableColumn(checkableColumn);
        }
        PropertyChangeListener columnVisibleListener = evt -> {
            this.checkIfColumnPreventsUiSortForTable();
            this.checkIfContextColumnIsVisible();
        };
        for (IColumn<?> column : this.m_columnSet.getColumns()) {
            column.addPropertyChangeListener("visible", columnVisibleListener);
        }
    }

    protected void injectColumnsInternal(OrderedCollection<IColumn<?>> columns) {
        ITableCustomizer c = this.getTableCustomizer();
        if (c != null) {
            c.injectCustomColumns(columns);
        }
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    protected ITableUIFacade createUIFacade() {
        return new P_TableUIFacade();
    }

    @Override
    public String getUserPreferenceContext() {
        return this.m_userPreferenceContext;
    }

    @Override
    public void setUserPreferenceContext(String context) {
        this.m_userPreferenceContext = context;
        if (this.isInitDone()) {
            try {
                this.reinit();
            }
            catch (RuntimeException e) {
                LOG.error("Failed re-initializing table {}", (Object)this.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    protected final void initInternal() {
        block6: {
            super.initInternal();
            try {
                if (!this.m_initLock.acquire()) break block6;
                try {
                    this.setTableChanging(true);
                    this.initTableInternal();
                    this.interceptInitTable();
                }
                finally {
                    this.setTableChanging(false);
                }
            }
            finally {
                this.m_initLock.release();
            }
        }
    }

    protected void initTableInternal() {
        this.initColumnsInternal();
        if (this.getUserFilterManager() == null) {
            this.setUserFilterManager(this.createUserFilterManager());
        }
        this.setTileMode(ClientUIPreferences.getInstance().getTableTileMode(this, this.isTileMode()));
    }

    @Override
    protected final void disposeInternal() {
        try {
            this.disposeTableInternal();
            this.interceptDisposeTable();
        }
        catch (Exception e) {
            LOG.error("Could not dispose table [{}]", (Object)this.getClass().getName(), (Object)e);
        }
        super.disposeInternal();
    }

    protected void disposeTableInternal() {
        this.disposeColumnsInternal();
    }

    @Override
    public void doAppLinkAction(String ref) {
        if (this.isActionRunning()) {
            return;
        }
        try {
            this.setActionRunning(true);
            this.interceptAppLinkAction(ref);
        }
        finally {
            this.setActionRunning(false);
        }
    }

    @Override
    public void addAttachment(BinaryResource attachment) {
        this.m_attachmentSupport.addAttachment(attachment);
    }

    @Override
    public Set<BinaryResource> getAttachments() {
        return this.m_attachmentSupport.getAttachments();
    }

    @Override
    public BinaryResource getAttachment(String filename) {
        return this.m_attachmentSupport.getAttachment(filename);
    }

    @Override
    public void removeAttachment(BinaryResource attachment) {
        this.m_attachmentSupport.removeAttachment(attachment);
    }

    @Override
    public List<ITableRowFilter> getRowFilters() {
        return CollectionUtility.arrayList(this.m_rowFilters);
    }

    @Override
    public void addRowFilter(ITableRowFilter filter) {
        if (filter != null && !this.m_rowFilters.contains(filter)) {
            this.m_rowFilters.add(filter);
            this.applyRowFilters();
        }
    }

    @Override
    public void removeRowFilter(ITableRowFilter filter) {
        if (filter != null && this.m_rowFilters.remove(filter)) {
            this.removeUserRowFilters();
        }
    }

    public void removeUserRowFilters() {
        this.removeUserRowFilters(true);
    }

    public void removeUserRowFilters(boolean applyRowFilters) {
        for (ITableRowFilter filter : this.getRowFilters()) {
            if (!(filter instanceof UserTableRowFilter)) continue;
            this.m_rowFilters.remove(filter);
        }
        if (applyRowFilters) {
            this.applyRowFilters();
        }
    }

    @Override
    public void applyRowFilters() {
        boolean filterChanged = this.applyRowFiltersInternal();
        if (filterChanged) {
            this.fireRowFilterChanged();
        }
    }

    private boolean applyRowFiltersInternal() {
        boolean filterChanged = false;
        for (ITableRow row : this.m_rows) {
            boolean wasFilterAccepted = row.isFilterAccepted();
            this.applyRowFiltersInternal((InternalTableRow)row);
            if (row.isFilterAccepted() == wasFilterAccepted) continue;
            filterChanged = true;
        }
        return filterChanged;
    }

    private void applyRowFiltersInternal(InternalTableRow row) {
        ArrayList<ITableRowFilter> rejectingFilters = new ArrayList<ITableRowFilter>();
        row.setFilterAcceptedInternal(true);
        row.setRejectedByUser(false);
        if (!this.m_rowFilters.isEmpty()) {
            for (ITableRowFilter filter : this.m_rowFilters) {
                if (filter.accept(row)) continue;
                row.setFilterAcceptedInternal(false);
                if (this.isSelectedRow(row)) {
                    this.deselectRow(row);
                }
                rejectingFilters.add(filter);
            }
        }
        row.setRejectedByUser(row.isRejectedByUser() || rejectingFilters.size() == 1 && rejectingFilters.get(0) instanceof IUserFilter);
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    private boolean isSortValid() {
        return FLAGS_BIT_HELPER.isBitSet(SORT_VALID, this.m_flags);
    }

    private void setSortValid(boolean valid) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(SORT_VALID, valid, this.m_flags);
    }

    private boolean isActionRunning() {
        return FLAGS_BIT_HELPER.isBitSet(ACTION_RUNNING, this.m_flags);
    }

    private void setActionRunning(boolean running) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ACTION_RUNNING, running, this.m_flags);
    }

    @Override
    public boolean isAutoResizeColumns() {
        return this.propertySupport.getPropertyBool("autoResizeColumns");
    }

    @Override
    public void setAutoResizeColumns(boolean b) {
        this.propertySupport.setPropertyBool("autoResizeColumns", b);
    }

    @Override
    public void expandAll(ITableRow startRow) {
        this.expandAllInternal(startRow, true);
    }

    @Override
    public void collapseAll(ITableRow startRow) {
        this.expandAllInternal(startRow, false);
    }

    public void expandRows(List<ITableRow> rows) {
        this.expandRowsInternal(rows, true);
    }

    public void collapseRows(List<ITableRow> rows) {
        this.expandRowsInternal(rows, false);
    }

    private void expandAllInternal(ITableRow startRow, final boolean expanded) {
        List<Object> rows = startRow != null ? CollectionUtility.arrayList((Object)startRow) : this.m_rootRows;
        CollectingVisitor<ITableRow> collector = new CollectingVisitor<ITableRow>(){

            protected boolean accept(ITableRow element) {
                return element.isExpanded() ^ expanded;
            }
        };
        rows.forEach(arg_0 -> AbstractTable.lambda$6((CollectingVisitor)collector, arg_0));
        this.expandRowsInternal(collector.getCollection(), expanded);
    }

    protected void expandRowsInternal(List<? extends ITableRow> rows, boolean expanded) {
        try {
            this.setTableChanging(true);
            List changedRows = rows.stream().filter(row -> row.setExpanded(expanded)).collect(Collectors.toList());
            this.fireRowsExpanded(changedRows);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public boolean isExpanded(ITableRow row) {
        return false;
    }

    @Override
    public void setRowExpanded(ITableRow row, boolean expanded) {
        if (row == null || row.isExpanded() == expanded) {
            return;
        }
        this.expandRowsInternal(CollectionUtility.arrayList((Object)row), expanded);
    }

    @Override
    public ColumnSet getColumnSet() {
        return this.m_columnSet;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnSet().getColumnCount();
    }

    @Override
    public List<IColumn<?>> getColumns() {
        return this.getColumnSet().getColumns();
    }

    @Override
    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.getColumnCount());
        for (IColumn<?> col : this.getColumns()) {
            columnNames.add(col.getHeaderCell().getText());
        }
        return columnNames;
    }

    @Override
    public int getVisibleColumnCount() {
        return this.getColumnSet().getVisibleColumnCount();
    }

    @Override
    public IHeaderCell getVisibleHeaderCell(int visibleColumnIndex) {
        return this.getHeaderCell(this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public IHeaderCell getHeaderCell(int columnIndex) {
        return this.getHeaderCell(this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public IHeaderCell getHeaderCell(IColumn<?> col) {
        return col.getHeaderCell();
    }

    @Override
    public ICell getVisibleCell(int rowIndex, int visibleColumnIndex) {
        return this.getVisibleCell(this.getRow(rowIndex), visibleColumnIndex);
    }

    @Override
    public ICell getVisibleCell(ITableRow row, int visibleColumnIndex) {
        return this.getCell(row, this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public ICell getCell(int rowIndex, int columnIndex) {
        return this.getCell(this.getRow(rowIndex), this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public ICell getSummaryCell(int rowIndex) {
        return this.getSummaryCell(this.getRow(rowIndex));
    }

    @Override
    public ICell getSummaryCell(ITableRow row) {
        return this.getSummaryCellBuilder().build(row);
    }

    @Override
    public ICell getCell(ITableRow row, IColumn<?> col) {
        if ((row = this.resolveRow(row)) == null || col == null) {
            return null;
        }
        return row.getCell(col.getColumnIndex());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isCellEditable(this.getRow(rowIndex), this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public boolean isCellEditable(ITableRow row, IColumn<?> column) {
        return row != null && column != null && column.isCellEditable(row);
    }

    @Override
    public boolean isCheckable() {
        return this.propertySupport.getPropertyBool("checkable");
    }

    @Override
    public void setCheckable(boolean b) {
        this.propertySupport.setPropertyBool("checkable", b);
    }

    @Override
    public void setCompact(boolean compact) {
        if (this.propertySupport.setPropertyBool("compact", compact)) {
            this.getCompactHandler().handle(this.isCompact());
        }
    }

    @Override
    public boolean isCompact() {
        return this.propertySupport.getPropertyBool("compact");
    }

    @Override
    public ITableCompactHandler getCompactHandler() {
        return this.m_compactHandler;
    }

    protected ITableCompactHandler createCompactHandler() {
        return ((ITableCompactHandlerProvider)BEANS.get(ITableCompactHandlerProvider.class)).createCompactHandler(this);
    }

    @Override
    public void setCompactHandler(ITableCompactHandler compactHandler) {
        Assertions.assertNotNull((Object)compactHandler);
        if (this.m_compactHandler != null && this.isCompact()) {
            this.m_compactHandler.handle(false);
        }
        this.m_compactHandler = compactHandler;
        if (this.isInitConfigDone()) {
            this.m_compactHandler.handle(this.isCompact());
        }
    }

    protected ITableCompactHandler createSummaryCompactHandler() {
        return this.createCompactHandler().withMoreLinkAvailable(false).withLineCustomizer(line -> line.getTextBlock().setHtmlToPlainTextEnabled(true));
    }

    protected ISummaryCellBuilder createSummaryCellBuilder() {
        if (UserAgentUtility.isMobileDevice()) {
            return new MobileSummaryCellBuilder(this.createSummaryCompactHandler());
        }
        return new SummaryCellBuilder(this);
    }

    @Override
    public ISummaryCellBuilder getSummaryCellBuilder() {
        return this.m_summaryCellBuilder;
    }

    @Override
    public void setSummaryCellBuilder(ISummaryCellBuilder summaryCellBuilder) {
        this.m_summaryCellBuilder = summaryCellBuilder;
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.propertySupport.setPropertyLong("dropMaximumSize", dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.propertySupport.getPropertyInt("dropMaximumSize");
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public void setMultilineText(boolean on) {
        this.propertySupport.setPropertyBool("multilineText", on);
    }

    @Override
    public boolean isInitialMultilineText() {
        return FLAGS_BIT_HELPER.isBitSet(INITIAL_MULTI_LINE_TEXT, this.m_flags);
    }

    @Override
    public void setInitialMultilineText(boolean on) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(INITIAL_MULTI_LINE_TEXT, on, this.m_flags);
    }

    @Override
    public boolean hasKeyboardNavigation() {
        return this.propertySupport.getPropertyBool("keyboardNavigation");
    }

    @Override
    public void setKeyboardNavigation(boolean on) {
        this.propertySupport.setPropertyBool("keyboardNavigation", on);
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean b) {
        this.propertySupport.setPropertyBool("multiSelect", b);
    }

    @Override
    public boolean isMultiCheck() {
        return this.propertySupport.getPropertyBool("multiCheck");
    }

    @Override
    public void setMultiCheck(boolean b) {
        this.propertySupport.setPropertyBool("multiCheck", b);
    }

    @Override
    public IBooleanColumn getCheckableColumn() {
        return this.m_checkableColumn;
    }

    @Override
    public void setCheckableColumn(IBooleanColumn checkableColumn) {
        this.m_checkableColumn = checkableColumn;
    }

    @Override
    public boolean isAutoDiscardOnDelete() {
        return FLAGS_BIT_HELPER.isBitSet(AUTO_DISCARD_ON_DELETE, this.m_flags);
    }

    @Override
    public void setAutoDiscardOnDelete(boolean on) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(AUTO_DISCARD_ON_DELETE, on, this.m_flags);
    }

    @Override
    public boolean isTableChanging() {
        return this.m_tableChanging > 0;
    }

    @Override
    public void setTableChanging(boolean b) {
        if (b) {
            ++this.m_tableChanging;
            if (this.m_tableChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_tableChanging > 0) {
            Throwable saveEx = null;
            try {
                try {
                    if (this.m_tableChanging == 1) {
                        if (this.m_treeStructureDirty) {
                            this.rebuildTreeStructureInternal();
                        }
                        this.processDecorationBuffer();
                        if (!this.isSortValid()) {
                            this.sort();
                        }
                    }
                }
                catch (RuntimeException | PlatformError t) {
                    saveEx = t;
                    throw t;
                }
            }
            finally {
                block39: {
                    --this.m_tableChanging;
                    if (this.m_tableChanging == 0) {
                        try {
                            try {
                                this.processEventBuffer();
                            }
                            catch (RuntimeException | PlatformError t) {
                                if (saveEx == null) {
                                    saveEx = t;
                                    throw t;
                                }
                                saveEx.addSuppressed(t);
                                try {
                                    this.propertySupport.setPropertiesChanging(false);
                                    break block39;
                                }
                                catch (RuntimeException | PlatformError t2) {
                                    if (saveEx != null) {
                                        saveEx.addSuppressed(t2);
                                        break block39;
                                    }
                                    throw t2;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block40: {
                                try {
                                    this.propertySupport.setPropertiesChanging(false);
                                }
                                catch (RuntimeException | PlatformError t) {
                                    if (saveEx != null) {
                                        saveEx.addSuppressed(t);
                                        break block40;
                                    }
                                    throw t;
                                }
                            }
                            throw throwable;
                        }
                        try {
                            this.propertySupport.setPropertiesChanging(false);
                        }
                        catch (RuntimeException | PlatformError t) {
                            if (saveEx != null) {
                                saveEx.addSuppressed(t);
                            }
                            throw t;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void firePendingEvents() {
        int tableChanging = this.m_tableChanging;
        int i = 0;
        while (i < tableChanging) {
            this.setTableChanging(false);
            ++i;
        }
        i = 0;
        while (i < tableChanging) {
            this.setTableChanging(true);
            ++i;
        }
    }

    @Override
    public List<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.arrayList(this.getKeyStrokesInternal());
    }

    protected List<IKeyStroke> getKeyStrokesInternal() {
        return this.propertySupport.getPropertyList("keyStrokes");
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus(), this.getKeyStrokesInternal(), this.m_tableControls, CollectionUtility.arrayList((Object)this.getTileTableHeader())});
    }

    @Override
    public void setKeyStrokes(List<? extends IKeyStroke> keyStrokes0) {
        this.propertySupport.setPropertyList("keyStrokes", (List)CollectionUtility.arrayListWithoutNullElements(keyStrokes0));
    }

    @Override
    public void requestFocus() {
        this.fireRequestFocus();
    }

    @Override
    public void requestFocusInCell(IColumn<?> column, ITableRow row) {
        if (this.isCellEditable(row, column)) {
            this.fireRequestFocusInCell(column, row);
        }
    }

    private void startCellEdit() {
        if (this.m_editContext == null) {
            return;
        }
        this.m_editContext.getFormField().init();
        TableEvent tableEvent = new TableEvent(this, 807);
        tableEvent.setCellEditor(this.m_editContext.getFormField());
        tableEvent.setRows(Arrays.asList(this.m_editContext.getRow()));
        tableEvent.setColumns(Arrays.asList(this.m_editContext.getColumn()));
        this.fireTableEventInternal(tableEvent);
    }

    private void endCellEdit() {
        if (this.m_editContext == null) {
            return;
        }
        TableEvent tableEvent = new TableEvent(this, 808);
        tableEvent.setCellEditor(this.m_editContext.getFormField());
        this.fireTableEventInternal(tableEvent);
    }

    protected void disposeCellEditor() {
        if (this.m_editContext == null) {
            return;
        }
        this.m_editContext.getFormField().dispose();
        this.m_editContext = null;
    }

    @Override
    public void completeCellEdit() {
        if (this.m_editContext == null) {
            return;
        }
        this.endCellEdit();
        this.m_editContext.getColumn().completeEdit(this.m_editContext.getRow(), this.m_editContext.getFormField());
        this.disposeCellEditor();
    }

    @Override
    public void cancelCellEdit() {
        if (this.m_editContext == null) {
            return;
        }
        this.endCellEdit();
        this.disposeCellEditor();
    }

    @Override
    public ITableRowDataMapper createTableRowDataMapper(Class<? extends AbstractTableRowData> rowType) {
        return this.interceptCreateTableRowDataMapper(rowType);
    }

    @ConfigOperation
    @Order(value=130.0)
    protected ITableRowDataMapper execCreateTableRowDataMapper(Class<? extends AbstractTableRowData> rowType) {
        return new TableRowDataMapper(rowType, this.getColumnSet());
    }

    @Override
    public void exportToTableBeanData(AbstractTableFieldBeanData target) {
        AbstractTableRowData rowData;
        ITableRowDataMapper rowMapper = this.createTableRowDataMapper(target.getRowType());
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            if (rowMapper.acceptExport(row)) {
                rowData = target.addRow();
                rowMapper.exportTableRowData(row, rowData);
            }
            ++i;
        }
        List<ITableRow> deletedRows = this.getDeletedRows();
        for (ITableRow delRow : deletedRows) {
            if (!rowMapper.acceptExport(delRow)) continue;
            rowData = target.addRow();
            rowMapper.exportTableRowData(delRow, rowData);
            rowData.setRowState(3);
        }
    }

    @Override
    public void importFromTableBeanData(AbstractTableFieldBeanData source) {
        this.importFromTableRowBeanData(CollectionUtility.arrayList((Object[])source.getRows()), source.getRowType());
    }

    public void importFromTableRowBeanData(List<? extends AbstractTableRowData> rowDatas, Class<? extends AbstractTableRowData> rowType) {
        TableRow newTableRow;
        this.discardAllDeletedRows();
        int deleteCount = 0;
        ArrayList<TableRow> newRows = new ArrayList<TableRow>(rowDatas.size());
        ITableRowDataMapper mapper = this.createTableRowDataMapper(rowType);
        for (AbstractTableRowData abstractTableRowData : rowDatas) {
            if (abstractTableRowData.getRowState() != 3 && mapper.acceptImport(abstractTableRowData)) {
                newTableRow = new TableRow(this.getColumnSet());
                mapper.importTableRowData(newTableRow, abstractTableRowData);
                newRows.add(newTableRow);
                continue;
            }
            ++deleteCount;
        }
        this.replaceRows(newRows);
        if (deleteCount > 0) {
            try {
                this.setTableChanging(true);
                for (AbstractTableRowData abstractTableRowData : rowDatas) {
                    if (abstractTableRowData.getRowState() != 3 || !mapper.acceptImport(abstractTableRowData)) continue;
                    newTableRow = new TableRow(this.getColumnSet());
                    mapper.importTableRowData(newTableRow, abstractTableRowData);
                    newTableRow.setStatus(0);
                    ITableRow addedRow = this.addRow(newTableRow);
                    this.deleteRow(addedRow);
                }
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.getContextMenu().setChildActions(menus);
    }

    @Override
    public void addMenu(IMenu menu) {
        List<IMenu> menus = this.getMenus();
        menus.add(menu);
        this.setMenus(menus);
    }

    protected void setContextMenu(ITableContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenus", (Object)contextMenu);
    }

    @Override
    public ITableContextMenu getContextMenu() {
        return (ITableContextMenu)this.propertySupport.getProperty("contextMenus");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public boolean runMenu(Class<? extends IMenu> menuType) {
        Class<? extends IMenu> c = this.getReplacingMenuClass(menuType);
        for (IMenu m : this.getMenus()) {
            if (m.getClass() != c) continue;
            m.doAction();
            return true;
        }
        return false;
    }

    private <T extends IMenu> Class<? extends T> getReplacingMenuClass(Class<T> c) {
        Class<? extends IMenu> replacingMenuClass;
        if (this.m_menuReplacementMapping != null && (replacingMenuClass = this.m_menuReplacementMapping.get(c)) != null) {
            return replacingMenuClass;
        }
        return c;
    }

    protected TableUserFilterManager createUserFilterManager() {
        return new TableUserFilterManager(this);
    }

    protected ITableCustomizer createTableCustomizer() {
        return ((ITableCustomizerProvider)BEANS.get(ITableCustomizerProvider.class)).createTableCustomizer(this);
    }

    protected ITableOrganizer createTableOrganizer() {
        return ((ITableOrganizerProvider)BEANS.get(ITableOrganizerProvider.class)).createTableOrganizer(this);
    }

    @Override
    public ITableRow createRow() {
        return new P_TableRowBuilder().createRow();
    }

    @Override
    public ITableRow createRow(Object rowValues) {
        return new P_TableRowBuilder().createRow(rowValues);
    }

    @Override
    public List<ITableRow> createRowsByArray(Object dataArray) {
        return new P_TableRowBuilder().createRowsByArray(dataArray);
    }

    @Override
    public List<ITableRow> createRowsByArray(Object dataArray, int rowStatus) {
        return new P_TableRowBuilder().createRowsByArray(dataArray, rowStatus);
    }

    @Override
    public List<ITableRow> createRowsByMatrix(Object dataMatrixOrReference) {
        return new P_TableRowBuilder().createRowsByMatrix(dataMatrixOrReference);
    }

    @Override
    public List<ITableRow> createRowsByMatrix(Object dataMatrixOrReference, int rowStatus) {
        return new P_TableRowBuilder().createRowsByMatrix(dataMatrixOrReference, rowStatus);
    }

    @Override
    public List<ITableRow> createRowsByCodes(Collection<? extends ICode<?>> codes) {
        return new P_TableRowBuilder().createRowsByCodes(codes);
    }

    @Override
    public void replaceRowsByMatrix(Object dataMatrixOrReference) {
        this.replaceRows(this.createRowsByMatrix(dataMatrixOrReference));
    }

    @Override
    public void replaceRowsByArray(Object dataArray) {
        this.replaceRows(this.createRowsByArray(dataArray));
    }

    @Override
    public void replaceRows(List<? extends ITableRow> newRows) {
        if (this.isAutoDiscardOnDelete()) {
            this.replaceRowsCase1(newRows);
        } else {
            this.replaceRowsCase2(newRows);
        }
    }

    private void replaceRowsCase1(List<? extends ITableRow> newRows) {
        try {
            this.setTableChanging(true);
            List<CompositeObject> selectedKeys = this.getSelectedKeys();
            this.discardAllRows();
            this.addRows(newRows, false);
            this.restoreSelection(selectedKeys);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public List<CompositeObject> getSelectedKeys() {
        ArrayList<CompositeObject> selectedKeys = new ArrayList<CompositeObject>();
        for (ITableRow r : this.getSelectedRows()) {
            selectedKeys.add(new CompositeObject(new Object[]{this.getRowKeys(r)}));
        }
        return selectedKeys;
    }

    @Override
    public void restoreSelection(List<CompositeObject> selectedKeys) {
        ArrayList<ITableRow> selectedRows = new ArrayList<ITableRow>();
        if (!selectedKeys.isEmpty()) {
            for (ITableRow r : this.m_rows) {
                if (!selectedKeys.remove(new CompositeObject(new Object[]{this.getRowKeys(r)}))) continue;
                selectedRows.add(r);
                if (selectedKeys.isEmpty()) break;
            }
        }
        this.selectRows(selectedRows, false);
    }

    private void replaceRowsCase2(List<? extends ITableRow> newRows) {
        try {
            ITableRow existingRow;
            this.setTableChanging(true);
            int[] oldToNew = new int[this.getRowCount()];
            int[] newToOld = new int[newRows.size()];
            Arrays.fill(oldToNew, -1);
            Arrays.fill(newToOld, -1);
            HashMap<CompositeObject, Integer> newRowIndexMap = new HashMap<CompositeObject, Integer>();
            int i = newRows.size() - 1;
            while (i >= 0) {
                newRowIndexMap.put(new CompositeObject(new Object[]{this.getRowKeys(newRows.get(i))}), i);
                --i;
            }
            int mappedCount = 0;
            int i2 = 0;
            int ni = this.getRowCount();
            while (i2 < ni) {
                existingRow = this.m_rows.get(i2);
                Integer newIndex = (Integer)newRowIndexMap.remove(new CompositeObject(new Object[]{this.getRowKeys(existingRow)}));
                if (newIndex != null) {
                    oldToNew[i2] = newIndex;
                    newToOld[newIndex.intValue()] = i2;
                    ++mappedCount;
                }
                ++i2;
            }
            ArrayList<ITableRow> updatedRows = new ArrayList<ITableRow>(mappedCount);
            int i3 = 0;
            while (i3 < oldToNew.length) {
                if (oldToNew[i3] >= 0) {
                    existingRow = this.getRow(i3);
                    ITableRow newRow = newRows.get(oldToNew[i3]);
                    this.replaceRowValues(existingRow, newRow);
                    updatedRows.add(existingRow);
                }
                ++i3;
            }
            ArrayList<ITableRow> deletedRows = new ArrayList<ITableRow>(this.getRowCount() - mappedCount);
            int i4 = 0;
            while (i4 < oldToNew.length) {
                if (oldToNew[i4] < 0) {
                    deletedRows.add(this.m_rows.get(i4));
                }
                ++i4;
            }
            ArrayList<ITableRow> insertedRows = new ArrayList<ITableRow>(newRows.size() - mappedCount);
            int[] insertedRowIndexes = new int[newRows.size() - mappedCount];
            int index = 0;
            int i5 = 0;
            while (i5 < newToOld.length) {
                if (newToOld[i5] < 0) {
                    insertedRows.add(newRows.get(i5));
                    insertedRowIndexes[index] = i5;
                    ++index;
                }
                ++i5;
            }
            this.updateRows(updatedRows);
            this.deleteRows(deletedRows);
            this.addRows(insertedRows, false, insertedRowIndexes);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void replaceRowValues(ITableRow existingRow, ITableRow newRow) {
        try {
            existingRow.setRowChanging(true);
            existingRow.setEnabled(newRow.isEnabled());
            existingRow.setStatus(newRow.getStatus());
            for (IColumn<?> col : this.getColumns()) {
                int columnIndex = col.getColumnIndex();
                Object newValue = null;
                if (columnIndex < newRow.getCellCount()) {
                    newValue = newRow.getCellValue(columnIndex);
                }
                col.parseValueAndSet(existingRow, newValue);
            }
        }
        finally {
            existingRow.setRowPropertiesChanged(false);
            existingRow.setRowChanging(false);
        }
    }

    @Override
    public void updateRow(ITableRow row) {
        if (row != null) {
            this.updateRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void updateAllRows() {
        this.updateRows(this.getRows());
    }

    @Override
    public void setRowState(ITableRow row, int rowState) {
        this.setRowState(CollectionUtility.arrayList((Object)row), rowState);
    }

    @Override
    public void setAllRowState(int rowState) {
        this.setRowState(this.getRows(), rowState);
    }

    @Override
    public void setRowState(Collection<? extends ITableRow> rows, int rowState) {
        try {
            this.setTableChanging(true);
            for (ITableRow iTableRow : rows) {
                iTableRow.setStatus(rowState);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void updateRows(Collection<? extends ITableRow> rows) {
        try {
            this.setTableChanging(true);
            ArrayList<ITableRow> resolvedRowList = new ArrayList<ITableRow>(rows.size());
            for (ITableRow iTableRow : rows) {
                ITableRow resolvedRow = this.resolveRow(iTableRow);
                if (resolvedRow == null) continue;
                resolvedRowList.add(resolvedRow);
                this.updateRowImpl(resolvedRow);
            }
            if (!resolvedRowList.isEmpty()) {
                this.fireRowsUpdated(resolvedRowList);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void updateRowImpl(ITableRow row) {
        if (row != null) {
            this.ensureInvalidColumnsVisible(row);
            Set<Integer> changedColumnValues = row.getUpdatedColumnIndexes(1);
            if (CollectionUtility.containsAny(changedColumnValues, (Object[])((Integer[])IntStream.of(this.getColumnSet().getKeyColumnIndexes()).boxed().toArray(Integer[]::new)))) {
                this.m_rowsByKey.values().remove(row);
                this.m_rowsByKey.put(new CompositeObject(new Object[]{row.getKeyValues()}), row);
            }
            if (CollectionUtility.containsAny(changedColumnValues, (Collection)this.getColumnSet().getSortColumns().stream().map(IColumn::getColumnIndex).collect(Collectors.toSet()))) {
                if (this.isTableChanging()) {
                    this.setSortValid(false);
                } else {
                    this.sort();
                }
            }
            if (!changedColumnValues.isEmpty()) {
                this.enqueueValueChangeTasks(row, changedColumnValues);
            }
            this.enqueueDecorationTasks(row);
        }
    }

    @Override
    public void ensureInvalidColumnsVisible() {
        List<ITableRow> rows = this.getRows();
        for (ITableRow row : rows) {
            this.ensureInvalidColumnsVisible(row);
        }
    }

    private void ensureInvalidColumnsVisible(ITableRow row) {
        for (IColumn<?> col : this.getColumns()) {
            col.ensureVisibleIfInvalid(row);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_rows.size();
    }

    @Override
    public int getDeletedRowCount() {
        return this.m_deletedRows.size();
    }

    @Override
    public int getSelectedRowCount() {
        return this.m_selectedRows.size();
    }

    @Override
    public ITableRow getSelectedRow() {
        return (ITableRow)CollectionUtility.firstElement(this.m_selectedRows);
    }

    @Override
    public List<ITableRow> getSelectedRows() {
        return CollectionUtility.arrayList(this.m_selectedRows);
    }

    @Override
    public boolean isSelectedRow(ITableRow row) {
        if ((row = this.resolveRow(row)) == null) {
            return false;
        }
        return this.m_selectedRows.contains(row);
    }

    @Override
    public boolean isCheckedRow(ITableRow row) {
        if ((row = this.resolveRow(row)) == null) {
            return false;
        }
        return this.m_checkedRows.contains(row);
    }

    @Override
    public void selectRow(int rowIndex) {
        this.selectRow(this.getRow(rowIndex));
    }

    @Override
    public void selectRow(ITableRow row) {
        this.selectRow(row, false);
    }

    @Override
    public void selectRow(ITableRow row, boolean append) {
        this.selectRows(CollectionUtility.arrayList((Object)row), append);
    }

    @Override
    public void selectRows(List<? extends ITableRow> rows) {
        this.selectRows(rows, false);
    }

    @Override
    public void selectRows(List<? extends ITableRow> rows, boolean append) {
        rows = this.resolveRows(rows);
        TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
        if (append) {
            newSelection.addAll(this.m_selectedRows);
        }
        newSelection.addAll(rows);
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITableRow first = newSelection.first();
            newSelection.clear();
            newSelection.add(first);
        }
        if (!CollectionUtility.equalsCollection(this.m_selectedRows, newSelection, (boolean)true)) {
            this.m_selectedRows = new ArrayList<ITableRow>(newSelection);
            ArrayList notificationCopy = CollectionUtility.arrayList(this.m_selectedRows);
            this.fireRowsSelected(notificationCopy);
        }
    }

    @Override
    public void selectFirstRow() {
        this.selectRow(this.getRow(0));
    }

    @Override
    public void selectNextRow() {
        ITableRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() + 1 < this.getRowCount()) {
            this.selectRow(this.getRow(row.getRowIndex() + 1));
        } else if (row == null && this.getRowCount() > 0) {
            this.selectRow(0);
        }
    }

    @Override
    public void selectPreviousRow() {
        ITableRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() - 1 >= 0) {
            this.selectRow(this.getRow(row.getRowIndex() - 1));
        } else if (row == null && this.getRowCount() > 0) {
            this.selectRow(this.getRowCount() - 1);
        }
    }

    @Override
    public void selectLastRow() {
        this.selectRow(this.getRow(this.getRowCount() - 1));
    }

    @Override
    public void deselectRow(ITableRow row) {
        if (row != null) {
            this.deselectRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void deselectRows(List<? extends ITableRow> rows) {
        HashSet<ITableRow> rowsToDeselect = new HashSet<ITableRow>(this.resolveRows(rows));
        if (!CollectionUtility.hasElements(rowsToDeselect)) {
            return;
        }
        TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
        newSelection.addAll(this.m_selectedRows);
        if (newSelection.removeAll(rowsToDeselect)) {
            this.m_selectedRows = new ArrayList<ITableRow>(newSelection);
            this.fireRowsSelected(this.m_selectedRows);
        }
    }

    @Override
    public void selectAllRows() {
        this.selectRows(this.getRows(), false);
    }

    @Override
    public void deselectAllRows() {
        this.selectRow(null, false);
    }

    @Override
    public void selectAllEnabledRows() {
        ArrayList<ITableRow> newList = new ArrayList<ITableRow>();
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            if (row.isEnabled()) {
                newList.add(row);
            } else if (this.isSelectedRow(row)) {
                newList.add(row);
            }
            ++i;
        }
        this.selectRows(newList, false);
    }

    @Override
    public void deselectAllEnabledRows() {
        List<ITableRow> selectedRows = this.getSelectedRows();
        ArrayList<ITableRow> newList = new ArrayList<ITableRow>();
        for (ITableRow selectedRow : selectedRows) {
            if (!selectedRow.isEnabled()) continue;
            newList.add(selectedRow);
        }
        this.deselectRows(newList);
    }

    @Override
    public List<ITableRow> getCheckedRows() {
        return CollectionUtility.arrayList(this.m_checkedRows);
    }

    @Override
    public void checkRow(int row, boolean value) {
        this.checkRow(this.getRow(row), value);
    }

    @Override
    public void checkRow(ITableRow row, boolean value) {
        this.checkRows(CollectionUtility.arrayList((Object)row), value);
    }

    @Override
    public void checkRows(Collection<? extends ITableRow> rows, boolean value) {
        this.checkRows(rows, value, false);
    }

    public void checkRows(Collection<? extends ITableRow> rows, boolean value, boolean enabledRowsOnly) {
        this.setTableChanging(true);
        try {
            try {
                rows = this.resolveRows(rows);
                if (!this.isMultiCheck() && value) {
                    ITableRow rowToCheck = null;
                    for (ITableRow iTableRow : rows) {
                        if (iTableRow.isChecked() == value || enabledRowsOnly && !iTableRow.isEnabled()) continue;
                        rowToCheck = iTableRow;
                        break;
                    }
                    if (rowToCheck != null) {
                        if (!enabledRowsOnly) {
                            this.uncheckAllRows();
                        } else {
                            this.uncheckAllEnabledRows();
                        }
                        this.checkRowImpl(rowToCheck, value);
                        this.fireRowsChecked(CollectionUtility.arrayList((Object)rowToCheck));
                    }
                } else {
                    ArrayList<ITableRow> rowsUpdated = new ArrayList<ITableRow>();
                    for (ITableRow iTableRow : rows) {
                        if (iTableRow.isChecked() == value || enabledRowsOnly && !iTableRow.isEnabled()) continue;
                        this.checkRowImpl(iTableRow, value);
                        rowsUpdated.add(iTableRow);
                    }
                    if (!rowsUpdated.isEmpty()) {
                        if (value) {
                            this.sortCheckedRows();
                        }
                        this.fireRowsChecked(CollectionUtility.arrayList(rowsUpdated));
                    }
                }
            }
            catch (RuntimeException e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                this.setTableChanging(false);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void checkRowImpl(ITableRow row, boolean value) {
        if (!(row instanceof InternalTableRow)) {
            return;
        }
        InternalTableRow internalRow = (InternalTableRow)row;
        if (value) {
            this.m_checkedRows.add(internalRow);
        } else {
            this.m_checkedRows.remove(internalRow);
        }
        if (this.getCheckableColumn() != null) {
            this.getCheckableColumn().setValue(internalRow, Boolean.valueOf(value));
        } else {
            internalRow.setStatusInternal(2);
        }
    }

    @Override
    public void checkAllRows() {
        try {
            this.setTableChanging(true);
            this.checkRows(this.getRows(), true);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    public void checkAllEnabledRows() {
        try {
            this.setTableChanging(true);
            this.checkRows(this.getRows(), true, true);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void uncheckRow(ITableRow row) {
        this.checkRow(row, false);
    }

    @Override
    public void uncheckRows(Collection<? extends ITableRow> rows) {
        this.checkRows(rows, false);
    }

    @Override
    public void uncheckAllEnabledRows() {
        try {
            this.setTableChanging(true);
            this.checkRows(this.getRows(), false, true);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void uncheckAllRows() {
        try {
            this.setTableChanging(true);
            this.checkRows(this.getRows(), false);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public String getDefaultIconId() {
        String iconId = this.propertySupport.getPropertyString("defaultIcon");
        if (iconId != null && iconId.isEmpty()) {
            iconId = null;
        }
        return iconId;
    }

    @Override
    public void setDefaultIconId(String iconId) {
        this.propertySupport.setPropertyString("defaultIcon", iconId);
    }

    @Override
    public boolean isRowIconVisible() {
        return this.propertySupport.getPropertyBool("rowIconVisible");
    }

    @Override
    public void setRowIconVisible(boolean rowIconVisible) {
        this.propertySupport.setPropertyBool("rowIconVisible", rowIconVisible);
    }

    @Override
    public int getRowIconColumnWidth() {
        return this.propertySupport.getPropertyInt("rowIconColumnWidth");
    }

    @Override
    public void setRowIconColumnWidth(int width) {
        this.propertySupport.setPropertyInt("rowIconColumnWidth", width);
    }

    @Override
    public boolean isScrollToSelection() {
        return this.propertySupport.getPropertyBool("scrollToSelection");
    }

    @Override
    public void setScrollToSelection(boolean b) {
        this.propertySupport.setPropertyBool("scrollToSelection", b);
    }

    @Override
    public void scrollToSelection() {
        this.fireTableEventInternal(new TableEvent(this, 830));
    }

    @Override
    public ITableRow getRow(int rowIndex) {
        return (ITableRow)CollectionUtility.getElement(this.getRows(), (int)rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITableRow> getRows() {
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            if (this.m_cachedRows == null) {
                this.m_cachedRows = CollectionUtility.arrayList(this.m_rows);
            }
            return this.m_cachedRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITableRow> getFilteredRows() {
        List<ITableRow> rows = this.getRows();
        if (!this.m_rowFilters.isEmpty()) {
            Object object = this.m_cachedFilteredRowsLock;
            synchronized (object) {
                if (this.m_cachedFilteredRows == null) {
                    if (!this.m_rowFilters.isEmpty()) {
                        ArrayList<ITableRow> filteredRows = new ArrayList<ITableRow>(this.getRowCount());
                        for (ITableRow row : rows) {
                            if (row == null || !row.isFilterAccepted()) continue;
                            filteredRows.add(row);
                        }
                        this.m_cachedFilteredRows = filteredRows;
                    } else {
                        this.m_cachedFilteredRows = CollectionUtility.emptyArrayList();
                    }
                }
                return this.m_cachedFilteredRows;
            }
        }
        return rows;
    }

    @Override
    public int getFilteredRowCount() {
        if (!this.m_rowFilters.isEmpty()) {
            return this.getFilteredRows().size();
        }
        return this.getRowCount();
    }

    @Override
    public ITableRow getFilteredRow(int index) {
        if (!this.m_rowFilters.isEmpty()) {
            ITableRow row = null;
            List<ITableRow> filteredRows = this.getFilteredRows();
            if (index >= 0 && index < filteredRows.size()) {
                row = filteredRows.get(index);
            }
            return row;
        }
        return this.getRow(index);
    }

    @Override
    public int getFilteredRowIndex(ITableRow row) {
        return this.getFilteredRows().indexOf(row);
    }

    @Override
    public List<ITableRow> getNotDeletedRows() {
        ArrayList<ITableRow> notDeletedRows = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() == 3) continue;
            notDeletedRows.add(row);
        }
        return notDeletedRows;
    }

    @Override
    public int getNotDeletedRowCount() {
        return this.getNotDeletedRows().size();
    }

    @Override
    public Object[][] getTableData() {
        Object[][] data = new Object[this.getRowCount()][this.getColumnCount()];
        int r = 0;
        while (r < this.getRowCount()) {
            int c = 0;
            while (c < this.getColumnCount()) {
                data[r][c] = this.getRow(r).getCellValue(c);
                ++c;
            }
            ++r;
        }
        return data;
    }

    @Override
    public Object[][] exportTableRowsAsCSV(List<? extends ITableRow> rows, List<? extends IColumn> columns, boolean includeLineForColumnNames, boolean includeLineForColumnTypes, boolean includeLineForColumnFormat) {
        return TableUtility.exportRowsAsCSV(rows, columns, includeLineForColumnNames, includeLineForColumnTypes, includeLineForColumnFormat);
    }

    @Override
    public List<ITableRow> getRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ITableRow> result = new ArrayList<ITableRow>(rowIndexes.length);
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            ITableRow row = this.getRow(rowIndex);
            if (row != null) {
                result.add(row);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<ITableRow> getDeletedRows() {
        return CollectionUtility.arrayList(this.m_deletedRows.values());
    }

    @Override
    public int getInsertedRowCount() {
        int count = 0;
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<ITableRow> getInsertedRows() {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 1) continue;
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public int getUpdatedRowCount() {
        int count = 0;
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<ITableRow> getUpdatedRows() {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 2) continue;
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public ITableRow addRowByArray(Object dataArray) {
        if (dataArray == null) {
            return null;
        }
        List<ITableRow> result = this.addRowsByMatrix(new Object[]{dataArray});
        return (ITableRow)CollectionUtility.firstElement(result);
    }

    @Override
    public List<ITableRow> addRowsByMatrix(Object dataMatrix) {
        return this.addRowsByMatrix(dataMatrix, 1);
    }

    @Override
    public List<ITableRow> addRowsByMatrix(Object dataMatrix, int rowStatus) {
        return this.addRows(this.createRowsByMatrix(dataMatrix, rowStatus));
    }

    @Override
    public List<ITableRow> addRowsByArray(Object dataArray) {
        return this.addRowsByArray(dataArray, 1);
    }

    @Override
    public List<ITableRow> addRowsByArray(Object dataArray, int rowStatus) {
        return this.addRows(this.createRowsByArray(dataArray, rowStatus));
    }

    @Override
    public ITableRow addRow() {
        return this.addRow(true);
    }

    @Override
    public ITableRow addRow(boolean markAsInserted) {
        return this.addRow(this.createRow(), markAsInserted);
    }

    @Override
    public ITableRow addRow(ITableRow newRow) {
        return this.addRow(newRow, false);
    }

    @Override
    public ITableRow addRow(ITableRow newRow, boolean markAsInserted) {
        List<ITableRow> addedRows = this.addRows(CollectionUtility.arrayList((Object)newRow), markAsInserted);
        return (ITableRow)CollectionUtility.firstElement(addedRows);
    }

    @Override
    public List<ITableRow> addRows(List<? extends ITableRow> newRows) {
        return this.addRows(newRows, false);
    }

    @Override
    public List<ITableRow> addRows(List<? extends ITableRow> newRows, boolean markAsInserted) {
        return this.addRows(newRows, markAsInserted, null);
    }

    @Override
    public List<ITableRow> addRows(List<? extends ITableRow> newRows, boolean markAsInserted, int[] insertIndexes) {
        if (newRows == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<InternalTableRow> newIRows = null;
        try {
            this.setTableChanging(true);
            int oldRowCount = this.m_rows.size();
            this.initCells(newRows);
            if (markAsInserted) {
                this.updateStatus(newRows, 1);
            }
            newIRows = this.createInternalRows(newRows);
            this.addCellObserver(newIRows);
            this.fireRowsInserted(newIRows);
            int i = 0;
            while (i < newIRows.size()) {
                InternalTableRow newIRow = newIRows.get(i);
                this.addInternalRow(newIRow);
                ITableRow newRow = newRows.get(i);
                boolean checked = newRow.isChecked() || this.getCheckableColumn() != null && BooleanUtility.nvl((Boolean)((Boolean)this.getCheckableColumn().getValue(newRow)));
                this.checkRow(newIRow, checked);
                ++i;
            }
            if (this.getColumnSet().getSortColumnCount() > 0) {
                this.setSortValid(false);
            } else if (insertIndexes != null) {
                ITableRow[] sortArray = this.createSortArray(newIRows, insertIndexes, oldRowCount);
                this.sortInternal(Arrays.asList(sortArray));
            }
        }
        finally {
            this.setTableChanging(false);
        }
        return new ArrayList<ITableRow>(newIRows);
    }

    /*
     * Unable to fully structure code
     */
    private ITableRow[] createSortArray(List<InternalTableRow> newIRows, int[] insertIndexes, int oldRowCount) {
        sortArray = new ITableRow[this.m_rows.size()];
        i = 0;
        while (i < insertIndexes.length) {
            sortArray[insertIndexes[i]] = newIRows.get(i);
            ++i;
        }
        sortArrayIndex = 0;
        i = 0;
        ** GOTO lbl15
        {
            ++sortArrayIndex;
            do {
                if (sortArray[sortArrayIndex] != null) continue block1;
                sortArray[sortArrayIndex] = this.m_rows.get(i);
                ++i;
lbl15:
                // 2 sources

            } while (i < oldRowCount);
        }
        i = insertIndexes.length;
        ** GOTO lbl23
        {
            ++sortArrayIndex;
            do {
                if (sortArray[sortArrayIndex] != null) continue block3;
                sortArray[sortArrayIndex] = newIRows.get(i);
                ++i;
lbl23:
                // 2 sources

            } while (i < newIRows.size());
        }
        return sortArray;
    }

    private void addCellObserver(List<InternalTableRow> rows) {
        for (InternalTableRow row : rows) {
            int i = 0;
            while (i < row.getCellCount()) {
                Cell cell = row.getCellForUpdate(i);
                cell.setObserver(row);
                ++i;
            }
        }
    }

    private void initCells(List<? extends ITableRow> rows) {
        int i = 0;
        while (i < this.getColumnCount()) {
            for (ITableRow iTableRow : rows) {
                IColumn col = this.getColumnSet().getColumn(i);
                col.initCell(iTableRow);
            }
            ++i;
        }
    }

    private void updateStatus(List<? extends ITableRow> rows, int status) {
        for (ITableRow iTableRow : rows) {
            iTableRow.setStatus(status);
        }
    }

    private List<InternalTableRow> createInternalRows(List<? extends ITableRow> newRows) {
        ArrayList<InternalTableRow> newIRows = new ArrayList<InternalTableRow>(newRows.size());
        for (ITableRow iTableRow : newRows) {
            newIRows.add(new InternalTableRow(this, iTableRow));
        }
        return newIRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITableRow addInternalRow(InternalTableRow newIRow) {
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            this.m_cachedRows = null;
            int newIndex = this.m_rows.size();
            newIRow.setRowIndex(newIndex);
            newIRow.setTableInternal(this);
            this.m_rows.add(newIRow);
            this.m_rowsByKey.put(new CompositeObject(new Object[]{newIRow.getKeyValues()}), newIRow);
        }
        this.rebuildTreeStructure();
        HashSet<Integer> indexes = new HashSet<Integer>();
        int[] nArray = this.getColumnSet().getAllColumnIndexes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int idx = nArray[n2];
            indexes.add(idx);
            ++n2;
        }
        this.enqueueValueChangeTasks(newIRow, indexes);
        this.enqueueDecorationTasks(newIRow);
        return newIRow;
    }

    private void rebuildTreeStructure() {
        if (this.isTableChanging()) {
            this.m_treeStructureDirty = true;
        } else {
            this.rebuildTreeStructureInternal();
        }
    }

    private void rebuildTreeStructureInternal() {
        ArrayList rootNodes = new ArrayList();
        HashMap parentToChildren = new HashMap();
        this.m_rows.forEach(row -> {
            List<Object> parentRowKeys = this.getParentRowKeys((ITableRow)row);
            if (parentRowKeys.stream().filter(Objects::nonNull).findAny().orElse(null) != null) {
                ITableRow parentRow = this.getRowByKey(parentRowKeys);
                if (parentRow == null) {
                    throw new IllegalArgumentException("Could not find the parent row of '" + String.valueOf(row) + "'. parent keys are defined.");
                }
                parentToChildren.computeIfAbsent(parentRow, children -> new ArrayList()).add(row);
            } else {
                row.setParentRowInternal(null);
                rootNodes.add(row);
            }
        });
        this.m_rootRows = Collections.synchronizedList(rootNodes);
        boolean hierarchical = !parentToChildren.isEmpty();
        this.setHierarchicalInternal(hierarchical);
        if (hierarchical) {
            CollectingVisitor collector = new CollectingVisitor();
            rootNodes.forEach(root -> {
                TreeVisitResult treeVisitResult = TreeTraversals.create((IDepthFirstTreeVisitor)collector, node -> {
                    List<ITableRow> childRows = parentToChildren.getOrDefault(node, Collections.emptyList());
                    node.setChildRowsInternal(childRows);
                    childRows.forEach(childRow -> childRow.setParentRowInternal((ITableRow)node));
                    return childRows;
                }).traverse(root);
            });
            this.m_rows = Collections.synchronizedList(collector.getCollection());
        }
        this.m_treeStructureDirty = false;
    }

    @Override
    public boolean isHierarchical() {
        return this.propertySupport.getPropertyBool("hierarchicalRows");
    }

    protected void setHierarchicalInternal(boolean hierarchical) {
        this.propertySupport.setPropertyBool("hierarchicalRows", hierarchical);
    }

    @Override
    public void moveRow(int sourceIndex, int targetIndex) {
        this.moveRowImpl(sourceIndex, targetIndex);
    }

    @Override
    public void moveRowBefore(ITableRow movingRow, ITableRow targetRow) {
        movingRow = this.resolveRow(movingRow);
        targetRow = this.resolveRow(targetRow);
        if (movingRow != null && targetRow != null) {
            int targetIndex;
            int sourceIndex = movingRow.getRowIndex();
            if (sourceIndex < (targetIndex = targetRow.getRowIndex())) {
                this.moveRowImpl(sourceIndex, targetIndex - 1);
            } else {
                this.moveRowImpl(sourceIndex, targetIndex);
            }
        }
    }

    @Override
    public void moveRowAfter(ITableRow movingRow, ITableRow targetRow) {
        movingRow = this.resolveRow(movingRow);
        targetRow = this.resolveRow(targetRow);
        if (movingRow != null && targetRow != null) {
            int targetIndex;
            int sourceIndex = movingRow.getRowIndex();
            if (sourceIndex > (targetIndex = targetRow.getRowIndex())) {
                this.moveRowImpl(sourceIndex, targetIndex + 1);
            } else {
                this.moveRowImpl(sourceIndex, targetIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRowImpl(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0) {
            sourceIndex = 0;
        }
        if (sourceIndex >= this.getRowCount()) {
            sourceIndex = this.getRowCount() - 1;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        if (targetIndex >= this.getRowCount()) {
            targetIndex = this.getRowCount() - 1;
        }
        if (targetIndex != sourceIndex) {
            Object object = this.m_cachedRowsLock;
            synchronized (object) {
                this.m_cachedRows = null;
                ITableRow row = this.m_rows.remove(sourceIndex);
                this.m_rows.add(targetIndex, row);
            }
            int min = Math.min(sourceIndex, targetIndex);
            int max = Math.max(sourceIndex, targetIndex);
            ITableRow[] changedRows = new ITableRow[max - min + 1];
            int i = min;
            while (i <= max) {
                changedRows[i - min] = this.getRow(i);
                ((InternalTableRow)changedRows[i - min]).setRowIndex(i);
                ++i;
            }
            this.fireRowOrderChanged();
            this.selectRows(this.getSelectedRows(), false);
            this.sortCheckedRows();
        }
    }

    @Override
    public void deleteRow(int rowIndex) {
        this.deleteRows(new int[]{rowIndex});
    }

    @Override
    public void deleteRows(int[] rowIndexes) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndexe = nArray[n2];
            ITableRow row = this.getRow(rowIndexe);
            if (row != null) {
                rowList.add(row);
            }
            ++n2;
        }
        this.deleteRows(rowList);
    }

    @Override
    public void deleteRow(ITableRow row) {
        if (row != null) {
            this.deleteRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void deleteAllRows() {
        this.deleteRows(this.getRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRows(Collection<? extends ITableRow> rows) {
        List<ITableRow> existingRows = this.getRows();
        if (rows != existingRows) {
            rows = this.resolveRows(rows);
            CollectingVisitor collector = new CollectingVisitor();
            rows.forEach(parent -> {
                TreeVisitResult treeVisitResult = TreeTraversals.create((IDepthFirstTreeVisitor)collector, ITableRow::getChildRows).traverse(parent);
            });
            rows = collector.getCollection();
        }
        if (!CollectionUtility.hasElements(rows)) {
            return;
        }
        try {
            this.setTableChanging(true);
            int rowCountBefore = this.getRowCount();
            int min = this.getRowCount();
            int max = 0;
            for (ITableRow row : rows) {
                min = Math.min(min, row.getRowIndex());
                max = Math.max(max, row.getRowIndex());
            }
            ArrayList deletedRows = new ArrayList(rows);
            this.deselectRows(deletedRows);
            this.uncheckRows(deletedRows);
            if (rows == existingRows) {
                Object object = this.m_cachedRowsLock;
                synchronized (object) {
                    this.m_rows.clear();
                    this.m_rootRows.clear();
                    this.m_rowsByKey.clear();
                    this.m_cachedRows = null;
                }
                i = deletedRows.size() - 1;
                while (i >= 0) {
                    candidateRow = (ITableRow)deletedRows.get(i);
                    if (candidateRow != null) {
                        this.deleteRowImpl(candidateRow);
                    }
                    --i;
                }
            } else {
                i = deletedRows.size() - 1;
                while (i >= 0) {
                    candidateRow = (ITableRow)deletedRows.get(i);
                    if (candidateRow != null) {
                        boolean removed = false;
                        Object object = this.m_cachedRowsLock;
                        synchronized (object) {
                            removed = this.m_rows.remove(candidateRow);
                            this.m_rowsByKey.remove(new CompositeObject(new Object[]{candidateRow.getKeyValues()}));
                            if (removed) {
                                this.m_cachedRows = null;
                            }
                        }
                        if (removed) {
                            this.deleteRowImpl(candidateRow);
                            this.rebuildTreeStructure();
                        }
                    }
                    --i;
                }
            }
            int minAffectedIndex = Math.max(min - 1, 0);
            ITableRow[] affectedRows = new ITableRow[this.getRowCount() - minAffectedIndex];
            int i = minAffectedIndex;
            while (i < this.getRowCount()) {
                affectedRows[i - minAffectedIndex] = this.getRow(i);
                ((InternalTableRow)affectedRows[i - minAffectedIndex]).setRowIndex(i);
                ++i;
            }
            if (rowCountBefore == deletedRows.size()) {
                this.removeUserRowFilters(false);
                this.fireAllRowsDeleted(deletedRows);
            } else {
                this.fireRowsDeleted(deletedRows);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void deleteRowImpl(ITableRow row) {
        if (!(row instanceof InternalTableRow)) {
            return;
        }
        InternalTableRow internalRow = (InternalTableRow)row;
        if (this.isAutoDiscardOnDelete()) {
            internalRow.setTableInternal(null);
        } else if (internalRow.getStatus() == 1) {
            internalRow.setTableInternal(null);
        } else {
            internalRow.setStatus(3);
            this.m_deletedRows.put(new CompositeObject(new Object[]{this.getRowKeys(internalRow)}), internalRow);
        }
    }

    @Override
    public void discardRow(int rowIndex) {
        this.discardRows(new int[]{rowIndex});
    }

    @Override
    public void discardRows(int[] rowIndexes) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rIndex = nArray[n2];
            ITableRow row = this.getRow(rIndex);
            if (row != null) {
                rowList.add(row);
            }
            ++n2;
        }
        this.discardRows(rowList);
    }

    @Override
    public void discardRow(ITableRow row) {
        if (row != null) {
            this.discardRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void discardAllRows() {
        this.discardRows(this.getRows());
    }

    @Override
    public void discardRows(Collection<? extends ITableRow> rows) {
        boolean oldAutoDiscardOnDelete = this.isAutoDiscardOnDelete();
        try {
            this.setTableChanging(true);
            this.setAutoDiscardOnDelete(true);
            this.deleteRows(rows);
        }
        finally {
            this.setAutoDiscardOnDelete(oldAutoDiscardOnDelete);
            this.setTableChanging(false);
        }
    }

    @Override
    public void discardAllDeletedRows() {
        for (ITableRow iTableRow : this.m_deletedRows.values()) {
            ((InternalTableRow)iTableRow).setTableInternal(null);
        }
        this.m_deletedRows.clear();
    }

    @Override
    public void discardDeletedRow(ITableRow deletedRow) {
        if (deletedRow != null) {
            this.discardDeletedRows(CollectionUtility.arrayList((Object)deletedRow));
        }
    }

    @Override
    public void discardDeletedRows(Collection<? extends ITableRow> deletedRows) {
        if (deletedRows != null) {
            for (ITableRow iTableRow : deletedRows) {
                this.m_deletedRows.remove(new CompositeObject(new Object[]{this.getRowKeys(iTableRow)}));
                ((InternalTableRow)iTableRow).setTableInternal(null);
            }
        }
    }

    @Override
    public void setContextColumn(IColumn<?> col) {
        this.propertySupport.setProperty("contextColumn", col);
    }

    @Override
    public IColumn<?> getContextColumn() {
        return (IColumn)this.propertySupport.getProperty("contextColumn");
    }

    @Override
    public List<Object> getRowKeys(int rowIndex) {
        ITableRow row = this.getRow(rowIndex);
        return this.getRowKeys(row);
    }

    @Override
    public List<Object> getRowKeys(ITableRow row) {
        if (row != null) {
            return row.getKeyValues();
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public ITableRow getRowByKey(List<?> keys) {
        if (!CollectionUtility.hasElements(keys)) {
            return null;
        }
        return this.m_rowsByKey.get(new CompositeObject(new Object[]{keys}));
    }

    @Override
    public List<Object> getParentRowKeys(int rowIndex) {
        ITableRow row = this.getRow(rowIndex);
        return this.getParentRowKeys(row);
    }

    @Override
    public List<Object> getParentRowKeys(ITableRow row) {
        if (row != null) {
            return row.getParentKeyValues();
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public ITableRow findParentRow(ITableRow row) {
        return this.getRowByKey(this.getParentRowKeys(row));
    }

    protected boolean areCellsEqual(List<?> searchValues, List<IColumn<?>> keyColumns, ITableRow row) {
        int keyIndex = 0;
        int numKeyColumns = keyColumns.size();
        for (Object key : searchValues) {
            if (keyIndex >= numKeyColumns) break;
            Object cellValue = keyColumns.get(keyIndex).getValue(row);
            if (ObjectUtility.notEquals(key, cellValue)) {
                return false;
            }
            ++keyIndex;
        }
        return true;
    }

    @Override
    public TableUserFilterManager getUserFilterManager() {
        return (TableUserFilterManager)this.propertySupport.getProperty("userFilterManager");
    }

    @Override
    public void setUserFilterManager(TableUserFilterManager m) {
        this.propertySupport.setProperty("userFilterManager", (Object)m);
    }

    @Override
    public ITableCustomizer getTableCustomizer() {
        return (ITableCustomizer)this.propertySupport.getProperty("tableCustomizer");
    }

    @Override
    public void setTableCustomizer(ITableCustomizer c) {
        this.propertySupport.setProperty("tableCustomizer", (Object)c);
    }

    @Override
    public ITypeWithClassId getContainer() {
        IWidget parentWidget = this.getParent();
        if (parentWidget != null) {
            return parentWidget;
        }
        return (ITypeWithClassId)this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(ITypeWithClassId container) {
        this.propertySupport.setProperty("container", (Object)container);
    }

    @Override
    public boolean isSortEnabled() {
        return this.propertySupport.getPropertyBool("sortEnabled");
    }

    @Override
    public void setSortEnabled(boolean b) {
        this.propertySupport.setPropertyBool("sortEnabled", b);
    }

    @Override
    public boolean isUiSortPossible() {
        return this.propertySupport.getPropertyBool("uiSortPossible");
    }

    @Override
    public void setUiSortPossible(boolean b) {
        this.propertySupport.setPropertyBool("uiSortPossible", b);
    }

    public void onGroupedColumnInvisible(IColumn<?> col) {
        if (this.isTableChanging()) {
            this.setSortValid(false);
        } else {
            this.sort();
        }
    }

    @Override
    public void sort() {
        try {
            if (this.isSortEnabled() && !this.getRows().isEmpty()) {
                TableRowComparator comparator = null;
                LinkedHashSet sortCols = new LinkedHashSet(this.getColumnSet().getSortColumns());
                if (!sortCols.isEmpty()) {
                    sortCols.addAll(this.getColumnSet().getVisibleColumns());
                    comparator = new TableRowComparator(sortCols);
                }
                this.processDecorationBuffer();
                this.sortInternal(this.sortRows(this.getRows(), comparator));
            }
        }
        finally {
            this.setSortValid(true);
        }
    }

    protected List<ITableRow> sortRows(List<? extends ITableRow> rows, Comparator<ITableRow> comparator) {
        ArrayList<ITableRow> rootNodes = new ArrayList<ITableRow>();
        HashMap parentToChildren = new HashMap();
        rows.forEach(row -> {
            ITableRow parentRow = this.findParentRow((ITableRow)row);
            if (parentRow == null) {
                rootNodes.add((ITableRow)row);
            } else {
                parentToChildren.computeIfAbsent(parentRow, children -> new ArrayList()).add(row);
            }
        });
        CollectingVisitor collector = new CollectingVisitor();
        if (comparator != null) {
            rootNodes.sort(comparator);
        }
        rootNodes.forEach(root -> {
            TreeVisitResult treeVisitResult = TreeTraversals.create((IDepthFirstTreeVisitor)collector, node -> {
                List childRows = (List)parentToChildren.get(node);
                if (comparator != null && CollectionUtility.hasElements((Collection)childRows)) {
                    childRows.sort(comparator);
                }
                return childRows;
            }).traverse(root);
        });
        return collector.getCollection();
    }

    @Override
    public void sort(List<? extends ITableRow> rowsInNewOrder) {
        List<ITableRow> resolvedRows = this.resolveRows(rowsInNewOrder);
        if (resolvedRows.size() == rowsInNewOrder.size()) {
            this.sortInternal(resolvedRows);
        } else {
            ArrayList<ITableRow> list = new ArrayList<ITableRow>(this.m_rows);
            list.removeAll(resolvedRows);
            ArrayList<ITableRow> sortedList = new ArrayList<ITableRow>();
            sortedList.addAll(resolvedRows);
            sortedList.addAll(list);
            this.sortInternal(sortedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortInternal(List<? extends ITableRow> resolvedRows) {
        int i = 0;
        for (ITableRow iTableRow : resolvedRows) {
            ((InternalTableRow)iTableRow).setRowIndex(i);
            ++i;
        }
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            this.m_cachedRows = null;
            this.m_rows.clear();
            this.m_rows.addAll(resolvedRows);
        }
        if (this.m_selectedRows != null && !this.m_selectedRows.isEmpty()) {
            TreeSet<ITableRow> treeSet = new TreeSet<ITableRow>(new RowIndexComparator());
            treeSet.addAll(this.m_selectedRows);
            this.m_selectedRows = new ArrayList<ITableRow>(treeSet);
        }
        this.sortCheckedRows();
        this.fireRowOrderChanged();
    }

    private void sortCheckedRows() {
        if (this.m_checkedRows == null || this.m_checkedRows.isEmpty()) {
            return;
        }
        TreeSet<ITableRow> newCheckedRows = new TreeSet<ITableRow>(new RowIndexComparator());
        newCheckedRows.addAll(this.m_checkedRows);
        this.m_checkedRows = new LinkedHashSet<ITableRow>(newCheckedRows);
    }

    @Override
    public void resetColumnConfiguration() {
        this.discardAllRows();
        try {
            this.setTableChanging(true);
            HashMap<String, Boolean> displayableState = new HashMap<String, Boolean>();
            for (IColumn<?> col : this.getColumns()) {
                displayableState.put(col.getColumnId(), col.isDisplayable());
            }
            this.disposeColumnsInternal();
            this.m_objectExtensions.runInExtensionContext(() -> {
                this.m_contributionHolder.resetContributionsByClass((Object)this, IColumn.class);
                this.createColumnsInternal();
            });
            this.initColumnsInternal();
            for (IColumn<?> col : this.getColumns()) {
                if (displayableState.get(col.getColumnId()) == null) continue;
                col.setDisplayable((Boolean)displayableState.get(col.getColumnId()));
            }
            this.linkColumnFilters();
            if (this.isCompact()) {
                this.getCompactHandler().handle(this.isCompact());
            }
            this.setContextColumn(null);
            this.fireTableEventInternal(new TableEvent(this, 1));
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void linkColumnFilters() {
        TableUserFilterManager filterManager = this.getUserFilterManager();
        if (filterManager == null) {
            return;
        }
        for (IColumn<?> col : this.getColumns()) {
            this.getUserFilterManager().getFilters().stream().filter(IColumnAwareUserFilterState.class::isInstance).map(IColumnAwareUserFilterState.class::cast).forEach(filter -> filter.replaceColumn(col));
        }
    }

    @Override
    public void resetColumnVisibilities() {
        this.resetColumns(CollectionUtility.hashSet((Object)"visibility"));
    }

    @Override
    public void resetColumnOrder() {
        this.resetColumns(CollectionUtility.hashSet((Object)"order"));
    }

    @Override
    public void resetColumnSortOrder() {
        this.resetColumns(CollectionUtility.hashSet((Object)"sorting"));
    }

    @Override
    public void resetColumnWidths() {
        this.resetColumns(CollectionUtility.hashSet((Object)"widths"));
    }

    @Override
    public void resetColumnBackgroundEffects() {
        this.resetColumns(CollectionUtility.hashSet((Object)"backgroundEffects"));
    }

    @Override
    public void resetColumnFilters() {
        this.resetColumns(CollectionUtility.hashSet((Object)"filters"));
    }

    @Override
    public void resetColumns() {
        this.resetColumns(CollectionUtility.hashSet((Object[])new String[]{"visibility", "order", "sorting", "widths", "backgroundEffects", "filters"}));
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void reset(boolean store) {
        try {
            ITableCustomizer cst;
            this.setTableChanging(true);
            TableUserFilterManager m = this.getUserFilterManager();
            if (m != null) {
                m.reset();
            }
            if ((cst = this.getTableCustomizer()) != null) {
                cst.removeAllColumns();
            }
            this.resetColumns();
        }
        finally {
            this.setTableChanging(false);
        }
        if (store) {
            ClientUIPreferences.getInstance().setAllTableColumnPreferences(this);
        }
    }

    protected void resetColumns(Set<String> options) {
        try {
            this.setTableChanging(true);
            this.resetColumnsInternal(options);
            this.interceptResetColumns(options);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void resetColumnsInternal(Set<String> options) {
        if (options.contains("sorting")) {
            this.setSortValid(false);
        }
        if (options.contains("order")) {
            TreeMap orderMap = new TreeMap();
            int index = 0;
            for (IColumn<?> col : this.getColumns()) {
                if (!col.isDisplayable()) continue;
                orderMap.put(new CompositeObject(new Object[]{col.getOrder(), index}), col);
                ++index;
            }
            this.getColumnSet().setVisibleColumns(orderMap.values());
        }
        if (options.contains("visibility")) {
            ArrayList list = new ArrayList();
            for (IColumn<?> col : this.getColumnSet().getAllColumnsInUserOrder()) {
                boolean configuredVisible;
                if (!col.isDisplayable() || !(configuredVisible = col.isInitialVisible())) continue;
                list.add(col);
            }
            this.getColumnSet().setVisibleColumns(list);
        }
        if (options.contains("sorting")) {
            this.getColumnSet().resetSortingAndGrouping();
        }
        if (options.contains("widths")) {
            for (IColumn<?> col : this.getColumns()) {
                if (!col.isDisplayable()) continue;
                col.setWidth(col.getInitialWidth());
            }
        }
        if (options.contains("backgroundEffects")) {
            for (IColumn<?> col : this.getColumns()) {
                if (!(col instanceof INumberColumn)) continue;
                ((INumberColumn)col).setBackgroundEffect(((INumberColumn)col).getInitialBackgroundEffect());
            }
        }
        if (options.contains("filters")) {
            this.removeUserRowFilters();
        }
    }

    private void processDecorationBuffer() {
        Map<Integer, Set<ITableRow>> changes = this.m_rowValueChangeBuffer;
        this.m_rowValueChangeBuffer = new HashMap<Integer, Set<ITableRow>>();
        this.applyRowValueChanges(changes);
        Set<ITableRow> set = this.m_rowDecorationBuffer;
        this.m_rowDecorationBuffer = new HashSet<ITableRow>();
        this.applyRowDecorations(set);
        if (!this.m_rowFilters.isEmpty()) {
            boolean filterChanged = false;
            for (ITableRow row : set) {
                if (row.getTable() != this || !(row instanceof InternalTableRow)) continue;
                InternalTableRow internalRow = (InternalTableRow)row;
                boolean oldFlag = internalRow.isFilterAccepted();
                this.applyRowFiltersInternal(internalRow);
                boolean newFlag = internalRow.isFilterAccepted();
                boolean bl = filterChanged = filterChanged || oldFlag != newFlag;
            }
            if (filterChanged) {
                this.fireRowFilterChanged();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void applyRowValueChanges(Map<Integer, Set<ITableRow>> changes) {
        if (changes.isEmpty()) {
            return;
        }
        try {
            for (ITableRow tableRow : this.getRows()) {
                tableRow.setRowChanging(true);
            }
            entrySet = changes.entrySet();
            for (Map.Entry<Integer, Set<ITableRow>> e : entrySet) {
                col = this.getColumnSet().getColumn(e.getKey());
                col.updateDisplayTexts(CollectionUtility.arrayList((Collection)e.getValue()));
            }
        }
        finally {
            ** for (tableRow : this.getRows())
        }
lbl-1000:
        // 1 sources

        {
            tableRow.setRowPropertiesChanged(false);
            tableRow.setRowChanging(false);
            continue;
        }
lbl18:
        // 1 sources

    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void applyRowDecorations(Set<ITableRow> rows) {
        block12: {
            block11: {
                if (rows.isEmpty()) {
                    return;
                }
                try {
                    try {
                        for (ITableRow tableRow : rows) {
                            tableRow.setRowChanging(true);
                            this.decorateRow(tableRow);
                        }
                        for (IColumn col : this.getColumns()) {
                            col.decorateCells(CollectionUtility.arrayList(rows));
                            for (ITableRow row : rows) {
                                this.decorateCell(row, col);
                            }
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        AbstractTable.LOG.error("Error occurred while applying row decoration", (Throwable)ex);
                        ** for (tableRow : rows)
                    }
                }
                catch (Throwable var6_13) {
                    ** for (tableRow : rows)
                }
lbl-1000:
                // 1 sources

                {
                    tableRow.setRowPropertiesChanged(false);
                    tableRow.setRowChanging(false);
                    continue;
lbl22:
                    // 1 sources

                    break block12;
                }
lbl-1000:
                // 1 sources

                {
                    tableRow.setRowPropertiesChanged(false);
                    tableRow.setRowChanging(false);
                    continue;
                }
lbl28:
                // 1 sources

                throw var6_13;
            }
            for (ITableRow tableRow : rows) {
                tableRow.setRowPropertiesChanged(false);
                tableRow.setRowChanging(false);
            }
        }
    }

    private void processEventBuffer() {
        block8: {
            try {
                ++this.m_eventBufferLoopDetection;
                if (this.m_eventBufferLoopDetection > 100) {
                    LOG.error("LOOP DETECTION in {}. see stack trace for more details.", this.getClass(), (Object)new Exception("LOOP DETECTION"));
                    return;
                }
                if (this.getEventBuffer().isEmpty()) break block8;
                List<TableEvent> list = this.getEventBuffer().consumeAndCoalesceEvents();
                try {
                    this.setTableChanging(true);
                    this.m_listeners.fireEvents(list);
                }
                finally {
                    this.setTableChanging(false);
                }
            }
            finally {
                --this.m_eventBufferLoopDetection;
            }
        }
    }

    private void enqueueDecorationTasks(ITableRow row) {
        if (row != null) {
            this.m_rowDecorationBuffer.add(row);
        }
    }

    private void enqueueValueChangeTasks(ITableRow row, Set<Integer> valueChangedColumns) {
        for (Integer colIndex : valueChangedColumns) {
            Set<ITableRow> rows = this.m_rowValueChangeBuffer.get(colIndex);
            if (rows == null) {
                rows = new HashSet<ITableRow>();
            }
            rows.add(row);
            this.m_rowValueChangeBuffer.put(colIndex, rows);
        }
    }

    @Override
    public ITableRow resolveRow(ITableRow row) {
        if (row == null) {
            return null;
        }
        if (!(row instanceof InternalTableRow)) {
            throw new IllegalArgumentException("only accept InternalTableRow, not " + String.valueOf(row.getClass()));
        }
        if (row.getTable() == this) {
            return row;
        }
        return null;
    }

    @Override
    public List<ITableRow> resolveRows(Collection<? extends ITableRow> rows) {
        if (rows == null) {
            rows = CollectionUtility.emptyArrayList();
        }
        ArrayList<ITableRow> resolvedRows = new ArrayList<ITableRow>(rows.size());
        for (ITableRow row : rows) {
            if (this.resolveRow(row) == row) {
                resolvedRows.add(row);
                continue;
            }
            LOG.info("Could not resolve row with keys {} in table {}", new Object[]{row.getKeyValues(), this.getClass().getName(), LOG.isDebugEnabled() ? new Exception("stacktrace") : null});
        }
        return resolvedRows;
    }

    @Override
    public boolean isHeaderVisible() {
        return this.propertySupport.getPropertyBool("headerVisible");
    }

    @Override
    public void setHeaderVisible(boolean b) {
        this.propertySupport.setPropertyBool("headerVisible", b);
    }

    @Override
    public boolean isHeaderEnabled() {
        return this.propertySupport.getPropertyBool("headerEnabled");
    }

    @Override
    public void setHeaderEnabled(boolean headerEnabled) {
        this.propertySupport.setPropertyBool("headerEnabled", headerEnabled);
    }

    @Override
    public boolean isHeaderMenusEnabled() {
        return this.propertySupport.getPropertyBool("headerMenusEnabled");
    }

    @Override
    public void setHeaderMenusEnabled(boolean headerMenusEnabled) {
        this.propertySupport.setPropertyBool("headerMenusEnabled", headerMenusEnabled);
    }

    @Override
    public boolean isClientUiPreferencesEnabled() {
        return this.propertySupport.getPropertyBool("clientUiPreferencesEnabled");
    }

    @Override
    public void setClientUiPreferencesEnabled(boolean clientUiPreferencesEnabled) {
        this.propertySupport.setPropertyBool("clientUiPreferencesEnabled", clientUiPreferencesEnabled);
    }

    @Override
    public boolean isTextFilterEnabled() {
        return this.propertySupport.getPropertyBool("textFilterEnabled");
    }

    @Override
    public void setTextFilterEnabled(boolean textFilterEnabled) {
        this.propertySupport.setPropertyBool("textFilterEnabled", textFilterEnabled);
    }

    @Override
    public final void decorateCell(ITableRow row, IColumn<?> col) {
        Cell cell = row.getCellForUpdate(col.getColumnIndex());
        this.decorateCellInternal(cell, row, col);
        try {
            this.interceptDecorateCell(cell, row, col);
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    protected void decorateCellInternal(Cell view, ITableRow row, IColumn<?> col) {
    }

    @Override
    public final void decorateRow(ITableRow row) {
        this.decorateRowInternal(row);
        try {
            this.interceptDecorateRow(row);
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    protected void decorateRowInternal(ITableRow row) {
        String s;
        if (row.getIconId() == null && (s = this.getDefaultIconId()) != null) {
            row.setIconId(s);
        }
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execResetColumns(Set<String> options) {
    }

    @Override
    public TableListeners tableListeners() {
        return this.m_listeners;
    }

    protected IEventHistory<TableEvent> createEventHistory() {
        return new DefaultTableEventHistory(5000L);
    }

    @Override
    public IEventHistory<TableEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsInserted(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent((ITable)this, 100, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsUpdated(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        TableEvent e = new TableEvent((ITable)this, 101, rows);
        for (ITableRow iTableRow : rows) {
            Set<Integer> columnIndexes = iTableRow.getUpdatedColumnIndexes();
            if (columnIndexes.isEmpty()) continue;
            HashSet columns = new HashSet();
            for (Integer columnIndex : columnIndexes) {
                IColumn<?> column = this.getColumns().get(columnIndex);
                if (column == null) continue;
                columns.add(column);
            }
            e.setUpdatedColumns(iTableRow, columns);
        }
        this.fireTableEventInternal(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsDeleted(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent((ITable)this, 102, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAllRowsDeleted(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent((ITable)this, 105, rows));
    }

    private void fireRowsSelected(List<? extends ITableRow> rows) {
        this.fireTableEventInternal(new TableEvent((ITable)this, 103, rows));
    }

    private void fireRowsChecked(List<? extends ITableRow> rows) {
        this.fireTableEventInternal(new TableEvent((ITable)this, 850, rows));
    }

    private void fireRowsExpanded(List<? extends ITableRow> rows) {
        this.fireTableEventInternal(new TableEvent((ITable)this, 860, rows));
    }

    private void fireRowClick(ITableRow row, MouseButton mouseButton) {
        if (row != null) {
            try {
                this.interceptRowClickSingleObserver(row, mouseButton);
                this.interceptRowClick(row, mouseButton);
            }
            catch (Exception ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
            }
        }
    }

    protected void interceptRowClickSingleObserver(ITableRow row, MouseButton mouseButton) {
        IFormField field;
        if (!row.isEnabled() || !this.isEnabledIncludingParents()) {
            return;
        }
        if (mouseButton != MouseButton.Left) {
            return;
        }
        IColumn<?> ctxCol = this.getContextColumn();
        if (this.isCellEditable(row, ctxCol) && ctxCol instanceof IBooleanColumn && (field = ctxCol.prepareEdit(row)) instanceof IBooleanField) {
            IBooleanField booleanField = (IBooleanField)field;
            booleanField.toggleValue();
            ctxCol.completeEdit(row, field);
        }
    }

    private void fireRowAction(ITableRow row) {
        if (this.isActionRunning() || row == null) {
            return;
        }
        try {
            try {
                this.setActionRunning(true);
                this.interceptRowAction(row);
            }
            catch (Exception ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                this.setActionRunning(false);
            }
        }
        finally {
            this.setActionRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowOrderChanged() {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent((ITable)this, 200, this.getRows()));
    }

    private void fireRequestFocus() {
        this.fireTableEventInternal(new TableEvent(this, 800));
    }

    private void fireRequestFocusInCell(IColumn<?> column, ITableRow row) {
        TableEvent e = new TableEvent(this, 805);
        e.setColumns(CollectionUtility.hashSet(column));
        e.setRows(CollectionUtility.arrayList((Object)row));
        this.fireTableEventInternal(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowFilterChanged() {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 210));
    }

    private TransferObject fireRowsDragRequest() {
        List<ITableRow> rows = this.getSelectedRows();
        if (CollectionUtility.hasElements(rows)) {
            TableEvent e = new TableEvent((ITable)this, 730, rows);
            this.fireTableEventInternal(e);
            return e.getDragObject();
        }
        return null;
    }

    private void fireRowDropAction(ITableRow row, TransferObject dropData) {
        ArrayList rows = null;
        if (row != null) {
            rows = CollectionUtility.arrayList((Object)row);
        }
        TableEvent e = new TableEvent((ITable)this, 740, rows);
        e.setDropObject(dropData);
        this.fireTableEventInternal(e);
    }

    private TransferObject fireRowsCopyRequest() {
        List<ITableRow> rows = this.getSelectedRows();
        if (CollectionUtility.hasElements(rows)) {
            TableEvent e = new TableEvent((ITable)this, 760, rows);
            this.fireTableEventInternal(e);
            return e.getCopyObject();
        }
        return null;
    }

    public void fireTableEventInternal(TableEvent e) {
        if (this.isTableChanging()) {
            this.getEventBuffer().add(e);
        } else {
            this.doFireTableEvent(e);
        }
    }

    protected void doFireTableEvent(TableEvent e) {
        this.m_listeners.fireEvent(e);
    }

    @Override
    public ITableUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setReloadHandler(IReloadHandler reloadHandler) {
        this.m_reloadHandler = reloadHandler;
    }

    @Override
    public IReloadHandler getReloadHandler() {
        return this.m_reloadHandler;
    }

    @Override
    public List<ITableControl> getTableControls() {
        return CollectionUtility.arrayList(this.m_tableControls);
    }

    @Override
    public void addTableControl(ITableControl control) {
        this.m_tableControls.add(control);
        this.addTableControlInternal(control);
    }

    private void addTableControlInternal(ITableControl control) {
        ((AbstractTableControl)control).setTable(this);
        this.m_tableControls.sort((Comparator<ITableControl>)new OrderedComparator());
        this.propertySupport.firePropertyChange("tableControls", null, this.getTableControls());
    }

    @Override
    public void removeTableControl(ITableControl control) {
        this.m_tableControls.remove(control);
        ((AbstractTableControl)control).setTable(null);
        this.propertySupport.firePropertyChange("tableControls", null, this.getTableControls());
    }

    @Override
    public <T extends ITableControl> T getTableControl(Class<T> controlClass) {
        for (ITableControl control : this.m_tableControls) {
            if (!controlClass.isAssignableFrom(control.getClass())) continue;
            return (T)((ITableControl)controlClass.cast(control));
        }
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredTableStatusVisible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    protected boolean getConfiguredTextFilterEnabled() {
        return true;
    }

    @Override
    public boolean isTableStatusVisible() {
        return this.propertySupport.getPropertyBool("tableStatusVisible");
    }

    @Override
    public void setTableStatusVisible(boolean visible) {
        this.propertySupport.setPropertyBool("tableStatusVisible", visible);
    }

    @Override
    public IStatus getTableStatus() {
        return (IStatus)this.propertySupport.getProperty("tableStatus");
    }

    @Override
    public void setTableStatus(IStatus status) {
        this.propertySupport.setProperty("tableStatus", (Object)status);
    }

    protected void checkIfColumnPreventsUiSortForTable() {
        for (IColumn<?> column : this.m_columnSet.getColumns()) {
            if (column.isVisible() || column.getSortIndex() == -1) continue;
            this.setUiSortPossible(false);
            return;
        }
        this.setUiSortPossible(true);
    }

    protected void checkIfContextColumnIsVisible() {
        IColumn<?> contextColumn = this.getContextColumn();
        if (contextColumn != null && !contextColumn.isVisible()) {
            this.setContextColumn(null);
        }
    }

    @Override
    public List<ITableRowTileMapping> createTiles(List<? extends ITableRow> rows) {
        return rows.stream().map(row -> {
            ITile tile = this.interceptCreateTile((ITableRow)row);
            if (tile != null && tile.getParent() == null) {
                tile.setParentInternal(this);
            }
            return ((TableRowTileMapping)BEANS.get(TableRowTileMapping.class)).withTableRow((ITableRow)row).withTile(tile);
        }).filter(m -> m.getTile() != null).collect(Collectors.toList());
    }

    protected final void interceptAppLinkAction(String ref) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableAppLinkActionChain chain = new TableChains.TableAppLinkActionChain(extensions);
        chain.execAppLinkAction(ref);
    }

    protected final void interceptRowAction(ITableRow row) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableRowActionChain chain = new TableChains.TableRowActionChain(extensions);
        chain.execRowAction(row);
    }

    protected final void interceptContentChanged() {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableContentChangedChain chain = new TableChains.TableContentChangedChain(extensions);
        chain.execContentChanged();
    }

    protected final ITableRowDataMapper interceptCreateTableRowDataMapper(Class<? extends AbstractTableRowData> rowType) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableCreateTableRowDataMapperChain chain = new TableChains.TableCreateTableRowDataMapperChain(extensions);
        return chain.execCreateTableRowDataMapper(rowType);
    }

    protected final void interceptInitTable() {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableInitTableChain chain = new TableChains.TableInitTableChain(extensions);
        chain.execInitTable();
    }

    protected final void interceptResetColumns(Set<String> options) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableResetColumnsChain chain = new TableChains.TableResetColumnsChain(extensions);
        chain.execResetColumns(options);
    }

    protected final void interceptDecorateCell(Cell view, ITableRow row, IColumn<?> col) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableDecorateCellChain chain = new TableChains.TableDecorateCellChain(extensions);
        chain.execDecorateCell(view, row, col);
    }

    protected final void interceptDrop(ITableRow row, TransferObject t) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableDropChain chain = new TableChains.TableDropChain(extensions);
        chain.execDrop(row, t);
    }

    protected final void interceptDisposeTable() {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableDisposeTableChain chain = new TableChains.TableDisposeTableChain(extensions);
        chain.execDisposeTable();
    }

    protected final void interceptRowClick(ITableRow row, MouseButton mouseButton) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableRowClickChain chain = new TableChains.TableRowClickChain(extensions);
        chain.execRowClick(row, mouseButton);
    }

    protected final void interceptDecorateRow(ITableRow row) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableDecorateRowChain chain = new TableChains.TableDecorateRowChain(extensions);
        chain.execDecorateRow(row);
    }

    protected final TransferObject interceptCopy(List<? extends ITableRow> rows) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableCopyChain chain = new TableChains.TableCopyChain(extensions);
        return chain.execCopy(rows);
    }

    protected final void interceptRowsSelected(List<? extends ITableRow> rows) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableRowsSelectedChain chain = new TableChains.TableRowsSelectedChain(extensions);
        chain.execRowsSelected(rows);
    }

    protected final void interceptRowsChecked(List<? extends ITableRow> rows) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableRowsCheckedChain chain = new TableChains.TableRowsCheckedChain(extensions);
        chain.execRowsChecked(rows);
    }

    protected final TransferObject interceptDrag(List<ITableRow> rows) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableDragChain chain = new TableChains.TableDragChain(extensions);
        return chain.execDrag(rows);
    }

    protected final ITile interceptCreateTile(ITableRow row) {
        List<? extends ITableExtension<? extends AbstractTable>> extensions = this.getAllExtensions();
        TableChains.TableCreateTileChain chain = new TableChains.TableCreateTileChain(extensions);
        return chain.execCreateTile(row);
    }

    @Override
    public boolean isValueChangeTriggerEnabled() {
        return this.m_valueChangeTriggerEnabled >= 1;
    }

    @Override
    public void setValueChangeTriggerEnabled(boolean b) {
        this.m_valueChangeTriggerEnabled = b ? ++this.m_valueChangeTriggerEnabled : --this.m_valueChangeTriggerEnabled;
    }

    protected void setTableOrganizer(ITableOrganizer tableOrganizer) {
        this.propertySupport.setProperty("tableOrganizer", (Object)tableOrganizer);
    }

    @Override
    public ITableOrganizer getTableOrganizer() {
        return (ITableOrganizer)this.propertySupport.getProperty("tableOrganizer");
    }

    @Override
    public boolean isCustomizable() {
        return this.getTableCustomizer() != null;
    }

    @Override
    public GroupingStyle getGroupingStyle() {
        return (GroupingStyle)((Object)this.propertySupport.getProperty("groupingStyle"));
    }

    @Override
    public void setGroupingStyle(GroupingStyle groupingStyle) {
        this.propertySupport.setProperty("groupingStyle", (Object)groupingStyle);
    }

    @Override
    public HierarchicalStyle getHierarchicalStyle() {
        return (HierarchicalStyle)((Object)this.propertySupport.getProperty("hierarchicalStyle"));
    }

    @Override
    public void setHierarchicalStyle(HierarchicalStyle hierarchicalStyle) {
        this.propertySupport.setProperty("hierarchicalStyle", (Object)hierarchicalStyle);
    }

    @Override
    public CheckableStyle getCheckableStyle() {
        return (CheckableStyle)((Object)this.propertySupport.getProperty("checkableStyle"));
    }

    @Override
    public void setCheckableStyle(CheckableStyle checkableStyle) {
        this.propertySupport.setProperty("checkableStyle", (Object)checkableStyle);
    }

    @Override
    public long getEstimatedRowCount() {
        return this.propertySupport.getPropertyLong("estimatedRowCount");
    }

    @Override
    public void setEstimatedRowCount(long estimatedRowCount) {
        this.propertySupport.setPropertyLong("estimatedRowCount", estimatedRowCount);
    }

    @Override
    public int getMaxRowCount() {
        return this.propertySupport.getPropertyInt("maxRowCount");
    }

    @Override
    public void setMaxRowCount(int maxRowCount) {
        this.propertySupport.setPropertyInt("maxRowCount", maxRowCount);
    }

    @Override
    public TriState isTruncatedCellTooltipEnabled() {
        return (TriState)this.propertySupport.getProperty("truncatedCellTooltipEnabled");
    }

    @Override
    public void setTruncatedCellTooltipEnabled(TriState truncatedCellTooltipEnabled) {
        if (truncatedCellTooltipEnabled == null) {
            truncatedCellTooltipEnabled = TriState.UNDEFINED;
        }
        this.propertySupport.setProperty("truncatedCellTooltipEnabled", (Object)truncatedCellTooltipEnabled);
    }

    @Override
    public boolean isTileMode() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.propertySupport.getProperty("tileMode")));
    }

    @Override
    public void setTileMode(boolean tileMode) {
        if (tileMode) {
            if (this.getTableTileGridMediator() == null) {
                this.setTableTileGridMediator(this.createTableTileGridMediator());
            }
            if (this.getTileTableHeader() == null) {
                this.setTileTableHeader(this.createTileTableHeader());
            }
        }
        this.propertySupport.setProperty("tileMode", (Object)tileMode);
    }

    private static /* synthetic */ void lambda$6(CollectingVisitor collectingVisitor, ITableRow root) {
        TreeVisitResult treeVisitResult = TreeTraversals.create((IDepthFirstTreeVisitor)collectingVisitor, ITableRow::getChildRows).traverse((Object)root);
    }

    public static interface IResetColumnsOption {
        public static final String VISIBILITY = "visibility";
        public static final String ORDER = "order";
        public static final String SORTING = "sorting";
        public static final String WIDTHS = "widths";
        public static final String BACKGROUND_EFFECTS = "backgroundEffects";
        public static final String FILTERS = "filters";
    }

    protected static class LocalTableExtension<TABLE extends AbstractTable>
    extends AbstractExtension<TABLE>
    implements ITableExtension<TABLE> {
        public LocalTableExtension(TABLE owner) {
            super(owner);
        }

        @Override
        public void execAppLinkAction(TableChains.TableAppLinkActionChain chain, String ref) {
            ((AbstractTable)this.getOwner()).execAppLinkAction(ref);
        }

        @Override
        public void execRowAction(TableChains.TableRowActionChain chain, ITableRow row) {
            ((AbstractTable)this.getOwner()).execRowAction(row);
        }

        @Override
        public void execContentChanged(TableChains.TableContentChangedChain chain) {
            ((AbstractTable)this.getOwner()).execContentChanged();
        }

        @Override
        public ITableRowDataMapper execCreateTableRowDataMapper(TableChains.TableCreateTableRowDataMapperChain chain, Class<? extends AbstractTableRowData> rowType) {
            return ((AbstractTable)this.getOwner()).execCreateTableRowDataMapper(rowType);
        }

        @Override
        public void execInitTable(TableChains.TableInitTableChain chain) {
            ((AbstractTable)this.getOwner()).execInitTable();
        }

        @Override
        public void execResetColumns(TableChains.TableResetColumnsChain chain, Set<String> options) {
            ((AbstractTable)this.getOwner()).execResetColumns(options);
        }

        @Override
        public void execDecorateCell(TableChains.TableDecorateCellChain chain, Cell view, ITableRow row, IColumn<?> col) {
            ((AbstractTable)this.getOwner()).execDecorateCell(view, row, col);
        }

        @Override
        public void execDrop(TableChains.TableDropChain chain, ITableRow row, TransferObject t) {
            ((AbstractTable)this.getOwner()).execDrop(row, t);
        }

        @Override
        public void execDisposeTable(TableChains.TableDisposeTableChain chain) {
            ((AbstractTable)this.getOwner()).execDisposeTable();
        }

        @Override
        public void execRowClick(TableChains.TableRowClickChain chain, ITableRow row, MouseButton mouseButton) {
            ((AbstractTable)this.getOwner()).execRowClick(row, mouseButton);
        }

        @Override
        public void execDecorateRow(TableChains.TableDecorateRowChain chain, ITableRow row) {
            ((AbstractTable)this.getOwner()).execDecorateRow(row);
        }

        @Override
        public TransferObject execCopy(TableChains.TableCopyChain chain, List<? extends ITableRow> rows) {
            return ((AbstractTable)this.getOwner()).execCopy(rows);
        }

        @Override
        public void execRowsSelected(TableChains.TableRowsSelectedChain chain, List<? extends ITableRow> rows) {
            ((AbstractTable)this.getOwner()).execRowsSelected(rows);
        }

        @Override
        public TransferObject execDrag(TableChains.TableDragChain chain, List<ITableRow> rows) {
            return ((AbstractTable)this.getOwner()).execDrag(rows);
        }

        @Override
        public void execRowsChecked(TableChains.TableRowsCheckedChain chain, List<? extends ITableRow> row) {
            ((AbstractTable)this.getOwner()).execRowsChecked(row);
        }

        @Override
        public ITile execCreateTile(TableChains.TableCreateTileChain chain, ITableRow row) {
            return ((AbstractTable)this.getOwner()).execCreateTile(row);
        }
    }

    private static class P_CellEditorContext {
        private final ITableRow m_row;
        private final IColumn<?> m_column;
        private final IFormField m_formField;

        public P_CellEditorContext(ITableRow row, IColumn<?> col, IFormField f) {
            this.m_row = row;
            this.m_column = col;
            this.m_formField = f;
        }

        public ITableRow getRow() {
            return this.m_row;
        }

        public IColumn<?> getColumn() {
            return this.m_column;
        }

        public IFormField getFormField() {
            return this.m_formField;
        }
    }

    private class P_TableRowBuilder
    extends AbstractTableRowBuilder<Object> {
        private P_TableRowBuilder() {
        }

        @Override
        protected ITableRow createEmptyTableRow() {
            return new TableRow(AbstractTable.this.getColumnSet());
        }
    }

    protected class P_TableUIFacade
    implements ITableUIFacade {
        private int m_uiProcessorCount = 0;

        protected P_TableUIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void fireRowClickFromUI(ITableRow row, MouseButton mouseButton) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null) {
                    AbstractTable.this.fireRowClick(AbstractTable.this.resolveRow(row), mouseButton);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireRowActionFromUI(ITableRow row) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null) {
                    AbstractTable.this.fireRowAction(row);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireVisibleColumnsChangedFromUI(Collection<IColumn<?>> visibleColumns) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getColumnSet().setVisibleColumns(visibleColumns);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireColumnMovedFromUI(IColumn<?> c, int toViewIndex) {
            try {
                this.pushUIProcessor();
                c = AbstractTable.this.getColumnSet().resolveColumn(c);
                if (c != null) {
                    AbstractTable.this.getColumnSet().moveColumnToVisibleIndex(c.getColumnIndex(), toViewIndex);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setColumnWidthFromUI(IColumn<?> c, int newWidth) {
            try {
                this.pushUIProcessor();
                c = AbstractTable.this.getColumnSet().resolveColumn(c);
                if (c != null) {
                    c.setWidthInternal(newWidth);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHeaderSortFromUI(IColumn<?> c, boolean multiSort, boolean ascending) {
            try {
                this.pushUIProcessor();
                if (AbstractTable.this.isSortEnabled() && (c = AbstractTable.this.getColumnSet().resolveColumn(c)) != null) {
                    AbstractTable.this.getColumnSet().handleSortEvent(c, multiSort, ascending);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                    AbstractTable.this.sort();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHeaderGroupFromUI(IColumn<?> c, boolean multiGroup, boolean ascending) {
            try {
                this.pushUIProcessor();
                if (AbstractTable.this.isSortEnabled() && (c = AbstractTable.this.getColumnSet().resolveColumn(c)) != null) {
                    AbstractTable.this.getColumnSet().handleGroupingEvent(c, multiGroup, ascending);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                    AbstractTable.this.sort();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireAggregationFunctionChanged(INumberColumn<?> c, String function) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getColumnSet().setAggregationFunction(c, function);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setColumnBackgroundEffect(INumberColumn<?> column, String effect) {
            try {
                this.pushUIProcessor();
                column.setBackgroundEffect(effect);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setCheckedRowsFromUI(List<? extends ITableRow> rows, boolean checked) {
            if (!AbstractTable.this.isEnabled()) {
                return;
            }
            try {
                this.pushUIProcessor();
                AbstractTable.this.checkRows(rows, checked, true);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setExpandedRowsFromUI(List<? extends ITableRow> rows, boolean expanded) {
            if (CollectionUtility.isEmpty(rows)) {
                return;
            }
            try {
                this.pushUIProcessor();
                AbstractTable.this.expandRowsInternal(rows, expanded);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setSelectedRowsFromUI(List<? extends ITableRow> rows) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.selectRows(rows, false);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireRowsDragRequestFromUI() {
            try {
                this.pushUIProcessor();
                TransferObject transferObject = AbstractTable.this.fireRowsDragRequest();
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireRowDropActionFromUI(ITableRow row, TransferObject dropData) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                AbstractTable.this.fireRowDropAction(row, dropData);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireRowsCopyRequestFromUI() {
            try {
                this.pushUIProcessor();
                TransferObject transferObject = AbstractTable.this.fireRowsCopyRequest();
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            try {
                try {
                    this.pushUIProcessor();
                    AbstractTable.this.doAppLinkAction(ref);
                }
                catch (RuntimeException e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setContextColumnFromUI(IColumn<?> col) {
            try {
                this.pushUIProcessor();
                if (col != null && col.getTable() != AbstractTable.this) {
                    col = null;
                }
                AbstractTable.this.setContextColumn(col);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IFormField prepareCellEditFromUI(ITableRow row, IColumn<?> col) {
            if (!AbstractTable.this.isEnabled()) {
                return null;
            }
            try {
                this.pushUIProcessor();
                AbstractTable.this.disposeCellEditor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null && col != null) {
                    row.getTable().selectRow(row);
                    IFormField f = col.prepareEdit(row);
                    if (f != null) {
                        AbstractTable.this.m_editContext = new P_CellEditorContext(row, col, f);
                    }
                    AbstractTable.this.startCellEdit();
                    IFormField iFormField = f;
                    return iFormField;
                }
            }
            finally {
                this.popUIProcessor();
            }
            return null;
        }

        @Override
        public void completeCellEditFromUI() {
            if (!AbstractTable.this.isEnabled()) {
                return;
            }
            try {
                this.pushUIProcessor();
                AbstractTable.this.completeCellEdit();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void cancelCellEditFromUI() {
            try {
                this.pushUIProcessor();
                AbstractTable.this.cancelCellEdit();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireTableReloadFromUI(String reloadReason) {
            if (AbstractTable.this.m_reloadHandler != null) {
                try {
                    this.pushUIProcessor();
                    AbstractTable.this.m_reloadHandler.reload(reloadReason);
                }
                finally {
                    this.popUIProcessor();
                }
            }
        }

        @Override
        public void fireTableResetFromUI() {
            AbstractTable.this.reset();
        }

        @Override
        public void fireSortColumnRemovedFromUI(IColumn<?> column) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getColumnSet().removeSortColumn(column);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                AbstractTable.this.sort();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireGroupColumnRemovedFromUI(IColumn<?> column) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getColumnSet().removeGroupColumn(column);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                AbstractTable.this.sort();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireOrganizeColumnAddFromUI(IColumn<?> column) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getTableOrganizer().addColumn(column);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireOrganizeColumnRemoveFromUI(IColumn<?> column) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getTableOrganizer().removeColumn(column);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireOrganizeColumnModifyFromUI(IColumn<?> column) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getTableOrganizer().modifyColumn(column);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireFilterAddedFromUI(IUserFilterState filter) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getUserFilterManager().addFilter(filter);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireFilterRemovedFromUI(IUserFilterState filter) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getUserFilterManager().removeFilter(filter);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setFilteredRowsFromUI(List<? extends ITableRow> rows) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.removeUserRowFilters(false);
                UserTableRowFilter filter = new UserTableRowFilter(rows);
                AbstractTable.this.m_rowFilters.add(filter);
                AbstractTable.this.applyRowFilters();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void removeFilteredRowsFromUI() {
            try {
                this.pushUIProcessor();
                AbstractTable.this.removeUserRowFilters();
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

