/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.util.Date;

class TimeRange {
    private final Date m_from;
    private final Date m_to;

    public TimeRange(Date from, Date to) {
        this.m_from = from;
        this.m_to = to;
    }

    public boolean contains(Date representedDate) {
        return !representedDate.after(this.m_to) && !representedDate.before(this.m_from);
    }

    public Date getFrom() {
        return this.m_from;
    }

    public Date getTo() {
        return this.m_to;
    }

    public long getDurationMillis() {
        return this.m_to.getTime() - this.m_from.getTime();
    }

    public int getDurationMinutes() {
        return (int)(this.getDurationMillis() / 60000L);
    }
}

