/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.IActivityObserver;
import org.eclipse.scout.rt.client.ui.basic.planner.IResourceObserver;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class Resource<RI>
implements ICellObserver,
IActivityObserver {
    private final RI m_id;
    private final Cell m_cell;
    private final List<Activity<?, ?>> m_activities;
    private int m_resourceChanging = 0;
    private boolean m_resourcePropertiesChanged;
    private IResourceObserver<RI> m_observer;

    public Resource(RI id, String text) {
        this.m_id = id;
        this.m_cell = new Cell(this);
        this.m_cell.setText(text);
        this.m_cell.setObserver(this);
        this.m_activities = new ArrayList();
    }

    public RI getId() {
        return this.m_id;
    }

    public Cell getCell() {
        return this.m_cell;
    }

    public String getText() {
        return this.m_cell.getText();
    }

    public List<Activity<?, ?>> getActivities() {
        return CollectionUtility.arrayList(this.m_activities);
    }

    public void addActivities(List<Activity<?, ?>> activities) {
        this.setResourceChanging(true);
        try {
            for (Activity<?, ?> activity : activities) {
                this.addActivity(activity);
            }
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    public void removeAllActivities() {
        this.setResourceChanging(true);
        try {
            for (Activity<?, ?> activity : this.getActivities()) {
                this.removeActivity(activity);
            }
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    public void removeActivities(List<Activity<?, ?>> activities) {
        this.setResourceChanging(true);
        try {
            for (Activity<?, ?> activity : activities) {
                this.removeActivity(activity);
            }
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    public void addActivity(Activity<?, ?> activity) {
        this.setResourceChanging(true);
        try {
            this.m_activities.add(activity);
            activity.setObserver(this);
            this.m_resourcePropertiesChanged = true;
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    public void removeActivity(Activity<?, ?> activity) {
        this.setResourceChanging(true);
        try {
            this.m_activities.remove(activity);
            activity.setObserver(null);
            this.m_resourcePropertiesChanged = true;
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    @Override
    public Object validateValue(ICell cell, Object value) {
        return null;
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        try {
            this.setResourceChanging(true);
            this.m_resourcePropertiesChanged = true;
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    public void activityChanged(Activity activity, int bitPos) {
        try {
            this.setResourceChanging(true);
            this.m_resourcePropertiesChanged = true;
        }
        finally {
            this.setResourceChanging(false);
        }
    }

    public boolean isResourceChanging() {
        return this.m_resourceChanging > 0;
    }

    public void setResourceChanging(boolean b) {
        if (b) {
            ++this.m_resourceChanging;
        } else {
            --this.m_resourceChanging;
            if (this.m_resourceChanging == 0 && this.m_resourcePropertiesChanged) {
                this.m_resourcePropertiesChanged = false;
                if (this.m_observer != null) {
                    this.m_observer.resourceChanged(this);
                }
            }
        }
    }

    public void setObserver(IResourceObserver<RI> observer) {
        this.m_observer = observer;
    }

    public IResourceObserver<RI> getObserver() {
        return this.m_observer;
    }

    public String toString() {
        return String.valueOf(this.getId()) + " " + this.m_cell.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.m_id, resource.m_id);
    }

    public int hashCode() {
        return Objects.hash(this.m_id);
    }
}

