/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class PlannerEvent
extends EventObject
implements IModelEvent {
    public static final int TYPE_RESOURCES_INSERTED = 100;
    public static final int TYPE_RESOURCES_UPDATED = 101;
    public static final int TYPE_RESOURCES_DELETED = 102;
    public static final int TYPE_RESOURCES_SELECTED = 103;
    public static final int TYPE_ACTIVITY_ACTION = 104;
    public static final int TYPE_ALL_RESOURCES_DELETED = 105;
    private final int m_type;
    private List<? extends Resource> m_resources;
    private List<IMenu> m_popupMenus;

    public PlannerEvent(IPlanner source, int type) {
        super(source);
        this.m_type = type;
    }

    public PlannerEvent(IPlanner source, int type, List<? extends Resource> resources) {
        super(source);
        this.m_type = type;
        if (CollectionUtility.hasElements(resources)) {
            this.m_resources = CollectionUtility.arrayList(resources);
        }
    }

    public IPlanner getPlanner() {
        return (IPlanner)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public List<? extends Resource> getResources() {
        return CollectionUtility.arrayList(this.m_resources);
    }

    protected void setResources(List<? extends Resource> resources) {
        this.m_resources = CollectionUtility.arrayList(resources);
    }

    public int getResourceCount() {
        return this.m_resources != null ? this.m_resources.size() : 0;
    }

    public void addPopupMenu(IMenu menu) {
        if (menu == null) {
            return;
        }
        if (this.m_popupMenus == null) {
            this.m_popupMenus = new ArrayList<IMenu>();
        }
        this.m_popupMenus.add(menu);
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus == null) {
            return;
        }
        if (this.m_popupMenus == null) {
            this.m_popupMenus = new ArrayList<IMenu>(menus.size());
        }
        this.m_popupMenus.addAll(menus);
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    buf.append(aF.getName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception t) {
            buf.append("#").append(this.m_type);
        }
        buf.append(" ");
        if (CollectionUtility.hasElements(this.m_resources) && this.getPlanner() != null) {
            buf.append("Resources: ").append(this.m_resources);
        } else {
            buf.append("{}");
        }
        buf.append("]");
        return buf.toString();
    }
}

