/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.planner.IActivityObserver;
import org.eclipse.scout.rt.shared.data.basic.MemoryOptimizedObject;

public class Activity<RESOURCE_ID, ACTIVITY_ID>
extends MemoryOptimizedObject {
    private static final long serialVersionUID = 1L;
    public static final int OBSERVER_BIT = 0;
    public static final int RESOURCE_ID_BIT = 1;
    public static final int ID_BIT = 2;
    public static final int BEGIN_TIME_BIT = 3;
    public static final int END_TIME_BIT = 4;
    public static final int TEXT_BIT = 5;
    public static final int BACKGROUND_COLOR_BIT = 6;
    public static final int FOREGROUND_COLOR_BIT = 7;
    public static final int LEVEL_BIT = 8;
    public static final int LEVEL_COLOR_BIT = 9;
    public static final int CSS_CLASS_BIT = 10;
    public static final int DURATION_MINUTES_BIT = 12;
    public static final int TOOLTIP_TEXT_BIT = 13;
    public static final int CUSTOM_DATA = 15;

    public Activity(RESOURCE_ID resource, ACTIVITY_ID activityId) {
        this.setValueInternal(1, resource);
        this.setValueInternal(2, activityId);
    }

    public Activity(RESOURCE_ID resource, ACTIVITY_ID activityId, Date startTime, Date endTime, String text, String tooltipText, float level) {
        this.setValueInternal(1, resource);
        this.setValueInternal(2, activityId);
        this.setValueInternal(3, startTime);
        this.setValueInternal(4, endTime);
        this.setValueInternal(5, text);
        this.setValueInternal(13, tooltipText);
        this.setValueInternal(8, Float.valueOf(level));
    }

    public Activity(Object[] row) {
        if (row == null || row.length < 2) {
            throw new IllegalArgumentException("row must not be null or shorted than 2 elements");
        }
        if (row[0] == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        if (row[1] == null) {
            throw new IllegalArgumentException("activityId must not be null");
        }
        int i = 0;
        while (i < row.length) {
            if (row[i] != null) {
                switch (i) {
                    case 0: {
                        this.setValueInternal(1, row[i]);
                        break;
                    }
                    case 1: {
                        this.setValueInternal(2, row[i]);
                        break;
                    }
                    case 2: {
                        this.setValueInternal(3, row[i]);
                        break;
                    }
                    case 3: {
                        this.setValueInternal(4, row[i]);
                        break;
                    }
                    case 4: {
                        this.setText((String)row[i]);
                        break;
                    }
                    case 5: {
                        this.setTooltipText((String)row[i]);
                        break;
                    }
                    case 6: {
                        this.setLevel(((Number)row[i]).floatValue());
                    }
                }
            }
            ++i;
        }
    }

    public IActivityObserver<RESOURCE_ID, ACTIVITY_ID> getObserver() {
        return (IActivityObserver)this.getValueInternal(0);
    }

    public void setObserver(IActivityObserver<RESOURCE_ID, ACTIVITY_ID> observer) {
        this.setValueInternal(0, observer);
    }

    protected boolean setValueInternal(int bitPos, Object o) {
        boolean b = super.setValueInternal(bitPos, o);
        if (this.getObserver() != null && bitPos != 0) {
            this.getObserver().activityChanged(this, bitPos);
        }
        return b;
    }

    public ACTIVITY_ID getId() {
        return (ACTIVITY_ID)this.getValueInternal(2);
    }

    public RESOURCE_ID getResourceId() {
        return (RESOURCE_ID)this.getValueInternal(1);
    }

    public Date getBeginTime() {
        return (Date)this.getValueInternal(3);
    }

    public void setBeginTime(Date d) {
        this.setValueInternal(3, d);
    }

    public Date getEndTime() {
        return (Date)this.getValueInternal(4);
    }

    public void setEndTime(Date d) {
        this.setValueInternal(4, d);
    }

    public int getDurationMinutes() {
        Integer o = (Integer)this.getValueInternal(12);
        return o != null ? o : 0;
    }

    public float getLevel() {
        Float o = (Float)this.getValueInternal(8);
        return o != null ? o.floatValue() : 0.0f;
    }

    public void setLevel(float f) {
        this.setValueInternal(8, Float.valueOf(f));
    }

    public String getLevelColor() {
        return (String)this.getValueInternal(9);
    }

    public void setLevelColor(String s) {
        this.setValueInternal(9, s);
    }

    public String getCssClass() {
        return (String)this.getValueInternal(10);
    }

    public void setCssClass(String s) {
        this.setValueInternal(10, s);
    }

    public String getTooltipText() {
        return (String)this.getValueInternal(13);
    }

    public void setTooltipText(String s) {
        this.setValueInternal(13, s);
    }

    public String getText() {
        return (String)this.getValueInternal(5);
    }

    public void setText(String s) {
        this.setValueInternal(5, s);
    }

    public String getBackgroundColor() {
        return (String)this.getValueInternal(6);
    }

    public void setBackgroundColor(String c) {
        this.setValueInternal(6, c);
    }

    public String getForegroundColor() {
        return (String)this.getValueInternal(7);
    }

    public void setForegroundColor(String c) {
        this.setValueInternal(7, c);
    }

    public Object getCustomData() {
        return this.getValueInternal(15);
    }

    public void setCustomData(Object o) {
        this.setValueInternal(15, o);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getText() + "]";
    }
}

