/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.planner.IPlannerExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.planner.PlannerChains;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IPlannerContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.PlannerContextMenu;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.DisplayModeOptions;
import org.eclipse.scout.rt.client.ui.basic.planner.IActivityObserver;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlannerUIFacade;
import org.eclipse.scout.rt.client.ui.basic.planner.IResourceObserver;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerAdapter;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerEvent;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerEventBuffer;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerListener;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="38cbdf76-8742-4c1c-89b3-ef994391a7a5")
public abstract class AbstractPlanner<RI, AI>
extends AbstractWidget
implements IPlanner<RI, AI>,
IContributionOwner,
IExtensibleObject {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPlanner.class);
    private FastListenerList<PlannerListener> m_listenerList;
    private IPlannerUIFacade m_activityMapUIFacade;
    private final List<Resource<RI>> m_resources;
    private List<Resource<RI>> m_selectedResources = new ArrayList<Resource<RI>>();
    private int m_tableChanging;
    private final AbstractEventBuffer<PlannerEvent> m_eventBuffer;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractPlanner<RI, AI>, IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> m_objectExtensions;
    private int m_eventBufferLoopDetection;
    private IResourceObserver<RI> m_resourceObserver = new P_ResourceObserver();

    public AbstractPlanner() {
        this(true);
    }

    public AbstractPlanner(boolean callInitializer) {
        super(false);
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        this.m_resources = new ArrayList<Resource<RI>>();
        this.m_eventBuffer = this.createEventBuffer();
        this.m_resourceObserver = new P_ResourceObserver();
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus()});
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    @Override
    public AbstractEventBuffer<PlannerEvent> createEventBuffer() {
        return (AbstractEventBuffer)BEANS.get(PlannerEventBuffer.class);
    }

    protected AbstractEventBuffer<PlannerEvent> getEventBuffer() {
        return this.m_eventBuffer;
    }

    @ConfigProperty(value="STRING")
    @Order(value=5.0)
    protected String getConfiguredLabel() {
        return null;
    }

    @Order(value=10.0)
    protected Set<Integer> getConfiguredAvailableDisplayModes() {
        return CollectionUtility.hashSet((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=165.0)
    protected boolean getConfiguredRangeSelectable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=170.0)
    protected boolean getConfiguredMultiSelect() {
        return true;
    }

    @Order(value=175.0)
    protected boolean getConfiguredActivitySelectable() {
        return false;
    }

    @Order(value=180.0)
    protected int getConfiguredDisplayMode() {
        return 5;
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execDisplayModeChanged(int displayMode) {
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        if (this.getViewRange() != null && this.getViewRange().getFrom() != null) {
            from.setTime((Date)this.getViewRange().getFrom());
            to.setTime((Date)this.getViewRange().getFrom());
        }
        DateUtility.truncCalendar((Calendar)from);
        DateUtility.truncCalendar((Calendar)to);
        switch (displayMode) {
            case 1: {
                to.add(7, 1);
                break;
            }
            case 2: {
                from.set(7, 2);
                to.set(7, 2);
                to.add(7, 7);
                break;
            }
            case 4: {
                from.set(7, 2);
                to.set(7, 2);
                to.add(7, 5);
                break;
            }
            case 3: {
                from.set(7, 2);
                to.set(7, 2);
                to.add(2, 2);
                break;
            }
            case 5: {
                from.set(7, 2);
                to.set(7, 2);
                to.add(2, 9);
                break;
            }
            case 6: {
                to.add(1, 2);
            }
        }
        this.setViewRange(from.getTime(), to.getTime());
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execViewRangeChanged(Range<Date> viewRange) {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execResourcesSelected(List<Resource<RI>> resources) {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execSelectionRangeChanged(Range<Date> selectionRange) {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execActivitySelected(Activity<RI, AI> activity) {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execDecorateActivity(Activity<RI, AI> activity) {
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execInitPlanner() {
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execDisposePlanner() {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_listenerList = new FastListenerList();
        this.m_activityMapUIFacade = this.createUIFacade();
        this.setLabel(this.getConfiguredLabel());
        this.setAvailableDisplayModes(this.getConfiguredAvailableDisplayModes());
        this.setDisplayMode(this.getConfiguredDisplayMode());
        this.setDisplayModeOptions(new HashMap<Integer, DisplayModeOptions>());
        this.initDisplayModeOptions();
        this.setHeaderVisible(this.getConfiguredHeaderVisible());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setRangeSelectable(this.getConfiguredRangeSelectable());
        this.setActivitySelectable(this.getConfiguredActivitySelectable());
        List<Class<IMenu>> declaredMenus = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        for (Class<IMenu> menuClazz : declaredMenus) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
            menus.addOrdered((IOrdered)menu);
        }
        this.m_contributionHolder = new ContributionComposite((Object)this);
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e2) {
            LOG.error("Error occurred while dynamically contributing menus.", (Throwable)e2);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        PlannerContextMenu contextMenu = new PlannerContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
        this.setContextMenu(contextMenu);
        this.addPlannerListener(new PlannerAdapter(){

            @Override
            public void plannerChanged(PlannerEvent e) {
                if (e.getType() == 103) {
                    List resources = e.getResources();
                    try {
                        AbstractPlanner.this.interceptResourcesSelected(resources);
                    }
                    catch (Exception t) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
                    }
                }
            }
        });
        this.addPropertyChangeListener(e -> {
            switch (e.getPropertyName()) {
                case "displayMode": {
                    try {
                        this.interceptDisplayModeChanged((Integer)e.getNewValue());
                    }
                    catch (Exception t) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
                    }
                    break;
                }
                case "viewRange": {
                    try {
                        this.interceptViewRangeChanged((Range<Date>)((Range)e.getNewValue()));
                    }
                    catch (Exception t) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
                    }
                    break;
                }
                case "selectionRange": {
                    try {
                        this.interceptSelectionRangeChanged((Range<Date>)((Range)e.getNewValue()));
                    }
                    catch (Exception t) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
                    }
                    break;
                }
                case "selectedActivity": {
                    Activity cell = (Activity)((Object)((Object)e.getNewValue()));
                    if (cell == null) break;
                    try {
                        this.interceptActivitySelected(cell);
                        break;
                    }
                    catch (Exception t) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
                    }
                }
            }
        });
    }

    protected void initDisplayModeOptions() {
        this.setDisplayModeOption(1, new DisplayModeOptions().withInterval(30L));
        this.setDisplayModeOption(2, new DisplayModeOptions().withInterval(360L));
        this.setDisplayModeOption(4, new DisplayModeOptions().withInterval(360L));
        this.setDisplayModeOption(3, new DisplayModeOptions().withLabelPeriod(2));
        this.setDisplayModeOption(5, new DisplayModeOptions());
        this.setDisplayModeOption(6, new DisplayModeOptions());
    }

    public final List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> createLocalExtension() {
        return new LocalPlannerExtension(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    protected IPlannerUIFacade createUIFacade() {
        return new P_PlannerUIFacade();
    }

    @Override
    protected final void initInternal() {
        super.initInternal();
        this.initPlannerInternal();
        this.interceptInitPlanner();
    }

    protected void initPlannerInternal() {
    }

    @Override
    protected final void disposeInternal() {
        this.disposePlannerInternal();
        try {
            this.interceptDisposePlanner();
        }
        catch (Exception t) {
            LOG.warn(this.getClass().getName(), (Throwable)t);
        }
        super.disposeInternal();
    }

    protected void disposePlannerInternal() {
    }

    @Override
    public IFastListenerList<PlannerListener> plannerListeners() {
        return this.m_listenerList;
    }

    @Override
    public void replaceResources(List<Resource<RI>> resources) {
        this.setPlannerChanging(true);
        try {
            List<RI> selectedResourceIds = this.getSelectedResourceIds();
            this.deleteAllResources();
            this.addResources(resources);
            this.restoreSelection(selectedResourceIds);
        }
        finally {
            this.setPlannerChanging(false);
        }
    }

    private void restoreSelection(List<RI> selectedIds) {
        ArrayList<Resource<RI>> selectedResources = new ArrayList<Resource<RI>>();
        if (!selectedIds.isEmpty()) {
            for (Resource<RI> resource : this.getResources()) {
                if (!selectedIds.remove(resource.getId())) continue;
                selectedResources.add(resource);
                if (selectedIds.isEmpty()) break;
            }
        }
        this.selectResources((List<? extends Resource<RI>>)selectedResources);
    }

    @Override
    public void deleteResource(Resource<RI> resource) {
        this.deleteResources(CollectionUtility.arrayList(resource));
    }

    @Override
    public void deleteResources(List<Resource<RI>> resources) {
        this.setPlannerChanging(true);
        try {
            int resourceCountBefore = this.m_resources.size();
            ArrayList<Resource<RI>> deletedResources = new ArrayList<Resource<RI>>();
            for (Resource<RI> resource : resources) {
                this.m_resources.remove(resource);
                deletedResources.add(resource);
            }
            if (deletedResources.size() == resourceCountBefore) {
                this.fireAllResourcesDeleted();
                this.deselectAllResources();
                this.setSelectionRange((Range<Date>)new Range());
            } else {
                this.fireResourcesDeleted(deletedResources);
                if (this.deselectResources((List<? extends Resource<RI>>)deletedResources)) {
                    this.setSelectionRange((Range<Date>)new Range());
                }
            }
        }
        finally {
            this.setPlannerChanging(false);
        }
    }

    @Override
    public void deleteAllResources() {
        this.setPlannerChanging(true);
        try {
            this.deleteResources(this.getResources());
        }
        finally {
            this.setPlannerChanging(false);
        }
    }

    @Override
    public void addResources(List<Resource<RI>> resources) {
        this.setPlannerChanging(true);
        try {
            for (Resource<RI> resource : resources) {
                this.decorateResource(resource);
                resource.setObserver(this.m_resourceObserver);
                this.m_resources.add(resource);
            }
            this.fireResourcesInserted(resources);
        }
        finally {
            this.setPlannerChanging(false);
        }
    }

    @Override
    public void addResource(Resource<RI> resource) {
        this.addResources(CollectionUtility.arrayList(resource));
    }

    public void updateResource(Resource<RI> resource) {
        this.updateResources(CollectionUtility.arrayList(resource));
    }

    public void updateResources(List<Resource<RI>> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (Resource<RI> resource : resources) {
            this.decorateResource(resource);
        }
        this.setPlannerChanging(true);
        try {
            this.fireResourcesUpdated(resources);
        }
        finally {
            this.setPlannerChanging(false);
        }
    }

    @Override
    public List<Resource<RI>> getResources() {
        return CollectionUtility.arrayList(this.m_resources);
    }

    @Override
    public Activity<RI, AI> getSelectedActivity() {
        return (Activity)((Object)this.propertySupport.getProperty("selectedActivity"));
    }

    @Override
    public void setSelectedActivity(Activity<RI, AI> activity) {
        this.propertySupport.setProperty("selectedActivity", activity);
    }

    @Override
    public boolean isSelectedActivity(Activity<RI, AI> activity) {
        return this.getSelectedActivity() == activity;
    }

    @Override
    public Resource<RI> getSelectedResource() {
        return (Resource)CollectionUtility.firstElement(this.m_selectedResources);
    }

    @Override
    public List<Resource<RI>> getSelectedResources() {
        return CollectionUtility.arrayList(this.m_selectedResources);
    }

    @Override
    public List<RI> getSelectedResourceIds() {
        ArrayList<RI> ids = new ArrayList<RI>();
        List<Resource<RI>> resources = this.getSelectedResources();
        for (Resource<RI> resource : resources) {
            ids.add(resource.getId());
        }
        return ids;
    }

    @Override
    public void deselectAllResources() {
        this.selectResources(new ArrayList());
    }

    @Override
    public boolean deselectResource(Resource<RI> resource) {
        return this.deselectResources(CollectionUtility.arrayList(resource));
    }

    @Override
    public boolean deselectResources(List<? extends Resource<RI>> resources) {
        List<Resource<RI>> selectedResources = this.getSelectedResources();
        boolean selectionChanged = selectedResources.removeAll(resources);
        if (selectionChanged) {
            this.selectResources((List<? extends Resource<RI>>)selectedResources);
        }
        return selectionChanged;
    }

    @Override
    public void selectResource(Resource<RI> resource) {
        this.selectResources(CollectionUtility.arrayList(resource));
    }

    @Override
    public void selectResources(List<? extends Resource<RI>> resources) {
        this.setPlannerChanging(true);
        try {
            ArrayList<Resource<RI>> newSelection = new ArrayList<Resource<RI>>(resources);
            if (newSelection.size() > 1 && !this.isMultiSelect()) {
                Resource first = (Resource)newSelection.get(0);
                newSelection.clear();
                newSelection.add(first);
            }
            if (!CollectionUtility.equalsCollection(this.m_selectedResources, newSelection, (boolean)false)) {
                this.m_selectedResources = new ArrayList<Resource<RI>>(newSelection);
                ArrayList notificationCopy = CollectionUtility.arrayList(this.m_selectedResources);
                this.fireResourcesSelected(notificationCopy);
            }
        }
        finally {
            this.setPlannerChanging(false);
        }
    }

    @Override
    public boolean isSelectedResource(Resource<RI> resource) {
        return this.getSelectedResources().contains(resource);
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.getContextMenu().setChildActions(menus);
    }

    @Override
    public void addMenu(IMenu menu) {
        List<IMenu> menus = this.getMenus();
        menus.add(menu);
        this.setMenus(menus);
    }

    protected void setContextMenu(IPlannerContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenus", (Object)contextMenu);
    }

    @Override
    public IPlannerContextMenu getContextMenu() {
        return (IPlannerContextMenu)this.propertySupport.getProperty("contextMenus");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    private void fireResourcesInserted(List<Resource<RI>> resources) {
        PlannerEvent e = new PlannerEvent(this, 100, resources);
        this.firePlannerEventInternal(e);
    }

    private void fireResourcesUpdated(List<Resource<RI>> resources) {
        PlannerEvent e = new PlannerEvent(this, 101, resources);
        this.firePlannerEventInternal(e);
    }

    private void fireResourcesDeleted(List<Resource<RI>> resources) {
        PlannerEvent e = new PlannerEvent(this, 102, resources);
        this.firePlannerEventInternal(e);
    }

    private void fireAllResourcesDeleted() {
        PlannerEvent e = new PlannerEvent(this, 105);
        this.firePlannerEventInternal(e);
    }

    private void fireResourcesSelected(List<Resource<RI>> resources) {
        PlannerEvent e = new PlannerEvent(this, 103, resources);
        this.firePlannerEventInternal(e);
    }

    private void firePlannerEventInternal(PlannerEvent e) {
        if (this.isPlannerChanging()) {
            this.getEventBuffer().add(e);
        } else {
            this.plannerListeners().list().forEach(listener -> listener.plannerChanged(e));
        }
    }

    private void firePlannerEventBatchInternal(List<PlannerEvent> batch) {
        if (CollectionUtility.hasElements(batch)) {
            this.plannerListeners().list().forEach(listener -> listener.plannerChangedBatch(batch));
        }
    }

    private void processEventBuffer() {
        block8: {
            try {
                ++this.m_eventBufferLoopDetection;
                if (this.m_eventBufferLoopDetection > 100) {
                    LOG.error("LOOP DETECTION in {}. see stack trace for more details.", this.getClass(), (Object)new Exception("LOOP DETECTION"));
                    return;
                }
                if (this.getEventBuffer().isEmpty()) break block8;
                List<PlannerEvent> coalescedEvents = this.getEventBuffer().consumeAndCoalesceEvents();
                try {
                    this.setPlannerChanging(true);
                    this.firePlannerEventBatchInternal(coalescedEvents);
                }
                finally {
                    this.setPlannerChanging(false);
                }
            }
            finally {
                --this.m_eventBufferLoopDetection;
            }
        }
    }

    @Override
    public boolean isPlannerChanging() {
        return this.m_tableChanging > 0;
    }

    @Override
    public void setPlannerChanging(boolean b) {
        if (b) {
            ++this.m_tableChanging;
            if (this.m_tableChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_tableChanging > 0) {
            --this.m_tableChanging;
            if (this.m_tableChanging == 0) {
                try {
                    this.processEventBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    @Override
    public void setLabel(String label) {
        this.propertySupport.setPropertyString("label", label);
    }

    @Override
    public String getLabel() {
        return this.propertySupport.getPropertyString("label");
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        this.propertySupport.setPropertyBool("headerVisible", visible);
    }

    @Override
    public boolean isHeaderVisible() {
        return this.propertySupport.getPropertyBool("headerVisible");
    }

    @Override
    public void setMultiSelect(boolean resourceMultiSelect) {
        this.propertySupport.setPropertyBool("multiSelect", resourceMultiSelect);
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public int getDisplayMode() {
        return this.propertySupport.getPropertyInt("displayMode");
    }

    @Override
    public void setDisplayMode(int mode) {
        this.propertySupport.setPropertyInt("displayMode", mode);
    }

    @Override
    public Set<Integer> getAvailableDisplayModes() {
        return (Set)this.propertySupport.getProperty("availableDisplayModes");
    }

    @Override
    public void setAvailableDisplayModes(Set<Integer> modes) {
        this.propertySupport.setProperty("availableDisplayModes", modes);
    }

    @Override
    public Map<Integer, DisplayModeOptions> getDisplayModeOptions() {
        return (Map)this.propertySupport.getProperty("displayModeOptions");
    }

    @Override
    public void setDisplayModeOptions(Map<Integer, DisplayModeOptions> displayModeOptions) {
        this.propertySupport.setProperty("displayModeOptions", displayModeOptions);
    }

    @Override
    public void setDisplayModeOption(int displayMode, DisplayModeOptions displayModeOption) {
        DisplayModeOptions previousDisplayModeOption = this.getDisplayModeOptions().put(displayMode, displayModeOption);
        if (ObjectUtility.notEquals((Object)displayModeOption, (Object)previousDisplayModeOption)) {
            this.propertySupport.firePropertyChange(new PropertyChangeEvent(this, "displayModeOptions", null, this.getDisplayModeOptions()));
        }
    }

    @Override
    public boolean isRangeSelectable() {
        return this.propertySupport.getPropertyBool("rangeSelectable");
    }

    @Override
    public void setRangeSelectable(boolean rangeSelectable) {
        this.propertySupport.setPropertyBool("rangeSelectable", rangeSelectable);
    }

    @Override
    public boolean isActivitySelectable() {
        return this.propertySupport.getPropertyBool("activitySelectable");
    }

    @Override
    public void setActivitySelectable(boolean selectable) {
        this.propertySupport.setPropertyBool("activitySelectable", selectable);
    }

    @Override
    public Range<Date> getViewRange() {
        Range propValue = (Range)this.propertySupport.getProperty("viewRange");
        return new Range(propValue);
    }

    @Override
    public void setViewRange(Date minDate, Date maxDate) {
        this.setViewRange((Range<Date>)new Range((Object)minDate, (Object)maxDate));
    }

    @Override
    public void setViewRange(Range<Date> viewRange) {
        LOG.debug("Setting view range to {}", viewRange);
        if (viewRange != null) {
            viewRange.setFrom((Object)this.ensureTruncated((Date)viewRange.getFrom(), "from"));
            viewRange.setTo((Object)this.ensureTruncated((Date)viewRange.getTo(), "to"));
            if (viewRange.getFrom() != null && viewRange.getTo() != null && ((Date)viewRange.getFrom()).getTime() >= ((Date)viewRange.getTo()).getTime()) {
                throw new IllegalArgumentException("Invalid viewRange provided: " + String.valueOf(viewRange));
            }
        }
        this.propertySupport.setProperty("viewRange", viewRange);
    }

    private Date ensureTruncated(Date date, String fromOrTo) {
        if (date == null) {
            return null;
        }
        Date truncated = DateUtility.truncDate((Date)date);
        if (!date.equals(truncated)) {
            LOG.warn("Had to truncate {} date of range, because UI does not support intra day ranges: {}", (Object)fromOrTo, (Object)date);
        }
        return truncated;
    }

    @Override
    public void setSelectionRange(Date beginDate, Date endDate) {
        this.setSelectionRange((Range<Date>)new Range((Object)beginDate, (Object)endDate));
    }

    @Override
    public void setSelectionRange(Range<Date> selectionRange) {
        LOG.debug("Setting selection range to {}", selectionRange);
        this.propertySupport.setProperty("selectionRange", selectionRange);
    }

    @Override
    public Range<Date> getSelectionRange() {
        Range propValue = (Range)this.propertySupport.getProperty("selectionRange");
        return new Range(propValue);
    }

    @Override
    public Date getSelectedBeginTime() {
        return (Date)this.getSelectionRange().getFrom();
    }

    @Override
    public Date getSelectedEndTime() {
        return (Date)this.getSelectionRange().getTo();
    }

    @Override
    public void decorateResource(Resource<RI> resource) {
        IResourceObserver<RI> observer = resource.getObserver();
        try {
            try {
                resource.setObserver(null);
                Iterator<Activity<?, ?>> iterator = resource.getActivities().iterator();
                while (iterator.hasNext()) {
                    Activity<?, ?> activity;
                    Activity<?, ?> castedActivity = activity = iterator.next();
                    this.decorateActivity((Activity<RI, AI>)castedActivity);
                }
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                resource.setObserver(observer);
            }
        }
        finally {
            resource.setObserver(observer);
        }
    }

    @Override
    public void decorateActivity(Activity<RI, AI> activity) {
        IActivityObserver<RI, AI> observer = activity.getObserver();
        try {
            try {
                activity.setObserver(null);
                this.interceptDecorateActivity(activity);
            }
            catch (RuntimeException e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                activity.setObserver(observer);
            }
        }
        finally {
            activity.setObserver(observer);
        }
    }

    @Override
    public IPlannerUIFacade getUIFacade() {
        return this.m_activityMapUIFacade;
    }

    protected final void interceptResourcesSelected(List<Resource<RI>> resources) {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerResourcesSelectedChain<RI, AI> chain = new PlannerChains.PlannerResourcesSelectedChain<RI, AI>(extensions);
        chain.execResourcesSelected(resources);
    }

    protected final void interceptSelectionRangeChanged(Range<Date> selectionRange) {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerSelectionRangeChangedChain<RI, AI> chain = new PlannerChains.PlannerSelectionRangeChangedChain<RI, AI>(extensions);
        chain.execSelectionRangeChanged(selectionRange);
    }

    protected final void interceptViewRangeChanged(Range<Date> viewRange) {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerViewRangeChangedChain<RI, AI> chain = new PlannerChains.PlannerViewRangeChangedChain<RI, AI>(extensions);
        chain.execViewRangeChanged(viewRange);
    }

    protected void interceptDisplayModeChanged(int displayMode) {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerDisplayModeChangedChain<RI, AI> chain = new PlannerChains.PlannerDisplayModeChangedChain<RI, AI>(extensions);
        chain.execDisplayModeChanged(displayMode);
    }

    protected final void interceptActivitySelected(Activity<RI, AI> cell) {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerActivitySelectedChain<RI, AI> chain = new PlannerChains.PlannerActivitySelectedChain<RI, AI>(extensions);
        chain.execActivitySelected(cell);
    }

    protected final void interceptDisposePlanner() {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerDisposePlannerChain<RI, AI> chain = new PlannerChains.PlannerDisposePlannerChain<RI, AI>(extensions);
        chain.execDisposePlanner();
    }

    protected final void interceptDecorateActivity(Activity<RI, AI> activity) {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerDecorateActivityChain<RI, AI> chain = new PlannerChains.PlannerDecorateActivityChain<RI, AI>(extensions);
        chain.execDecorateActivity(activity);
    }

    protected final void interceptInitPlanner() {
        List<IPlannerExtension<RI, AI, AbstractPlanner<RI, AI>>> extensions = this.getAllExtensions();
        PlannerChains.PlannerInitPlannerChain<RI, AI> chain = new PlannerChains.PlannerInitPlannerChain<RI, AI>(extensions);
        chain.execInitPlanner();
    }

    protected static class LocalPlannerExtension<RI, AI, OWNER extends AbstractPlanner<RI, AI>>
    extends AbstractExtension<OWNER>
    implements IPlannerExtension<RI, AI, OWNER> {
        public LocalPlannerExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execActivitySelected(PlannerChains.PlannerActivitySelectedChain<RI, AI> chain, Activity<RI, AI> cell) {
            ((AbstractPlanner)this.getOwner()).execActivitySelected(cell);
        }

        @Override
        public void execDisposePlanner(PlannerChains.PlannerDisposePlannerChain<RI, AI> chain) {
            ((AbstractPlanner)this.getOwner()).execDisposePlanner();
        }

        @Override
        public void execDecorateActivityCell(PlannerChains.PlannerDecorateActivityChain<RI, AI> chain, Activity<RI, AI> cell) {
            ((AbstractPlanner)this.getOwner()).execDecorateActivity(cell);
        }

        @Override
        public void execInitPlanner(PlannerChains.PlannerInitPlannerChain<RI, AI> chain) {
            ((AbstractPlanner)this.getOwner()).execInitPlanner();
        }

        @Override
        public void execResourcesSelected(PlannerChains.PlannerResourcesSelectedChain<RI, AI> plannerResourcesSelectedChain, List<Resource<RI>> resources) {
            ((AbstractPlanner)this.getOwner()).execResourcesSelected(resources);
        }

        @Override
        public void execSelectionRangeChanged(PlannerChains.PlannerSelectionRangeChangedChain<RI, AI> plannerSelectionRangeChangedChain, Range<Date> selectionRange) {
            ((AbstractPlanner)this.getOwner()).execSelectionRangeChanged(selectionRange);
        }

        @Override
        public void execViewRangeChanged(PlannerChains.PlannerViewRangeChangedChain<RI, AI> plannerViewRangeChangedChain, Range<Date> viewRange) {
            ((AbstractPlanner)this.getOwner()).execViewRangeChanged(viewRange);
        }

        @Override
        public void execDisplayModeChanged(PlannerChains.PlannerDisplayModeChangedChain<RI, AI> plannerDisplayModeChangedChain, int displayMode) {
            ((AbstractPlanner)this.getOwner()).execDisplayModeChanged(displayMode);
        }
    }

    private class P_PlannerUIFacade
    implements IPlannerUIFacade<RI, AI> {
        private P_PlannerUIFacade() {
        }

        @Override
        public void setSelectedResourcesFromUI(List<? extends Resource<RI>> resources) {
            try {
                AbstractPlanner.this.setPlannerChanging(true);
                AbstractPlanner.this.selectResources(resources);
            }
            finally {
                AbstractPlanner.this.setPlannerChanging(false);
            }
        }

        @Override
        public void setSelectionRangeFromUI(Range<Date> selectionRange) {
            AbstractPlanner.this.setSelectionRange(selectionRange);
        }

        @Override
        public void setDisplayModeFromUI(int displayMode) {
            AbstractPlanner.this.setDisplayMode(displayMode);
        }

        @Override
        public void setViewRangeFromUI(Range<Date> viewRange) {
            AbstractPlanner.this.setViewRange(viewRange);
        }

        @Override
        public void setSelectedActivityFromUI(Activity<RI, AI> activity) {
            AbstractPlanner.this.setSelectedActivity(activity);
        }
    }

    private class P_ResourceObserver
    implements IResourceObserver<RI> {
        private P_ResourceObserver() {
        }

        @Override
        public void resourceChanged(Resource<RI> resource) {
            try {
                AbstractPlanner.this.updateResource(resource);
            }
            catch (RuntimeException e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
    }
}

