/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.cell;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.IHtmlCapable;
import org.eclipse.scout.rt.client.ui.IStyleable;
import org.eclipse.scout.rt.client.ui.basic.cell.CellExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.CellStyle;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellSpecialization;
import org.eclipse.scout.rt.client.ui.form.fields.DefaultFieldStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ValidationFailedStatus;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.MultiStatus;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cell
implements ICell,
IStyleable,
IHtmlCapable {
    private static final Logger LOG = LoggerFactory.getLogger(Cell.class);
    private static final Map<CellStyle, CellStyle> SHARED_STYLE_STORE;
    private static final Object SHARED_STYLE_STORE_LOCK;
    private static final CellStyle DEFAULT_CELL_STYLE;
    private ICellObserver m_observer;
    private Object m_value;
    private String m_text;
    private ICellSpecialization m_cellSpecialization = DEFAULT_CELL_STYLE;
    private IMultiStatus m_errorStatus = null;

    static {
        SHARED_STYLE_STORE_LOCK = new Object();
        SHARED_STYLE_STORE = new HashMap<CellStyle, CellStyle>();
        DEFAULT_CELL_STYLE = new CellStyle();
        SHARED_STYLE_STORE.put(DEFAULT_CELL_STYLE, DEFAULT_CELL_STYLE);
    }

    public Cell() {
    }

    public Cell(ICell c) {
        try {
            this.updateFrom(c);
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected", (Throwable)e);
        }
    }

    public Cell(ICellObserver observer) {
        this.setObserver(observer);
    }

    public Cell(ICellObserver observer, ICell c) {
        this.updateFrom(c);
        this.setObserver(observer);
    }

    public void updateFrom(ICell c) {
        if (c != null) {
            this.setCssClass(c.getCssClass());
            this.setFont(c.getFont());
            this.setEditable(c.isEditable());
            this.setForegroundColor(c.getForegroundColor());
            this.setBackgroundColor(c.getBackgroundColor());
            this.setHorizontalAlignment(c.getHorizontalAlignment());
            this.setTooltipText(c.getTooltipText());
            this.setIconId(c.getIconId());
            this.setText(c.getText());
            this.setValue(c.getValue());
            this.setMandatory(c.isMandatory());
            this.setErrorStatusInternal(c.getErrorStatus());
            this.setHtmlEnabled(c.isHtmlEnabled());
        }
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    public boolean setValue(Object value) {
        if (this.getObserver() != null) {
            try {
                value = this.getObserver().validateValue(this, value);
            }
            catch (ProcessingException e) {
                this.addErrorStatus((IStatus)new ValidationFailedStatus<Object>(e, value));
            }
        }
        if (ObjectUtility.equals((Object)this.m_value, (Object)value)) {
            return false;
        }
        this.m_value = value;
        this.notifyObserver(1);
        return true;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    public void setText(String s) {
        if (ObjectUtility.notEquals((Object)this.m_text, (Object)s)) {
            this.m_text = s;
            this.notifyObserver(2);
        }
    }

    @Override
    public String getCssClass() {
        return this.m_cellSpecialization.getCssClass();
    }

    @Override
    public void setCssClass(String cssClass) {
        if (ObjectUtility.notEquals((Object)this.m_cellSpecialization.getCssClass(), (Object)cssClass)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setCssClass(cssClass);
            this.setValueInternal(11, newStyle);
        }
    }

    @Override
    public String getIconId() {
        return this.m_cellSpecialization.getIconId();
    }

    public void setIconId(String s) {
        if (ObjectUtility.notEquals((Object)this.m_cellSpecialization.getIconId(), (Object)s)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setIconId(s);
            this.setValueInternal(3, newStyle);
        }
    }

    @Override
    public String getTooltipText() {
        return this.m_cellSpecialization.getTooltipText();
    }

    public void setTooltipText(String s) {
        if (this.m_cellSpecialization instanceof CellStyle) {
            if (!StringUtility.isNullOrEmpty((CharSequence)s)) {
                CellExtension newStyle = new CellExtension(this.m_cellSpecialization);
                newStyle.setTooltipText(s);
                this.setValueInternal(4, newStyle);
            }
        } else if (ObjectUtility.notEquals((Object)this.m_cellSpecialization.getIconId(), (Object)s)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setTooltipText(s);
            this.setValueInternal(4, newStyle);
        }
    }

    @Override
    public boolean isMandatory() {
        return this.m_cellSpecialization.isMandatory();
    }

    public void setMandatory(boolean mandatory) {
        if (this.m_cellSpecialization instanceof CellStyle) {
            if (mandatory) {
                CellExtension newStyle = new CellExtension(this.m_cellSpecialization);
                newStyle.setMandatory(mandatory);
                this.setValueInternal(13, newStyle);
            }
        } else if (ObjectUtility.notEquals((Object)this.m_cellSpecialization.isMandatory(), (Object)mandatory)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setMandatory(mandatory);
            this.setValueInternal(13, newStyle);
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return this.m_cellSpecialization.getHorizontalAlignment();
    }

    public void setHorizontalAlignment(int a) {
        if (this.m_cellSpecialization.getHorizontalAlignment() != a) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setHorizontalAlignment(a);
            this.setValueInternal(5, newStyle);
        }
    }

    @Override
    public String getBackgroundColor() {
        return this.m_cellSpecialization.getBackgroundColor();
    }

    public void setBackgroundColor(String c) {
        if (ObjectUtility.notEquals((Object)this.m_cellSpecialization.getBackgroundColor(), (Object)c)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setBackgroundColor(c);
            this.setValueInternal(6, newStyle);
        }
    }

    @Override
    public String getForegroundColor() {
        return this.m_cellSpecialization.getForegroundColor();
    }

    public void setForegroundColor(String c) {
        if (ObjectUtility.notEquals((Object)this.m_cellSpecialization.getForegroundColor(), (Object)c)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setForegroundColor(c);
            this.setValueInternal(7, newStyle);
        }
    }

    @Override
    public FontSpec getFont() {
        return this.m_cellSpecialization.getFont();
    }

    public void setFont(FontSpec f) {
        if (this.m_cellSpecialization.getFont() == null && f != null || this.m_cellSpecialization.getFont() != null && f == null || ObjectUtility.notEquals((Object)this.m_cellSpecialization.getFont(), (Object)f)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setFont(f);
            this.setValueInternal(8, newStyle);
        }
    }

    @Override
    public boolean isEditable() {
        return this.m_cellSpecialization.isEditable();
    }

    public void setEditable(boolean b) {
        if (this.m_cellSpecialization instanceof CellStyle) {
            if (b) {
                CellExtension newStyle = new CellExtension(this.m_cellSpecialization);
                newStyle.setEditable(b);
                this.setValueInternal(10, newStyle);
            }
        } else if (this.m_cellSpecialization.isEditable() != b) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setEditable(b);
            this.setValueInternal(10, newStyle);
        }
    }

    @Override
    public void setHtmlEnabled(boolean b) {
        if (this.m_cellSpecialization.isHtmlEnabled() != b) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setHtmlEnabled(b);
            this.setValueInternal(12, newStyle);
        }
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.m_cellSpecialization.isHtmlEnabled();
    }

    @Override
    public ICellObserver getObserver() {
        return this.m_observer;
    }

    public void setObserver(ICellObserver observer) {
        this.m_observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueInternal(int bitPos, ICellSpecialization cellSpecialization) {
        Object object = SHARED_STYLE_STORE_LOCK;
        synchronized (object) {
            CellStyle newStyle = cellSpecialization.getCellStyle();
            CellStyle sharedStyle = SHARED_STYLE_STORE.get(newStyle);
            if (sharedStyle == null) {
                SHARED_STYLE_STORE.put(newStyle, newStyle);
                this.m_cellSpecialization = cellSpecialization.reconcile(newStyle);
            } else {
                this.m_cellSpecialization = cellSpecialization.reconcile(sharedStyle);
            }
        }
        this.notifyObserver(bitPos);
    }

    @Override
    public IMultiStatus getErrorStatus() {
        return this.m_errorStatus;
    }

    public void clearErrorStatus() {
        this.setErrorStatusInternal(null);
    }

    public void addErrorStatus(String message) {
        this.addErrorStatus((IStatus)new DefaultFieldStatus(message));
    }

    public void addErrorStatus(IStatus newStatus) {
        MultiStatus status = this.ensureMultiStatus((IStatus)this.getErrorStatusInternal());
        status.add(newStatus);
        this.setErrorStatusInternal((IMultiStatus)status);
        this.notifyObserver(14);
    }

    public void addErrorStatuses(List<IStatus> newStatus) {
        MultiStatus status = this.ensureMultiStatus((IStatus)this.getErrorStatusInternal());
        status.addAll(newStatus);
        this.setErrorStatusInternal((IMultiStatus)status);
        this.notifyObserver(14);
    }

    public void removeErrorStatus(Class<? extends IStatus> statusClazz) {
        IMultiStatus ms = this.getErrorStatusInternal();
        if (ms != null) {
            ms.removeAll(statusClazz);
            if (ms.getChildren().isEmpty()) {
                this.clearErrorStatus();
            }
            this.notifyObserver(14);
        }
    }

    private MultiStatus ensureMultiStatus(IStatus s) {
        if (s instanceof MultiStatus) {
            return (MultiStatus)s;
        }
        MultiStatus ms = new MultiStatus();
        if (s != null) {
            ms.add(s);
        }
        return ms;
    }

    private IMultiStatus getErrorStatusInternal() {
        return this.m_errorStatus;
    }

    public void setErrorStatusInternal(IMultiStatus status) {
        this.m_errorStatus = status;
    }

    private void notifyObserver(int changedBit) {
        if (this.getObserver() != null) {
            this.getObserver().cellChanged(this, changedBit);
        }
    }

    public boolean hasError() {
        IMultiStatus errorStatus = this.getErrorStatus();
        return errorStatus != null && errorStatus.getSeverity() >= 0x1000000;
    }

    @Override
    public boolean isContentValid() {
        return !this.hasError() && this.isMandatoryFulfilled();
    }

    @Override
    public boolean isMandatoryFulfilled() {
        return !this.isMandatory() || this.getValue() != null;
    }

    public String toString() {
        String s = this.getText();
        if (s == null) {
            s = StringUtility.emptyIfNull((Object)this.getValue());
        }
        return s;
    }
}

