/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class CalendarEvent
extends EventObject
implements IModelEvent {
    public static final int TYPE_COMPONENT_ACTION = 20;
    public static final int TYPE_COMPONENT_POPUP = 30;
    public static final int TYPE_NEW_POPUP = 31;
    private final int m_type;
    private final CalendarComponent m_component;
    private List<IMenu> m_popupMenus;

    public CalendarEvent(ICalendar source, int type) {
        super(source);
        this.m_type = type;
        this.m_component = null;
    }

    public CalendarEvent(ICalendar source, int type, CalendarComponent comp) {
        super(source);
        this.m_type = type;
        this.m_component = comp;
    }

    public ICalendar getCalendar() {
        return (ICalendar)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public CalendarComponent getComponent() {
        return this.m_component;
    }

    public void addPopupMenu(IMenu menu) {
        if (menu == null) {
            return;
        }
        if (this.m_popupMenus == null) {
            this.m_popupMenus = new ArrayList<IMenu>();
        }
        this.m_popupMenus.add(menu);
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus == null) {
            return;
        }
        if (this.m_popupMenus == null) {
            this.m_popupMenus = new ArrayList<IMenu>(menus.size());
        }
        this.m_popupMenus.addAll(menus);
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CalendarEvent[");
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    buf.append(aF.getName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception t) {
            buf.append("#").append(this.m_type);
        }
        if (this.m_component != null) {
            buf.append(", component=").append(this.m_component.getItem().getSubject());
        }
        buf.append("]");
        return buf.toString();
    }
}

