/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="8af6de2d-6e4a-4008-821f-1830b6a360fd")
public class TreeContextMenu
extends AbstractContextMenu<ITree>
implements ITreeContextMenu {
    private Set<? extends ITreeNode> m_currentSelection;

    public TreeContextMenu(ITree owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ITree container = (ITree)this.getContainer();
        container.addTreeListener(e -> {
            switch (e.getType()) {
                case 40: {
                    this.handleOwnerValueChanged();
                    break;
                }
                case 20: {
                    if (!CollectionUtility.containsAny(e.getNodes(), this.m_currentSelection)) break;
                    this.handleOwnerValueChanged();
                }
            }
        }, 40, 20);
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(container.getSelectedNodes()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        if ("enabled".equals(evt.getPropertyName())) {
            this.calculateEnabledState();
        }
    }

    protected void handleOwnerValueChanged() {
        ITree container = (ITree)this.getContainer();
        if (container == null) {
            return;
        }
        Set<ITreeNode> ownerSelection = container.getSelectedNodes();
        this.m_currentSelection = CollectionUtility.hashSet(ownerSelection);
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(ownerSelection));
        this.visit(new MenuOwnerChangedVisitor(ownerSelection, this.getCurrentMenuTypes()), IMenu.class);
        this.calculateLocalVisibility();
        this.calculateEnabledState();
    }

    protected boolean isSelectionEnabled() {
        return ((ITree)this.getContainer()).getSelectedNodes().stream().allMatch(ITreeNode::isEnabled);
    }

    protected void calculateEnabledState() {
        MenuUtility.updateContextMenuEnabledState(this, this::isSelectionEnabled, TreeMenuType.MultiSelection, TreeMenuType.SingleSelection);
    }

    protected Set<TreeMenuType> getMenuTypesForSelection(Set<? extends ITreeNode> selection) {
        if (CollectionUtility.isEmpty(selection)) {
            return CollectionUtility.hashSet((Object)TreeMenuType.EmptySpace);
        }
        if (CollectionUtility.size(selection) == 1) {
            return CollectionUtility.hashSet((Object)TreeMenuType.SingleSelection);
        }
        return CollectionUtility.hashSet((Object)TreeMenuType.MultiSelection);
    }
}

