/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.PlannerMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IPlannerContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerAdapter;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerEvent;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.Range;

@ClassId(value="4e3da25c-da4c-4258-aa24-e057aa9004d7")
public class PlannerContextMenu
extends AbstractContextMenu<IPlanner<?, ?>>
implements IPlannerContextMenu {
    public PlannerContextMenu(IPlanner<?, ?> owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ((IPlanner)this.getContainer()).addPlannerListener(new P_OwnerPlannerListener());
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(((IPlanner)this.getContainer()).getSelectedResources(), ((IPlanner)this.getContainer()).getSelectedActivity(), ((IPlanner)this.getContainer()).getSelectionRange()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        IPlanner container = (IPlanner)this.getContainer();
        if (container != null) {
            CompositeObject ownerValue = new CompositeObject(new Object[]{container.getSelectedResources(), container.getSelectedActivity(), container.getSelectionRange()});
            this.setCurrentMenuTypes(this.getMenuTypesForSelection(container.getSelectedResources(), container.getSelectedActivity(), container.getSelectionRange()));
            this.visit(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()), IMenu.class);
            this.calculateLocalVisibility();
        }
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("selectedActivity".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        } else if ("selectionRange".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }

    protected Set<PlannerMenuType> getMenuTypesForSelection(List<? extends Resource<?>> selectedResources, Activity<?, ?> selectedActivity, Range<Date> selectionRange) {
        if (CollectionUtility.isEmpty(selectedResources)) {
            return CollectionUtility.hashSet((Object)PlannerMenuType.EmptySpace);
        }
        HashSet<PlannerMenuType> menuTypes = new HashSet<PlannerMenuType>();
        if (CollectionUtility.size(selectedResources) > 0) {
            menuTypes.add(PlannerMenuType.Resource);
        }
        if (selectedActivity != null) {
            menuTypes.add(PlannerMenuType.Activity);
        } else if (selectionRange.getFrom() != null || selectionRange.getTo() != null) {
            menuTypes.add(PlannerMenuType.Range);
        }
        return menuTypes;
    }

    private class P_OwnerPlannerListener
    extends PlannerAdapter {
        private P_OwnerPlannerListener() {
        }

        @Override
        public void plannerChanged(PlannerEvent e) {
            if (e.getType() == 103) {
                PlannerContextMenu.this.handleOwnerValueChanged();
            }
        }
    }
}

