/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ImageFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.IFormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.imagefield.IImageField;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CompositeObject;

@ClassId(value="ea5a9db8-b80c-4795-9e33-187a1750dc48")
public class ImageFieldContextMenu
extends FormFieldContextMenu<IImageField>
implements IFormFieldContextMenu {
    public ImageFieldContextMenu(IImageField owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(this.getMenuTypesForValues());
        this.calculateLocalVisibility();
    }

    protected Set<IMenuType> getMenuTypesForValues() {
        IImageField field = (IImageField)this.getContainer();
        HashSet<IMenuType> menuTypes = new HashSet<IMenuType>();
        if (field.getImageId() != null) {
            menuTypes.add(ImageFieldMenuType.ImageId);
        }
        if (field.getImageUrl() != null) {
            menuTypes.add(ImageFieldMenuType.ImageUrl);
        }
        if (field.getImage() != null) {
            menuTypes.add(ImageFieldMenuType.Image);
        }
        if (menuTypes.isEmpty()) {
            return Collections.singleton(ImageFieldMenuType.Null);
        }
        return menuTypes;
    }

    protected void handleOwnerValueChanged() {
        IImageField container = (IImageField)this.getContainer();
        if (container != null) {
            CompositeObject ownerValue = new CompositeObject(new Object[]{container.getImageId(), container.getImageUrl(), container.getImage()});
            this.setCurrentMenuTypes(this.getMenuTypesForValues());
            if (container.isInitConfigDone()) {
                this.visit(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()), IMenu.class);
            }
        }
        this.calculateLocalVisibility();
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        String propertyName = evt.getPropertyName();
        if ("imageId".equals(propertyName) || "imageUrl".equals(propertyName) || "image".equals(propertyName)) {
            this.handleOwnerValueChanged();
        }
    }
}

