/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.CalendarMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ICalendarContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="7c6a0c17-90f1-4f1f-bad0-c6d417eaf5b5")
public class CalendarContextMenu
extends AbstractContextMenu<ICalendar>
implements ICalendarContextMenu {
    public CalendarContextMenu(ICalendar container, List<? extends IMenu> initialChildMenus) {
        super(container, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(((ICalendar)this.getContainer()).getSelectedComponent()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        ICalendar container = (ICalendar)this.getContainer();
        if (container != null) {
            CalendarComponent ownerValue = container.getSelectedComponent();
            this.setCurrentMenuTypes(this.getMenuTypesForSelection(ownerValue));
            this.visit(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()), IMenu.class);
            this.calculateLocalVisibility();
        }
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("selectedComponent".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }

    protected Set<CalendarMenuType> getMenuTypesForSelection(CalendarComponent selectedComponent) {
        if (selectedComponent == null) {
            return CollectionUtility.hashSet((Object)CalendarMenuType.EmptySpace);
        }
        return CollectionUtility.hashSet((Object)CalendarMenuType.CalendarComponent);
    }
}

