/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.extension.ui.action.menu.root.IContextMenuExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuEvent;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuListener;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.holders.BooleanHolder;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

@ClassId(value="b34571a2-032b-4910-921a-bec4acd110ed")
public abstract class AbstractContextMenu<T extends IWidget>
extends AbstractMenu
implements IContextMenu {
    private FastListenerList<ContextMenuListener> m_listeners;
    private PropertyChangeListener m_menuVisibilityListener;

    public AbstractContextMenu(T container, List<? extends IMenu> initialChildList) {
        this(container, initialChildList, true);
    }

    public AbstractContextMenu(T container, List<? extends IMenu> initialChildList, boolean callInitializer) {
        super(false);
        this.setContainerInternal((IWidget)container);
        this.setParentInternal((IWidget)container);
        if (callInitializer) {
            this.callInitializer();
        }
        this.setChildActions(initialChildList);
    }

    public T getContainer() {
        return (T)super.getContainer();
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.calculateLocalVisibility();
        if (this.isOwnerPropertyChangedListenerRequired()) {
            this.getContainer().addPropertyChangeListener((PropertyChangeListener)new P_OwnerPropertyListener());
        }
    }

    @Override
    public Set<? extends IMenuType> getCurrentMenuTypes() {
        return (Set)this.propertySupport.getProperty("currentMenuTypes");
    }

    protected void setCurrentMenuTypes(Set<? extends IMenuType> menuTypes) {
        this.propertySupport.setProperty("currentMenuTypes", menuTypes);
    }

    @Override
    public IFastListenerList<ContextMenuListener> contextMenuListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new FastListenerList();
        }
        return this.m_listeners;
    }

    protected void fireContextMenuEvent(ContextMenuEvent event) {
        this.contextMenuListeners().list().forEach(listener -> listener.contextMenuChanged(event));
    }

    @Override
    protected void afterChildMenusAdd(Collection<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.addScoutMenuVisibilityListenerRec(newChildMenus);
        this.calculateLocalVisibility();
        this.fireContextMenuEvent(new ContextMenuEvent(this, 1));
    }

    @Override
    protected void afterChildMenusRemove(Collection<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.removeScoutMenuVisibilityListenerRec(childMenusToRemove);
        this.calculateLocalVisibility();
        this.fireContextMenuEvent(new ContextMenuEvent(this, 1));
    }

    protected void handleChildActionsChanged(List<IMenu> oldValue, List<IMenu> newValue) {
        this.removeScoutMenuVisibilityListenerRec(oldValue);
        this.addScoutMenuVisibilityListenerRec(newValue);
        this.fireContextMenuEvent(new ContextMenuEvent(this, 1));
    }

    protected void addScoutMenuVisibilityListenerRec(Collection<? extends IMenu> menus) {
        if (menus != null) {
            for (IMenu iMenu : menus) {
                iMenu.addPropertyChangeListener("childActions", this.menuVisibilityListener());
                iMenu.addPropertyChangeListener("visible", this.menuVisibilityListener());
                this.addScoutMenuVisibilityListenerRec(iMenu.getChildActions());
            }
        }
    }

    protected void removeScoutMenuVisibilityListenerRec(Collection<? extends IMenu> menus) {
        if (menus != null) {
            for (IMenu iMenu : menus) {
                iMenu.removePropertyChangeListener("childActions", this.menuVisibilityListener());
                iMenu.removePropertyChangeListener("visible", this.menuVisibilityListener());
                this.removeScoutMenuVisibilityListenerRec(iMenu.getChildActions());
            }
        }
    }

    protected void calculateLocalVisibility() {
        Predicate<IMenu> activeFilter = MenuUtility.createMenuFilterMenuTypes(this.getCurrentMenuTypes(), true);
        if (activeFilter != null) {
            BooleanHolder visibleHolder = new BooleanHolder(Boolean.valueOf(false));
            this.visit((T menu) -> {
                if (menu.hasChildActions() || menu.isSeparator() || menu instanceof IContextMenu) {
                    return TreeVisitResult.CONTINUE;
                }
                if (activeFilter.test((IMenu)menu)) {
                    visibleHolder.setValue((Object)true);
                    return TreeVisitResult.TERMINATE;
                }
                return TreeVisitResult.CONTINUE;
            }, IMenu.class);
            this.setVisible((Boolean)visibleHolder.getValue());
        }
    }

    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
    }

    protected abstract boolean isOwnerPropertyChangedListenerRequired();

    @Override
    protected IContextMenuExtension<? extends AbstractContextMenu> createLocalExtension() {
        return new LocalContextMenuExtension<AbstractContextMenu>(this);
    }

    protected PropertyChangeListener menuVisibilityListener() {
        if (this.m_menuVisibilityListener == null) {
            this.m_menuVisibilityListener = new P_VisibilityOfMenuItemChangedListener();
        }
        return this.m_menuVisibilityListener;
    }

    protected static class LocalContextMenuExtension<OWNER extends AbstractContextMenu>
    extends AbstractMenu.LocalMenuExtension<OWNER>
    implements IContextMenuExtension<OWNER> {
        public LocalContextMenuExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_OwnerPropertyListener
    implements PropertyChangeListener {
        private P_OwnerPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractContextMenu.this.handleOwnerPropertyChanged(evt);
        }
    }

    private class P_VisibilityOfMenuItemChangedListener
    implements PropertyChangeListener {
        private P_VisibilityOfMenuItemChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("childActions".equals(evt.getPropertyName())) {
                AbstractContextMenu.this.handleChildActionsChanged((List)evt.getOldValue(), (List)evt.getNewValue());
            }
            AbstractContextMenu.this.calculateLocalVisibility();
        }
    }
}

