/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;

public enum TileGridMenuType implements IMenuType
{
    EmptySpace,
    SingleSelection,
    MultiSelection;


    public static void updateMenuVisibilitiesForTiles(ITileGrid<? extends ITile> tileGrid) {
        TileGridMenuType.updateMenuVisibilitiesForTiles(tileGrid.getContextMenu(), tileGrid.getSelectedTiles(), null);
    }

    public static void updateMenuVisibilitiesForTiles(IContextMenu contextMenu, List<? extends ITile> selectedTiles, Predicate<IAction> filter) {
        HashSet<IMenuType> acceptedMenuTypes = new HashSet<IMenuType>();
        acceptedMenuTypes.add(EmptySpace);
        if (selectedTiles.size() == 1) {
            acceptedMenuTypes.add(SingleSelection);
        } else if (selectedTiles.size() > 1) {
            acceptedMenuTypes.add(MultiSelection);
        }
        TileGridMenuType.updateMenuVisibilities(contextMenu, acceptedMenuTypes, filter);
    }

    public static void updateMenuVisibilities(IContextMenu contextMenu, Set<IMenuType> acceptedMenuTypes, Predicate<IAction> filter) {
        Predicate<IMenu> activeFilter = MenuUtility.createMenuFilterMenuTypes(acceptedMenuTypes, false);
        contextMenu.visit(menu -> {
            if (filter != null && !filter.test((IAction)menu)) {
                return;
            }
            if (!menu.isSeparator()) {
                menu.setVisible(activeFilter.test((IMenu)menu));
            }
        }, IMenu.class);
    }
}

