/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public final class MenuUtility {
    private MenuUtility() {
    }

    public static <T extends IActionNode<?>> boolean isVisible(T menu) {
        if (!menu.isVisible()) {
            return false;
        }
        if (menu.hasChildActions()) {
            boolean visible = false;
            for (Object o : menu.getChildActions()) {
                IActionNode m;
                if (!(o instanceof IActionNode) || (m = (IActionNode)o).isSeparator() || !m.isVisible()) continue;
                visible = true;
                break;
            }
            return visible;
        }
        return true;
    }

    public static <T extends IMenu> T getMenuByClass(IContextMenuOwner contextMenuOwner, Class<T> menuType) {
        if (contextMenuOwner == null) {
            throw new IllegalArgumentException("Argument 'contextMenuOwner' must not be null");
        }
        IContextMenu root = contextMenuOwner.getContextMenu();
        List<IMenu> rootMenus = root == null ? contextMenuOwner.getMenus() : Collections.singletonList(root);
        return (T)((IMenu)new ActionFinder().findAction(rootMenus, menuType));
    }

    public static List<IMenu> visibleNormalizedMenus(List<IMenu> menus) {
        return MenuUtility.normalizedMenus(menus, MenuUtility.createVisibleFilter());
    }

    public static List<IMenu> normalizedMenus(List<IMenu> menus, Predicate<IMenu> filter) {
        if (menus == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<IMenu> cleanedMenus = MenuUtility.filterMenusRec(menus, filter);
        MenuUtility.normalizeSeparators(cleanedMenus);
        return cleanedMenus;
    }

    public static void normalizeSeparators(List<IMenu> menus) {
        IMenu prevMenu = null;
        ListIterator<IMenu> it = menus.listIterator();
        while (it.hasNext()) {
            IMenu currentMenu = it.next();
            if (currentMenu.isSeparator() && (prevMenu == null || prevMenu.isSeparator())) {
                it.remove();
                continue;
            }
            prevMenu = currentMenu;
        }
        while (it.hasPrevious()) {
            IMenu previous = it.previous();
            if (!previous.isSeparator()) break;
            it.remove();
        }
    }

    public static List<IMenu> filterMenusRec(List<IMenu> menus, Predicate<IMenu> filter) {
        return MenuUtility.filterMenus(menus, filter, m -> m.hasChildActions() ? MenuWrapper.wrapMenu(m, OutlineMenuWrapper.AUTO_MENU_TYPE_MAPPER, filter) : m);
    }

    public static List<IMenu> filterMenus(List<IMenu> menus, Predicate<IMenu> filter) {
        return MenuUtility.filterMenus(menus, filter, UnaryOperator.identity());
    }

    private static List<IMenu> filterMenus(List<IMenu> menus, Predicate<IMenu> filter, UnaryOperator<IMenu> menuMapper) {
        if (menus != null) {
            ArrayList<IMenu> result = new ArrayList<IMenu>(menus.size());
            for (IMenu m : menus) {
                if (m.isSeparator()) {
                    result.add(m);
                    continue;
                }
                if (!filter.test(m)) continue;
                m = (IMenu)menuMapper.apply(m);
                result.add(m);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static Predicate<IMenu> createVisibleFilter() {
        return new Predicate<IMenu>(){

            @Override
            public boolean test(IMenu menu) {
                if (menu != null && menu.isVisible()) {
                    if (menu.hasChildActions()) {
                        List<IMenu> visibleChildActions = MenuUtility.filterMenusRec(menu.getChildActions(), this);
                        return !visibleChildActions.isEmpty();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static void updateContextMenuEnabledState(AbstractContextMenu<? extends IWidget> contextMenu, BooleanSupplier selectionEnabledStateSupplier, IMenuType ... menuTypes) {
        boolean containerEnabled = contextMenu.getContainer().isEnabled();
        contextMenu.setEnabled(containerEnabled);
        if (containerEnabled) {
            MenuUtility.updateEnabledStateOfMenus(contextMenu, selectionEnabledStateSupplier.getAsBoolean(), menuTypes);
        }
    }

    public static void updateEnabledStateOfMenus(IWidget widget, boolean enabled, IMenuType ... menuTypes) {
        Predicate<IMenu> menusToUpdate = MenuUtility.createMenuFilterMenuTypes(false, menuTypes);
        widget.visit(new UpdateMenuEnabledStateVisitor<IMenu>(enabled, menusToUpdate), IMenu.class);
    }

    public static Predicate<IMenu> createMenuFilterMenuTypes(boolean visibleOnly, IMenuType ... menuTypes) {
        return MenuUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object[])menuTypes), visibleOnly);
    }

    public static Predicate<IMenu> createMenuFilterMenuTypes(Set<? extends IMenuType> menuTypes, boolean visibleOnly) {
        return new MenuTypeFilter(menuTypes, visibleOnly);
    }

    public static class MenuTypeFilter
    implements Predicate<IMenu> {
        private final boolean m_visibleOnly;
        private final Set<? extends IMenuType> m_menuTypes;

        public MenuTypeFilter(Set<? extends IMenuType> menuTypes, boolean visibleOnly) {
            this.m_menuTypes = menuTypes;
            this.m_visibleOnly = visibleOnly;
        }

        @Override
        public boolean test(IMenu menu) {
            if (menu == null) {
                return false;
            }
            if (this.isVisibleOnly() && !menu.isVisible()) {
                return false;
            }
            if (menu.hasChildActions()) {
                return !MenuUtility.normalizedMenus(menu.getChildActions(), this).isEmpty();
            }
            if (this.getMenuTypes() != null) {
                for (IMenuType iMenuType : this.getMenuTypes()) {
                    if (!menu.getMenuTypes().contains(iMenuType)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public Set<? extends IMenuType> getMenuTypes() {
            return this.m_menuTypes;
        }

        public boolean isVisibleOnly() {
            return this.m_visibleOnly;
        }
    }

    public static class UpdateMenuEnabledStateVisitor<T extends IMenu>
    extends DepthFirstTreeVisitor<T> {
        private final boolean m_enabled;
        private final Predicate<? super T> m_filter;

        public UpdateMenuEnabledStateVisitor(boolean enabled, Predicate<? super T> filter) {
            this.m_enabled = enabled;
            this.m_filter = filter;
        }

        public TreeVisitResult preVisit(T element, int level, int index) {
            if (this.isSkipElement(element)) {
                return TreeVisitResult.SKIP_SUBTREE;
            }
            return TreeVisitResult.CONTINUE;
        }

        protected boolean isSkipElement(T element) {
            return element.isSeparator() || !element.isInheritAccessibility();
        }

        public boolean postVisit(T element, int level, int index) {
            if (this.isSkipElement(element)) {
                return true;
            }
            if (!element.hasChildActions() && this.m_filter.test(element)) {
                element.setEnabled(this.m_enabled, "ENABLED_SLAVE");
            }
            return true;
        }
    }
}

