/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public class ActionFinder {
    public <T extends IAction> T findAction(List<? extends IAction> actionTree, Class<T> searchType) {
        List<T> filteredActions = this.findActions(actionTree, searchType, true, true);
        return (T)((IAction)CollectionUtility.firstElement(filteredActions));
    }

    public <T extends IAction> List<T> findActions(List<? extends IAction> actionTree, Class<T> searchType, boolean recursive) {
        return this.findActions(actionTree, searchType, recursive, false);
    }

    protected <T extends IAction> List<T> findActions(List<? extends IAction> actionTree, Class<T> searchType, boolean recursive, boolean oneMatchSearch) {
        if (CollectionUtility.isEmpty(actionTree) || searchType == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList result = new ArrayList();
        Function<IAction, TreeVisitResult> collector = action -> {
            if (searchType.isInstance(action)) {
                result.add(action);
                if (oneMatchSearch) {
                    return TreeVisitResult.TERMINATE;
                }
            }
            return recursive ? TreeVisitResult.CONTINUE : TreeVisitResult.SKIP_SUBTREE;
        };
        for (IAction iAction : actionTree) {
            TreeVisitResult continueSearch;
            if (iAction == null || (continueSearch = iAction.visit(collector, IAction.class)) != TreeVisitResult.TERMINATE) continue;
            return result;
        }
        return result;
    }
}

