/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.security.Permission;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.action.ActionChains;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionUIFacade;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStrokeNormalizer;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="d3cdbb0d-4c53-4854-b6f2-23465050c3c5")
public abstract class AbstractAction
extends AbstractWidget
implements IAction,
IExtensibleObject {
    private static final String TOGGLE_ACTION = "TOGGLE_ACTION";
    private static final String SEPARATOR = "SEPARATOR";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAction.class);
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE", "VISIBLE_GRANTED"});
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"TOGGLE_ACTION", "SEPARATOR"});
    private byte m_visible;
    private byte m_flags = 0;
    private byte m_horizontalAlignment;
    private final IActionUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(this.createUIFacade(), ModelContextProxy.ModelContext.copyCurrent());
    private final ObjectExtensions<AbstractAction, IActionExtension<? extends AbstractAction>> m_objectExtensions;

    public AbstractAction() {
        this(true);
    }

    public AbstractAction(boolean callInitializer) {
        super(false);
        this.m_visible = (byte)-1;
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        this.interceptInitAction();
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=30.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=45.0)
    protected String getConfiguredTextPosition() {
        return "default";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=46.0)
    protected boolean getConfiguredHtmlEnabled() {
        return false;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=55.0)
    protected String getConfiguredKeyStroke() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=60.0)
    protected int getConfiguredKeyStrokeFirePolicy() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=25.0)
    protected boolean getConfiguredToggleAction() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSeparator() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=120.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @Order(value=130.0)
    @ConfigProperty(value="INTEGER")
    protected byte getConfiguredHorizontalAlignment() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=140.0)
    protected int getConfiguredActionStyle() {
        return 0;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAction() {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDispose() {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execAction() {
    }

    @ConfigOperation
    @Order(value=32.0)
    protected void execSelectionChanged(boolean selection) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setIconId(this.getConfiguredIconId());
        this.setText(this.getConfiguredText());
        this.setTextPosition(this.getConfiguredTextPosition());
        this.setHtmlEnabled(this.getConfiguredHtmlEnabled());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setKeyStroke(this.getConfiguredKeyStroke());
        this.setKeyStrokeFirePolicy(this.getConfiguredKeyStrokeFirePolicy());
        this.setVisible(this.getConfiguredVisible());
        this.setToggleAction(this.getConfiguredToggleAction());
        this.setSeparator(this.getConfiguredSeparator());
        this.setOrder(this.calculateViewOrder());
        this.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setActionStyle(this.getConfiguredActionStyle());
        this.setCssClass(this.getConfiguredCssClass());
    }

    protected IActionUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    protected IActionExtension<? extends AbstractAction> createLocalExtension() {
        return new LocalActionExtension<AbstractAction>(this);
    }

    public final List<? extends IActionExtension<? extends AbstractAction>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        if (viewOrder == 9.876543212345678E16) {
            Class<?> cls = this.getClass();
            while (cls != null && IAction.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @Override
    public String getActionId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public void doAction() {
        if (this.isEnabledIncludingParents() && this.isVisibleIncludingParents()) {
            this.doActionInternal();
        }
    }

    protected void doActionInternal() {
        this.interceptAction();
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public Object getImage() {
        return this.propertySupport.getProperty("image");
    }

    @Override
    public void setImage(Object imgObj) {
        this.propertySupport.setProperty("image", imgObj);
    }

    @Override
    public String getText() {
        return this.propertySupport.getPropertyString("text");
    }

    @Override
    public void setText(String text) {
        this.propertySupport.setPropertyString("text", text);
    }

    @Override
    public String getTextPosition() {
        return this.propertySupport.getPropertyString("textPosition");
    }

    @Override
    public void setTextPosition(String position) {
        this.propertySupport.setPropertyString("textPosition", position);
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.propertySupport.getPropertyBool("htmlEnabled");
    }

    @Override
    public void setHtmlEnabled(boolean htmlEnabled) {
        this.propertySupport.setPropertyBool("htmlEnabled", htmlEnabled);
    }

    @Override
    public int getActionStyle() {
        return this.propertySupport.getPropertyInt("actionStyle");
    }

    @Override
    public void setActionStyle(int actionStyle) {
        this.propertySupport.setPropertyInt("actionStyle", actionStyle);
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @Override
    public String getKeyStroke() {
        return this.propertySupport.getPropertyString("keyStroke");
    }

    @Override
    public void setKeyStroke(String k) {
        KeyStrokeNormalizer scoutKeystroke = new KeyStrokeNormalizer(k);
        scoutKeystroke.normalize();
        if (scoutKeystroke.isValid()) {
            this.propertySupport.setPropertyString("keyStroke", scoutKeystroke.getNormalizedKeystroke());
        } else {
            LOG.warn("Could not create keystroke '{}' because it is invalid!", (Object)k);
        }
    }

    @Override
    public int getKeyStrokeFirePolicy() {
        return this.propertySupport.getPropertyInt("keyStrokeFirePolicy");
    }

    @Override
    public void setKeyStrokeFirePolicy(int keyStrokeFirePolicy) {
        this.propertySupport.setPropertyInt("keyStrokeFirePolicy", keyStrokeFirePolicy);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String text) {
        this.propertySupport.setPropertyString("tooltipText", text);
    }

    @Override
    public boolean isSeparator() {
        return FLAGS_BIT_HELPER.isBitSet(SEPARATOR, this.m_flags);
    }

    @Override
    public void setSeparator(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(SEPARATOR, b, this.m_flags);
    }

    @Override
    public boolean isSelected() {
        return this.propertySupport.getPropertyBool("selected");
    }

    @Override
    public void setSelected(boolean b) {
        if (this.setSelectedInternal(b)) {
            try {
                this.interceptSelectionChanged(b);
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
    }

    protected boolean setSelectedInternal(boolean b) {
        return this.propertySupport.setPropertyBool("selected", b);
    }

    @Override
    public boolean isToggleAction() {
        return FLAGS_BIT_HELPER.isBitSet(TOGGLE_ACTION, this.m_flags);
    }

    @Override
    public void setToggleAction(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(TOGGLE_ACTION, b, this.m_flags);
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, "VISIBLE");
    }

    private void setVisibleInternal() {
        this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet((byte)this.m_visible));
    }

    @Override
    public boolean isVisibleIncludingParents() {
        if (!this.isVisible()) {
            return false;
        }
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(true);
        Predicate<IWidget> visitor = widget -> {
            if (!(widget instanceof IActionNode)) {
                return false;
            }
            IActionNode node = (IActionNode)widget;
            if (!node.isVisible() && !(node instanceof IContextMenu)) {
                result.set(false);
                return false;
            }
            return true;
        };
        this.visitParents(visitor);
        return result.get();
    }

    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.setVisibleInternal();
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean visibleByPerm = true;
        if (p != null) {
            visibleByPerm = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(visibleByPerm);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        IWidget container = this.getContainer();
        if (container != null) {
            return simpleClassId + "_" + container.classId();
        }
        return simpleClassId;
    }

    public static String combineKeyStrokes(String firstKey, String secondKey, String ... otherKeys) {
        int keyCount = 2 + otherKeys.length;
        String[] keys = new String[keyCount];
        keys[0] = firstKey;
        keys[1] = secondKey;
        int i = 0;
        while (i < otherKeys.length) {
            keys[i + 2] = otherKeys[i];
            ++i;
        }
        return AbstractAction.combineKeyStrokes(keys);
    }

    public static String combineKeyStrokes(String[] keys) {
        StringBuilder builder = new StringBuilder();
        int separator = 45;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (builder.length() > 0) {
                builder.append('-');
            }
            builder.append(key);
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public IActionUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public IWidget getContainer() {
        return (IWidget)this.propertySupport.getProperty("container");
    }

    @Override
    public void setContainerInternal(IWidget container) {
        this.propertySupport.setProperty("container", (Object)container);
    }

    @Override
    public byte getHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.m_horizontalAlignment = horizontalAlignment;
    }

    @Override
    public void setView(boolean visible, boolean enabled) {
        this.setVisible(visible);
        this.setEnabled(enabled);
    }

    protected final void interceptSelectionChanged(boolean selection) {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionSelectionChangedChain chain = new ActionChains.ActionSelectionChangedChain(extensions);
        chain.execSelectionChanged(selection);
    }

    protected final void interceptAction() {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionActionChain chain = new ActionChains.ActionActionChain(extensions);
        chain.execAction();
    }

    protected final void interceptInitAction() {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionInitActionChain chain = new ActionChains.ActionInitActionChain(extensions);
        chain.execInitAction();
    }

    protected final void interceptDispose() {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionDisposeChain chain = new ActionChains.ActionDisposeChain(extensions);
        chain.execDispose();
    }

    @Override
    protected final void disposeInternal() {
        try {
            this.disposeActionInternal();
        }
        catch (RuntimeException e) {
            LOG.warn("Exception while disposing action.", (Throwable)e);
        }
        try {
            this.interceptDispose();
        }
        catch (RuntimeException e) {
            LOG.warn("Exception while disposing action.", (Throwable)e);
        }
        super.disposeInternal();
    }

    protected void disposeActionInternal() {
    }

    protected static class LocalActionExtension<OWNER extends AbstractAction>
    extends AbstractExtension<OWNER>
    implements IActionExtension<OWNER> {
        public LocalActionExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execSelectionChanged(ActionChains.ActionSelectionChangedChain chain, boolean selection) {
            ((AbstractAction)this.getOwner()).execSelectionChanged(selection);
        }

        @Override
        public void execAction(ActionChains.ActionActionChain chain) {
            ((AbstractAction)this.getOwner()).execAction();
        }

        @Override
        public void execInitAction(ActionChains.ActionInitActionChain chain) {
            ((AbstractAction)this.getOwner()).execInitAction();
        }

        @Override
        public void execDispose(ActionChains.ActionDisposeChain chain) {
            ((AbstractAction)this.getOwner()).execDispose();
        }
    }

    protected class P_UIFacade
    implements IActionUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireActionFromUI() {
            if (AbstractAction.this.isEnabledIncludingParents() && AbstractAction.this.isVisibleIncludingParents()) {
                AbstractAction.this.doAction();
            }
        }

        @Override
        public void setSelectedFromUI(boolean b) {
            AbstractAction.this.setSelected(b);
        }
    }
}

