/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.util.function.Function;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public class WidgetVisitorTypeAdapter<T extends IWidget>
implements IDepthFirstTreeVisitor<IWidget> {
    private final Class<T> m_type;
    private final IDepthFirstTreeVisitor<T> m_visitor;

    public WidgetVisitorTypeAdapter(Function<T, TreeVisitResult> visitor, Class<T> type) {
        this(WidgetVisitorTypeAdapter.functionToVisitor(visitor), type);
    }

    public static <S extends IWidget> IDepthFirstTreeVisitor<S> functionToVisitor(final Function<S, TreeVisitResult> visitor) {
        Assertions.assertNotNull(visitor);
        return new DepthFirstTreeVisitor<S>(){

            public TreeVisitResult preVisit(S widget, int level, int index) {
                return (TreeVisitResult)visitor.apply(widget);
            }
        };
    }

    public WidgetVisitorTypeAdapter(IDepthFirstTreeVisitor<T> visitor, Class<T> type) {
        this.m_type = (Class)Assertions.assertNotNull(type);
        this.m_visitor = (IDepthFirstTreeVisitor)Assertions.assertNotNull(visitor);
    }

    public TreeVisitResult preVisit(IWidget widget, int level, int index) {
        return this.delegateToFunctionIfTypeMatches(widget, w -> this.visitor().preVisit(w, level, index), TreeVisitResult.CONTINUE);
    }

    public boolean postVisit(IWidget widget, int level, int index) {
        return this.delegateToFunctionIfTypeMatches(widget, w -> this.visitor().postVisit(w, level, index), true);
    }

    protected <S> S delegateToFunctionIfTypeMatches(IWidget widget, Function<T, S> function, S resultOnTypeMismatch) {
        if (this.m_type.isInstance(widget)) {
            return function.apply(widget);
        }
        return resultOnTypeMismatch;
    }

    public Class<T> type() {
        return this.m_type;
    }

    public IDepthFirstTreeVisitor<T> visitor() {
        return this.m_visitor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for type '" + this.type().getName() + "'.";
    }
}

