/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.IPreferenceField;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.prefs.CustomClientPreferenceId;
import org.eclipse.scout.rt.shared.prefs.ICustomClientPreferenceDo;
import org.eclipse.scout.rt.shared.services.common.prefs.IPreferences;
import org.eclipse.scout.rt.shared.services.common.prefs.Preferences;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ClientUIPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUIPreferences.class);
    protected static final String PREFERENCES_NODE_ID = "org.eclipse.scout.rt.client";
    protected static final String TABLE_COLUMNS_CONFIGS = "table.columns.configs.";
    protected static final String TABLE_CUSTOMIZER_DATA = "table.customizer.data.";
    protected static final String TABLE_COLUMN_UIINDEX = "table.column.viewIndex.";
    protected static final String TABLE_COLUMN_WIDTH = "table.column.width.";
    protected static final String TABLE_COLUMN_VISIBLE = "table.column.visible.";
    protected static final String TABLE_COLUMN_SORT_INDEX = "table.column.sortIndex.";
    protected static final String TABLE_COLUMN_GROUPED = "table.column.grouped.";
    protected static final String TABLE_COLUMN_AGGR_FUNCTION = "table.column.aggr.function.";
    protected static final String TABLE_COLUMN_BACKGROUND_EFFECT = "table.column.background.effect.";
    protected static final String TABLE_COLUMN_SORT_ASC = "table.column.sortAsc.";
    protected static final String TABLE_COLUMN_SORT_EXPLICIT = "table.column.sortExplicit.";
    protected static final String TABLE_TILE_MODE = "table.tile.mode";
    protected static final String CALENDAR_DISPLAY_MODE = "calendar.display.mode";
    protected static final String CALENDAR_DISPLAY_CONDENSED = "calendar.display.condensed";
    protected static final String DESKTOP_COLUMN_SPLITS = "desktop.columnSplits";
    protected static final String FIELD_COLLAPSED = "fieldCollapsed";
    protected IPreferences m_prefs;

    public static ClientUIPreferences getInstance() {
        return ClientUIPreferences.getInstance(ClientSessionProvider.currentSession());
    }

    public static ClientUIPreferences getInstance(IClientSession session) {
        ClientUIPreferences preferences = (ClientUIPreferences)BEANS.get(ClientUIPreferences.class);
        preferences.load(session);
        return preferences;
    }

    protected ClientUIPreferences() {
    }

    protected String getUserAgentPrefix() {
        UserAgent currentUserAgent = this.m_prefs != null && this.m_prefs.userScope() instanceof IClientSession ? ((IClientSession)this.m_prefs.userScope()).getUserAgent() : UserAgentUtility.getCurrentUserAgent();
        if (currentUserAgent == null) {
            return "";
        }
        String uiLayer = null;
        if (!UiLayer.UNKNOWN.equals((Object)currentUserAgent.getUiLayer())) {
            uiLayer = currentUserAgent.getUiLayer().stringValue();
        }
        String uiDeviceType = null;
        if (!UiDeviceType.UNKNOWN.equals((Object)currentUserAgent.getUiDeviceType())) {
            uiDeviceType = currentUserAgent.getUiDeviceType().stringValue();
        }
        return StringUtility.concatenateTokens((String[])new String[]{uiLayer, ".", uiDeviceType, "."});
    }

    public Double getSplitterPosition(ISplitBox splitBox) {
        if (this.m_prefs == null) {
            return null;
        }
        Object baseKey = splitBox.getCacheSplitterPositionPropertyName();
        if (baseKey == null) {
            return null;
        }
        baseKey = this.getUserAgentPrefix() + (String)baseKey;
        String splitterPositionKey = (String)baseKey + "#splitterPosition";
        String splitterPositionTypeKey = (String)baseKey + "#splitterPositionType";
        Double splitterPosition = this.getPropertyDouble(splitterPositionKey);
        String splitterPositionType = this.m_prefs.get(splitterPositionTypeKey, null);
        if (ObjectUtility.notEquals((Object)splitterPositionType, (Object)splitBox.getSplitterPositionType())) {
            this.m_prefs.remove(splitterPositionKey);
            this.m_prefs.remove(splitterPositionTypeKey);
            return null;
        }
        return splitterPosition;
    }

    public Boolean getSplitBoxFieldMinimized(ISplitBox splitBox) {
        if (this.m_prefs == null) {
            return null;
        }
        Object baseKey = splitBox.getCacheSplitterPositionPropertyName();
        if (baseKey == null) {
            return null;
        }
        baseKey = this.getUserAgentPrefix() + (String)baseKey;
        String minimizedKey = (String)baseKey + "#fieldMinimized";
        return this.getPropertyBoolean(minimizedKey);
    }

    public Boolean getSplitBoxFieldCollapsed(ISplitBox splitBox) {
        return this.isFieldCollapsed(splitBox);
    }

    public Boolean isFieldCollapsed(IPreferenceField field) {
        if (this.m_prefs == null) {
            return null;
        }
        String propName = this.prepareCollapsedPropName(field);
        if (propName == null) {
            return null;
        }
        return this.getPropertyBoolean(propName);
    }

    public void setFieldCollapsed(IPreferenceField field, Boolean value) {
        if (this.m_prefs == null) {
            return;
        }
        String propName = this.prepareCollapsedPropName(field);
        if (propName == null) {
            return;
        }
        this.setPropertyBoolean(propName, value);
    }

    protected String prepareCollapsedPropName(IPreferenceField field) {
        return Optional.ofNullable(field.getPreferenceBaseKey()).map(k -> this.getUserAgentPrefix() + k + "#fieldCollapsed").orElse(null);
    }

    public void setAllSplitBoxPreferences(ISplitBox splitBox) {
        if (this.m_prefs == null) {
            return;
        }
        if (!splitBox.isCacheSplitterPosition()) {
            this.removeAllSplitBoxPreferences(splitBox);
            return;
        }
        Object baseKey = splitBox.getPreferenceBaseKey();
        if (baseKey == null) {
            return;
        }
        baseKey = this.getUserAgentPrefix() + (String)baseKey;
        String splitterPositionKey = (String)baseKey + "#splitterPosition";
        String splitterPositionTypeKey = (String)baseKey + "#splitterPositionType";
        String minimizedKey = (String)baseKey + "#fieldMinimized";
        this.m_prefs.putDouble(splitterPositionKey, splitBox.getSplitterPosition());
        this.m_prefs.put(splitterPositionTypeKey, splitBox.getSplitterPositionType());
        this.m_prefs.putBoolean(minimizedKey, splitBox.isFieldMinimized());
        this.setFieldCollapsed(splitBox, splitBox.isFieldCollapsed());
        this.flush();
    }

    public void removeAllSplitBoxPreferences(ISplitBox splitBox) {
        Object baseKey = splitBox.getCacheSplitterPositionPropertyName();
        if (baseKey == null) {
            return;
        }
        baseKey = this.getUserAgentPrefix() + (String)baseKey;
        String splitterPositionKey = (String)baseKey + "#splitterPosition";
        String splitterPositionTypeKey = (String)baseKey + "#splitterPositionType";
        String minimizedKey = (String)baseKey + "#fieldMinimized";
        String collapsedKey = this.prepareCollapsedPropName(splitBox);
        this.m_prefs.remove(splitterPositionKey);
        this.m_prefs.remove(splitterPositionTypeKey);
        this.m_prefs.remove(minimizedKey);
        this.m_prefs.remove(collapsedKey);
    }

    public String getTableKey(ITable t) {
        Object key = t.getClass().getName();
        String context = t.getUserPreferenceContext();
        if (context != null) {
            key = (String)key + "#" + context;
        }
        return key;
    }

    public void removeTableCustomizerData(ITableCustomizer customizer, String configName) {
        if (this.m_prefs == null || customizer == null || customizer.getPreferencesKey() == null) {
            return;
        }
        this.m_prefs.remove(this.createTableCustomizerConfigKey(customizer, configName));
    }

    protected void renameTableCustomizerData(ITableCustomizer customizer, String oldConfigName, String newConfigName) {
        if (this.m_prefs == null || customizer == null || customizer.getPreferencesKey() == null) {
            return;
        }
        String oldKey = this.createTableCustomizerConfigKey(customizer, oldConfigName);
        String newKey = this.createTableCustomizerConfigKey(customizer, newConfigName);
        this.renameEntry(oldKey, newKey);
    }

    protected void renameEntry(String oldKey, String newKey) {
        String entry = this.m_prefs.get(oldKey, null);
        if (entry != null) {
            this.m_prefs.remove(oldKey);
            this.m_prefs.put(newKey, entry);
        }
    }

    public void setTableCustomizerData(ITableCustomizer customizer, String configName) {
        if (this.m_prefs == null || customizer == null || customizer.getPreferencesKey() == null) {
            return;
        }
        this.m_prefs.putByteArray(this.createTableCustomizerConfigKey(customizer, configName), customizer.getSerializedData());
    }

    public byte[] getTableCustomizerData(ITableCustomizer customizer, String configName) {
        if (this.m_prefs == null || customizer == null || customizer.getPreferencesKey() == null) {
            return null;
        }
        return this.m_prefs.getByteArray(this.createTableCustomizerConfigKey(customizer, configName), null);
    }

    protected String createTableCustomizerConfigKey(ITableCustomizer customizer, String configName) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtility.isNullOrEmpty((CharSequence)configName)) {
            sb.append(configName).append(".");
        }
        sb.append(TABLE_CUSTOMIZER_DATA).append(customizer.getPreferencesKey());
        return sb.toString();
    }

    public String getColumnKey(IColumn c) {
        Object key = c.getColumnId();
        if (c.getTable() != null) {
            key = this.getTableKey(c.getTable()) + "#" + (String)key;
        }
        return key;
    }

    protected boolean isTableClientUiPreferencesEnabled(IColumn col) {
        if (this.m_prefs == null) {
            return false;
        }
        return col.getTable().isClientUiPreferencesEnabled();
    }

    public void setTableColumnPreferences(IColumn col) {
        this.setTableColumnPreferences(col, true);
    }

    public void setTableColumnPreferences(IColumn col, boolean flush) {
        this.setTableColumnPreferences(col, flush, null);
    }

    public void setTableColumnPreferences(IColumn col, boolean flush, String configName) {
        if (!this.isTableClientUiPreferencesEnabled(col)) {
            return;
        }
        Object key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_UIINDEX);
        int viewIndex = col.getVisibleColumnIndexHint();
        boolean visible = col.isVisible("VISIBLE");
        int width = col.getWidth();
        int sortIndex = col.getSortIndex();
        boolean grouped = col.isGroupingActive();
        boolean sortUp = col.isSortAscending();
        String aggregationFunction = null;
        if (col instanceof INumberColumn) {
            aggregationFunction = ((INumberColumn)col).getAggregationFunction();
        }
        String backgroundEffect = null;
        if (col instanceof INumberColumn) {
            backgroundEffect = ((INumberColumn)col).getBackgroundEffect();
        }
        if (viewIndex >= 0) {
            this.m_prefs.put((String)key, "" + viewIndex);
        } else {
            this.m_prefs.remove((String)key);
        }
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_VISIBLE);
        if (!visible) {
            this.m_prefs.put((String)key, "no");
        } else {
            this.m_prefs.put((String)key, "yes");
        }
        key = this.getUserAgentPrefix() + this.createColumnConfigKey(col, configName, TABLE_COLUMN_WIDTH);
        if (width >= 0) {
            this.m_prefs.put((String)key, "" + width);
        } else {
            this.m_prefs.remove((String)key);
        }
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_EXPLICIT);
        this.m_prefs.remove((String)key);
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_INDEX);
        if (sortIndex >= 0) {
            this.m_prefs.put((String)key, "" + sortIndex);
        } else {
            this.m_prefs.put((String)key, "-1");
        }
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_ASC);
        if (sortIndex >= 0 && sortUp) {
            this.m_prefs.put((String)key, "true");
        } else {
            this.m_prefs.put((String)key, "false");
        }
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_GROUPED);
        if (grouped) {
            this.m_prefs.put((String)key, "true");
        } else {
            this.m_prefs.put((String)key, "false");
        }
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_AGGR_FUNCTION);
        this.m_prefs.put((String)key, aggregationFunction);
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_BACKGROUND_EFFECT);
        this.m_prefs.put((String)key, backgroundEffect);
        if (flush) {
            this.flush();
        }
    }

    public void renameTableColumnPreferences(IColumn col, String oldConfigName, String newConfigName) {
        if (col == null || StringUtility.isNullOrEmpty((CharSequence)oldConfigName) || StringUtility.isNullOrEmpty((CharSequence)newConfigName)) {
            throw new IllegalArgumentException();
        }
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_UIINDEX), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_UIINDEX));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_VISIBLE), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_VISIBLE));
        this.renameEntry(this.getUserAgentPrefix() + this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_WIDTH), this.getUserAgentPrefix() + this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_WIDTH));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_SORT_INDEX), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_SORT_INDEX));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_SORT_ASC), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_SORT_ASC));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_GROUPED), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_GROUPED));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_AGGR_FUNCTION), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_AGGR_FUNCTION));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_SORT_EXPLICIT), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_SORT_EXPLICIT));
        this.renameEntry(this.createColumnConfigKey(col, oldConfigName, TABLE_COLUMN_BACKGROUND_EFFECT), this.createColumnConfigKey(col, newConfigName, TABLE_COLUMN_BACKGROUND_EFFECT));
    }

    protected String createColumnConfigKey(IColumn col, String configName, String propertyKey) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtility.isNullOrEmpty((CharSequence)configName)) {
            sb.append(configName).append(".");
        }
        sb.append(propertyKey).append(this.getColumnKey(col));
        return sb.toString();
    }

    public void updateTableColumnOrder(List<IColumn<?>> columnList, int[] visibleColumnIndexHints) {
        if (columnList.size() != visibleColumnIndexHints.length) {
            throw new IllegalArgumentException("columnList.size=" + columnList.size() + " hints.length=" + visibleColumnIndexHints.length);
        }
        if (this.m_prefs == null) {
            return;
        }
        int i = 0;
        while (i < visibleColumnIndexHints.length) {
            IColumn<?> c = columnList.get(i);
            int viewIndex = visibleColumnIndexHints[i];
            String key = this.createColumnConfigKey(c, null, TABLE_COLUMN_UIINDEX);
            if (viewIndex >= 0) {
                this.m_prefs.put(key, "" + viewIndex);
            } else {
                this.m_prefs.remove(key);
            }
            ++i;
        }
        this.flush();
    }

    public void removeAllTableColumnPreferences(IColumn col, String configName, boolean flush) {
        if (this.m_prefs == null) {
            return;
        }
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_VISIBLE));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_UIINDEX));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_INDEX));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_ASC));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_GROUPED));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_AGGR_FUNCTION));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_EXPLICIT));
        this.m_prefs.remove(this.getUserAgentPrefix() + this.createColumnConfigKey(col, configName, TABLE_COLUMN_WIDTH));
        this.m_prefs.remove(this.createColumnConfigKey(col, configName, TABLE_COLUMN_BACKGROUND_EFFECT));
        if (flush) {
            this.flush();
        }
    }

    public void removeAllTableColumnPreferences(ITable table, String configName) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        for (IColumn<?> col : table.getColumns()) {
            if (!col.isDisplayable()) continue;
            this.removeAllTableColumnPreferences(col, configName, false);
        }
        this.flush();
    }

    protected void renameAllTableColumnPreferences(ITable table, String oldConfigName, String newConfigName) {
        if (table == null || StringUtility.isNullOrEmpty((CharSequence)oldConfigName) || StringUtility.isNullOrEmpty((CharSequence)newConfigName)) {
            throw new IllegalArgumentException();
        }
        for (IColumn<?> col : table.getColumns()) {
            if (!col.isDisplayable()) continue;
            this.renameTableColumnPreferences(col, oldConfigName, newConfigName);
        }
        this.flush();
    }

    public void setAllTableColumnPreferences(ITable table, String configName) {
        if (table == null || !table.isClientUiPreferencesEnabled()) {
            return;
        }
        for (IColumn<?> col : table.getColumns()) {
            if (!col.isDisplayable()) continue;
            this.setTableColumnPreferences(col, false, configName);
        }
        this.flush();
    }

    public void setAllTableColumnPreferences(ITable table) {
        this.setAllTableColumnPreferences(table, null);
    }

    public Set<String> getAllTableColumnsConfigs(ITable table) {
        if (this.m_prefs == null) {
            return null;
        }
        String key = TABLE_COLUMNS_CONFIGS + this.getTableKey(table);
        return new LinkedHashSet<String>(this.m_prefs.getList(key, new ArrayList()));
    }

    public void removeTableColumnsConfig(ITable table, String name) {
        if (this.m_prefs == null) {
            return;
        }
        String key = TABLE_COLUMNS_CONFIGS + this.getTableKey(table);
        Set<String> configs = this.getAllTableColumnsConfigs(table);
        configs.remove(name);
        this.m_prefs.putList(key, new ArrayList<String>(configs));
        this.removeAllTableColumnPreferences(table, name);
        this.removeTableCustomizerData(table.getTableCustomizer(), name);
    }

    public void renameTableColumnsConfig(ITable table, String oldName, String newName) {
        if (this.m_prefs == null) {
            return;
        }
        String key = TABLE_COLUMNS_CONFIGS + this.getTableKey(table);
        Set<String> configs = this.getAllTableColumnsConfigs(table);
        configs.remove(oldName);
        configs.add(newName);
        this.m_prefs.putList(key, new ArrayList<String>(configs));
        this.renameAllTableColumnPreferences(table, oldName, newName);
        this.renameTableCustomizerData(table.getTableCustomizer(), oldName, newName);
    }

    public void addTableColumnsConfig(ITable table, String name) {
        if (this.m_prefs == null) {
            return;
        }
        String key = TABLE_COLUMNS_CONFIGS + this.getTableKey(table);
        Set<String> configs = this.getAllTableColumnsConfigs(table);
        configs.add(name);
        this.m_prefs.putList(key, new ArrayList<String>(configs));
    }

    public boolean hasTableColumnPreferences(ITable table) {
        if (table != null && this.m_prefs != null) {
            for (IColumn<?> col : table.getColumns()) {
                String keySuffix = this.getColumnKey(col);
                if (this.m_prefs.get(TABLE_COLUMN_VISIBLE + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_prefs.get(TABLE_COLUMN_UIINDEX + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_prefs.get(TABLE_COLUMN_SORT_INDEX + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_prefs.get(TABLE_COLUMN_SORT_ASC + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_prefs.get(TABLE_COLUMN_WIDTH + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_prefs.get(TABLE_COLUMN_GROUPED + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_prefs.get(TABLE_COLUMN_AGGR_FUNCTION + keySuffix, null) == null) continue;
                return true;
            }
        }
        return false;
    }

    public int getTableColumnWidth(IColumn col, int defaultWidth) {
        return this.getTableColumnWidth(col, defaultWidth, null);
    }

    public int getTableColumnWidth(IColumn col, int defaultWidth, String configName) {
        if (this.m_prefs == null) {
            return defaultWidth;
        }
        String baseKey = this.createColumnConfigKey(col, configName, TABLE_COLUMN_WIDTH);
        String key = this.getUserAgentPrefix() + baseKey;
        String value = this.m_prefs.get(key, null);
        if (value == null) {
            value = this.m_prefs.get(baseKey, null);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.warn("could not get table column width for [{}]. Loaded value '{}'", new Object[]{col.getClass().getName(), value, e});
            }
        }
        return defaultWidth;
    }

    public String getTableColumnBackgroundEffect(IColumn col, String defaultValue, String configName) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_BACKGROUND_EFFECT);
        return this.m_prefs.get(key, defaultValue);
    }

    public boolean getTableColumnVisible(IColumn col, boolean defaultValue) {
        return this.getTableColumnVisible(col, defaultValue, null);
    }

    public boolean getTableColumnVisible(IColumn col, boolean defaultValue, String configName) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_VISIBLE);
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            Boolean b = (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            return b != null ? b : defaultValue;
        }
        return defaultValue;
    }

    public int getTableColumnViewIndex(IColumn col, int defaultIndex) {
        return this.getTableColumnViewIndex(col, defaultIndex, null);
    }

    public int getTableColumnViewIndex(IColumn col, int defaultIndex, String configName) {
        if (this.m_prefs == null) {
            return defaultIndex;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_UIINDEX);
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.warn("could not get table column view index for [{}]. Loaded value '{}'", new Object[]{col.getClass().getName(), value, e});
            }
        }
        return defaultIndex;
    }

    public int getTableColumnSortIndex(IColumn col, int defaultValue, String configName) {
        Boolean b;
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_EXPLICIT);
        String value = this.m_prefs.get(key, null);
        if (value != null && (b = (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class)) != null && !b.booleanValue()) {
            return defaultValue;
        }
        key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_INDEX);
        value = this.m_prefs.get(key, null);
        if (value != null) {
            Integer i = (Integer)TypeCastUtility.castValue((Object)value, Integer.class);
            return i;
        }
        return defaultValue;
    }

    public boolean getTableColumnGrouped(IColumn col, boolean defaultValue, String configName) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_GROUPED);
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            Boolean b = (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            return b != null ? b : defaultValue;
        }
        return defaultValue;
    }

    public String getTableColumnAggregationFunction(IColumn col, String defaultValue, String configName) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_AGGR_FUNCTION);
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            String s = (String)TypeCastUtility.castValue((Object)value, String.class);
            return s;
        }
        return defaultValue;
    }

    public boolean getTableColumnSortAscending(IColumn col, boolean defaultValue, String configName) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.createColumnConfigKey(col, configName, TABLE_COLUMN_SORT_ASC);
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            Boolean b = (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            return b != null ? b : defaultValue;
        }
        return defaultValue;
    }

    public void setCalendarPreferences(int displayMode, boolean displayCondensed) {
        if (this.m_prefs == null) {
            return;
        }
        this.m_prefs.put(CALENDAR_DISPLAY_MODE, "" + displayMode);
        this.m_prefs.put(CALENDAR_DISPLAY_CONDENSED, "" + displayCondensed);
        this.flush();
    }

    public int getCalendarDisplayMode(int defaultValue) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = CALENDAR_DISPLAY_MODE;
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.warn("could not get calendar display mode. Loaded value '{}'", (Object)value, (Object)e);
            }
        }
        return defaultValue;
    }

    public boolean getCalendarDisplayCondensed(boolean defaultValue) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = CALENDAR_DISPLAY_CONDENSED;
        String value = this.m_prefs.get(key, null);
        if (value != null) {
            try {
                return (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            }
            catch (Exception e) {
                LOG.warn("could not get calendar display condensed. Loaded value '{}'", (Object)value, (Object)e);
            }
        }
        return defaultValue;
    }

    public boolean getTableTileMode(ITable table, boolean defaultValue) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String key = this.getTableKey(table) + "#table.tile.mode";
        return BooleanUtility.nvl((Boolean)this.getPropertyBoolean(key));
    }

    public void setTableTileMode(ITable table, boolean value) {
        String key = this.getTableKey(table) + "#table.tile.mode";
        this.setPropertyBoolean(key, value);
    }

    public int getPropertyInteger(String propName, int defaultValue, boolean setDefaultAsProperty) {
        if (this.m_prefs == null) {
            return defaultValue;
        }
        String value = this.m_prefs.get(propName, null);
        if (value != null) {
            try {
                return (Integer)TypeCastUtility.castValue((Object)value, Integer.class);
            }
            catch (Exception e) {
                LOG.warn("could not get integer property '{}'. Loaded value '{}'", new Object[]{propName, value, e});
                if (setDefaultAsProperty) {
                    this.setPropertyInteger(propName, defaultValue);
                }
            }
        } else if (setDefaultAsProperty) {
            this.setPropertyInteger(propName, defaultValue);
        }
        return defaultValue;
    }

    public void setPropertyInteger(String propName, int value) {
        if (this.m_prefs == null) {
            return;
        }
        this.m_prefs.put(propName, "" + value);
        this.flush();
    }

    public int[] getPropertyIntArray(String propName) {
        if (this.m_prefs == null) {
            return null;
        }
        String strVal = this.m_prefs.get(propName, null);
        if (!StringUtility.hasText((CharSequence)strVal)) {
            return null;
        }
        String[] split = strVal.split(";");
        int[] val = new int[split.length];
        int i = 0;
        while (i < split.length) {
            val[i] = Integer.parseInt(split[i]);
            ++i;
        }
        return val;
    }

    public void setPropertyIntArray(String propName, int[] value) {
        if (this.m_prefs == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                builder.append(value[i]);
                if (i != value.length - 1) {
                    builder.append(";");
                }
                ++i;
            }
        }
        this.m_prefs.put(propName, builder.toString());
        this.flush();
    }

    public Double getPropertyDouble(String propName) {
        if (this.m_prefs == null) {
            return null;
        }
        String value = this.m_prefs.get(propName, null);
        if (value != null) {
            try {
                return (Double)TypeCastUtility.castValue((Object)value, Double.class);
            }
            catch (Exception e) {
                LOG.warn("could not get double property '{}'. Loaded value '{}'", new Object[]{propName, value, e});
            }
        }
        return null;
    }

    public void setPropertyDouble(String propName, Double value) {
        if (this.m_prefs == null) {
            return;
        }
        this.m_prefs.put(propName, String.valueOf(value));
        this.flush();
    }

    public Boolean getPropertyBoolean(String propName) {
        if (this.m_prefs == null) {
            return null;
        }
        Boolean result = null;
        String value = this.m_prefs.get(propName, null);
        if (value != null) {
            if ("true".equalsIgnoreCase(value)) {
                result = true;
            } else if ("false".equalsIgnoreCase(value)) {
                result = false;
            }
        }
        return result;
    }

    public void setPropertyBoolean(String propName, boolean value) {
        if (this.m_prefs == null) {
            return;
        }
        this.m_prefs.put(propName, Boolean.toString(value));
        this.flush();
    }

    public String getPropertyString(String propName) {
        if (this.m_prefs == null) {
            return null;
        }
        return this.m_prefs.get(propName, null);
    }

    public void setPropertyString(String propName, String value) {
        if (this.m_prefs == null) {
            return;
        }
        this.m_prefs.put(propName, value);
        this.flush();
    }

    public int[][] getDesktopColumnSplits(int rowCount, int colCount) {
        int[] a = this.getPropertyIntArray(DESKTOP_COLUMN_SPLITS);
        if (a != null && a.length == rowCount * colCount) {
            int[][] splits = new int[rowCount][colCount];
            int r = 0;
            while (r < rowCount) {
                System.arraycopy(a, r * colCount, splits[r], 0, colCount);
                ++r;
            }
            return splits;
        }
        return null;
    }

    public void setDesktopColumnSplits(int[][] splits) {
        if (splits != null) {
            int rowCount = splits.length;
            int colCount = splits[0].length;
            int[] a = new int[rowCount * colCount];
            int index = 0;
            int[][] nArray = splits;
            int n = splits.length;
            int n2 = 0;
            while (n2 < n) {
                int[] split = nArray[n2];
                int c = 0;
                while (c < colCount) {
                    a[index] = split[c];
                    ++index;
                    ++c;
                }
                ++n2;
            }
            this.setPropertyIntArray(DESKTOP_COLUMN_SPLITS, a);
        }
    }

    public void setCustomClientPreference(CustomClientPreferenceId customClientPreferenceId, ICustomClientPreferenceDo customClientPreference) {
        Assertions.assertNotNull((Object)customClientPreferenceId, (String)"customClientPreferenceId is required", (Object[])new Object[0]);
        if (this.m_prefs == null) {
            return;
        }
        if (customClientPreference == null) {
            this.m_prefs.remove(customClientPreferenceId.unwrapAsString());
        } else {
            this.m_prefs.put(customClientPreferenceId.unwrapAsString(), ((IDataObjectMapper)BEANS.get(IDataObjectMapper.class)).writeValue((Object)customClientPreference));
        }
        this.flush();
    }

    public <T extends ICustomClientPreferenceDo> T getCustomClientPreference(CustomClientPreferenceId customClientPreferenceId, Class<T> customClientPreferenceClass) {
        if (this.m_prefs == null) {
            return null;
        }
        String customClientPreferenceJson = this.m_prefs.get(customClientPreferenceId.unwrapAsString(), null);
        return (T)((ICustomClientPreferenceDo)((IDataObjectMapper)BEANS.get(IDataObjectMapper.class)).readValue(customClientPreferenceJson, customClientPreferenceClass));
    }

    public static IPreferences getClientPreferences(IClientSession session) {
        try {
            return Preferences.get((ISession)session, (String)PREFERENCES_NODE_ID);
        }
        catch (RuntimeException | PlatformError t) {
            LOG.error("Unable to load preferences.", t);
            return null;
        }
    }

    protected void load(IClientSession session) {
        this.m_prefs = ClientUIPreferences.getClientPreferences(session);
    }

    protected void flush() {
        if (this.m_prefs == null) {
            return;
        }
        try {
            this.m_prefs.flush();
        }
        catch (RuntimeException | PlatformError t) {
            LOG.error("Unable to flush preferences.", t);
        }
    }
}

