/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.ScrollOptions;
import org.eclipse.scout.rt.client.ui.WidgetEvent;
import org.eclipse.scout.rt.client.ui.WidgetListeners;
import org.eclipse.scout.rt.client.ui.WidgetVisitorTypeAdapter;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.IBreadthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeTraversals;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="c11a79f7-0af6-430e-9700-2d050e3aa41e")
public abstract class AbstractWidget
extends AbstractPropertyObserver
implements IWidget {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWidget.class);
    private static final NamedBitMaskHelper ENABLED_BIT_HELPER = new NamedBitMaskHelper(new String[]{"ENABLED", "ENABLED_GRANTED", "ENABLED_SLAVE"});
    private static final String PROP_ENABLED_BYTE = "enabledByte";
    private final WidgetListeners m_listenerList = new WidgetListeners();

    public AbstractWidget() {
        this(true);
    }

    public AbstractWidget(boolean callInitializer) {
        this.setEnabledByte((byte)-1, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        if (this.isInitConfigDone()) {
            return;
        }
        this.initConfigInternal();
        this.setInitConfigDone(true);
    }

    protected void initConfigInternal() {
        this.initConfig();
    }

    protected void initConfig() {
        this.setCssClass(this.getConfiguredCssClass());
        this.setEnabled(this.getConfiguredEnabled());
        this.setInheritAccessibility(this.getConfiguredInheritAccessibility());
    }

    @Override
    public boolean isInitConfigDone() {
        return this.propertySupport.getPropertyBool("initConfigDone");
    }

    protected void setInitConfigDone(boolean initConfigDone) {
        this.propertySupport.setPropertyBool("initConfigDone", initConfigDone);
    }

    @Override
    public final void init() {
        if (this.isInitDone()) {
            return;
        }
        this.doInit(true);
    }

    @Override
    public <T extends IWidget> T getWidgetByClass(Class<T> widgetClassToFind) {
        Assertions.assertNotNull(widgetClassToFind);
        Holder result = new Holder(widgetClassToFind);
        Function<IWidget, TreeVisitResult> visitor = w -> {
            if (w instanceof AbstractWidget) {
                return ((AbstractWidget)w).getWidgetByClassInternal(result, widgetClassToFind);
            }
            return TreeVisitResult.CONTINUE;
        };
        this.visit(visitor);
        return (T)((IWidget)result.getValue());
    }

    public <T extends IWidget> TreeVisitResult getWidgetByClassInternal(Holder<T> result, Class<T> widgetClassToFind) {
        if (widgetClassToFind.isInstance(this)) {
            result.setValue((Object)((IWidget)widgetClassToFind.cast(this)));
            return TreeVisitResult.TERMINATE;
        }
        return TreeVisitResult.CONTINUE;
    }

    private void doInit(boolean recursive) {
        this.initInternal();
        if (recursive) {
            this.initChildren();
        }
        this.setInitDone(true);
        this.setDisposeDone(false);
    }

    protected void initChildren() {
        this.initChildren(this.getChildren());
    }

    protected void initChildren(List<? extends IWidget> widgets) {
        for (IWidget iWidget : widgets) {
            iWidget.init();
        }
    }

    protected void initInternal() {
    }

    @Override
    public boolean isInitDone() {
        return this.propertySupport.getPropertyBool("initDone");
    }

    protected void setInitDone(boolean initDone) {
        this.propertySupport.setPropertyBool("initDone", initDone);
    }

    @Override
    public void reinit() {
        this.setInitDone(false);
        this.doInit(false);
        for (IWidget iWidget : this.getChildren()) {
            iWidget.reinit();
        }
    }

    @Override
    public final void dispose() {
        if (this.isDisposeDone()) {
            return;
        }
        this.disposeChildren();
        try {
            this.disposeInternal();
        }
        catch (RuntimeException t) {
            LOG.warn("Could not dispose widget '{}'.", (Object)this, (Object)t);
        }
        this.setDisposeDone(true);
        this.setInitDone(false);
    }

    protected void disposeChildren() {
        this.disposeChildren(this.getChildren());
    }

    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        for (IWidget iWidget : widgetsToDispose) {
            try {
                iWidget.dispose();
            }
            catch (RuntimeException t) {
                LOG.warn("Could not dispose widget '{}'.", (Object)iWidget, (Object)t);
            }
        }
    }

    protected void disposeInternal() {
    }

    @Override
    public boolean isDisposeDone() {
        return this.propertySupport.getPropertyBool("disposeDone");
    }

    protected void setDisposeDone(boolean disposeDone) {
        this.propertySupport.setPropertyBool("disposeDone", disposeDone);
    }

    @Override
    public <T extends IWidget> TreeVisitResult visit(Function<T, TreeVisitResult> visitor, Class<T> type) {
        return this.visit(new WidgetVisitorTypeAdapter<T>(visitor, type));
    }

    @Override
    public <T extends IWidget> void visit(Consumer<T> visitor, Class<T> type) {
        Assertions.assertNotNull(visitor);
        this.visit(new WidgetVisitorTypeAdapter<IWidget>(widget -> {
            visitor.accept(widget);
            return TreeVisitResult.CONTINUE;
        }, type));
    }

    @Override
    public void visit(Consumer<IWidget> visitor) {
        Assertions.assertNotNull(visitor);
        this.visit((IWidget widget) -> {
            visitor.accept((IWidget)widget);
            return TreeVisitResult.CONTINUE;
        });
    }

    @Override
    public TreeVisitResult visit(Function<IWidget, TreeVisitResult> visitor) {
        return this.visit(WidgetVisitorTypeAdapter.functionToVisitor(visitor));
    }

    @Override
    public <T extends IWidget> TreeVisitResult visit(IDepthFirstTreeVisitor<T> visitor, Class<T> type) {
        return this.visit(new WidgetVisitorTypeAdapter<T>(visitor, type));
    }

    @Override
    public TreeVisitResult visit(IDepthFirstTreeVisitor<IWidget> visitor) {
        return this.visit(visitor, IWidget::getChildren);
    }

    protected <T extends IWidget> TreeVisitResult visit(IDepthFirstTreeVisitor<T> visitor, Function<T, Collection<? extends IWidget>> childrenSupplier, Class<T> type) {
        WidgetVisitorTypeAdapter<T> widgetVisitorTypeAdapter = new WidgetVisitorTypeAdapter<T>(visitor, type);
        Function<IWidget, Collection<? extends IWidget>> cs = widget -> {
            if (type.isAssignableFrom(widget.getClass())) {
                childrenSupplier.apply(widget);
            }
            return widget.getChildren();
        };
        return this.visit(widgetVisitorTypeAdapter, cs);
    }

    protected TreeVisitResult visit(IDepthFirstTreeVisitor<IWidget> visitor, Function<IWidget, Collection<? extends IWidget>> childrenSupplier) {
        return TreeTraversals.create(visitor, childrenSupplier).traverse((Object)this);
    }

    @Override
    public <T extends IWidget> TreeVisitResult visit(IBreadthFirstTreeVisitor<T> visitor, Class<T> type) {
        return this.visit((IBreadthFirstTreeVisitor<IWidget>)((IBreadthFirstTreeVisitor)(widget, level, index) -> {
            if (type.isAssignableFrom(widget.getClass())) {
                return visitor.visit(widget, level, index);
            }
            return TreeVisitResult.CONTINUE;
        }));
    }

    @Override
    public TreeVisitResult visit(IBreadthFirstTreeVisitor<IWidget> visitor) {
        return TreeTraversals.create(visitor, IWidget::getChildren).traverse((Object)this);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.emptyArrayList();
    }

    @Order(value=10.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @Order(value=20.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredInheritAccessibility() {
        return true;
    }

    @Order(value=30.0)
    @ConfigProperty(value="STRING")
    protected String getConfiguredCssClass() {
        return null;
    }

    @Override
    public String getCssClass() {
        return this.propertySupport.getPropertyString("cssClass");
    }

    @Override
    public void setCssClass(String cssClass) {
        this.propertySupport.setPropertyString("cssClass", cssClass);
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public boolean setProperty(String name, Object value) {
        return this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public boolean isLoading() {
        return this.propertySupport.getPropertyBool("loading");
    }

    @Override
    public void setLoading(boolean loading) {
        this.propertySupport.setPropertyBool("loading", loading);
    }

    @Override
    public boolean isEnabled() {
        return NamedBitMaskHelper.allBitsSet((byte)this.getEnabledByte());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, "ENABLED");
    }

    @Override
    public boolean isEnabledGranted() {
        return this.isEnabled("ENABLED_GRANTED");
    }

    @Override
    public void setEnabledGranted(boolean enabled) {
        this.setEnabled(enabled, "ENABLED_GRANTED");
    }

    public boolean isEnabled(String dimension) {
        return ENABLED_BIT_HELPER.isBitSet(dimension, this.getEnabledByte());
    }

    @Override
    public boolean isInheritAccessibility() {
        return this.propertySupport.getPropertyBool("inheritAccessibility");
    }

    @Override
    public void setInheritAccessibility(boolean b) {
        this.propertySupport.setPropertyBool("inheritAccessibility", b);
    }

    @Override
    public void setEnabledPermission(Permission permission) {
        boolean b = true;
        if (permission != null) {
            b = ACCESS.check((Permission)permission);
        }
        this.setEnabledGranted(b);
    }

    @Override
    public void setEnabledGranted(boolean enabled, boolean updateParents) {
        this.setEnabledGranted(enabled, updateParents, false);
    }

    @Override
    public void setEnabledGranted(boolean enabled, boolean updateParents, boolean updateChildren) {
        this.setEnabled(enabled, updateParents, updateChildren, "ENABLED_GRANTED");
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents) {
        this.setEnabled(enabled, updateParents, false);
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, boolean updateChildren) {
        this.setEnabled(enabled, updateParents, updateChildren, "ENABLED");
    }

    public void setEnabled(boolean enabled, String dimension) {
        this.setEnabled(enabled, false, dimension);
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, String dimension) {
        this.setEnabled(enabled, updateParents, false, dimension);
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, boolean updateChildren, String dimension) {
        this.setEnabledByte(ENABLED_BIT_HELPER.changeBit(dimension, enabled, this.getEnabledByte()), true);
        if (enabled && updateParents) {
            this.visitParents((IWidget field) -> field.setEnabled(true, dimension));
        }
        if (updateChildren) {
            for (IWidget iWidget : this.getChildren()) {
                iWidget.visit((IWidget field) -> {
                    if (field instanceof IAction) {
                        if (field.isInheritAccessibility()) {
                            field.setEnabled(enabled, dimension);
                        }
                    } else {
                        field.setEnabled(enabled, dimension);
                    }
                });
            }
        }
    }

    @Override
    public boolean isEnabled(Predicate<String> filter) {
        return ENABLED_BIT_HELPER.allBitsEqual(this.getEnabledByte(), filter);
    }

    private byte getEnabledByte() {
        return this.propertySupport.getPropertyByte(PROP_ENABLED_BYTE);
    }

    private boolean setEnabledByte(byte enabled, boolean fireListeners) {
        boolean changed = this.propertySupport.setPropertyByte(PROP_ENABLED_BYTE, enabled);
        if (changed && fireListeners) {
            boolean newEnabled = this.isEnabled();
            this.propertySupport.firePropertyChange("enabled", !newEnabled, newEnabled);
        }
        return changed;
    }

    @Override
    public IWidget getParent() {
        return (IWidget)this.propertySupport.getProperty("parentWidget");
    }

    @Override
    public boolean setParentInternal(IWidget w) {
        return this.propertySupport.setProperty("parentWidget", (Object)w);
    }

    @Override
    public boolean isEnabledIncludingParents() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.isInheritAccessibility()) {
            return true;
        }
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(true);
        this.visitParents((IWidget w) -> {
            if (!w.isEnabled()) {
                result.set(false);
                return false;
            }
            return w.isInheritAccessibility();
        });
        return result.get();
    }

    @Override
    public boolean visitParents(Consumer<IWidget> visitor) {
        return this.visitParents(visitor, IWidget.class);
    }

    @Override
    public <T extends IWidget> boolean visitParents(Consumer<T> visitor, Class<T> typeFilter) {
        return this.visitParents((T w) -> {
            visitor.accept(w);
            return true;
        }, typeFilter);
    }

    @Override
    public boolean visitParents(Predicate<IWidget> visitor) {
        return this.visitParents(visitor, IWidget.class);
    }

    @Override
    public <T extends IWidget> boolean visitParents(Predicate<T> visitor, Class<T> typeFilter) {
        IWidget cur = this;
        while ((cur = cur.getParent()) != null) {
            if (!typeFilter.isInstance(cur) || visitor.test((AbstractWidget)cur)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends IWidget> T getParentOfType(Class<T> type) {
        AtomicReference result = new AtomicReference();
        this.visitParents((T composite) -> !result.compareAndSet(null, composite), type);
        return (T)((IWidget)result.get());
    }

    @Override
    public boolean has(IWidget child) {
        while (child != null) {
            if (this.equals(child.getParent())) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        IWidget parent = this.getParent();
        if (parent != null) {
            return simpleClassId + "_" + parent.classId();
        }
        return simpleClassId;
    }

    @Override
    public void scrollToTop() {
        this.scrollToTop(null);
    }

    @Override
    public void scrollToTop(ScrollOptions options) {
        WidgetEvent event = new WidgetEvent(this, 100);
        event.setScrollOptions(options);
        this.fireWidgetEvent(event);
    }

    @Override
    public void reveal() {
        this.reveal(null);
    }

    @Override
    public void reveal(ScrollOptions options) {
        WidgetEvent event = new WidgetEvent(this, 400);
        event.setScrollOptions(options);
        this.fireWidgetEvent(event);
    }

    public final void notifyFocusIn() {
        this.fireWidgetEvent(new WidgetEvent(this, 200));
        this.execFocusIn();
    }

    public final void notifyFocusOut() {
        this.fireWidgetEvent(new WidgetEvent(this, 300));
        this.execFocusOut();
    }

    protected void execFocusIn() {
    }

    protected void execFocusOut() {
    }

    protected void fireWidgetEvent(WidgetEvent event) {
        this.widgetListeners().fireEvent(event);
    }

    @Override
    public WidgetListeners widgetListeners() {
        return this.m_listenerList;
    }
}

