/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.transformation.AbstractDeviceTransformer;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.controls.ITableControl;
import org.eclipse.scout.rt.client.ui.basic.table.controls.SearchFormTableControl;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.placeholder.IPlaceholderField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

@Order(value=5200.0)
public class MobileDeviceTransformer
extends AbstractDeviceTransformer {
    @Override
    public boolean isActive() {
        return UserAgentUtility.isMobileDevice();
    }

    @Override
    protected void initTransformationConfig() {
        this.enableTransformation(MobileDeviceTransformation.MAKE_DESKTOP_COMPACT);
        this.enableTransformation(MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP);
        this.enableTransformation(MobileDeviceTransformation.MOVE_FIELD_STATUS_TO_TOP);
        this.enableTransformation(MobileDeviceTransformation.MAKE_FIELD_SCALEABLE);
        this.enableTransformation(MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
        this.enableTransformation(MobileDeviceTransformation.MAKE_OUTLINE_ROOT_NODE_VISIBLE);
        this.enableTransformation(MobileDeviceTransformation.REDUCE_GROUPBOX_COLUMNS_TO_ONE);
        this.enableTransformation(MobileDeviceTransformation.HIDE_PLACEHOLDER_FIELD);
        this.enableTransformation(MobileDeviceTransformation.HIDE_FIELD_STATUS);
        this.enableTransformation(MobileDeviceTransformation.DISABLE_FORM_CANCEL_CONFIRMATION);
        this.enableTransformation(MobileDeviceTransformation.AUTO_CLOSE_SEARCH_FORM);
        this.enableTransformation(MobileDeviceTransformation.MAXIMIZE_DIALOG);
        this.enableTransformation(MobileDeviceTransformation.SET_SEQUENCEBOX_UI_HEIGHT);
        this.enableTransformation(MobileDeviceTransformation.USE_DIALOG_STYLE_FOR_VIEW);
        this.enableTransformation(MobileDeviceTransformation.AVOID_DETAIL_FORM_AS_DISPLAY_PARENT);
        this.enableTransformation(MobileDeviceTransformation.SET_RADIO_BUTTON_GROUP_UI_HEIGHT);
    }

    @Override
    public void transformDesktop() {
        if (this.isTransformationEnabled(MobileDeviceTransformation.MAKE_DESKTOP_COMPACT)) {
            this.getDesktop().setDisplayStyle("compact");
        }
    }

    @Override
    public void transformForm(IForm form) {
    }

    @Override
    public void notifyFormAboutToShow(IForm form) {
        this.transformDesktopForm(form);
    }

    protected void transformDesktopForm(IForm form) {
        if (this.isFormExcluded(form)) {
            return;
        }
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.DISABLE_FORM_CANCEL_CONFIRMATION, form)) {
            form.setAskIfNeedSave(false);
        }
        if (form.getDisplayHint() == 20) {
            this.transformView(form);
        } else if (form.getDisplayHint() == 0) {
            this.transformDialog(form);
        }
    }

    protected void transformView(IForm form) {
        form.setDisplayViewId("C");
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.USE_DIALOG_STYLE_FOR_VIEW, form)) {
            form.setHeaderVisible(true);
            form.addCssClass("mobile-view");
            form.getRootGroupBox().setMenuBarPosition("bottom");
        }
        if ("compact".equals(this.getDesktop().getDisplayStyle()) && this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.AVOID_DETAIL_FORM_AS_DISPLAY_PARENT, form) && this.getDesktop().getPageDetailForm() == form.getDisplayParent()) {
            form.setDisplayParent(this.getDesktop().getOutline());
        }
    }

    protected void transformDialog(IForm form) {
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAXIMIZE_DIALOG, form)) {
            form.setMaximized(true);
        }
    }

    @Override
    public void transformOutline(IOutline outline) {
        outline.setNavigateButtonsVisible(false);
        outline.setLazyExpandingEnabled(false);
        outline.setToggleBreadcrumbStyleEnabled(false);
        outline.setDisplayStyle("breadcrumb");
        if (this.isTransformationEnabled(MobileDeviceTransformation.MAKE_OUTLINE_ROOT_NODE_VISIBLE)) {
            this.ensureOutlineRootContentVisible(outline);
        }
    }

    protected void ensureOutlineRootContentVisible(IOutline outline) {
        if (outline.getDefaultDetailForm() == null && !outline.isOutlineOverviewVisible()) {
            return;
        }
        outline.setRootNodeVisible(true);
        outline.addUITreeListener(event -> {
            if (event.getNewSelectedNodes().isEmpty()) {
                outline.selectNode(outline.getRootNode());
            }
        }, 40);
        outline.addUITreeListener(event -> {
            if (event.getNodeCount() == 1 && event.getNode() == outline.getRootNode()) {
                this.transformRootPage(outline.getRootPage());
            }
        }, 10);
        this.transformRootPage(outline.getRootPage());
    }

    protected void transformRootPage(IPage page) {
        page.setCompactRoot(true);
        page.setExpanded(true);
        IOutline outline = page.getOutline();
        if (outline.getSelectedNodes().isEmpty()) {
            outline.selectNode(outline.getRootNode());
        }
    }

    public void transformPage(IPage page) {
        if (page instanceof IPageWithTable) {
            this.transformPageWithTable((IPageWithTable)page);
        }
    }

    public void transformPageWithTable(IPageWithTable page) {
        page.setLeaf(false);
        page.setAlwaysCreateChildPage(true);
    }

    @Override
    public void transformPageTable(ITable table, IPage<?> page) {
        for (ITableControl control : table.getTableControls()) {
            if (control instanceof SearchFormTableControl) continue;
            control.setVisibleGranted(false);
        }
    }

    @Override
    public void notifyPageDetailFormChanged(IForm form) {
        IGroupBox mainBox = form.getRootGroupBox();
        if (mainBox.isScrollable().isTrue()) {
            mainBox.setScrollable(false);
            FormUtility.initRootBoxGridData(mainBox);
        }
    }

    @Override
    public void notifyPageDetailTableChanged(ITable table) {
        IPage<?> activePage = this.getDesktop().getOutline().getActivePage();
        if (activePage == null) {
            return;
        }
        IPage<?> parentPage = activePage.getParentPage();
        if (parentPage == null) {
            return;
        }
        Object parentTable = parentPage.getTable(false);
        if (parentTable == null) {
            return;
        }
        ArrayList<IMenu> newMenus = new ArrayList<IMenu>();
        for (IMenu menu : table.getMenus()) {
            if (menu instanceof OutlineMenuWrapper) {
                OutlineMenuWrapper menuWrapper = (OutlineMenuWrapper)menu;
                IMenu originalMenu = MobileDeviceTransformer.unwrapOutlineWrapperMenu(menuWrapper);
                if (menuWrapper.getMenuTypes().contains(TableMenuType.EmptySpace) && originalMenu.getMenuTypes().contains(TableMenuType.SingleSelection) && parentTable.getMenus().contains(originalMenu)) continue;
            }
            newMenus.add(menu);
        }
        if (!CollectionUtility.equalsCollection(newMenus, table.getContextMenu().getChildActions())) {
            table.getContextMenu().setChildActions(newMenus);
        }
    }

    protected static IMenu unwrapOutlineWrapperMenu(IMenu menu) {
        return MenuWrapper.unwrapMenu(menu);
    }

    @Override
    public void notifyPageSearchFormInit(IPageWithTable<ITable> page) {
        if (!this.isTransformationEnabled(MobileDeviceTransformation.AUTO_CLOSE_SEARCH_FORM)) {
            return;
        }
        ISearchForm searchForm = page.getSearchFormInternal();
        searchForm.addFormListener(e -> {
            if (2020 == e.getType()) {
                this.onSearchFormStored(page);
            }
        }, new Integer[0]);
    }

    protected void onSearchFormStored(IPageWithTable<ITable> page) {
        SearchFormTableControl tableControl = page.getTable().getTableControl(SearchFormTableControl.class);
        if (tableControl != null) {
            tableControl.setSelected(false);
        }
    }

    @Override
    public void transformFormField(IFormField field) {
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP, field)) {
            this.moveLabelToTop(field);
        }
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAKE_FIELD_SCALEABLE, field)) {
            this.makeFieldScalable(field);
        }
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.HIDE_FIELD_STATUS, field)) {
            this.hideStatus(field);
        }
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MOVE_FIELD_STATUS_TO_TOP, field)) {
            this.moveStatusToTop(field);
        }
        if (field instanceof IGroupBox) {
            this.transformGroupBox((IGroupBox)field);
        } else if (field instanceof IPlaceholderField) {
            this.transformPlaceholderField((IPlaceholderField)field);
        } else if (field instanceof ISequenceBox) {
            this.transformSequenceBox((ISequenceBox)field);
        } else if (field instanceof IRadioButtonGroup) {
            this.transformRadioButtonGroup((IRadioButtonGroup)field);
        }
    }

    protected void makeFieldScalable(IFormField field) {
        if (field.getParentField() instanceof ISequenceBox) {
            return;
        }
        GridData gridDataHints = field.getGridDataHints();
        if (gridDataHints.weightX == 0.0) {
            gridDataHints.weightX = 1.0;
            field.setGridDataHints(gridDataHints);
            this.rebuildParentGrid(field);
        }
    }

    protected void moveLabelToTop(IFormField field) {
        if (field instanceof IGroupBox) {
            return;
        }
        if (ObjectUtility.isOneOf((Object)field.getLabelPosition(), (Object)2, (Object[])new Object[]{(byte)5})) {
            return;
        }
        if (field.getParentField() instanceof ISequenceBox) {
            return;
        }
        if (field instanceof IButton) {
            return;
        }
        field.setLabelPosition((byte)4);
        if (field instanceof IBooleanField) {
            field.setLabelVisible(false);
        } else if (!StringUtility.hasText((CharSequence)field.getLabel()) && !(field instanceof ITabBox)) {
            field.setLabelVisible(false);
        }
    }

    protected void moveStatusToTop(IFormField field) {
        field.setStatusPosition("top");
    }

    protected void hideStatus(IFormField field) {
        if (field instanceof ICompositeField) {
            field.setStatusVisible(false, false);
        } else {
            field.setStatusVisible(false);
        }
    }

    protected void transformMainBox(IGroupBox groupBox) {
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE, groupBox)) {
            this.makeGroupBoxScrollable(groupBox);
        }
    }

    protected void makeGroupBoxScrollable(IGroupBox groupBox) {
        if (groupBox.isScrollable().isTrue()) {
            return;
        }
        if (groupBox.getForm() != null && this.getDesktop().getPageDetailForm() == groupBox.getForm()) {
            return;
        }
        groupBox.setScrollable(true);
        if (groupBox.isMainBox()) {
            FormUtility.initRootBoxGridData(groupBox);
        } else {
            this.rebuildParentGrid(groupBox);
        }
    }

    protected void transformGroupBox(IGroupBox groupBox) {
        if (groupBox.isMainBox()) {
            this.transformMainBox(groupBox);
        }
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.REDUCE_GROUPBOX_COLUMNS_TO_ONE, groupBox)) {
            groupBox.setGridColumnCount(1);
        }
        groupBox.setResponsive(false);
    }

    protected void transformPlaceholderField(IPlaceholderField field) {
        if (this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.HIDE_PLACEHOLDER_FIELD, field)) {
            field.setVisible(false);
        }
    }

    protected void transformSequenceBox(ISequenceBox box) {
        if (!this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.SET_SEQUENCEBOX_UI_HEIGHT, box)) {
            return;
        }
        this.transformUseUiHeight(box);
    }

    protected void transformRadioButtonGroup(IRadioButtonGroup box) {
        if (!this.isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.SET_RADIO_BUTTON_GROUP_UI_HEIGHT, box)) {
            return;
        }
        this.transformUseUiHeight(box);
    }

    protected void transformUseUiHeight(IFormField field) {
        if (field == null) {
            return;
        }
        GridData gridDataHints = field.getGridDataHints();
        if (!gridDataHints.useUiHeight) {
            gridDataHints.useUiHeight = true;
            field.setGridDataHints(gridDataHints);
            this.rebuildParentGrid(field);
        }
    }
}

