/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.session;

import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.clientnotification.IClientSessionRegistry;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.shared.session.Sessions;

@ApplicationScoped
public class ClientSessionProvider {
    public <SESSION extends IClientSession> SESSION provide(ClientRunContext clientRunContext) {
        return this.provide(null, clientRunContext);
    }

    public <SESSION extends IClientSession> SESSION provide(String sessionId, ClientRunContext clientRunContext) {
        String sid = sessionId != null ? sessionId : Sessions.randomSessionId();
        return (SESSION)((IClientSession)clientRunContext.call(() -> {
            IClientSession session = (IClientSession)BEANS.get(IClientSession.class);
            this.registerSessionForNotifications(session, sid);
            return (IClientSession)ModelJobs.schedule(() -> {
                this.beforeStartSession(session, sid);
                session.start(sid);
                this.afterStartSession(session);
                return session;
            }, ModelJobs.newInput(ClientRunContexts.copyCurrent().withSession(session, true)).withName("Starting ClientSession [sessionId={}]", new Object[]{sid}).withExceptionHandling(null, false)).awaitDoneAndGet();
        }));
    }

    protected void registerSessionForNotifications(IClientSession session, String sessionId) {
        ((IClientSessionRegistry)BEANS.get(IClientSessionRegistry.class)).register(session, sessionId);
    }

    protected void beforeStartSession(IClientSession clientSession, String sessionId) {
    }

    protected void afterStartSession(IClientSession clientSession) {
    }

    public static IClientSession currentSession() {
        return (IClientSession)Sessions.currentSession(IClientSession.class);
    }

    public static <SESSION extends IClientSession> SESSION currentSession(Class<SESSION> type) {
        return (SESSION)((IClientSession)Sessions.currentSession(type));
    }
}

