/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.search;

import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@Order(value=5100.0)
public class DefaultSearchFilterService
implements ISearchFilterService {
    @Override
    public SearchFilter createNewSearchFilter() {
        return new SearchFilter();
    }

    @Override
    public void applySearchDelegate(IFormField field, SearchFilter search, boolean includeChildren) {
        AbstractValueField valueField;
        AbstractFormField range;
        Object label = field.getLabel();
        if (field.getParentField() instanceof ISequenceBox && field.getParentField() instanceof AbstractFormField && (range = (AbstractFormField)((Object)field.getParentField())).getInitialLabel() != null) {
            label = range.getInitialLabel() + (String)(StringUtility.isNullOrEmpty((CharSequence)label) ? "" : " " + (String)label);
        }
        label = StringUtility.nullIfEmpty((Object)label);
        if (field instanceof AbstractListBox) {
            valueField = (AbstractListBox)field;
            if (!((AbstractListBox)valueField).getValue().isEmpty()) {
                search.addDisplayText(StringUtility.box((String)"", (String)label, (String)(" " + TEXTS.get((String)"LogicIn") + " ")) + valueField.getDisplayText());
            }
            return;
        }
        if (field instanceof AbstractTreeBox) {
            valueField = (AbstractTreeBox)field;
            if (!((AbstractTreeBox)valueField).getValue().isEmpty()) {
                search.addDisplayText(StringUtility.box((String)"", (String)label, (String)(" " + TEXTS.get((String)"LogicIn") + " ")) + valueField.getDisplayText());
            }
            return;
        }
        if (field instanceof AbstractStringField || field instanceof AbstractHtmlField || field instanceof AbstractLabelField) {
            valueField = (AbstractValueField)field;
            if (valueField.getValue() != null) {
                search.addDisplayText(StringUtility.box((String)"", (String)label, (String)(" " + TEXTS.get((String)"LogicLike") + " ")) + valueField.getDisplayText());
            }
            return;
        }
        if (field instanceof AbstractBooleanField) {
            valueField = (AbstractBooleanField)field;
            if (valueField.getValue() != null && ((Boolean)valueField.getValue()).booleanValue() && label != null) {
                search.addDisplayText((String)label);
            }
            return;
        }
        if (field instanceof AbstractRadioButtonGroup) {
            valueField = (AbstractRadioButtonGroup)field;
            if (valueField.getValue() != null) {
                String valueLabel;
                IRadioButton selectedButton = ((AbstractRadioButtonGroup)valueField).getSelectedButton();
                String string = valueLabel = selectedButton != null ? selectedButton.getLabel() : null;
                if (valueLabel == null) {
                    if (label != null) {
                        search.addDisplayText((String)label);
                    }
                } else {
                    search.addDisplayText(StringUtility.box((String)"", (String)label, (String)" = ") + valueLabel);
                }
            }
            return;
        }
        if (field instanceof AbstractValueField) {
            valueField = (AbstractValueField)field;
            if (valueField.getValue() != null) {
                search.addDisplayText(StringUtility.box((String)"", (String)label, (String)(" " + TEXTS.get((String)"LogicEQ") + " ")) + valueField.getDisplayText());
            }
            return;
        }
        if (includeChildren) {
            this.applySearchDelegateForChildren(field, search);
        }
    }

    protected void applySearchDelegateForChildren(IFormField field, SearchFilter search) {
        if (field instanceof ICompositeField) {
            for (IFormField f : ((ICompositeField)field).getFields()) {
                f.applySearch(search);
            }
        }
    }
}

