/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.icon;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.client.services.common.icon.IIconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIconProviderService
implements IIconProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIconProviderService.class);
    private static final String[] DEFAULT_ICON_EXTENSIONS = new String[]{"png", "gif", "jpg", "svg"};
    private final ReentrantReadWriteLock m_cacheLock = new ReentrantReadWriteLock();
    private final Map<String, IconSpec> m_cache = new HashMap<String, IconSpec>();

    protected AbstractIconProviderService() {
    }

    protected boolean isCacheEnabled() {
        return true;
    }

    protected void clearCache() {
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_cache.clear();
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
    }

    protected String[] getIconExtensions() {
        return DEFAULT_ICON_EXTENSIONS;
    }

    @Override
    public IconSpec getIconSpec(String iconName) {
        IconSpec spec;
        if (iconName == null) {
            return null;
        }
        this.m_cacheLock.readLock().lock();
        try {
            spec = this.m_cache.get(iconName);
            if (spec != null || this.m_cache.containsKey(iconName)) {
                IconSpec iconSpec = spec;
                return iconSpec;
            }
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
        this.m_cacheLock.writeLock().lock();
        try {
            spec = this.findIconSpec(iconName);
            this.m_cache.put(iconName, spec);
            IconSpec iconSpec = spec;
            return iconSpec;
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
    }

    protected IconSpec findIconSpec(String iconName) {
        String relativePathBase = iconName;
        if (StringUtility.isNullOrEmpty((CharSequence)relativePathBase)) {
            return null;
        }
        relativePathBase = relativePathBase.replaceAll("\\A[\\/\\\\]*", "");
        String[] exts = this.getIconExtensions();
        String[] relativePaths = new String[exts.length + 1];
        String[] iconNames = new String[exts.length + 1];
        relativePaths[0] = relativePathBase;
        iconNames[0] = iconName;
        int i = 1;
        while (i < relativePaths.length) {
            relativePaths[i] = relativePathBase + "." + exts[i - 1];
            iconNames[i] = iconName + "." + exts[i - 1];
            ++i;
        }
        IconSpec spec = null;
        spec = this.findIconSpec(relativePaths, iconNames);
        return spec;
    }

    protected IconSpec findIconSpec(String[] relativePaths, String[] iconNames) {
        if (relativePaths != null && relativePaths.length > 0) {
            int i = 0;
            while (i < relativePaths.length) {
                String relativePath = relativePaths[i];
                String iconName = iconNames[i];
                URL url = this.findResource(relativePath);
                if (url != null) {
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (InputStream in = url.openStream();){
                            IconSpec iconSpec = new IconSpec();
                            byte[] content = IOUtility.readBytes((InputStream)in);
                            if (content != null) {
                                iconSpec.setContent(content);
                            }
                            iconSpec.setName(iconName);
                            return iconSpec;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("could not read input stream from url '{}'.", (Object)url, (Object)e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected abstract URL findResource(String var1);
}

