/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.scout.rt.client.services.common.file.IFileService;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;

public class FileService
implements IFileService {
    private String m_rootPath = null;

    @Override
    public File getLocalFile(String dir, String simpleName) {
        return this.getFileLocation(dir, simpleName, true);
    }

    @Override
    public File getRemoteFile(String dir, String simpleName) {
        return this.getRemoteFile(dir, simpleName, null);
    }

    @Override
    public File getRemoteFile(String dir, String simpleName, Locale locale) {
        return this.getRemoteFile(dir, simpleName, locale, true);
    }

    @Override
    public File getRemoteFile(String dir, String simpleName, Locale locale, boolean checkCache) {
        File f;
        block22: {
            Object language;
            RemoteFile spec = null;
            f = null;
            if (locale != null && simpleName != null && simpleName.lastIndexOf(46) != -1) {
                Object filename = simpleName;
                language = locale.toString().replaceAll("__", "_");
                String prefix = ((String)filename).substring(0, ((String)filename).lastIndexOf(46)) + "_";
                String suffix = ((String)filename).substring(((String)filename).lastIndexOf(46));
                filename = prefix + (String)language + suffix;
                File test = this.getFileLocation(dir, (String)filename, false);
                while (!test.exists()) {
                    if (((String)language).indexOf(95) == -1) {
                        filename = simpleName;
                        break;
                    }
                    language = ((String)language).substring(0, ((String)language).lastIndexOf(95));
                    filename = prefix + (String)language + suffix;
                    test = this.getFileLocation(dir, (String)filename, false);
                }
                f = this.getFileLocation(dir, (String)filename, false);
                spec = new RemoteFile(dir, (String)filename, locale, 0L);
            } else {
                f = this.getFileLocation(dir, simpleName, false);
                spec = new RemoteFile(dir, simpleName, locale, 0L);
            }
            if (f.exists()) {
                spec.setLastModified(f.lastModified());
            }
            if (checkCache) {
                IRemoteFileService svc = (IRemoteFileService)BEANS.get(IRemoteFileService.class);
                spec = svc.getRemoteFile(spec);
                try {
                    if (spec.getName() != null && !spec.getName().equalsIgnoreCase(f.getName())) {
                        if (locale != null && f.getName().length() > spec.getName().length()) {
                            f.delete();
                        }
                        f = this.getFileLocation(spec.getDirectory(), spec.getName(), false);
                    }
                    if (spec.exists() && spec.hasContent()) {
                        language = null;
                        Object var9_11 = null;
                        try (FileOutputStream out = new FileOutputStream(f);){
                            spec.writeData((OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            if (language == null) {
                                language = throwable;
                            } else if (language != throwable) {
                                ((Throwable)language).addSuppressed(throwable);
                            }
                            throw language;
                        }
                        f.setLastModified(spec.getLastModified());
                        break block22;
                    }
                    if (!spec.exists()) {
                        f.delete();
                    }
                }
                catch (IOException e) {
                    throw new ProcessingException("error writing remote file in local store", new Object[]{e});
                }
            }
        }
        return f;
    }

    private String[][] getFiles(String folderBase, FilenameFilter filter, boolean useServerFolderStructureOnClient) {
        File path = this.getFileLocation(useServerFolderStructureOnClient ? folderBase : "", null, false);
        String[] dirs = path.list(filter);
        if (dirs == null || dirs.length < 1) {
            return new String[0][];
        }
        ArrayList<String> dirList = new ArrayList<String>();
        ArrayList<String> fileList = new ArrayList<String>();
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            try {
                File file = new File(path.getCanonicalPath() + "/" + dir);
                if (file.isDirectory()) {
                    String[][] tmp;
                    String[][] stringArray2 = tmp = this.getFiles((String)(folderBase == null ? dir : folderBase + "/" + dir), filter, true);
                    int n3 = tmp.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] f = stringArray2[n4];
                        dirList.add(f[0]);
                        fileList.add(f[1]);
                        ++n4;
                    }
                } else {
                    dirList.add(folderBase);
                    fileList.add(dir);
                }
            }
            catch (IOException e) {
                throw new ProcessingException("FileService.getFiles:", new Object[]{e});
            }
            ++n2;
        }
        String[][] retVal = new String[dirList.size()][2];
        int i = 0;
        while (i < dirList.size()) {
            retVal[i][0] = (String)dirList.get(i);
            retVal[i][1] = (String)fileList.get(i);
            ++i;
        }
        return retVal;
    }

    @Override
    public void syncRemoteFilesToPath(String clientFolderPath, String serverFolderPath, FilenameFilter filter) {
        this.setDirectPath(clientFolderPath);
        this.syncRemoteFilesInternal(serverFolderPath, filter, false);
        this.setDirectPath(null);
    }

    @Override
    public void syncRemoteFiles(String serverFolderPath, FilenameFilter filter) {
        this.syncRemoteFilesInternal(serverFolderPath, filter, true);
    }

    private void syncRemoteFilesInternal(String serverFolderPath, FilenameFilter filter, boolean useServerFolderStructureOnClient) {
        IRemoteFileService svc = (IRemoteFileService)BEANS.get(IRemoteFileService.class);
        String[][] realFiles = this.getFiles(serverFolderPath, filter, useServerFolderStructureOnClient);
        RemoteFile[] existingFileInfoOnClient = new RemoteFile[realFiles.length];
        int i = 0;
        while (i < realFiles.length) {
            RemoteFile rf = new RemoteFile(realFiles[i][0], realFiles[i][1], 0L);
            String dir = this.m_rootPath == null ? realFiles[i][0] : "";
            File f = this.getFileLocation(dir, realFiles[i][1], false);
            if (f.exists()) {
                rf.setLastModified(f.lastModified());
            }
            existingFileInfoOnClient[i] = rf;
            ++i;
        }
        RemoteFile[] remoteFileArray = existingFileInfoOnClient = svc.getRemoteFiles(serverFolderPath, filter, existingFileInfoOnClient);
        int n = existingFileInfoOnClient.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteFile spec = remoteFileArray[n2];
            String fileDirectory = useServerFolderStructureOnClient ? spec.getDirectory() : null;
            File f = this.getFileLocation(fileDirectory, spec.getName(), false);
            if (spec.exists() && spec.hasContent()) {
                try {
                    if (spec.hasMoreParts()) {
                        FileOutputStream out;
                        Object var19_31;
                        int counter = 0;
                        long fileDate = spec.getLastModified();
                        File part = this.getFileLocation(fileDirectory, spec.getName() + "." + counter, false);
                        Throwable throwable = null;
                        Throwable throwable2 = null;
                        try (FileOutputStream out2 = new FileOutputStream(part);){
                            spec.writeData((OutputStream)out2);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        part.setLastModified(fileDate);
                        RemoteFile specPart = spec;
                        while (specPart.hasMoreParts()) {
                            part = this.getFileLocation(fileDirectory, spec.getName() + "." + ++counter, false);
                            if (part.exists() && fileDate == part.lastModified()) continue;
                            specPart = svc.getRemoteFilePart(spec, (long)counter);
                            throwable2 = null;
                            var19_31 = null;
                            try {
                                out = new FileOutputStream(part);
                                try {
                                    specPart.writeData((OutputStream)out);
                                }
                                finally {
                                    if (out != null) {
                                        ((OutputStream)out).close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                            part.setLastModified(fileDate);
                        }
                        counter = 0;
                        f = this.getFileLocation(fileDirectory, spec.getName(), false);
                        throwable2 = null;
                        var19_31 = null;
                        try {
                            out = new FileOutputStream(f);
                            try {
                                part = this.getFileLocation(fileDirectory, spec.getName() + "." + counter, false);
                                while (part.exists()) {
                                    Throwable throwable5 = null;
                                    Object var22_37 = null;
                                    try (FileInputStream in = new FileInputStream(part);){
                                        int len;
                                        byte[] buf = new byte[102400];
                                        while ((len = ((InputStream)in).read(buf)) > 0) {
                                            ((OutputStream)out).write(buf, 0, len);
                                        }
                                        out.flush();
                                    }
                                    catch (Throwable throwable6) {
                                        if (throwable5 == null) {
                                            throwable5 = throwable6;
                                        } else if (throwable5 != throwable6) {
                                            throwable5.addSuppressed(throwable6);
                                        }
                                        throw throwable5;
                                    }
                                    part.delete();
                                    part = this.getFileLocation(fileDirectory, spec.getName() + "." + ++counter, false);
                                }
                            }
                            finally {
                                if (out != null) {
                                    ((OutputStream)out).close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable2 == null) {
                                throwable2 = throwable7;
                            } else if (throwable2 != throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            throw throwable2;
                        }
                        f.setLastModified(fileDate);
                    }
                    Throwable counter = null;
                    Object var14_21 = null;
                    try (FileOutputStream out = new FileOutputStream(f);){
                        spec.writeData((OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        if (counter == null) {
                            counter = throwable;
                        } else if (counter != throwable) {
                            counter.addSuppressed(throwable);
                        }
                        throw counter;
                    }
                    f.setLastModified(spec.getLastModified());
                }
                catch (IOException e) {
                    throw new ProcessingException("error writing remote file in local store", new Object[]{e});
                }
            } else if (!spec.exists()) {
                f.delete();
            }
            ++n2;
        }
    }

    @Override
    public File getLocalFileLocation(String dir, String name) {
        return this.getFileLocation(dir, name, true);
    }

    @Override
    public File getRemoteFileLocation(String dir, String name) {
        return this.getFileLocation(dir, name, false);
    }

    private File getFileLocation(String dir, String name, boolean local) {
        File file;
        Object path = this.m_rootPath;
        if (path == null) {
            path = System.getProperty("java.io.tmpdir");
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            path = local ? (String)path + "local" : (String)path + "remote";
        }
        if (dir != null) {
            if (!(dir = dir.replace("\\", "/")).startsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + dir;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (!(file = new File((String)path)).exists()) {
            file.mkdirs();
        }
        if (name != null) {
            file = new File((String)path + name);
        }
        return file;
    }

    private void setDirectPath(String rootPath) {
        this.m_rootPath = rootPath;
    }
}

