/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.exceptionhandler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.exception.IProcessingStatus;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.RemoteSystemUnavailableException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.concurrent.AbstractInterruptionError;

@Bean
public class ErrorPopup {
    private final AtomicBoolean m_parsed = new AtomicBoolean();
    protected String m_header;
    protected String m_body;
    protected IHtmlContent m_html;
    protected String m_yesButtonText;
    protected String m_noButtonText;
    protected boolean m_reloadOnYesClick;
    protected Throwable m_parsedError;
    protected IStatus m_status;

    public void showMessageBox(Throwable error) {
        this.ensureErrorParsed(error);
        int result = MessageBoxes.create().withHeader(this.m_header).withBody(this.m_body).withHtml(this.m_html).withYesButtonText(this.m_yesButtonText).withNoButtonText(this.m_noButtonText).withSeverity(this.m_status.getSeverity()).withIconId(this.computeIconId()).show();
        if (this.m_reloadOnYesClick && result == 0) {
            ClientSessionProvider.currentSession().getDesktop().reloadGui();
        }
    }

    protected String computeIconId() {
        if (this.m_parsedError instanceof VetoException) {
            return null;
        }
        if (this.m_status != null && this.m_status.getSeverity() == 0x1000000) {
            return "font:\ue044";
        }
        return null;
    }

    protected void ensureErrorParsed(Throwable error) {
        if (!this.m_parsed.compareAndSet(false, true)) {
            return;
        }
        this.m_parsedError = this.unwrapException(error);
        this.m_header = TEXTS.get((String)"Error");
        this.m_body = TEXTS.get((String)"ErrorAndRetryTextDefault");
        this.m_html = HTML.div((CharSequence[])new CharSequence[]{StringUtility.box((String)(TEXTS.get((String)"CorrelationId") + ": "), (String)((String)CorrelationId.CURRENT.get()), (String)"")}).cssClass((CharSequence)"error-popup-correlation-id");
        this.m_yesButtonText = TEXTS.get((String)"Ok");
        this.m_noButtonText = null;
        this.m_reloadOnYesClick = false;
        this.m_status = new Status(0x1000000);
        Throwable t = this.m_parsedError;
        Throwable rootCause = this.m_parsedError;
        while (t != null) {
            if (this.parseError(t)) {
                this.extractStatus(t);
                this.m_parsedError = t;
                return;
            }
            rootCause = t;
            t = t.getCause();
        }
        this.parseUnexpectedProblem(rootCause);
    }

    protected Throwable getParsedError() {
        return this.m_parsedError;
    }

    protected Throwable unwrapException(Throwable t) {
        if (this.isWrapperException(t)) {
            return t.getCause();
        }
        return t;
    }

    protected boolean isWrapperException(Throwable t) {
        return t instanceof UndeclaredThrowableException || t instanceof InvocationTargetException || t instanceof ExecutionException;
    }

    protected void extractStatus(Throwable t) {
        IProcessingStatus status;
        if (t instanceof ProcessingException && (status = ((ProcessingException)t).getStatus()) != null) {
            this.m_status = status;
        }
    }

    protected boolean parseError(Throwable t) {
        if (t instanceof VetoException) {
            this.parseVetoException((VetoException)t);
            return true;
        }
        if (this.isNetError(t)) {
            this.parseNetError(t);
            return true;
        }
        if (t instanceof AbstractInterruptionError || t instanceof InterruptedException || t instanceof TimeoutException || t instanceof CancellationException) {
            this.parseInterruptedError(t);
            return true;
        }
        return false;
    }

    protected boolean isNetError(Throwable t) {
        return t instanceof RemoteSystemUnavailableException || t instanceof SocketException || t instanceof UnknownHostException;
    }

    protected void parseVetoException(VetoException ve) {
        this.m_header = ve.getStatus().getTitle();
        if (ve.getHtmlMessage() != null) {
            this.m_body = null;
            this.m_html = ve.getHtmlMessage();
        } else if (ve.getStatus().getBody() != null) {
            this.m_body = ve.getStatus().getBody();
            this.m_html = null;
        }
    }

    protected void parseNetError(Throwable t) {
        this.m_header = TEXTS.get((String)"NetErrorTitle");
        this.m_body = TEXTS.get((String)"NetSystemsNotAvailable") + "\n\n" + TEXTS.get((String)"PleaseTryAgainLater");
    }

    protected void parseInterruptedError(Throwable t) {
        this.m_header = TEXTS.get((String)"InterruptedErrorTitle");
        this.m_body = TEXTS.get((String)"InterruptedErrorText");
        this.m_html = null;
        this.m_status = new Status(256);
    }

    protected void parseUnexpectedProblem(Throwable error) {
        Object errorCode = null;
        if (error != null) {
            this.extractStatus(error);
            if (this.m_status.getCode() > 0) {
                errorCode = String.valueOf(this.m_status.getCode());
            } else {
                String s = error.getClass().getSimpleName();
                errorCode = "" + s.charAt(0) + s.length();
            }
        }
        this.m_header = TEXTS.get((String)"UnexpectedProblem");
        this.m_body = StringUtility.join((String)"\n\n", (Object[])new Object[]{TEXTS.get((String)"InternalProcessingErrorMsg", (String[])new String[]{errorCode == null ? "" : " (" + TEXTS.get((String)"ErrorCodeX", (String[])new String[]{errorCode}) + ")"}), TEXTS.get((String)"UiInconsistentMsg")});
        this.m_yesButtonText = TEXTS.get((String)"Reload");
        if (Platform.get().inDevelopmentMode()) {
            this.m_noButtonText = TEXTS.get((String)"Ignore");
        }
        this.m_reloadOnYesClick = true;
    }
}

