/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.bookmark;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceEvent;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.ActivateBookmarkKeyStroke;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkData;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkService
implements IBookmarkService {
    private static final Logger LOG = LoggerFactory.getLogger(BookmarkService.class);
    private static final String SESSION_DATA_KEY = "bookmarkServiceState";

    private ServiceState getServiceState() {
        IClientSession session = ClientSessionProvider.currentSession();
        if (session == null) {
            throw new IllegalStateException("null client session in current job context");
        }
        ServiceState data = (ServiceState)session.getData(SESSION_DATA_KEY);
        if (data == null) {
            data = new ServiceState();
            data.m_model = new BookmarkData();
            session.setData(SESSION_DATA_KEY, data);
        }
        return data;
    }

    @PostConstruct
    public void addBookmarkServiceListener() {
        this.addBookmarkServiceListener(this::handleBookmarksChangedInternal);
    }

    protected void handleBookmarksChangedInternal(BookmarkServiceEvent e) {
        switch (e.getType()) {
            case 10: {
                final ArrayList list = new ArrayList();
                IBookmarkVisitor visitor = new IBookmarkVisitor(){

                    public boolean visitFolder(List<BookmarkFolder> path) {
                        return true;
                    }

                    public boolean visitBookmark(List<BookmarkFolder> path, Bookmark b) {
                        if (b.getKeyStroke() != null) {
                            list.add(b);
                        }
                        return true;
                    }
                };
                this.getBookmarkData().getUserBookmarks().visit(visitor);
                this.getBookmarkData().getGlobalBookmarks().visit(visitor);
                IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
                if (desktop == null) break;
                ArrayList<IKeyStroke> newKeyStrokes = new ArrayList<IKeyStroke>();
                for (IKeyStroke k : desktop.getKeyStrokes()) {
                    if (k instanceof ActivateBookmarkKeyStroke) continue;
                    newKeyStrokes.add(k);
                }
                for (Bookmark b : list) {
                    newKeyStrokes.add(new ActivateBookmarkKeyStroke(b));
                }
                desktop.setKeyStrokes(newKeyStrokes);
            }
        }
    }

    @Override
    public void loadBookmarks() {
        IBookmarkStorageService storageService = (IBookmarkStorageService)BEANS.get(IBookmarkStorageService.class);
        this.importBookmarks(storageService.getBookmarkData());
    }

    @Override
    public void storeBookmarks() {
        ServiceState state = this.getServiceState();
        IBookmarkStorageService storageService = (IBookmarkStorageService)BEANS.get(IBookmarkStorageService.class);
        this.importBookmarks(storageService.storeBookmarkData(state.m_model));
    }

    @Override
    public void setStartBookmark() {
        ServiceState state = this.getServiceState();
        Bookmark b = ClientSessionProvider.currentSession().getDesktop().createBookmark();
        if (b != null) {
            b.setKind(1);
            state.m_model.getUserBookmarks().setStartupBookmark(b);
        }
    }

    @Override
    public void deleteStartBookmark() {
        ServiceState state = this.getServiceState();
        state.m_model.getUserBookmarks().setStartupBookmark(null);
    }

    @Override
    public Bookmark getStartBookmark() {
        ServiceState state = this.getServiceState();
        Bookmark b = state.m_model.getUserBookmarks().getStartupBookmark();
        if (b == null) {
            b = state.m_model.getGlobalBookmarks().getStartupBookmark();
        }
        return b;
    }

    @Override
    public final BookmarkData getBookmarkData() {
        ServiceState state = this.getServiceState();
        return state.m_model;
    }

    @Override
    public void activate(Bookmark b) {
        if (b != null) {
            try {
                ClientSessionProvider.currentSession().getDesktop().activateBookmark(b);
            }
            catch (Exception t) {
                LOG.error("Could not activate bookmark", (Throwable)t);
            }
        }
    }

    @Override
    public void updateBookmark(Bookmark bm) {
        Bookmark newBookmark = ClientSessionProvider.currentSession().getDesktop().createBookmark();
        int cachedKind = bm.getKind();
        String cachedIconId = bm.getIconId();
        String cachedTitle = bm.getTitle();
        String cachedKeyStroke = bm.getKeyStroke();
        double cachedOrder = bm.getOrder();
        bm.setSerializedData(newBookmark.getSerializedData());
        bm.setKind(cachedKind);
        bm.setIconId(cachedIconId);
        bm.setTitle(cachedTitle);
        bm.setKeyStroke(cachedKeyStroke);
        bm.setOrder(cachedOrder);
    }

    @Override
    public IFastListenerList<BookmarkServiceListener> bookmarkServiceListeners() {
        return this.getServiceState().m_listenerList;
    }

    private void fireBookmarksChanged() {
        BookmarkServiceEvent e = new BookmarkServiceEvent(this, 10);
        this.fireBookmarkSeviceEvent(e);
    }

    private void fireBookmarkSeviceEvent(BookmarkServiceEvent e) {
        this.bookmarkServiceListeners().list().forEach(listener -> listener.bookmarksChanged(e));
    }

    private void importBookmarks(BookmarkData model) {
        ServiceState state = this.getServiceState();
        state.m_model.setUserBookmarks(model.getUserBookmarks());
        state.m_model.setGlobalBookmarks(model.getGlobalBookmarks());
        this.fireBookmarksChanged();
    }

    private static class ServiceState {
        FastListenerList<BookmarkServiceListener> m_listenerList = new FastListenerList();
        BookmarkData m_model;

        private ServiceState() {
        }
    }
}

