/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.opentelemetry;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.basic.table.AbstractTableExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.table.TableChains;
import org.eclipse.scout.rt.client.opentelemetry.OpenTelemetryExtensionInstrumenterFactory;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.platform.BEANS;

public class OpenTelemetryTableExtension
extends AbstractTableExtension<AbstractTable> {
    private Instrumenter<OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractTable>, Void> m_instrumenter = ((OpenTelemetryExtensionInstrumenterFactory)BEANS.get(OpenTelemetryExtensionInstrumenterFactory.class)).createInstrumenter(this.getClass(), request -> ((AbstractTable)request.getOwner()).getTitle());
    private static final AttributeKey<String> ROWS_COUNT = AttributeKey.stringKey((String)"scout.extension.rows.count");
    private static final AttributeKey<String> ROWS_INDEX = AttributeKey.stringKey((String)"scout.extension.rows.index");
    private static final AttributeKey<String> MOUSE_BUTTON_NAME = AttributeKey.stringKey((String)"scout.extension.mouse.button.name");

    public OpenTelemetryTableExtension(AbstractTable owner) {
        super(owner);
    }

    @Override
    public void execRowsSelected(TableChains.TableRowsSelectedChain chain, List<? extends ITableRow> rows) {
        new OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractTable>((AbstractTable)this.getOwner(), "execRowsSelected").withAdditionalAttributesProvider(attributes -> {
            AttributesBuilder attributesBuilder = attributes.put(ROWS_COUNT, (Object)String.valueOf(rows.size()));
        }).wrapCall(() -> super.execRowsSelected(chain, rows), this.m_instrumenter);
    }

    @Override
    public void execRowClick(TableChains.TableRowClickChain chain, ITableRow row, MouseButton mouseButton) {
        new OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractTable>((AbstractTable)this.getOwner(), "execRowClick").withAdditionalAttributesProvider(attributes -> {
            attributes.put(MOUSE_BUTTON_NAME, (Object)mouseButton.name());
            attributes.put(ROWS_INDEX, (Object)String.valueOf(row.getRowIndex()));
        }).wrapCall(() -> super.execRowClick(chain, row, mouseButton), this.m_instrumenter);
    }
}

