/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.opentelemetry.OpenTelemetryProperties;

@ApplicationScoped
public class OpenTelemetryExtensionInstrumenterFactory {
    public <OWNER> Instrumenter<OpenTelemetryExtensionRequest<OWNER>, Void> createInstrumenter(Class<?> instrumentationClass, Function<OpenTelemetryExtensionRequest<OWNER>, String> getTextFunction) {
        SpanNameExtractor spanNameExtractor = request -> request.getOwner().getClass().getSimpleName() + "." + request.getEventName();
        ScoutExtensionAttributesExtractor attributesExtractor = new ScoutExtensionAttributesExtractor(getTextFunction);
        return Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)("scout." + instrumentationClass.getSimpleName()), (SpanNameExtractor)spanNameExtractor).addAttributesExtractor(attributesExtractor).setEnabled(((Boolean)CONFIG.getPropertyValue(OpenTelemetryProperties.OpenTelemetryTracingEnabledProperty.class)).booleanValue()).buildInstrumenter();
    }

    public static class OpenTelemetryExtensionRequest<T> {
        private T m_owner;
        private String m_eventName;
        private Consumer<AttributesBuilder> m_additionalAttributesProvider;

        public OpenTelemetryExtensionRequest(T owner, String eventName) {
            this.m_owner = owner;
            this.m_eventName = eventName;
            this.m_additionalAttributesProvider = attributes -> {};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpenTelemetryExtensionRequest that = (OpenTelemetryExtensionRequest)o;
            return Objects.equals(this.m_owner, that.m_owner) && Objects.equals(this.m_eventName, that.m_eventName);
        }

        public int hashCode() {
            return Objects.hash(this.m_owner, this.m_eventName);
        }

        public T getOwner() {
            return this.m_owner;
        }

        public String getEventName() {
            return this.m_eventName;
        }

        public Consumer<AttributesBuilder> getAdditionalAttributesProvider() {
            return this.m_additionalAttributesProvider;
        }

        public OpenTelemetryExtensionRequest<T> withAdditionalAttributesProvider(Consumer<AttributesBuilder> additionalAttributesProvider) {
            this.m_additionalAttributesProvider = additionalAttributesProvider;
            return this;
        }

        public <R> R wrapCall(Supplier<R> callable, Instrumenter<OpenTelemetryExtensionRequest<T>, Void> m_instrumenter) {
            R result;
            Context parentContext = Context.current();
            if (!m_instrumenter.shouldStart(parentContext, (Object)this)) {
                return callable.get();
            }
            Context context = m_instrumenter.start(parentContext, (Object)this);
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (Scope ignored = context.makeCurrent();){
                    result = callable.get();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                m_instrumenter.end(context, (Object)this, null, t);
                throw t;
            }
            m_instrumenter.end(context, (Object)this, null, null);
            return result;
        }

        public void wrapCall(Runnable callable, Instrumenter<OpenTelemetryExtensionRequest<T>, Void> m_instrumenter) {
            Context parentContext = Context.current();
            if (!m_instrumenter.shouldStart(parentContext, (Object)this)) {
                callable.run();
                return;
            }
            Context context = m_instrumenter.start(parentContext, (Object)this);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Scope ignored = context.makeCurrent();){
                    callable.run();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                m_instrumenter.end(context, (Object)this, null, t);
                throw t;
            }
            m_instrumenter.end(context, (Object)this, null, null);
        }
    }

    public static class ScoutExtensionAttributesExtractor<T>
    implements AttributesExtractor<OpenTelemetryExtensionRequest<T>, Void> {
        private static final AttributeKey<String> OWNER_CLASS = AttributeKey.stringKey((String)"scout.extension.owner.class");
        private static final AttributeKey<String> OWNER_DISPLAY_TEXT = AttributeKey.stringKey((String)"scout.extension.owner.display_text");
        private final Function<OpenTelemetryExtensionRequest<T>, String> m_getTextFunction;

        public ScoutExtensionAttributesExtractor(Function<OpenTelemetryExtensionRequest<T>, String> getTextFunction) {
            this.m_getTextFunction = getTextFunction;
        }

        public void onStart(AttributesBuilder attributes, Context parentContext, OpenTelemetryExtensionRequest<T> request) {
            attributes.put(OWNER_CLASS, (Object)request.getOwner().getClass().getName());
            attributes.put(OWNER_DISPLAY_TEXT, (Object)this.m_getTextFunction.apply(request));
            request.getAdditionalAttributesProvider().accept(attributes);
        }

        public void onEnd(AttributesBuilder attributes, Context context, OpenTelemetryExtensionRequest<T> request, @Nullable Void unused, @Nullable Throwable error) {
        }
    }
}

