/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.opentelemetry;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.Date;
import java.util.Set;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.provider.AbstractCalendarItemProviderExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.provider.CalendarItemProviderChains;
import org.eclipse.scout.rt.client.opentelemetry.OpenTelemetryExtensionInstrumenterFactory;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.AbstractCalendarItemProvider;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;

public class OpenTelemetryCalendarItemProviderExtension
extends AbstractCalendarItemProviderExtension<AbstractCalendarItemProvider> {
    private Instrumenter<OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractCalendarItemProvider>, Void> m_instrumenter = ((OpenTelemetryExtensionInstrumenterFactory)BEANS.get(OpenTelemetryExtensionInstrumenterFactory.class)).createInstrumenter(this.getClass(), request -> "");
    private static final AttributeKey<String> MIN_DATE = AttributeKey.stringKey((String)"scout.extension.min.date");
    private static final AttributeKey<String> MAX_DATE = AttributeKey.stringKey((String)"scout.extension.max.date");
    private static final AttributeKey<String> ITEM_TEXT = AttributeKey.stringKey((String)"scout.extension.item.text");

    public OpenTelemetryCalendarItemProviderExtension(AbstractCalendarItemProvider owner) {
        super(owner);
    }

    @Override
    public void execLoadItems(CalendarItemProviderChains.CalendarItemProviderLoadItemsChain chain, Date minDate, Date maxDate, Set<ICalendarItem> result) {
        new OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractCalendarItemProvider>((AbstractCalendarItemProvider)this.getOwner(), "execLoadItems").withAdditionalAttributesProvider(attributes -> {
            attributes.put(MIN_DATE, (Object)minDate.toString());
            attributes.put(MAX_DATE, (Object)maxDate.toString());
        }).wrapCall(() -> super.execLoadItems(chain, minDate, maxDate, result), this.m_instrumenter);
    }

    @Override
    public void execLoadItemsInBackground(CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain chain, IClientSession session, Date minDate, Date maxDate, Set<ICalendarItem> result) {
        new OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractCalendarItemProvider>((AbstractCalendarItemProvider)this.getOwner(), "execLoadItemsInBackground").withAdditionalAttributesProvider(attributes -> {
            attributes.put(MIN_DATE, (Object)minDate.toString());
            attributes.put(MAX_DATE, (Object)maxDate.toString());
        }).wrapCall(() -> super.execLoadItemsInBackground(chain, session, minDate, maxDate, result), this.m_instrumenter);
    }

    @Override
    public void execItemAction(CalendarItemProviderChains.CalendarItemProviderItemActionChain chain, ICalendarItem item) {
        String itemText = item.getItemId() == null ? "" : item.getItemId().toString();
        new OpenTelemetryExtensionInstrumenterFactory.OpenTelemetryExtensionRequest<AbstractCalendarItemProvider>((AbstractCalendarItemProvider)this.getOwner(), "execItemAction").withAdditionalAttributesProvider(attributes -> {
            AttributesBuilder attributesBuilder = attributes.put(ITEM_TEXT, (Object)itemText);
        }).wrapCall(() -> super.execItemAction(chain, item), this.m_instrumenter);
    }
}

