/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.extension.ui.basic.tree;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeExtension;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionChain;

public final class TreeChains {
    private TreeChains() {
    }

    protected static abstract class AbstractTreeChain
    extends AbstractExtensionChain<ITreeExtension<? extends AbstractTree>> {
        public AbstractTreeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions, ITreeExtension.class);
        }
    }

    public static class TreeDecorateCellChain
    extends AbstractTreeChain {
        public TreeDecorateCellChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDecorateCell(final ITreeNode node, final Cell cell) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execDecorateCell(this, node, cell);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeDisposeTreeChain
    extends AbstractTreeChain {
        public TreeDisposeTreeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDisposeTree() {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execDisposeTree(this);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeDragNodeChain
    extends AbstractTreeChain {
        public TreeDragNodeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public TransferObject execDrag(final ITreeNode node) {
            AbstractExtensionChain.MethodInvocation<TransferObject> methodInvocation = new AbstractExtensionChain.MethodInvocation<TransferObject>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    this.setReturnValue(next.execDrag(this, node));
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
            return (TransferObject)methodInvocation.getReturnValue();
        }
    }

    public static class TreeDragNodesChain
    extends AbstractTreeChain {
        public TreeDragNodesChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public TransferObject execDrag(final Collection<ITreeNode> nodes) {
            AbstractExtensionChain.MethodInvocation<TransferObject> methodInvocation = new AbstractExtensionChain.MethodInvocation<TransferObject>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    this.setReturnValue(next.execDrag(this, nodes));
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
            return (TransferObject)methodInvocation.getReturnValue();
        }
    }

    public static class TreeDropChain
    extends AbstractTreeChain {
        public TreeDropChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDrop(final ITreeNode node, final TransferObject t) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execDrop(this, node, t);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeDropTargetChangedChain
    extends AbstractTreeChain {
        public TreeDropTargetChangedChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDropTargetChanged(final ITreeNode node) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execDropTargetChanged(this, node);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeHyperlinkActionChain
    extends AbstractTreeChain {
        public TreeHyperlinkActionChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execHyperlinkAction(final String ref) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execAppLinkAction(this, ref);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeInitTreeChain
    extends AbstractTreeChain {
        public TreeInitTreeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execInitTree() {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execInitTree(this);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeNodeActionChain
    extends AbstractTreeChain {
        public TreeNodeActionChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodeAction(final ITreeNode node) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execNodeAction(this, node);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeNodeClickChain
    extends AbstractTreeChain {
        public TreeNodeClickChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodeClick(final ITreeNode node, final MouseButton mouseButton) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execNodeClick(this, node, mouseButton);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeNodesCheckedChain
    extends AbstractTreeChain {
        public TreeNodesCheckedChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodesChecked(final List<ITreeNode> nodes) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execNodesChecked(this, nodes);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class TreeNodesSelectedChain
    extends AbstractTreeChain {
        public TreeNodesSelectedChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodesSelected(final TreeEvent e) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) {
                    next.execNodesSelected(this, e);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }
}

