/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.extension.ui.basic.planner;

import java.util.Date;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.basic.planner.IPlannerExtension;
import org.eclipse.scout.rt.client.ui.basic.planner.AbstractPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionChain;

public final class PlannerChains {
    private PlannerChains() {
    }

    protected static abstract class AbstractPlannerChain<RI, AI>
    extends AbstractExtensionChain<IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> {
        public AbstractPlannerChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions, IPlannerExtension.class);
        }
    }

    public static class PlannerActivitySelectedChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerActivitySelectedChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execActivitySelected(final Activity<RI, AI> cell) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execActivitySelected(this, cell);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerDecorateActivityChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerDecorateActivityChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execDecorateActivity(final Activity<RI, AI> cell) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execDecorateActivityCell(this, cell);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerDisplayModeChangedChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerDisplayModeChangedChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execDisplayModeChanged(final int displayMode) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execDisplayModeChanged(this, displayMode);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerDisposePlannerChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerDisposePlannerChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execDisposePlanner() {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execDisposePlanner(this);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerInitPlannerChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerInitPlannerChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execInitPlanner() {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execInitPlanner(this);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerResourcesSelectedChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerResourcesSelectedChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execResourcesSelected(final List<Resource<RI>> resources) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execResourcesSelected(this, resources);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerSelectionRangeChangedChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerSelectionRangeChangedChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execSelectionRangeChanged(final Range<Date> selectionRange) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execSelectionRangeChanged(this, (Range<Date>)selectionRange);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }

    public static class PlannerViewRangeChangedChain<RI, AI>
    extends AbstractPlannerChain<RI, AI> {
        public PlannerViewRangeChangedChain(List<? extends IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>>> extensions) {
            super(extensions);
        }

        public void execViewRangeChanged(final Range<Date> viewRange) {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(IPlannerExtension<RI, AI, ? extends AbstractPlanner<RI, AI>> next) {
                    next.execViewRangeChanged(this, (Range<Date>)viewRange);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation);
        }
    }
}

