/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.deeplink;

import java.util.regex.Matcher;
import org.eclipse.scout.rt.client.deeplink.AbstractDeepLinkHandler;
import org.eclipse.scout.rt.client.deeplink.DeepLinkException;
import org.eclipse.scout.rt.client.deeplink.DeepLinkUriBuilder;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.BrowserHistoryEntry;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.StringUtility;

@Order(value=1000.0)
public class OutlineDeepLinkHandler
extends AbstractDeepLinkHandler {
    private static final String HANDLER_NAME = "outline";

    public OutlineDeepLinkHandler() {
        super(OutlineDeepLinkHandler.defaultPattern(HANDLER_NAME, "\\d+"));
    }

    @Override
    public void handleImpl(Matcher matcher) throws DeepLinkException {
        String outlineId = matcher.group(1);
        IOutline selectedOutline = null;
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        for (IOutline outline : desktop.getAvailableOutlines()) {
            String tmpOutlineId = this.outlineId(outline);
            if (!tmpOutlineId.equals(outlineId)) continue;
            selectedOutline = outline;
            break;
        }
        if (selectedOutline == null) {
            throw new DeepLinkException("No outline with ID " + outlineId + " found");
        }
        if (!selectedOutline.isVisible() || !selectedOutline.isEnabled()) {
            throw new DeepLinkException("Outline ID " + outlineId + " is not enabled or visible");
        }
        desktop.activateOutline(selectedOutline);
    }

    public BrowserHistoryEntry createBrowserHistoryEntry(IOutline outline, boolean startup) {
        return DeepLinkUriBuilder.createRelative().parameterPath(this.toDeepLinkPath(this.outlineId(outline))).parameterInfo(outline.getTitle()).pathVisible(!startup).createBrowserHistoryEntry();
    }

    protected String outlineId(IOutline outline) {
        int nameChecksum = OutlineDeepLinkHandler.fletcher16(outline);
        nameChecksum = Math.abs(nameChecksum);
        return StringUtility.lpad((String)String.valueOf(nameChecksum), (String)"0", (int)5);
    }

    protected static short fletcher16(IOutline outline) {
        int sum1 = 0;
        int sum2 = 0;
        int modulus = 255;
        String data = outline.getClass().getName();
        int i = 0;
        while (i < data.length()) {
            sum1 = (short)((sum1 + data.charAt(i)) % modulus);
            sum2 = (short)((sum2 + sum1) % modulus);
            ++i;
        }
        return (short)(sum2 << 8 | sum1);
    }

    @Override
    public String getName() {
        return HANDLER_NAME;
    }
}

