/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.context;

import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class ClientRunContexts {
    private ClientRunContexts() {
    }

    public static ClientRunContext empty() {
        return ((ClientRunContextFactory)((Object)BEANS.get(ClientRunContextFactory.class))).empty();
    }

    public static ClientRunContext copyCurrent() {
        return ClientRunContexts.copyCurrent(false);
    }

    public static ClientRunContext copyCurrent(boolean orElseEmpty) {
        if (RunContext.CURRENT.get() != null) {
            return ((ClientRunContextFactory)((Object)BEANS.get(ClientRunContextFactory.class))).copyCurrent();
        }
        if (orElseEmpty) {
            return ((ClientRunContextFactory)((Object)BEANS.get(ClientRunContextFactory.class))).empty();
        }
        return (ClientRunContext)((Object)Assertions.fail((String)"Not running in a RunContext. Use '{}.empty()' or {}.copyCurrent(true) instead.", (Object[])new Object[]{ClientRunContexts.class.getSimpleName(), ClientRunContexts.class.getSimpleName()}));
    }

    @Replace
    @Order(value=4900.0)
    public static class ClientRunContextFactory
    extends RunContexts.RunContextFactory {
        public ClientRunContext empty() {
            return (ClientRunContext)super.empty().withProperty((Object)"scout.scope.client", (Object)true);
        }

        public ClientRunContext copyCurrent() {
            return (ClientRunContext)super.copyCurrent().withProperty((Object)"scout.scope.client", (Object)true);
        }

        protected ClientRunContext newInstance() {
            return (ClientRunContext)((Object)BEANS.get(ClientRunContext.class));
        }
    }
}

