/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.clientnotification;

import jakarta.annotation.PostConstruct;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.clientnotification.ClientNotificationDispatcher;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.dataobject.id.IIds;
import org.eclipse.scout.rt.dataobject.id.IRootId;
import org.eclipse.scout.rt.dataobject.id.NodeId;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.job.FixedDelayScheduleBuilder;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ICancellable;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.quartz.ScheduleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@CreateImmediately
public class ClientNotificationPoller {
    private static final Logger LOG = LoggerFactory.getLogger(ClientNotificationPoller.class);
    private final Object m_lock = new Object();
    private IFuture<Void> m_pollerFuture;
    private IFuture<Void> m_livenessFuture;
    private volatile long m_pollerStaleTimeMillis;
    private volatile long m_lastPollRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void start() {
        Object object = this.m_lock;
        synchronized (object) {
            Assertions.assertNull(this.m_pollerFuture);
            if (((IServiceTunnel)BEANS.get(IServiceTunnel.class)).isActive()) {
                this.startPoller();
                this.startLivenessChecker();
            } else {
                LOG.debug("Starting without notifications due to no proxy service is available");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.m_lock;
        synchronized (object) {
            this.stopLivenessChecker();
            this.stopPoller();
        }
    }

    protected void startPoller() {
        this.touch();
        this.m_pollerFuture = Jobs.schedule((IRunnable)new P_NotificationPoller(this::touch), (JobInput)Jobs.newInput().withRunContext(this.createRunContext()).withName(ClientNotificationPoller.class.getSimpleName(), new Object[0]));
    }

    protected void stopPoller() {
        if (this.m_pollerFuture == null) {
            return;
        }
        LOG.debug("Stopping client notification poller [clientNodeId={}].", (Object)IIds.toString((IRootId)NodeId.current()));
        this.m_pollerFuture.cancel(true);
        this.m_pollerFuture = null;
    }

    protected RunContext createRunContext() {
        return ClientRunContexts.empty().withSubject((Subject)((SharedConfigProperties.NotificationSubjectProperty)BEANS.get(SharedConfigProperties.NotificationSubjectProperty.class)).getValue()).withUserAgent(UserAgents.createDefault()).withSession(null, false);
    }

    protected static void handleMessagesReceived(List<ClientNotificationMessage> notifications) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {} notifications ({}) [clientNodeId={}].", new Object[]{notifications.size(), LOG.isTraceEnabled() ? notifications : "use level TRACE to see notifications", IIds.toString((IRootId)NodeId.current())});
        }
        if (!notifications.isEmpty()) {
            ((ClientNotificationDispatcher)BEANS.get(ClientNotificationDispatcher.class)).dispatchNotifications(notifications);
        }
        LOG.debug("Dispatched notifications [clientNodeId={}]", (Object)IIds.toString((IRootId)NodeId.current()));
    }

    protected void startLivenessChecker() {
        if (this.m_livenessFuture != null) {
            return;
        }
        long pollerCheckIntervalMillis = (Long)Assertions.assertNotNull((Object)((Long)CONFIG.getPropertyValue(NotificationPollerLivenessCheckIntervalMillis.class)));
        this.m_pollerStaleTimeMillis = (Long)Assertions.assertNotNull((Object)((Long)CONFIG.getPropertyValue(MaxNotificationPollerStaleTimeMillis.class)));
        this.m_livenessFuture = Jobs.schedule(this::checkPollerLiveness, (JobInput)Jobs.newInput().withRunContext(this.createRunContext()).withName(ClientNotificationPoller.class.getSimpleName() + "-livenessCheck", new Object[0]).withExceptionHandling((ExceptionHandler)BEANS.get(ExceptionHandler.class), true).withExecutionTrigger(Jobs.newExecutionTrigger().withSchedule((ScheduleBuilder)FixedDelayScheduleBuilder.repeatForever((long)pollerCheckIntervalMillis, (TimeUnit)TimeUnit.MILLISECONDS))));
    }

    protected void stopLivenessChecker() {
        if (this.m_livenessFuture == null) {
            return;
        }
        this.m_livenessFuture.cancel(true);
        this.m_livenessFuture = null;
    }

    protected void touch() {
        this.m_lastPollRequest = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPollerLiveness() {
        LOG.debug("Checking client notification poller liveness");
        long lastPollRequest = this.m_lastPollRequest;
        if (lastPollRequest + this.m_pollerStaleTimeMillis < System.currentTimeMillis()) {
            LOG.warn("Detected stale client notification poller. Restarting poller job [lastPollRequest={}]", (Object)DateUtility.format((Date)new Date(lastPollRequest), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
            Object object = this.m_lock;
            synchronized (object) {
                try {
                    this.stopPoller();
                }
                catch (RuntimeException e) {
                    LOG.info("Exception while stopping client notification poller", (Throwable)e);
                }
                try {
                    this.startPoller();
                    LOG.info("Restarted client notification poller");
                }
                catch (RuntimeException e) {
                    LOG.error("Could not start client notification poller", (Throwable)e);
                }
            }
        }
    }

    public static class MaxNotificationPollerStaleTimeMillis
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.SECONDS.toMillis(90L);
        }

        public String description() {
            return "The maximum amount of time in milliseconds between two client notification poller invocations before the poller job is restarted. Note: this value should be at least two times of both 'scout.clientnotification.maxNotificationBlockingTimeOut' and 'scout.clientnotification.notificationPollerCheckInterval'. The default is 90 seconds.";
        }

        public String getKey() {
            return "scout.clientnotification.maxNotificationPollerStaleTime";
        }
    }

    public static class NotificationPollerLivenessCheckIntervalMillis
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.SECONDS.toMillis(30L);
        }

        public String description() {
            return "Interval in milliseconds the poller job liveness check is performed. The default is 30 seconds.";
        }

        public String getKey() {
            return "scout.clientnotification.notificationPollerLivenessCheckInterval";
        }
    }

    private static final class P_NotificationPoller
    implements IRunnable {
        private final Runnable m_livenessCheck;

        public P_NotificationPoller(Runnable livenessCheck) {
            this.m_livenessCheck = livenessCheck;
        }

        public void run() {
            RunMonitor outerRunMonitor = (RunMonitor)RunMonitor.CURRENT.get();
            while (!outerRunMonitor.isCancelled()) {
                this.m_livenessCheck.run();
                try {
                    RunMonitor tempRunMonitor = (RunMonitor)BEANS.get(RunMonitor.class);
                    RunContexts.copyCurrent().withRunMonitor(tempRunMonitor).withParentRunMonitor(outerRunMonitor).run(() -> {
                        try {
                            LOG.debug("Getting notifications from backend [clientNodeId={}]", (Object)IIds.toString((IRootId)NodeId.current()));
                            ClientNotificationPoller.handleMessagesReceived(((IClientNotificationService)BEANS.get(IClientNotificationService.class)).getNotifications(NodeId.current()));
                        }
                        finally {
                            outerRunMonitor.unregisterCancellable((ICancellable)tempRunMonitor);
                        }
                    });
                }
                catch (FutureCancelledError | ThreadInterruptedError e) {
                    LOG.debug("Client notification polling has been interrupted. [clientNodeId={}]", (Object)IIds.toString((IRootId)NodeId.current()), (Object)e);
                }
                catch (RuntimeException e) {
                    if (!(e instanceof PlatformException) || !((PlatformException)e).isConsumed()) {
                        LOG.error("Error receiving client notifications [clientNodeId={}]", (Object)IIds.toString((IRootId)NodeId.current()), (Object)e);
                    }
                    SleepUtil.sleepSafe((long)10L, (TimeUnit)TimeUnit.SECONDS);
                }
            }
            LOG.debug("Client notification polling has ended because the job was cancelled. [clientNodeId={}]", (Object)IIds.toString((IRootId)NodeId.current()));
        }
    }

    @Order(value=-1000.0)
    public static final class ShutdownListener
    implements IPlatformListener {
        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.PlatformStopping) {
                ClientNotificationPoller poller = (ClientNotificationPoller)BEANS.get(ClientNotificationPoller.class);
                poller.stop();
                poller.createRunContext().run(() -> BEANS.optional(IClientNotificationService.class).ifPresent(svc -> svc.unregisterNode(NodeId.current())));
            }
        }
    }
}

