/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.clientnotification;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.clientnotification.IClientSessionRegistry;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.job.DoneEvent;
import org.eclipse.scout.rt.platform.job.IDoneHandler;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;
import org.eclipse.scout.rt.shared.notification.NotificationHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ClientNotificationDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ClientNotificationDispatcher.class);
    private final Set<IFuture<Void>> m_notificationFutures = new HashSet<IFuture<Void>>();

    public void dispatchNotifications(List<ClientNotificationMessage> notifications) {
        if (notifications == null) {
            LOG.warn("Notifications are null. Please check your configuration.");
            return;
        }
        IClientSessionRegistry notificationService = (IClientSessionRegistry)BEANS.get(IClientSessionRegistry.class);
        for (ClientNotificationMessage message : notifications) {
            RunContexts.copyCurrent().withCorrelationId(message.getCorrelationId()).run(() -> this.dispatchNotification(message, notificationService));
        }
    }

    protected void dispatchNotification(ClientNotificationMessage message, IClientSessionRegistry notificationService) {
        block5: {
            Serializable notification;
            IClientNotificationAddress address;
            block7: {
                block6: {
                    block4: {
                        address = message.getAddress();
                        notification = message.getNotification();
                        LOG.debug("Processing client notification {}", (Object)notification);
                        if (!address.isNotifyAllNodes()) break block4;
                        LOG.debug("Notify all nodes");
                        this.dispatchForNode(notification, address);
                        break block5;
                    }
                    if (!address.isNotifyAllSessions()) break block6;
                    LOG.debug("Notify all sessions");
                    for (IClientSession session : notificationService.getAllClientSessions()) {
                        if (!this.isSessionValid(session, session.getId())) continue;
                        this.dispatchForSession(session, notification, address);
                    }
                    break block5;
                }
                if (!CollectionUtility.hasElements((Collection)address.getSessionIds())) break block7;
                LOG.debug("Notify sessions by session ids: {}", (Object)address.getSessionIds());
                for (String sessionId : address.getSessionIds()) {
                    IClientSession session = notificationService.getClientSession(sessionId);
                    if (!this.isSessionValid(session, sessionId)) continue;
                    this.dispatchForSession(session, notification, address);
                }
                break block5;
            }
            if (!CollectionUtility.hasElements((Collection)address.getUserIds())) break block5;
            LOG.debug("Notify sessions by user ids: {}", (Object)address.getUserIds());
            for (String userId : address.getUserIds()) {
                for (IClientSession session : notificationService.getClientSessionsForUser(userId)) {
                    if (!this.isSessionValid(session, session.getId())) continue;
                    this.dispatchForSession(session, notification, address);
                }
            }
        }
    }

    protected boolean isSessionValid(IClientSession session, String sessionId) {
        if (session == null) {
            LOG.debug("Received notification could not be delivered because the target session '{}' could not be found.", (Object)sessionId);
            return false;
        }
        if (session.getId() == null) {
            LOG.debug("Received notification for session '{}' is ignored because the session is not starting or started (active).", (Object)sessionId);
            return false;
        }
        return true;
    }

    public void dispatchForNode(Serializable notification, IClientNotificationAddress address) {
        if (IClientSession.CURRENT.get() != null) {
            this.dispatchSync(notification, address);
        } else {
            IFuture future = Jobs.schedule(() -> this.dispatchSync(notification, address), (JobInput)Jobs.newInput().withRunContext((RunContext)ClientRunContexts.copyCurrent().withTransactionScope(TransactionScope.REQUIRES_NEW)).withName("Dispatching client notification", new Object[0]));
            this.addPendingNotification((IFuture<Void>)future);
            future.whenDone((IDoneHandler)new P_NotificationFutureCallback((IFuture<Void>)future), null);
        }
    }

    public void dispatchForSession(IClientSession session, Serializable notification, IClientNotificationAddress address) {
        ISession currentSession = (ISession)ISession.CURRENT.get();
        if (session == currentSession) {
            this.dispatchSync(notification, address);
        } else {
            IFuture future = Jobs.schedule(() -> this.dispatchSync(notification, address), (JobInput)Jobs.newInput().withRunContext((RunContext)ClientRunContexts.empty().withSession(session, true).withCorrelationId((String)CorrelationId.CURRENT.get())).withName("Dispatching client notification", new Object[0]));
            this.addPendingNotification((IFuture<Void>)future);
            future.whenDone((IDoneHandler)new P_NotificationFutureCallback((IFuture<Void>)future), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPendingNotification(IFuture<Void> future) {
        Set<IFuture<Void>> set = this.m_notificationFutures;
        synchronized (set) {
            this.m_notificationFutures.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePendingNotification(IFuture<Void> future) {
        Set<IFuture<Void>> set = this.m_notificationFutures;
        synchronized (set) {
            this.m_notificationFutures.remove(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IFuture<?>> getPendingNotifications() {
        Set<IFuture<Void>> set = this.m_notificationFutures;
        synchronized (set) {
            return new HashSet(this.m_notificationFutures);
        }
    }

    protected void dispatchSync(Serializable notification, IClientNotificationAddress address) {
        NotificationHandlerRegistry reg = (NotificationHandlerRegistry)BEANS.get(NotificationHandlerRegistry.class);
        reg.notifyHandlers(notification, address);
    }

    private class P_NotificationFutureCallback
    implements IDoneHandler<Void> {
        private final IFuture<Void> m_future;

        P_NotificationFutureCallback(IFuture<Void> future) {
            this.m_future = future;
        }

        public void onDone(DoneEvent<Void> event) {
            ClientNotificationDispatcher.this.removePendingNotification(this.m_future);
        }
    }
}

