/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.clientnotification;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;
import org.eclipse.scout.rt.shared.clientnotification.IDispatchingNotificationHandler;
import org.eclipse.scout.rt.shared.notification.INotificationListener;
import org.eclipse.scout.rt.shared.session.IGlobalSessionListener;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservableNotificationHandler<T extends Serializable>
implements IDispatchingNotificationHandler<T>,
IGlobalSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractObservableNotificationHandler.class);
    private final Map<IClientSession, FastListenerList<INotificationListener<T>>> m_listeners = new WeakHashMap<IClientSession, FastListenerList<INotificationListener<T>>>();

    public void addListener(INotificationListener<T> listener) {
        this.addListener(ClientSessionProvider.currentSession(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IClientSession session, INotificationListener<T> listener) {
        Assertions.assertNotNull((Object)session, (String)"client session can not be null", (Object[])new Object[0]);
        Assertions.assertNotNull(listener, (String)"listener can not be null", (Object[])new Object[0]);
        Map<IClientSession, FastListenerList<INotificationListener<T>>> map = this.m_listeners;
        synchronized (map) {
            FastListenerList listeners = this.m_listeners.get(Assertions.assertNotNull((Object)session));
            if (listeners == null) {
                listeners = new FastListenerList();
                this.m_listeners.put(session, listeners);
            }
            listeners.add(listener);
        }
    }

    public void removeListener(INotificationListener<T> listener) {
        this.removeListener(ClientSessionProvider.currentSession(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IClientSession session, INotificationListener<T> listener) {
        Assertions.assertNotNull((Object)session, (String)"client session can not be null", (Object[])new Object[0]);
        Assertions.assertNotNull(listener, (String)"listener can not be null", (Object[])new Object[0]);
        Map<IClientSession, FastListenerList<INotificationListener<T>>> map = this.m_listeners;
        synchronized (map) {
            FastListenerList<INotificationListener<T>> listeners = this.m_listeners.get(session);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.m_listeners.remove(session);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<INotificationListener<T>> getListeners(IClientSession session) {
        Map<IClientSession, FastListenerList<INotificationListener<T>>> map = this.m_listeners;
        synchronized (map) {
            FastListenerList<INotificationListener<T>> listeners = this.m_listeners.get(session);
            if (listeners != null) {
                return listeners.list();
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FastListenerList<INotificationListener<T>> getListenerList(IClientSession session) {
        Map<IClientSession, FastListenerList<INotificationListener<T>>> map = this.m_listeners;
        synchronized (map) {
            return this.m_listeners.get(session);
        }
    }

    public void handleNotification(T notification, IClientNotificationAddress address) {
        if (address.isNotifyAllNodes()) {
            this.notifyListenersOfAllSessions(notification);
        } else {
            this.notifyListenersOfCurrentSession(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersOfAllSessions(T notification) {
        HashMap<IClientSession, FastListenerList<INotificationListener<T>>> listenerCopy;
        Map<IClientSession, FastListenerList<INotificationListener<T>>> map = this.m_listeners;
        synchronized (map) {
            listenerCopy = new HashMap<IClientSession, FastListenerList<INotificationListener<T>>>(this.m_listeners);
        }
        listenerCopy.forEach((session, listenerList) -> this.scheduleHandlingNotifications(notification, (FastListenerList<INotificationListener<T>>)listenerList, (IClientSession)session));
    }

    protected void notifyListenersOfCurrentSession(T notification) {
        ISession currentSession = (ISession)IClientSession.CURRENT.get();
        if (currentSession instanceof IClientSession) {
            IClientSession session = (IClientSession)currentSession;
            this.scheduleHandlingNotifications(notification, this.getListenerList(session), session);
        }
    }

    protected void scheduleHandlingNotifications(T notification, FastListenerList<INotificationListener<T>> listenerList, IClientSession session) {
        if (listenerList == null) {
            return;
        }
        JobInput input = Jobs.newInput().withName("Handling Client Notification", new Object[0]).withRunContext((RunContext)ClientRunContexts.empty().withSession(session, true).withCorrelationId((String)CorrelationId.CURRENT.get()));
        Jobs.schedule(() -> listenerList.list().forEach(listener -> listener.handleNotification(notification)), (JobInput)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionChanged(SessionEvent event) {
        ISession session;
        if (event.getType() == 110 && (session = (ISession)Assertions.assertNotNull((Object)event.getSource())) instanceof IClientSession) {
            IClientSession clientSession = (IClientSession)session;
            Map<IClientSession, FastListenerList<INotificationListener<T>>> map = this.m_listeners;
            synchronized (map) {
                for (INotificationListener<T> notificationListener : this.getListeners(clientSession)) {
                    this.removeListener(clientSession, notificationListener);
                    LOG.warn("Auto fallback removal of session listener due to stopped session. This must be done explicitly by the one that registered the listener: {}", notificationListener);
                }
            }
        }
    }
}

