/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.CRC32;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.pagefield.AbstractPageField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.reflect.FastBeanInfo;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemoryPolicy
implements IMemoryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMemoryPolicy.class);
    private boolean m_active;
    private IOutline m_activeOutline;
    private final Map<IForm, String> m_formToIdentifierMap;
    private final Map<ITable, String> m_tableToIdentifierMap;
    private final DesktopListener m_desktopListener;
    private final TreeListener m_treeListener;
    private final FormListener m_formListener = new FormListener(){

        @Override
        public void formChanged(FormEvent e) {
            if (!AbstractMemoryPolicy.this.m_active) {
                e.getForm().removeFormListener(AbstractMemoryPolicy.this.m_formListener, new Integer[0]);
                return;
            }
            String id = AbstractMemoryPolicy.this.m_formToIdentifierMap.get(e.getForm());
            if (id != null) {
                try {
                    AbstractMemoryPolicy.this.handlePageFormEvent(e, id);
                }
                catch (Exception t) {
                    LOG.warn("could not handle page form event{}", (Object)e, (Object)t);
                }
            }
        }
    };
    private final TableListener m_tableListener = new TableAdapter(){

        @Override
        public void tableChanged(TableEvent e) {
            if (!AbstractMemoryPolicy.this.m_active) {
                e.getTable().removeTableListener(AbstractMemoryPolicy.this.m_tableListener, new Integer[0]);
                return;
            }
            String id = AbstractMemoryPolicy.this.m_tableToIdentifierMap.get(e.getTable());
            if (id != null) {
                try {
                    AbstractMemoryPolicy.this.handleTableFilterEvent(e, id);
                }
                catch (Exception t) {
                    LOG.warn("could not handle table filter event {}", (Object)e, (Object)t);
                }
            }
        }
    };

    public AbstractMemoryPolicy() {
        this.m_formToIdentifierMap = new WeakHashMap<IForm, String>();
        this.m_tableToIdentifierMap = new WeakHashMap<ITable, String>();
        this.m_desktopListener = this.createDesktopListener();
        this.m_treeListener = this.createTreeListener();
    }

    @Override
    public void addNotify() {
        this.m_active = true;
    }

    @Override
    public void removeNotify() {
        this.m_active = false;
    }

    public IOutline getActiveOutline() {
        return this.m_activeOutline;
    }

    public void setActiveOutline(IOutline activeOutline) {
        this.m_activeOutline = activeOutline;
    }

    @Override
    public void pageCreated(IPage<?> p) {
    }

    @Override
    public void pageTableCreated(IPage<?> p) {
        String pageTableIdentifier;
        IPageWithTable pt;
        Object table;
        if (p instanceof IPageWithTable && (table = (pt = (IPageWithTable)p).getTable(false)) != null && (pageTableIdentifier = this.registerPageTable(pt, (ITable)table)) != null) {
            this.loadUserFilterState((ITable)table, pageTableIdentifier);
        }
    }

    @Override
    public void pageSearchFormStarted(IPageWithTable<?> p) {
        if (p.getOutline() instanceof AbstractPageField.SimpleOutline) {
            return;
        }
        ISearchForm f = p.getSearchFormInternal();
        if (f != null) {
            String pageFormIdentifier = this.registerPageForm(p, f);
            if (f.isFormStarted()) {
                this.loadSearchFormState(f, pageFormIdentifier);
            }
        }
    }

    protected String registerPageForm(IPage<?> p, IForm f) {
        String id = this.createUniqueIdForPage(p, f);
        this.m_formToIdentifierMap.put(f, id);
        f.removeFormListener(this.m_formListener, new Integer[0]);
        f.addFormListener(this.m_formListener, new Integer[0]);
        return id;
    }

    protected String registerPageTable(IPage<?> p, ITable t) {
        if (t.getUserFilterManager() == null) {
            return null;
        }
        String id = this.createUniqueIdForPage(p, t);
        this.m_tableToIdentifierMap.put(t, id);
        t.removeTableListener(this.m_tableListener, new Integer[0]);
        t.addTableListener(this.m_tableListener, 900, 910);
        return id;
    }

    protected String createUniqueIdForPage(IPage<?> p, Object o) {
        if (p == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        this.createIdForPage(builder, p, o);
        IPage<?> page = p.getParentPage();
        while (page != null) {
            this.createIdForPage(builder, page, null);
            page = page.getParentPage();
        }
        CRC32 crc = new CRC32();
        crc.update(builder.toString().getBytes());
        return "" + crc.getValue();
    }

    private void createIdForPage(StringBuilder b, IPage<?> page, Object o) {
        b.append("/");
        b.append(page.getClass().getName());
        if (page.getUserPreferenceContext() != null) {
            b.append("/");
            b.append(page.getUserPreferenceContext());
        }
        if (o != null) {
            b.append("/");
            b.append(o.getClass().getName());
        }
        FastBeanInfo pi = new FastBeanInfo(page.getClass(), page.getClass().getSuperclass());
        FastPropertyDescriptor[] fastPropertyDescriptorArray = pi.getPropertyDescriptors();
        int n = fastPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            FastPropertyDescriptor prop = fastPropertyDescriptorArray[n2];
            if (prop.getReadMethod() != null && (Date.class.isAssignableFrom(prop.getPropertyType()) || Number.class.isAssignableFrom(prop.getPropertyType()) || String.class.isAssignableFrom(prop.getPropertyType()) || Long.TYPE.isAssignableFrom(prop.getPropertyType()))) {
                try {
                    b.append("/");
                    b.append(prop.getName());
                    b.append("=");
                    b.append(prop.getReadMethod().invoke(page, new Object[0]));
                }
                catch (Exception e) {
                    LOG.error("Error reading property {}", (Object)prop, (Object)e);
                }
            }
            ++n2;
        }
    }

    protected void handlePageFormEvent(FormEvent e, String pageFormIdentifier) {
        switch (e.getType()) {
            case 1020: {
                this.storeSearchFormState(e.getForm(), pageFormIdentifier);
                break;
            }
            case 2020: {
                this.storeSearchFormState(e.getForm(), pageFormIdentifier);
            }
        }
    }

    protected void loadSearchFormState(IForm f, String pageFormIdentifier) {
    }

    protected void storeSearchFormState(IForm f, String pageFormIdentifier) {
    }

    protected void handleTableFilterEvent(TableEvent e, String id) {
        switch (e.getType()) {
            case 900: 
            case 910: {
                this.storeUserFilterState(e.getTable(), id);
            }
        }
    }

    protected void storeUserFilterState(ITable t, String pageTableIdentifier) {
    }

    protected void loadUserFilterState(ITable t, String pageTableIdentifier) {
    }

    @Override
    public void afterOutlineSelectionChanged(IDesktop desktop) {
    }

    @Override
    public void beforeTablePageLoadData(IPageWithTable<?> page) {
    }

    @Override
    public void afterTablePageLoadData(IPageWithTable<?> page) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void registerOutline(IOutline outline) {
        outline.addTreeListener(this.m_treeListener, 40, 1005, 1004, 1002, 1003, 1006);
    }

    @Override
    public void deregisterOutline(IOutline outline) {
        outline.removeTreeListener(this.m_treeListener, new Integer[0]);
    }

    @Override
    public void registerDesktop(IDesktop desktop) {
        desktop.addDesktopListener(this.m_desktopListener, new Integer[0]);
    }

    @Override
    public void deregisterDesktop(IDesktop desktop) {
        desktop.removeDesktopListener(this.m_desktopListener, new Integer[0]);
    }

    protected DesktopListener createDesktopListener() {
        return e -> {
            switch (e.getType()) {
                case 200: {
                    this.setActiveOutline(e.getOutline());
                    break;
                }
                case 100: {
                    if (!(e.getSource() instanceof IDesktop)) break;
                    this.deregisterDesktop((IDesktop)e.getSource());
                }
            }
        };
    }

    protected TreeListener createTreeListener() {
        return e -> {
            try {
                IPage p;
                if (e.getType() == 40 && e.getSource() == this.getActiveOutline()) {
                    this.afterOutlineSelectionChanged(ClientSessionProvider.currentSession().getDesktop());
                }
                if (e.getNode() instanceof IPage) {
                    p = (IPage)e.getNode();
                    switch (e.getType()) {
                        case 1005: {
                            this.pageCreated(p);
                            break;
                        }
                        case 1004: {
                            this.pageTableCreated(p);
                        }
                    }
                }
                if (e.getNode() instanceof IPageWithTable) {
                    p = (IPageWithTable)e.getNode();
                    switch (e.getType()) {
                        case 1002: {
                            this.beforeTablePageLoadData((IPageWithTable<?>)p);
                            break;
                        }
                        case 1003: {
                            this.afterTablePageLoadData((IPageWithTable<?>)p);
                            break;
                        }
                        case 1006: {
                            this.pageSearchFormStarted((IPageWithTable<?>)p);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (RuntimeException | PlatformError t) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(t);
            }
        };
    }

    public static class SearchFormState {
        final String m_formContentXml;
        final SearchFilter m_searchFilter;

        public SearchFormState(String xml, SearchFilter filter) {
            this.m_formContentXml = xml;
            this.m_searchFilter = filter;
        }
    }
}

