/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.app.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExceptionFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            if (this.isCausedByQuietException(e)) {
                throw e;
            }
            HttpServletRequest req = (HttpServletRequest)request;
            MDC.put((String)"scout.correlation.id", (String)req.getHeader("X-Scout-Correlation-Id"));
            try {
                LOG.warn(req.getRequestURI(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"scout.correlation.id");
            }
            throw new JettyQuietExceptionWrapper(e);
        }
    }

    protected boolean isCausedByQuietException(Throwable t) {
        return ((DefaultExceptionTranslator)BEANS.get(DefaultExceptionTranslator.class)).throwableCausesAccept(t, e -> e instanceof QuietException);
    }

    public void destroy() {
    }

    public static class JettyQuietExceptionWrapper
    extends RuntimeException
    implements QuietException {
        private static final long serialVersionUID = 1L;

        public JettyQuietExceptionWrapper(Throwable cause) {
            super(cause);
        }
    }
}

