/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.app;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPortConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringListConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class ApplicationProperties {
    private ApplicationProperties() {
    }

    public static class ScoutApplicationAutoCreateSelfSignedCertificateProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.app.autoCreateSelfSignedCertificate";
        }

        public String description() {
            return "Specifies the X-500 name to use in the self-signed certificate when starting Scout application in development mode with TLS enabled.\nExample: 'CN=my-host.my-domain.com,C=US,ST=CA,L=Sunnyvale,O=My Company Inc.'.\nThis property is only used in development mode and only if the property '" + ((ScoutApplicationUseTlsProperty)((Object)BEANS.get(ScoutApplicationUseTlsProperty.class))).getKey() + "' is true and no existing Java keystore is specified (property '" + ((ScoutApplicationKeyStorePathProperty)((Object)BEANS.get(ScoutApplicationKeyStorePathProperty.class))).getKey() + "').";
        }

        public String getDefaultValue() {
            return "CN=localhost";
        }
    }

    public static class ScoutApplicationCertificateAliasProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.app.certificateAlias";
        }

        public String description() {
            return "HTTPS certificate alias of the key in the keystore to use.";
        }
    }

    public static class ScoutApplicationConsoleInputHandlerEnabledProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.consoleInputHandlerEnabled";
        }

        public Boolean getDefaultValue() {
            return Platform.get().inDevelopmentMode();
        }

        public String description() {
            return "Specifies whether the application uses a console input handler or not. The default value is true for development, false otherwise.";
        }
    }

    public static class ScoutApplicationContextHandlerExtendedResourceLookup
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.contextHandlerExtendedResourceLookup";
        }

        public Boolean getDefaultValue() {
            return Boolean.FALSE;
        }

        public String description() {
            return "Specifies whether the application context handler should also lookup resources w/o base resource. The default value is false.";
        }
    }

    public static class ScoutApplicationContextPathProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.app.contextPath";
        }

        protected String parse(String value) {
            if (StringUtility.hasText((CharSequence)value)) {
                if (!((String)value).startsWith("/")) {
                    value = "/" + (String)value;
                }
                return value;
            }
            return null;
        }

        public String getDefaultValue() {
            return "/";
        }

        public String description() {
            return "The context path under which the application can be reached. The default value is / (i.e. root path).";
        }
    }

    public static class ScoutApplicationGzipEnabled
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.gzip.enabled";
        }

        public String description() {
            return "Specifies whether " + GzipHandler.class.getName() + " is used. Default value is " + String.valueOf(this.getDefaultValue()) + ".";
        }

        public Boolean getDefaultValue() {
            return true;
        }
    }

    public static class ScoutApplicationGzipExcludedInflatePaths
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.excluded.inflate.paths";
        }

        public String description() {
            return "Excluded inflate paths for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipExcludedMethods
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.excluded.methods";
        }

        public String description() {
            return "Excluded methods for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipExcludedMimeTypes
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.excluded.mimeTypes";
        }

        public String description() {
            return "Excluded MIME types for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipExcludedPaths
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.excluded.paths";
        }

        public String description() {
            return "Excluded paths for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipIncludedInflatePaths
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.included.inflate.paths";
        }

        public String description() {
            return "Included inflate paths for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipIncludedMethods
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.included.methods";
        }

        public String description() {
            return "Included methods for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipIncludedMimeTypes
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.included.mimeTypes";
        }

        public String description() {
            return "Included MIME types for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipIncludedPaths
    extends AbstractStringListConfigProperty {
        public String getKey() {
            return "scout.app.gzip.included.paths";
        }

        public String description() {
            return "Included paths for " + GzipHandler.class.getName() + " (respected only if at least one is set otherwise Jetty default is used).";
        }
    }

    public static class ScoutApplicationGzipMinSize
    extends AbstractPositiveIntegerConfigProperty {
        public String getKey() {
            return "scout.app.gzip.minSize";
        }

        public String description() {
            return "Minimum size to trigger compression for " + GzipHandler.class.getName() + ". If not set Jetty default value will be used.";
        }
    }

    public static class ScoutApplicationGzipSyncFlush
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.gzip.syncFlush";
        }

        public String description() {
            return "Enables sync flush for " + GzipHandler.class.getName() + ". Default value is " + String.valueOf(this.getDefaultValue()) + ".";
        }

        public Boolean getDefaultValue() {
            return true;
        }
    }

    public static class ScoutApplicationHttpRequestMaxHeaderSizeProperty
    extends AbstractIntegerConfigProperty {
        public String getKey() {
            return "scout.app.http.request.maxHeaderSize";
        }

        public String description() {
            return "Specifies the maximum allowed size in bytes for a HTTP request header. The default value is 72 KB.";
        }

        public Integer getDefaultValue() {
            return 73728;
        }
    }

    public static class ScoutApplicationHttpSessionEnabledProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.httpSessionEnabled";
        }

        public Boolean getDefaultValue() {
            return Boolean.TRUE;
        }

        public String description() {
            return "Specifies whether the application uses HTTP session or not. The default value is true.";
        }
    }

    public static class ScoutApplicationJvmShutdownHookEnabledProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.jvmShutdownHookEnabled";
        }

        public Boolean getDefaultValue() {
            return Boolean.TRUE;
        }

        public String description() {
            return "Specifies if the JVM shutdown hook is registered. The default value is true.";
        }
    }

    public static class ScoutApplicationKeyStorePasswordProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.app.keyStorePassword";
        }

        public String description() {
            return "HTTPS keystore password. Supports obfuscated values prefixed with 'OBF:'.";
        }
    }

    public static class ScoutApplicationKeyStorePathProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.app.keyStorePath";
        }

        public String description() {
            return "Setting this property enables the HTTPS connector. The value of this property must point to the local key store.\nExample: 'classpath:/dev/my-https.jks' or 'file:///C:/Users/usr/Desktop/my-store.jks' or 'C:/Users/usr/Desktop/my-store.jks'.";
        }
    }

    public static class ScoutApplicationPortProperty
    extends AbstractPortConfigProperty {
        public String getKey() {
            return "scout.app.port";
        }

        public Integer getDefaultValue() {
            return 8080;
        }

        public String description() {
            return "The port under which the application will be running. Default value is " + String.valueOf(this.getDefaultValue()) + ".";
        }
    }

    public static class ScoutApplicationPrivateKeyPasswordProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.app.privateKeyPassword";
        }

        public String description() {
            return "The password (if any) for the specific key within the key store. Supports obfuscated values prefixed with 'OBF:'.";
        }
    }

    public static class ScoutApplicationSessionCookieConfigHttpOnlyProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.sessionCookieConfigHttpOnly";
        }

        public Boolean getDefaultValue() {
            return Boolean.TRUE;
        }

        public String description() {
            return "Specifies whether the HTTP session cookie is HTTP only or not. The default value is true.";
        }
    }

    public static class ScoutApplicationSessionCookieConfigPartitionedProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.sessionCookieConfigPartitioned";
        }

        public Boolean getDefaultValue() {
            return false;
        }

        public String description() {
            return "Specifies whether the HTTP session cookie created by the web application will be marked as partitioned. The default value is false.";
        }
    }

    public static class ScoutApplicationSessionCookieConfigSameSiteProperty
    extends AbstractConfigProperty<HttpCookie.SameSite, String> {
        public String getKey() {
            return "scout.app.sessionCookieConfigSameSite";
        }

        public String description() {
            return "Specifies the SameSite attribute of the HTTP session cookie. Valid values are: '" + HttpCookie.SameSite.NONE.getAttributeValue() + "', '" + HttpCookie.SameSite.STRICT.getAttributeValue() + "' or '" + HttpCookie.SameSite.LAX.getAttributeValue() + "'. Default value is '" + this.getDefaultValue().getAttributeValue() + "'.";
        }

        public HttpCookie.SameSite getDefaultValue() {
            return HttpCookie.SameSite.LAX;
        }

        protected HttpCookie.SameSite parse(String value) {
            return Arrays.stream(HttpCookie.SameSite.values()).filter(e -> value.equals(e.getAttributeValue())).findFirst().orElseThrow();
        }
    }

    public static class ScoutApplicationSessionCookieConfigSecureProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.sessionCookieConfigSecure";
        }

        public Boolean getDefaultValue() {
            return !Platform.get().inDevelopmentMode();
        }

        public String description() {
            return "Specifies whether the HTTP session cookie created by the web application will be marked as secure. If true, the HTTP session cookie will be marked as secure even if the request initiated the corresponding session using plain HTTP instead of HTTPS (e.g. Scout application behind reverse proxy terminating SSL). If false, the HTTP session cookie will only be marked as secure if the request initiated the corresponding session is secure (using HTTPS). The default value is true for non-development mode.";
        }
    }

    public static class ScoutApplicationSessionTimeoutProperty
    extends AbstractPositiveIntegerConfigProperty {
        public String getKey() {
            return "scout.app.httpSessionTimeout";
        }

        public Integer getDefaultValue() {
            return (int)TimeUnit.MINUTES.toSeconds(Platform.get().inDevelopmentMode() ? 60 : 5);
        }

        public String description() {
            return "The session timeout in seconds to use if HTTP sessions are enabled. The default value is 300 seconds (5 minutes) for non-development mode, 3600 seconds (60 minutes) for development mode.";
        }
    }

    public static class ScoutApplicationUseTlsProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.app.useTls";
        }

        public String description() {
            return "Specifies if the Scout application should use TLS. If true, the server must either be started in development mode (then a new self-singed certificate is created automatically), or a Java KeyStore must be configured using property '" + ((ScoutApplicationKeyStorePathProperty)((Object)BEANS.get(ScoutApplicationKeyStorePathProperty.class))).getKey() + "'. By default this property is true, if a Java KeyStore has been specified.";
        }

        public Boolean getDefaultValue() {
            if (CONFIG.getPropertyValue(ScoutApplicationKeyStorePathProperty.class) != null) {
                return true;
            }
            return false;
        }
    }
}

