/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.scout.rt.app.ApplicationProperties;
import org.eclipse.scout.rt.app.servlet.ScoutServletContextHandler;
import org.eclipse.scout.rt.jetty.IServletContributor;
import org.eclipse.scout.rt.jetty.IServletFilterContributor;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.IConfigProperty;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.security.ICertificateProvider;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.LocalHostAddressHelper;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Application {
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    protected static final LazyValue<Application> INSTANCE = new LazyValue(Application.class);
    protected final AtomicReference<Server> m_server = new AtomicReference();

    public static void main(String[] args) {
        long t0 = System.nanoTime();
        LOG.info("Starting platform");
        IPlatform platform = Platform.get();
        platform.awaitPlatformStarted();
        LOG.info("Platform start took {} ms", (Object)StringUtility.formatNanos((long)(System.nanoTime() - t0)));
        LOG.info("Starting application");
        long t1 = System.nanoTime();
        ((Application)INSTANCE.get()).start();
        LOG.info("Application start took {} ms, total startup (platform/application) took {} ms", (Object)StringUtility.formatNanos((long)(System.nanoTime() - t1)), (Object)StringUtility.formatNanos((long)(System.nanoTime() - t0)));
    }

    protected void start() {
        try {
            this.startInternal();
        }
        catch (Exception e) {
            LOG.error("Fatal: Unable to start application", (Throwable)e);
            this.shutdown(1);
        }
    }

    protected void startInternal() throws Exception {
        Server server = this.createServer();
        this.m_server.set(server);
        server.start();
        if (((Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationConsoleInputHandlerEnabledProperty.class)).booleanValue()) {
            this.startConsoleInputHandler();
        }
        if (((Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationJvmShutdownHookEnabledProperty.class)).booleanValue()) {
            this.registerJvmShutdownHook();
        }
        this.logServerReady();
    }

    protected void logServerReady() {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        String protocol = (Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationUseTlsProperty.class) != false ? "https" : "http";
        LocalHostAddressHelper helper = (LocalHostAddressHelper)BEANS.get(LocalHostAddressHelper.class);
        String hostname = helper.getHostName();
        String ip = helper.getHostAddress();
        int port = (Integer)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationPortProperty.class);
        String contextPath = (String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationContextPathProperty.class);
        String pid = null;
        try {
            pid = String.valueOf(ProcessHandle.current().pid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Server ready. The application").append(StringUtility.box((String)" with PID=", (String)pid, (String)"")).append(" is available at the following addresses:\n");
        sb.append("---------------------------------------------------------------------\n");
        sb.append("  ").append(protocol).append("://localhost:").append(port).append(contextPath).append('\n');
        sb.append("  ").append(protocol).append("://").append(hostname).append(":").append(port).append(contextPath).append('\n');
        if (StringUtility.notEqualsIgnoreCase((String)hostname, (String)ip)) {
            sb.append("  ").append(protocol).append("://").append(ip).append(":").append(port).append(contextPath).append('\n');
        }
        sb.append("---------------------------------------------------------------------\n");
        if (((Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationConsoleInputHandlerEnabledProperty.class)).booleanValue()) {
            sb.append("To shut the server down, type \"shutdown\" or \"s\" in the console.\n");
        }
        LOG.info(sb.toString());
    }

    protected Server createServer() {
        Server server = new Server();
        ServerConnector connector = (Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationUseTlsProperty.class) != false ? this.createHttpsServerConnector(server) : this.createHttpServerConnector(server);
        connector.setPort(((Integer)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationPortProperty.class)).intValue());
        server.addConnector((Connector)connector);
        this.installErrorHandler(server);
        Handler handler = this.createHandler();
        server.setHandler(handler);
        return server;
    }

    protected ServerConnector createHttpServerConnector(Server server) {
        HttpConfiguration httpConfig = this.createHttpConfiguration();
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig), new HTTP2CServerConnectionFactory(httpConfig)});
        return http;
    }

    protected ServerConnector createHttpsServerConnector(Server server) {
        SslContextFactory.Server sslContextFactory = this.createSslContextFactory();
        HttpConfiguration httpsConfig = this.createHttpConfiguration();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpsConfig);
        HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(httpsConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(http11.getProtocol());
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{tls, alpn, http2, http11});
        return https;
    }

    protected HttpConfiguration createHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        httpConfig.setSendXPoweredBy(false);
        Integer requestHeaderMaxSize = (Integer)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationHttpRequestMaxHeaderSizeProperty.class);
        if (requestHeaderMaxSize != null) {
            httpConfig.setRequestHeaderSize(requestHeaderMaxSize.intValue());
        }
        return httpConfig;
    }

    protected SslContextFactory.Server createSslContextFactory() {
        Path keyStorePath = this.resolveKeyStorePath((String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationKeyStorePathProperty.class));
        String keyStoreUri = keyStorePath == null ? null : keyStorePath.toUri().toString();
        String keyStorePassword = (String)ObjectUtility.nvl((Object)((String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationKeyStorePasswordProperty.class)), (Object)"");
        String privateKeyPassword = (String)ObjectUtility.nvl((Object)((String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationPrivateKeyPasswordProperty.class)), (Object)"");
        String certAlias = (String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationCertificateAliasProperty.class);
        boolean keyStoreExists = keyStorePath != null && Files.isRegularFile(keyStorePath, new LinkOption[0]);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (Platform.get().inDevelopmentMode() && !keyStoreExists) {
            String autoCertName = (String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationAutoCreateSelfSignedCertificateProperty.class);
            if (!StringUtility.hasText((CharSequence)certAlias)) {
                certAlias = "localhost";
            }
            LOG.info("No existing keystore was provided to setup TLS. Creating a self-signed certificate '{}'.", (Object)autoCertName);
            ICertificateProvider certificateProvider = (ICertificateProvider)BEANS.optional(ICertificateProvider.class).orElseThrow(() -> new PlatformException("No certificate-provider available to create a self-signed certificate to use for TLS. Add a certificate-provider or specify an existing keystore using property '{}'.", new Object[]{((ApplicationProperties.ScoutApplicationKeyStorePathProperty)((Object)((Object)BEANS.get(ApplicationProperties.ScoutApplicationKeyStorePathProperty.class)))).getKey()}));
            if (keyStoreUri == null) {
                KeyStore ks = certificateProvider.createSelfSignedCertificate(certAlias, autoCertName, keyStorePassword.toCharArray(), privateKeyPassword.toCharArray());
                sslContextFactory.setKeyStore(ks);
            } else {
                LOG.info("Storing created keystore in '{}'.", (Object)keyStoreUri);
                certificateProvider.autoCreateSelfSignedCertificate(keyStoreUri, keyStorePassword.toCharArray(), privateKeyPassword.toCharArray(), certAlias, autoCertName);
                sslContextFactory.setKeyStorePath(keyStoreUri);
            }
        } else {
            LOG.info("Setup TLS certificate using alias '{}' from keystore '{}'.", (Object)certAlias, (Object)keyStoreUri);
            sslContextFactory.setKeyStorePath(keyStoreUri);
        }
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setKeyManagerPassword(privateKeyPassword);
        sslContextFactory.setCertAlias(certAlias);
        sslContextFactory.setEndpointIdentificationAlgorithm("https");
        sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256"});
        return sslContextFactory;
    }

    protected Path resolveKeyStorePath(String path) {
        if (!StringUtility.hasText((CharSequence)path)) {
            return null;
        }
        if (path.startsWith("classpath:")) {
            String subPath = path.substring("classpath:".length());
            URL res = this.getClass().getResource(subPath);
            if (res == null) {
                res = this.getClass().getClassLoader().getResource(subPath);
            }
            if (res == null) {
                res = ClassLoader.getSystemClassLoader().getResource(subPath);
            }
            if (res == null) {
                throw new ProcessingException("Missing resource defined by config property: {}={}", new Object[]{((ApplicationProperties.ScoutApplicationKeyStorePathProperty)((Object)BEANS.get(ApplicationProperties.ScoutApplicationKeyStorePathProperty.class))).getKey(), path});
            }
            path = res.toExternalForm();
        }
        try {
            return Paths.get(URI.create(path));
        }
        catch (Exception e) {
            LOG.debug("Path '{}' is no valid URI. Trying to read as file path.", (Object)path, (Object)e);
            return Paths.get(path, new String[0]);
        }
    }

    protected void installErrorHandler(Server server) {
        ErrorHandler handler = new ErrorHandler();
        handler.setShowMessageInTitle(false);
        handler.setShowStacks(false);
        server.setErrorHandler((Request.Handler)handler);
    }

    protected Handler createHandler() {
        boolean sessionEnabled = (Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationHttpSessionEnabledProperty.class);
        LOG.info("Creating servlet context handler with {}", (Object)(sessionEnabled ? "sessions" : "no sessions"));
        ScoutServletContextHandler handler = new ScoutServletContextHandler(sessionEnabled ? 1 : 0);
        boolean handlerExtendedResourceLookup = BooleanUtility.nvl((Boolean)((Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationContextHandlerExtendedResourceLookup.class)));
        handler.withExtendedResourceLookup(handlerExtendedResourceLookup);
        LOG.trace("Extended resource lookup enabled = {}", (Object)handlerExtendedResourceLookup);
        if (sessionEnabled) {
            int sessionTimeoutInSeconds = (Integer)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationSessionTimeoutProperty.class);
            boolean httpOnly = (Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationSessionCookieConfigHttpOnlyProperty.class);
            boolean secure = (Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationSessionCookieConfigSecureProperty.class);
            HttpCookie.SameSite sameSite = (HttpCookie.SameSite)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationSessionCookieConfigSameSiteProperty.class);
            boolean partitioned = (Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationSessionCookieConfigPartitionedProperty.class);
            LOG.info("[Session config] timeout: {} s, HTTP only: {}, secure: {}, same site: {}, partitioned: {}", new Object[]{sessionTimeoutInSeconds, httpOnly, secure, sameSite.getAttributeValue(), partitioned});
            SessionHandler sessionHandler = handler.getSessionHandler();
            sessionHandler.setMaxInactiveInterval(sessionTimeoutInSeconds);
            sessionHandler.getSessionCookieConfig().setHttpOnly(httpOnly);
            sessionHandler.getSessionCookieConfig().setSecure(secure);
            sessionHandler.setSameSite(sameSite);
            sessionHandler.setPartitioned(partitioned);
        }
        handler.setDisplayName((String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationNameProperty.class));
        handler.setInitParameter("logbackDisableServletContainerInitializer", Boolean.TRUE.toString());
        BEANS.all(IServletFilterContributor.class).forEach(c -> c.contribute((ServletContextHandler)handler));
        BEANS.all(IServletContributor.class).forEach(c -> c.contribute((ServletContextHandler)handler));
        String contextPath = (String)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationContextPathProperty.class);
        handler.setContextPath(contextPath);
        if (!"/".equals(contextPath)) {
            return new P_RedirectToContextPathHandler((ContextHandler)handler);
        }
        if (BooleanUtility.nvl((Boolean)((Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationGzipEnabled.class)), (boolean)true)) {
            return this.createGzipHandler((Handler)handler);
        }
        return handler;
    }

    protected Handler createGzipHandler(Handler handler) {
        GzipHandler gzipHandler = new GzipHandler();
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipExcludedInflatePaths.class, stringArray -> gzipHandler.setExcludedInflatePaths(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipExcludedMethods.class, stringArray -> gzipHandler.setExcludedMethods(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipExcludedMimeTypes.class, stringArray -> gzipHandler.setExcludedMimeTypes(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipExcludedPaths.class, stringArray -> gzipHandler.setExcludedPaths(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipIncludedInflatePaths.class, stringArray -> gzipHandler.setIncludedInflatePaths(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipIncludedMethods.class, stringArray -> gzipHandler.setIncludedMethods(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipIncludedMimeTypes.class, stringArray -> gzipHandler.setIncludedMimeTypes(stringArray));
        this.setStringPropertyValueIfFilled(ApplicationProperties.ScoutApplicationGzipIncludedPaths.class, stringArray -> gzipHandler.setIncludedPaths(stringArray));
        Optional.ofNullable((Integer)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationGzipMinSize.class)).ifPresent(arg_0 -> ((GzipHandler)gzipHandler).setMinGzipSize(arg_0));
        gzipHandler.setSyncFlush(((Boolean)CONFIG.getPropertyValue(ApplicationProperties.ScoutApplicationGzipSyncFlush.class)).booleanValue());
        gzipHandler.setHandler(handler);
        return gzipHandler;
    }

    protected void setStringPropertyValueIfFilled(Class<? extends IConfigProperty<List<String>>> propertyClass, Consumer<String[]> setter) {
        List propertyValue = (List)CONFIG.getPropertyValue(propertyClass);
        if (!CollectionUtility.isEmpty((Collection)propertyValue)) {
            setter.accept((String[])propertyValue.toArray(String[]::new));
        }
    }

    protected void startConsoleInputHandler() {
        Thread t = new Thread("Console input handler"){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    var1_1 = null;
                    var2_4 = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(System.in));
                        block10: while (true) {
                            while ((command = StringUtility.trim((String)br.readLine())) != null) {
                                if (!"shutdown".equalsIgnoreCase(command) && !"s".equalsIgnoreCase(command)) ** GOTO lbl16
                                try {
                                    Application.this.shutdown();
                                    return;
                                }
                                catch (Exception e) {
                                    Application.LOG.error("Shutdown error", (Throwable)e);
                                    continue block10;
lbl16:
                                    // 1 sources

                                    if (StringUtility.hasText((CharSequence)command)) ** break;
                                    continue block10;
                                    Application.LOG.warn("Unknown command: {}", (Object)command);
                                    continue;
                                    return;
                                }
                            }
                            break;
                        }
                        finally {
                            if (br != null) {
                                br.close();
                            }
                        }
                    }
                    catch (Throwable var2_5) {
                        if (var1_1 == null) {
                            var1_1 = var2_5;
                            throw var1_1;
                        }
                        if (var1_1 == var2_5) throw var1_1;
                        var1_1.addSuppressed(var2_5);
                        throw var1_1;
                    }
                }
                catch (IOException e1) {
                    Application.LOG.error("Unexpected error while waiting for console command", (Throwable)e1);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void registerJvmShutdownHook() {
        Thread shutdownHook = new Thread(() -> this.shutdown(), "Scout-app-shutdown-hook");
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public void shutdown() {
        this.shutdown(null);
    }

    public void shutdown(Integer exitCode) {
        try {
            this.shutdownInternal(exitCode);
        }
        catch (Exception e) {
            LOG.error("Error while shutting down application", (Throwable)e);
        }
    }

    protected void shutdownInternal(Integer exitCode) throws Exception {
        Server server = this.m_server.getAndSet(null);
        if (server != null) {
            LOG.info("Shutting down application...");
            server.stop();
            IPlatform platform = Platform.peek();
            if (platform != null && platform.getState() != IPlatform.State.PlatformStopped) {
                platform.stop();
            }
            LOG.info("Shutdown complete");
            if (exitCode != null) {
                System.exit(exitCode);
            }
        } else {
            LOG.debug("Shutdown already in progress");
        }
    }

    protected static class P_RedirectToContextPathHandler
    extends Handler.Wrapper {
        protected final String m_contextPath;

        public P_RedirectToContextPathHandler(ContextHandler contextHandler) {
            this.setHandler((Handler)contextHandler);
            this.m_contextPath = contextHandler.getContextPath();
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (!"GET".equals(request.getMethod())) {
                return super.handle(request, response, callback);
            }
            String requestURI = (String)ObjectUtility.nvl((Object)Request.getPathInContext((Request)request), (Object)"/");
            if (!"GET".equals(request.getMethod()) || requestURI.startsWith(this.m_contextPath)) {
                return super.handle(request, response, callback);
            }
            StringBuilder redirectUri = new StringBuilder();
            redirectUri.append(request.getHttpURI().getScheme()).append("://").append(request.getHttpURI().getHost());
            if ("http".equals(request.getHttpURI().getScheme()) && request.getHttpURI().getPort() != 80 || "https".equals(request.getHttpURI().getScheme()) && request.getHttpURI().getPort() != 443) {
                redirectUri.append(":").append(request.getHttpURI().getPort());
            }
            redirectUri.append(this.m_contextPath);
            if (!"/".equals(requestURI)) {
                redirectUri.append(requestURI);
            }
            if (request.getHttpURI().getQuery() != null) {
                redirectUri.append("?").append(request.getHttpURI().getQuery());
            }
            response.setStatus(302);
            response.getHeaders().add(new HttpField(HttpHeader.LOCATION, redirectUri.toString()));
            callback.succeeded();
            return true;
        }
    }
}

