/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.api.data;

import java.lang.annotation.Annotation;
import org.eclipse.scout.rt.api.data.ApiExposed;
import org.eclipse.scout.rt.api.data.FieldName;
import org.eclipse.scout.rt.api.data.ObjectType;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class ApiExposeHelper {
    public static final String OBJECT_TYPE_ATTRIBUTE_NAME = "objectType";

    public boolean hasApiExposedAnnotation(Object instance) {
        if (instance == null) {
            return false;
        }
        return this.hasApiExposedAnnotation(instance.getClass());
    }

    public boolean hasApiExposedAnnotation(IBean<?> bean) {
        return this.getAnnotation(bean, ApiExposed.class) != null;
    }

    public boolean hasApiExposedAnnotation(Class<?> clazz) {
        return this.getAnnotation(clazz, ApiExposed.class) != null;
    }

    public String objectTypeOf(Object instance) {
        if (instance == null) {
            return null;
        }
        return this.objectTypeOf(instance.getClass());
    }

    public String objectTypeOf(Class<?> clazz) {
        ObjectType annotation = this.getAnnotation(clazz, ObjectType.class);
        if (annotation == null) {
            return null;
        }
        String objectType = annotation.value();
        if (StringUtility.hasText((CharSequence)objectType)) {
            return objectType;
        }
        return null;
    }

    public void setObjectTypeToDo(Object instance, IDoEntity doEntity) {
        if (instance == null) {
            return;
        }
        this.setObjectTypeToDo(instance.getClass(), doEntity);
    }

    public void setObjectTypeToDo(Class<?> fromClass, IDoEntity doEntity) {
        if (doEntity == null || fromClass == null) {
            return;
        }
        if (StringUtility.hasText((CharSequence)((CharSequence)doEntity.get(OBJECT_TYPE_ATTRIBUTE_NAME, String.class)))) {
            return;
        }
        String declaredObjectType = this.objectTypeOf(fromClass);
        if (StringUtility.hasText((CharSequence)declaredObjectType)) {
            doEntity.put(OBJECT_TYPE_ATTRIBUTE_NAME, (Object)declaredObjectType);
        }
    }

    public String fieldNameOf(Object instance) {
        if (instance == null) {
            return null;
        }
        return this.fieldNameOf(instance.getClass());
    }

    public String fieldNameOf(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        FieldName fieldName = this.getAnnotation(clazz, FieldName.class);
        if (fieldName == null) {
            return null;
        }
        String name = fieldName.value();
        if (StringUtility.hasText((CharSequence)name)) {
            return name;
        }
        return null;
    }

    protected <A extends Annotation> A getAnnotation(IBean<?> bean, Class<? extends A> annotation) {
        if (bean == null) {
            return null;
        }
        return (A)bean.getBeanAnnotation(annotation);
    }

    protected <A extends Annotation> A getAnnotation(Class<?> clazz, Class<? extends A> annotation) {
        if (clazz == null || annotation == null) {
            return null;
        }
        IBean bean = BEANS.getBeanManager().optBean(clazz);
        A result = this.getAnnotation(bean, annotation);
        if (result != null) {
            return result;
        }
        return clazz.getAnnotation(annotation);
    }
}

