/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTokener {
    private final String m_in;
    private final boolean m_lenient;
    private int m_pos;

    public JSONTokener(String in) {
        if (in != null && in.startsWith("\ufeff")) {
            in = in.substring(1);
        }
        this.m_in = in;
        this.m_lenient = false;
    }

    public JSONTokener(String in, boolean lenient) {
        if (in != null && in.startsWith("\ufeff")) {
            in = in.substring(1);
        }
        this.m_in = in;
        this.m_lenient = lenient;
    }

    public Object nextValue() {
        int c = this.nextCleanInternal();
        switch (c) {
            case -1: {
                throw this.syntaxError("End of input");
            }
            case 123: {
                return this.readObject();
            }
            case 91: {
                return this.readArray();
            }
            case 34: 
            case 39: {
                return this.nextString((char)c);
            }
        }
        --this.m_pos;
        return this.readLiteral();
    }

    private int nextCleanInternal() {
        while (this.m_pos < this.m_in.length()) {
            char c = this.m_in.charAt(this.m_pos++);
            block0 : switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    if (this.m_pos == this.m_in.length()) {
                        return c;
                    }
                    char peek = this.m_in.charAt(this.m_pos);
                    switch (peek) {
                        case '*': {
                            ++this.m_pos;
                            int commentEnd = this.m_in.indexOf("*/", this.m_pos);
                            if (commentEnd == -1) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            this.m_pos = commentEnd + 2;
                            break block0;
                        }
                        case '/': {
                            ++this.m_pos;
                            this.skipToEndOfLine();
                            break block0;
                        }
                    }
                    return c;
                }
                case '#': {
                    this.skipToEndOfLine();
                    break;
                }
                default: {
                    return c;
                }
            }
        }
        return -1;
    }

    private void skipToEndOfLine() {
        while (this.m_pos < this.m_in.length()) {
            char c = this.m_in.charAt(this.m_pos);
            if (c == '\r' || c == '\n') {
                ++this.m_pos;
                break;
            }
            ++this.m_pos;
        }
    }

    public String nextString(char quote) {
        StringBuilder builder = null;
        int start = this.m_pos;
        while (this.m_pos < this.m_in.length()) {
            char c;
            if ((c = this.m_in.charAt(this.m_pos++)) == quote) {
                if (builder == null) {
                    return new String(this.m_in.substring(start, this.m_pos - 1));
                }
                builder.append(this.m_in, start, this.m_pos - 1);
                return builder.toString();
            }
            if (c != '\\') continue;
            if (this.m_pos == this.m_in.length()) {
                throw this.syntaxError("Unterminated escape sequence");
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.m_in, start, this.m_pos - 1);
            builder.append(this.readEscapeCharacter());
            start = this.m_pos;
        }
        throw this.syntaxError("Unterminated string");
    }

    private char readEscapeCharacter() {
        char escaped = this.m_in.charAt(this.m_pos++);
        switch (escaped) {
            case 'u': {
                if (this.m_pos + 4 > this.m_in.length()) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String hex = this.m_in.substring(this.m_pos, this.m_pos + 4);
                this.m_pos += 4;
                try {
                    return (char)Integer.parseInt(hex, 16);
                }
                catch (NumberFormatException nfe) {
                    throw this.syntaxError("Invalid escape sequence: " + hex);
                }
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    private Object readLiteral() {
        String literal = this.nextToInternal("{}[]/\\:,=;# \t\f");
        if (literal.isEmpty()) {
            if (this.m_lenient) {
                return JSONObject.NULL;
            }
            throw this.syntaxError("Expected literal value");
        }
        if ("null".equalsIgnoreCase(literal)) {
            return JSONObject.NULL;
        }
        if ("true".equalsIgnoreCase(literal)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(literal)) {
            return Boolean.FALSE;
        }
        if (literal.indexOf(46) == -1) {
            int base = 10;
            String number = literal;
            if (number.startsWith("0x") || number.startsWith("0X")) {
                number = number.substring(2);
                base = 16;
            } else if (number.startsWith("0") && number.length() > 1) {
                number = number.substring(1);
                base = 8;
            }
            try {
                long longValue = Long.parseLong(number, base);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.valueOf(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return new String(literal);
        }
    }

    private String nextToInternal(String excluded) {
        int start = this.m_pos;
        while (this.m_pos < this.m_in.length()) {
            char c = this.m_in.charAt(this.m_pos);
            if (c == '\r' || c == '\n' || excluded.indexOf(c) != -1) {
                return this.m_in.substring(start, this.m_pos);
            }
            ++this.m_pos;
        }
        return this.m_in.substring(start);
    }

    private JSONObject readObject() {
        JSONObject result = new JSONObject();
        int first = this.nextCleanInternal();
        if (first == 125) {
            return result;
        }
        if (first != -1) {
            --this.m_pos;
        }
        block4: while (true) {
            Object name;
            if (!((name = this.nextValue()) instanceof String)) {
                if (name == null) {
                    throw this.syntaxError("Names cannot be null");
                }
                throw this.syntaxError("Names must be strings, but " + String.valueOf(name) + " is of type " + name.getClass().getName());
            }
            int separator = this.nextCleanInternal();
            if (separator != 58 && separator != 61) {
                throw this.syntaxError("Expected ':' after " + String.valueOf(name));
            }
            if (this.m_pos < this.m_in.length() && this.m_in.charAt(this.m_pos) == '>') {
                ++this.m_pos;
            }
            result.put((String)name, this.nextValue());
            switch (this.nextCleanInternal()) {
                case 125: {
                    return result;
                }
                case 44: 
                case 59: {
                    continue block4;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated object");
    }

    private JSONArray readArray() {
        JSONArray result = new JSONArray();
        boolean hasTrailingSeparator = false;
        block9: while (true) {
            switch (this.nextCleanInternal()) {
                case -1: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    if (hasTrailingSeparator) {
                        result.put(null);
                    }
                    return result;
                }
                case 44: 
                case 59: {
                    result.put(null);
                    hasTrailingSeparator = true;
                    continue block9;
                }
            }
            --this.m_pos;
            result.put(this.nextValue());
            switch (this.nextCleanInternal()) {
                case 93: {
                    return result;
                }
                case 44: 
                case 59: {
                    hasTrailingSeparator = true;
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated array");
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + String.valueOf(this));
    }

    public String toString() {
        return " at character " + this.m_pos + " of " + this.m_in;
    }

    public boolean more() {
        return this.m_pos < this.m_in.length();
    }

    public char next() {
        return this.m_pos < this.m_in.length() ? this.m_in.charAt(this.m_pos++) : (char)'\u0000';
    }

    public char next(char c) {
        char result = this.next();
        if (result != c) {
            throw this.syntaxError("Expected " + c + " but was " + result);
        }
        return result;
    }

    public char nextClean() {
        int nextCleanInt = this.nextCleanInternal();
        return nextCleanInt == -1 ? (char)'\u0000' : (char)nextCleanInt;
    }

    public String next(int length) {
        if (this.m_pos + length > this.m_in.length()) {
            throw this.syntaxError(length + " is out of bounds");
        }
        String result = this.m_in.substring(this.m_pos, this.m_pos + length);
        this.m_pos += length;
        return result;
    }

    public String nextTo(String excluded) {
        if (excluded == null) {
            throw new NullPointerException("excluded == null");
        }
        return this.nextToInternal(excluded).trim();
    }

    public String nextTo(char excluded) {
        return this.nextToInternal(String.valueOf(excluded)).trim();
    }

    public void skipPast(String thru) {
        int thruStart = this.m_in.indexOf(thru, this.m_pos);
        this.m_pos = thruStart == -1 ? this.m_in.length() : thruStart + thru.length();
    }

    public char skipTo(char to) {
        int index = this.m_in.indexOf(to, this.m_pos);
        if (index != -1) {
            this.m_pos = index;
            return to;
        }
        return '\u0000';
    }

    public void back() {
        if (--this.m_pos == -1) {
            this.m_pos = 0;
        }
    }

    public static int dehexchar(char hex) {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        if (hex >= 'a' && hex <= 'f') {
            return hex - 97 + 10;
        }
        return -1;
    }
}

