/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStringer {
    final StringBuilder out = new StringBuilder();
    private final List<Scope> m_stack = new ArrayList<Scope>();
    private final String m_indent;

    public JSONStringer() {
        this.m_indent = null;
    }

    JSONStringer(int indentSpaces) {
        char[] indentChars = new char[indentSpaces];
        Arrays.fill(indentChars, ' ');
        this.m_indent = new String(indentChars);
    }

    public JSONStringer array() {
        return this.open(Scope.EMPTY_ARRAY, "[");
    }

    public JSONStringer endArray() {
        return this.close(Scope.EMPTY_ARRAY, Scope.NONEMPTY_ARRAY, "]");
    }

    public JSONStringer object() {
        return this.open(Scope.EMPTY_OBJECT, "{");
    }

    public JSONStringer endObject() {
        return this.close(Scope.EMPTY_OBJECT, Scope.NONEMPTY_OBJECT, "}");
    }

    JSONStringer open(Scope empty, String openBracket) {
        if (this.m_stack.isEmpty() && this.out.length() > 0) {
            throw new JSONException("Nesting problem: multiple top-level roots");
        }
        this.beforeValue();
        this.m_stack.add(empty);
        this.out.append(openBracket);
        return this;
    }

    JSONStringer close(Scope empty, Scope nonempty, String closeBracket) {
        Scope context = this.peek();
        if (context != nonempty && context != empty) {
            throw new JSONException("Nesting problem");
        }
        this.m_stack.remove(this.m_stack.size() - 1);
        if (context == nonempty) {
            this.newline();
        }
        this.out.append(closeBracket);
        return this;
    }

    private Scope peek() {
        if (this.m_stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        return this.m_stack.get(this.m_stack.size() - 1);
    }

    private void replaceTop(Scope topOfStack) {
        this.m_stack.set(this.m_stack.size() - 1, topOfStack);
    }

    public JSONStringer value(Object value) {
        if (this.m_stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        if (value instanceof JSONArray) {
            ((JSONArray)value).writeTo(this);
            return this;
        }
        if (value instanceof JSONObject) {
            ((JSONObject)value).writeTo(this);
            return this;
        }
        this.beforeValue();
        if (value == null || value instanceof Boolean || value == JSONObject.NULL) {
            this.out.append(value);
        } else if (value instanceof Number) {
            this.out.append(JSONObject.numberToString((Number)value));
        } else {
            this.string(value.toString());
        }
        return this;
    }

    public JSONStringer value(boolean value) {
        if (this.m_stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    public JSONStringer value(double value) {
        if (this.m_stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        this.beforeValue();
        this.out.append(JSONObject.numberToString(value));
        return this;
    }

    public JSONStringer value(long value) {
        if (this.m_stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    private void string(String value) {
        this.out.append("\"");
        int i = 0;
        int length = value.length();
        while (i < length) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    this.out.append('\\').append(c);
                    break;
                }
                case '\t': {
                    this.out.append("\\t");
                    break;
                }
                case '\b': {
                    this.out.append("\\b");
                    break;
                }
                case '\n': {
                    this.out.append("\\n");
                    break;
                }
                case '\r': {
                    this.out.append("\\r");
                    break;
                }
                case '\f': {
                    this.out.append("\\f");
                    break;
                }
                default: {
                    if (c <= '\u001f') {
                        this.out.append(String.format("\\u%04x", c));
                        break;
                    }
                    this.out.append(c);
                }
            }
            ++i;
        }
        this.out.append("\"");
    }

    private void newline() {
        if (this.m_indent == null) {
            return;
        }
        this.out.append("\n");
        int i = 0;
        while (i < this.m_stack.size()) {
            this.out.append(this.m_indent);
            ++i;
        }
    }

    public JSONStringer key(String name) {
        if (name == null) {
            throw new JSONException("Names must be non-null");
        }
        this.beforeKey();
        this.string(name);
        return this;
    }

    private void beforeKey() {
        Scope context = this.peek();
        if (context == Scope.NONEMPTY_OBJECT) {
            this.out.append(',');
        } else if (context != Scope.EMPTY_OBJECT) {
            throw new JSONException("Nesting problem");
        }
        this.newline();
        this.replaceTop(Scope.DANGLING_KEY);
    }

    private void beforeValue() {
        if (this.m_stack.isEmpty()) {
            return;
        }
        Scope context = this.peek();
        if (context == Scope.EMPTY_ARRAY) {
            this.replaceTop(Scope.NONEMPTY_ARRAY);
            this.newline();
        } else if (context == Scope.NONEMPTY_ARRAY) {
            this.out.append(',');
            this.newline();
        } else if (context == Scope.DANGLING_KEY) {
            this.out.append(this.m_indent == null ? ":" : ": ");
            this.replaceTop(Scope.NONEMPTY_OBJECT);
        } else if (context != Scope.NULL) {
            throw new JSONException("Nesting problem");
        }
    }

    public String toString() {
        return this.out.length() == 0 ? null : this.out.toString();
    }

    static enum Scope {
        EMPTY_ARRAY,
        NONEMPTY_ARRAY,
        EMPTY_OBJECT,
        DANGLING_KEY,
        NONEMPTY_OBJECT,
        NULL;

    }
}

