/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.join.JoinExecutorBase;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class SynchronousJoin
extends JoinExecutorBase<BindingSet> {
    public SynchronousJoin(FederationEvalStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(strategy, leftIter, rightArg, bindings, queryInfo);
    }

    @Override
    protected void handleBindings() throws Exception {
        int totalBindings = 0;
        while (!this.closed && this.leftIter.hasNext()) {
            this.rightQueue.put(this.strategy.evaluate(this.rightArg, (BindingSet)this.leftIter.next()));
            ++totalBindings;
        }
        if (log.isDebugEnabled()) {
            log.debug("JoinStats: left iter of " + this.getDisplayId() + " had " + totalBindings + " results.");
        }
    }
}

