/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.algebra.ConjunctiveFilterExpr;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExprRenderer;
import org.eclipse.rdf4j.federated.algebra.FedXLeftJoin;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.algebra.SingleSourceQuery;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.cache.CacheUtils;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCache;
import org.eclipse.rdf4j.federated.cache.SourceSelectionMemoryCache;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStatistics;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelServiceExecutor;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.evaluation.join.ControlledWorkerLeftJoin;
import org.eclipse.rdf4j.federated.evaluation.union.ControlledWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelGetStatementsTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedAlgebraUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelUnionOperatorTask;
import org.eclipse.rdf4j.federated.evaluation.union.SynchronousWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.WorkerUnionBase;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.optimizer.DefaultFedXCostModel;
import org.eclipse.rdf4j.federated.optimizer.ExclusiveTupleExprOptimizer;
import org.eclipse.rdf4j.federated.optimizer.FilterOptimizer;
import org.eclipse.rdf4j.federated.optimizer.GenericInfoOptimizer;
import org.eclipse.rdf4j.federated.optimizer.LimitOptimizer;
import org.eclipse.rdf4j.federated.optimizer.ServiceOptimizer;
import org.eclipse.rdf4j.federated.optimizer.SourceSelection;
import org.eclipse.rdf4j.federated.optimizer.StatementGroupAndJoinOptimizer;
import org.eclipse.rdf4j.federated.optimizer.UnionOptimizer;
import org.eclipse.rdf4j.federated.structures.FedXDataset;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.eclipse.rdf4j.repository.sparql.federation.RepositoryFederatedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationEvalStrategy
extends StrictEvaluationStrategy {
    private static final Logger log = LoggerFactory.getLogger(FederationEvalStrategy.class);
    protected Executor executor;
    protected SourceSelectionCache cache;
    protected FederationContext federationContext;

    public FederationEvalStrategy(FederationContext federationContext) {
        super(new org.eclipse.rdf4j.query.algebra.evaluation.TripleSource(){

            public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
                throw new FedXRuntimeException("Federation Strategy does not support org.openrdf.query.algebra.evaluation.TripleSource#getStatements. If you encounter this exception, please report it.");
            }

            public ValueFactory getValueFactory() {
                return SimpleValueFactory.getInstance();
            }
        }, (FederatedServiceResolver)federationContext.getFederatedServiceResolver());
        this.federationContext = federationContext;
        this.executor = federationContext.getManager().getExecutor();
        this.cache = this.createSourceSelectionCache();
    }

    protected SourceSelectionCache createSourceSelectionCache() {
        String cacheSpec = this.federationContext.getConfig().getSourceSelectionCacheSpec();
        return new SourceSelectionMemoryCache(cacheSpec);
    }

    public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
        List<Endpoint> members;
        if (!(evaluationStatistics instanceof FederationEvaluationStatistics)) {
            throw new FedXRuntimeException("Expected FederationEvaluationStatistics, was " + evaluationStatistics.getClass());
        }
        FederationEvaluationStatistics stats = (FederationEvaluationStatistics)evaluationStatistics;
        QueryInfo queryInfo = stats.getQueryInfo();
        Dataset dataset = stats.getDataset();
        FederationContext federationContext = queryInfo.getFederationContext();
        if (dataset instanceof FedXDataset) {
            FedXDataset ds = (FedXDataset)dataset;
            members = federationContext.getEndpointManager().getEndpoints(ds.getEndpoints());
        } else {
            FedX fed = federationContext.getFederation();
            members = fed.getMembers();
        }
        QueryRoot query = new QueryRoot(expr.clone());
        GenericInfoOptimizer info = new GenericInfoOptimizer(queryInfo);
        info.optimize((TupleExpr)query);
        if (members.size() == 1 && queryInfo.getQuery() != null && !info.hasService() && queryInfo.getQueryType() != QueryType.UPDATE) {
            return new SingleSourceQuery(expr, members.get(0), queryInfo);
        }
        if (log.isTraceEnabled()) {
            log.trace("Query before Optimization: " + query);
        }
        new ConstantOptimizer((EvaluationStrategy)this).optimize((TupleExpr)query, dataset, bindings);
        new DisjunctiveConstraintOptimizer().optimize((TupleExpr)query, dataset, bindings);
        Set<Endpoint> relevantSources = this.performSourceSelection(members, this.cache, queryInfo, info);
        if (relevantSources.size() == 1 && !info.hasService() && queryInfo.getQueryType() != QueryType.UPDATE) {
            return new SingleSourceQuery((TupleExpr)query, relevantSources.iterator().next(), queryInfo);
        }
        if (info.hasService()) {
            new ServiceOptimizer(queryInfo).optimize((TupleExpr)query);
        }
        if (info.hasUnion()) {
            new UnionOptimizer(queryInfo).optimize((TupleExpr)query);
        }
        this.optimizeExclusiveExpressions((TupleExpr)query, queryInfo, info);
        this.optimizeJoinOrder((TupleExpr)query, queryInfo, info);
        if (info.hasLimit()) {
            new LimitOptimizer().optimize((TupleExpr)query);
        }
        if (info.hasFilter()) {
            new FilterOptimizer().optimize((TupleExpr)query);
        }
        if (log.isTraceEnabled()) {
            log.trace("Query after Optimization: " + query);
        }
        return query;
    }

    protected Set<Endpoint> performSourceSelection(List<Endpoint> members, SourceSelectionCache cache, QueryInfo queryInfo, GenericInfoOptimizer info) {
        SourceSelection sourceSelection = new SourceSelection(members, cache, queryInfo);
        sourceSelection.doSourceSelection(info.getStatements());
        return sourceSelection.getRelevantSources();
    }

    protected void optimizeJoinOrder(TupleExpr query, QueryInfo queryInfo, GenericInfoOptimizer info) {
        new StatementGroupAndJoinOptimizer(queryInfo, DefaultFedXCostModel.INSTANCE).optimize(query);
    }

    protected void optimizeExclusiveExpressions(TupleExpr query, QueryInfo queryInfo, GenericInfoOptimizer info) {
        new ExclusiveTupleExprOptimizer().optimize(query);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof StatementTupleExpr) {
            return ((StatementTupleExpr)expr).evaluate(bindings);
        }
        if (expr instanceof NJoin) {
            return this.evaluateNJoin((NJoin)expr, bindings);
        }
        if (expr instanceof NUnion) {
            return this.evaluateNaryUnion((NUnion)expr, bindings);
        }
        if (expr instanceof ExclusiveGroup) {
            return ((ExclusiveGroup)expr).evaluate(bindings);
        }
        if (expr instanceof ExclusiveTupleExpr) {
            return this.evaluateExclusiveTupleExpr((ExclusiveTupleExpr)expr, bindings);
        }
        if (expr instanceof FedXLeftJoin) {
            return this.evaluateLeftJoin((FedXLeftJoin)expr, bindings);
        }
        if (expr instanceof SingleSourceQuery) {
            return this.evaluateSingleSourceQuery((SingleSourceQuery)expr, bindings);
        }
        if (expr instanceof FedXService) {
            return this.evaluateService((FedXService)expr, bindings);
        }
        if (expr instanceof EmptyResult) {
            return new EmptyIteration();
        }
        return super.evaluate(expr, bindings);
    }

    public CloseableIteration<Statement, QueryEvaluationException> getStatements(QueryInfo queryInfo, Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        if (contexts.length != 0) {
            log.warn("Context queries are not yet supported by FedX.");
        }
        List<Endpoint> members = this.federationContext.getFederation().getMembers();
        if (subj != null && pred != null && obj != null) {
            if (CacheUtils.checkCacheUpdateCache(this.cache, members, subj, pred, obj, queryInfo)) {
                return new SingletonIteration((Object)FedXUtil.valueFactory().createStatement(subj, pred, obj));
            }
            return new EmptyIteration();
        }
        List<StatementSource> sources = CacheUtils.checkCacheForStatementSourcesUpdateCache(this.cache, members, subj, pred, obj, queryInfo);
        if (sources.isEmpty()) {
            return new EmptyIteration();
        }
        if (sources.size() == 1) {
            Endpoint e = this.federationContext.getEndpointManager().getEndpoint(sources.get(0).getEndpointID());
            return e.getTripleSource().getStatements(subj, pred, obj, queryInfo, contexts);
        }
        SynchronousWorkerUnion<Statement> union = new SynchronousWorkerUnion<Statement>(this, queryInfo);
        for (StatementSource source : sources) {
            Endpoint e = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
            ParallelGetStatementsTask task = new ParallelGetStatementsTask(union, e, subj, pred, obj, queryInfo, contexts);
            union.addTask(task);
        }
        this.executor.execute(union);
        return union;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateService(FedXService service, BindingSet bindings) throws QueryEvaluationException {
        ParallelServiceExecutor pe = new ParallelServiceExecutor(service, this, bindings, this.federationContext);
        pe.run();
        return pe;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateSingleSourceQuery(SingleSourceQuery query, BindingSet bindings) throws QueryEvaluationException {
        try {
            Endpoint source = query.getSource();
            return source.getTripleSource().getStatements(query.getQueryString(), bindings, query.getQueryInfo().getQueryType(), query.getQueryInfo());
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateNJoin(NJoin join, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> result = this.evaluate(join.getArg(0), bindings);
        ControlledWorkerScheduler<BindingSet> joinScheduler = this.federationContext.getManager().getJoinScheduler();
        int n = join.getNumberOfArguments();
        for (int i = 1; i < n; ++i) {
            result = this.executeJoin(joinScheduler, result, join.getArg(i), join.getJoinVariables(i), bindings, join.getQueryInfo());
        }
        return result;
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateLeftJoin(FedXLeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        if (TupleExprs.containsSubquery((TupleExpr)leftJoin.getRightArg())) {
            return new HashJoinIteration((EvaluationStrategy)this, (LeftJoin)leftJoin, bindings);
        }
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
        }
        Set problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        problemVars.retainAll(bindings.getBindingNames());
        if (problemVars.isEmpty()) {
            CloseableIteration<BindingSet, QueryEvaluationException> leftIter = this.evaluate(leftJoin.getLeftArg(), bindings);
            ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getLeftJoinScheduler();
            ControlledWorkerLeftJoin join = new ControlledWorkerLeftJoin(scheduler, this, leftIter, leftJoin, bindings, leftJoin.getQueryInfo());
            this.executor.execute(join);
            return join;
        }
        return new BadlyDesignedLeftJoinIterator((EvaluationStrategy)this, (LeftJoin)leftJoin, bindings, problemVars);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateNaryUnion(NUnion union, BindingSet bindings) throws QueryEvaluationException {
        ControlledWorkerScheduler<BindingSet> unionScheduler = this.federationContext.getManager().getUnionScheduler();
        ControlledWorkerUnion<BindingSet> unionRunnable = new ControlledWorkerUnion<BindingSet>(this, unionScheduler, union.getQueryInfo());
        for (int i = 0; i < union.getNumberOfArguments(); ++i) {
            unionRunnable.addTask(new ParallelUnionOperatorTask(unionRunnable, this, union.getArg(i), bindings));
        }
        this.executor.execute(unionRunnable);
        return unionRunnable;
    }

    protected abstract CloseableIteration<BindingSet, QueryEvaluationException> executeJoin(ControlledWorkerScheduler<BindingSet> var1, CloseableIteration<BindingSet, QueryEvaluationException> var2, TupleExpr var3, Set<String> var4, BindingSet var5, QueryInfo var6) throws QueryEvaluationException;

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluateExclusiveGroup(ExclusiveGroup var1, BindingSet var2) throws RepositoryException, MalformedQueryException, QueryEvaluationException;

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateExclusiveTupleExpr(ExclusiveTupleExpr expr, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        if (expr instanceof StatementTupleExpr) {
            return ((StatementTupleExpr)((Object)expr)).evaluate(bindings);
        }
        if (!(expr instanceof ExclusiveTupleExprRenderer)) {
            return super.evaluate((TupleExpr)expr, bindings);
        }
        Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(expr.getOwner().getEndpointID());
        TripleSource t = ownedEndpoint.getTripleSource();
        AtomicBoolean isEvaluated = new AtomicBoolean(false);
        try {
            FilterValueExpr filterValueExpr = null;
            String preparedQuery = QueryStringUtil.selectQueryString((ExclusiveTupleExprRenderer)expr, bindings, filterValueExpr, isEvaluated);
            return t.getStatements(preparedQuery, bindings, isEvaluated.get() ? null : filterValueExpr, expr.getQueryInfo());
        }
        catch (IllegalQueryException e) {
            if (t.hasStatements(expr, bindings)) {
                return new SingleBindingSetIteration(bindings);
            }
            return new EmptyIteration();
        }
    }

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluateBoundJoinStatementPattern(StatementTupleExpr var1, List<BindingSet> var2) throws QueryEvaluationException;

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluateGroupedCheck(CheckStatementPattern var1, List<BindingSet> var2) throws QueryEvaluationException;

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateService(FedXService service, List<BindingSet> bindings) throws QueryEvaluationException {
        Var serviceRef = service.getService().getServiceRef();
        if (!serviceRef.hasValue()) {
            return new ServiceJoinIterator((CloseableIteration)new CollectionIteration(bindings), service.getService(), EmptyBindingSet.getInstance(), (EvaluationStrategy)this);
        }
        String serviceUri = serviceRef.getValue().stringValue();
        FederatedService fs = this.getService(serviceUri);
        if (fs instanceof RepositoryFederatedService) {
            ((RepositoryFederatedService)fs).setBoundJoinBlockSize(0);
        }
        return fs.evaluate(service.getService(), (CloseableIteration)new CollectionIteration(bindings), service.getService().getBaseURI());
    }

    public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof FilterExpr) {
            return this.evaluate((FilterExpr)expr, bindings);
        }
        if (expr instanceof ConjunctiveFilterExpr) {
            return this.evaluate((ConjunctiveFilterExpr)expr, bindings);
        }
        return super.evaluate(expr, bindings);
    }

    public Value evaluate(FilterExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value v = this.evaluate(node.getExpression(), bindings);
        return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue((Value)v));
    }

    public Value evaluate(ConjunctiveFilterExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        ValueExprEvaluationException error = null;
        for (FilterExpr expr : node.getExpressions()) {
            try {
                Value v = this.evaluate(expr.getExpression(), bindings);
                if (QueryEvaluationUtil.getEffectiveBooleanValue((Value)v)) continue;
                return BooleanLiteral.FALSE;
            }
            catch (ValueExprEvaluationException e) {
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
        return BooleanLiteral.TRUE;
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateAtStatementSources(Object preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        if (preparedQuery instanceof String) {
            return this.evaluateAtStatementSources((String)preparedQuery, statementSources, queryInfo);
        }
        if (preparedQuery instanceof TupleExpr) {
            return this.evaluateAtStatementSources((TupleExpr)preparedQuery, statementSources, queryInfo);
        }
        throw new RuntimeException("Unsupported type for prepared query: " + preparedQuery.getClass().getCanonicalName());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateAtStatementSources(String preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        try {
            WorkerUnionBase<BindingSet> result;
            if (statementSources.size() == 1) {
                Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(statementSources.get(0).getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                result = t.getStatements(preparedQuery, EmptyBindingSet.getInstance(), (FilterValueExpr)null, queryInfo);
            } else {
                WorkerUnionBase<BindingSet> union = this.federationContext.getManager().createWorkerUnion(queryInfo);
                for (StatementSource source : statementSources) {
                    Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
                    union.addTask(new ParallelPreparedUnionTask(union, preparedQuery, ownedEndpoint, EmptyBindingSet.getInstance(), null, queryInfo));
                }
                union.run();
                result = union;
            }
            return result;
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateAtStatementSources(TupleExpr preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        try {
            WorkerUnionBase<BindingSet> result;
            if (statementSources.size() == 1) {
                Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(statementSources.get(0).getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                result = t.getStatements(preparedQuery, EmptyBindingSet.getInstance(), null, queryInfo);
            } else {
                WorkerUnionBase<BindingSet> union = this.federationContext.getManager().createWorkerUnion(queryInfo);
                for (StatementSource source : statementSources) {
                    Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
                    union.addTask(new ParallelPreparedAlgebraUnionTask(union, preparedQuery, ownedEndpoint, EmptyBindingSet.getInstance(), null, queryInfo));
                }
                union.run();
                result = union;
            }
            return result;
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }
}

