/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.structures;

import java.io.Serializable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;

public class SubQuery
implements Serializable {
    private static final long serialVersionUID = 8968907794785828994L;
    protected String subj = null;
    protected String pred = null;
    protected String obj = null;

    public SubQuery(String subj, String pred, String obj) {
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
    }

    public SubQuery(Resource subj, IRI pred, Value obj) {
        if (subj != null) {
            this.subj = subj.stringValue();
        }
        if (pred != null) {
            this.pred = pred.stringValue();
        }
        if (obj != null) {
            this.obj = obj.toString();
        }
    }

    public SubQuery(StatementPattern stmt) {
        if (stmt.getSubjectVar().hasValue()) {
            this.subj = stmt.getSubjectVar().getValue().stringValue();
        }
        if (stmt.getPredicateVar().hasValue()) {
            this.pred = stmt.getPredicateVar().getValue().stringValue();
        }
        if (stmt.getObjectVar().hasValue()) {
            this.obj = stmt.getObjectVar().getValue().stringValue();
        }
    }

    public int hashCode() {
        int prime1 = 961;
        int prime2 = 31;
        boolean prime3 = true;
        int result = 1;
        result += this.subj == null ? 0 : this.subj.hashCode() * 961;
        result += this.pred == null ? 0 : this.pred.hashCode() * 31;
        return result += this.obj == null ? 0 : this.obj.hashCode() * 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubQuery other = (SubQuery)obj;
        if (this.obj == null ? other.obj != null : !this.obj.equals(other.obj)) {
            return false;
        }
        if (this.pred == null ? other.pred != null : !this.pred.equals(other.pred)) {
            return false;
        }
        return !(this.subj == null ? other.subj != null : !this.subj.equals(other.subj));
    }
}

