/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import java.io.File;
import org.eclipse.rdf4j.federated.EndpointManager;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.FederationManager;
import org.eclipse.rdf4j.federated.QueryManager;
import org.eclipse.rdf4j.federated.cache.MemoryCache;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.DelegateFederatedServiceResolver;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.monitoring.Monitoring;
import org.eclipse.rdf4j.federated.monitoring.MonitoringFactory;
import org.eclipse.rdf4j.federated.monitoring.MonitoringUtil;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConnection;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXRepository
extends SailRepository {
    private static final Logger log = LoggerFactory.getLogger(FedXRepository.class);
    private final FedX federation;
    private final FedXConfig fedXConfig;
    private FederationContext federationContext;
    private FederatedServiceResolver serviceResolver = null;

    public FedXRepository(FedX federation, FedXConfig config) {
        super((Sail)federation);
        this.federation = federation;
        this.fedXConfig = config;
    }

    public FedXRepositoryConnection getConnection() throws RepositoryException {
        try {
            return new FedXRepositoryConnection(this, this.getSail().getConnection());
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void initializeInternal() throws RepositoryException {
        log.info("Initializing federation ...");
        Monitoring monitoring = MonitoringFactory.createMonitoring(this.fedXConfig);
        EndpointManager endpointManager = EndpointManager.initialize(this.federation.getMembers());
        String location = this.fedXConfig.getCacheLocation();
        File cacheLocation = new File(location);
        if (!cacheLocation.isAbsolute()) {
            cacheLocation = new File(this.getDataDir(), location);
        }
        MemoryCache cache = new MemoryCache(cacheLocation);
        cache.initialize();
        FederationManager federationManager = new FederationManager();
        QueryManager queryManager = new QueryManager();
        DelegateFederatedServiceResolver fedxServiceResolver = new DelegateFederatedServiceResolver(endpointManager);
        if (this.serviceResolver != null) {
            fedxServiceResolver.setDelegate(this.serviceResolver);
        }
        this.federationContext = new FederationContext(federationManager, endpointManager, queryManager, cache, fedxServiceResolver, monitoring, this.fedXConfig);
        this.federation.setFederationContext(this.federationContext);
        super.initializeInternal();
        federationManager.init(this.federation, this.federationContext);
        queryManager.init(this, this.federationContext);
        fedxServiceResolver.initialize();
        if (this.fedXConfig.isEnableJMX()) {
            try {
                MonitoringUtil.initializeJMXMonitoring(this.federationContext);
            }
            catch (Exception e1) {
                log.error("JMX monitoring could not be initialized: " + e1.getMessage());
            }
        }
    }

    protected void shutDownInternal() throws RepositoryException {
        try {
            this.federationContext.getManager().shutDown();
        }
        catch (FedXException e) {
            throw new SailException((Throwable)((Object)e));
        }
        super.shutDownInternal();
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        super.setFederatedServiceResolver(resolver);
    }

    public String getFederationSize() {
        long size = 0L;
        boolean isLowerBound = false;
        for (Endpoint e : this.federation.getMembers()) {
            try {
                size += e.size();
            }
            catch (RepositoryException e1) {
                isLowerBound = true;
            }
        }
        return isLowerBound ? ">" + size : Long.toString(size);
    }

    public FederationContext getFederationContext() {
        return this.federationContext;
    }

    public QueryManager getQueryManager() {
        return this.federationContext.getQueryManager();
    }
}

