/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.EmptyNJoin;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveStatement;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.algebra.TrueStatementPattern;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.federated.optimizer.JoinOrderOptimizer;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementGroupOptimizer
extends AbstractQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    private static final Logger log = LoggerFactory.getLogger(StatementGroupOptimizer.class);
    protected final QueryInfo queryInfo;

    public StatementGroupOptimizer(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    @Override
    public void optimize(TupleExpr tupleExpr) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Service tupleExpr) {
    }

    public void meetOther(QueryModelNode node) {
        if (node instanceof NJoin) {
            super.meetOther(node);
            this.meetNJoin((NJoin)node);
        } else {
            super.meetOther(node);
        }
    }

    protected void meetNJoin(NJoin node) {
        LinkedList<TupleExpr> newArgs = new LinkedList<TupleExpr>();
        LinkedList<TupleExpr> argsCopy = new LinkedList<TupleExpr>(node.getArgs());
        while (!argsCopy.isEmpty()) {
            ArrayList<ExclusiveStatement> l;
            StatementTupleExpr current;
            TupleExpr t = argsCopy.removeFirst();
            if (t instanceof EmptyResult) {
                node.replaceWith((QueryModelNode)new EmptyNJoin(node, this.queryInfo));
                return;
            }
            if (t instanceof ExclusiveStatement) {
                current = (ExclusiveStatement)t;
                l = null;
                ArrayList<StatementTupleExpr> toRemoveFromArgs = null;
                for (TupleExpr te : argsCopy) {
                    StatementTupleExpr check;
                    if (te instanceof ExclusiveStatement) {
                        check = (ExclusiveStatement)te;
                        if (!((ExclusiveStatement)check).getOwner().equals((Object)((ExclusiveStatement)current).getOwner())) continue;
                        if (l == null) {
                            l = new ArrayList<ExclusiveStatement>();
                            l.add((ExclusiveStatement)current);
                        }
                        l.add((ExclusiveStatement)check);
                        continue;
                    }
                    if (!(te instanceof ExclusiveGroup) || !((ExclusiveGroup)(check = (ExclusiveGroup)te)).getOwner().equals((Object)((ExclusiveStatement)current).getOwner())) continue;
                    if (l == null) {
                        l = new ArrayList();
                        l.add((ExclusiveStatement)current);
                    }
                    if (toRemoveFromArgs == null) {
                        toRemoveFromArgs = new ArrayList<StatementTupleExpr>();
                    }
                    toRemoveFromArgs.add(check);
                    l.addAll(((ExclusiveGroup)check).getStatements());
                }
                if (l != null) {
                    argsCopy.removeAll(l);
                    if (toRemoveFromArgs != null) {
                        argsCopy.removeAll(toRemoveFromArgs);
                    }
                    newArgs.add(new ExclusiveGroup(l, ((ExclusiveStatement)current).getOwner(), this.queryInfo));
                    continue;
                }
                newArgs.add(current);
                continue;
            }
            if (t instanceof ExclusiveGroup) {
                current = (ExclusiveGroup)t;
                l = null;
                for (TupleExpr te : argsCopy) {
                    ExclusiveStatement check;
                    if (!(te instanceof ExclusiveStatement) || !(check = (ExclusiveStatement)te).getOwner().equals((Object)((ExclusiveGroup)current).getOwner())) continue;
                    if (l == null) {
                        l = new ArrayList();
                        l.addAll(((ExclusiveGroup)current).getStatements());
                    }
                    l.add(check);
                }
                if (l != null) {
                    argsCopy.removeAll(l);
                    argsCopy.remove(current);
                    newArgs.add(new ExclusiveGroup(l, ((ExclusiveGroup)current).getOwner(), this.queryInfo));
                    continue;
                }
                newArgs.add(current);
                continue;
            }
            if (t instanceof TrueStatementPattern) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Statement " + QueryStringUtil.toString((StatementPattern)t) + " yields results for at least one provided source, prune it.");
                continue;
            }
            newArgs.add(t);
        }
        if (newArgs.size() == 1) {
            log.debug("Join arguments could be reduced to a single argument, replacing join node.");
            node.replaceWith((QueryModelNode)newArgs.get(0));
            return;
        }
        if (newArgs.isEmpty()) {
            log.debug("Join could be pruned as all join statements evaluate to true, replacing join with true node.");
            node.replaceWith((QueryModelNode)new TrueStatementPattern(new StatementPattern()));
            return;
        }
        List<TupleExpr> optimized = newArgs;
        optimized = JoinOrderOptimizer.optimizeJoinOrder(optimized);
        NJoin newNode = new NJoin(optimized, this.queryInfo);
        node.replaceWith((QueryModelNode)newNode);
    }
}

