/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveStatement;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.NTuple;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.algebra.StatementSourcePattern;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinOrderOptimizer {
    private static final Logger log = LoggerFactory.getLogger(JoinOrderOptimizer.class);

    public static List<TupleExpr> optimizeJoinOrder(List<TupleExpr> joinArgs) {
        ArrayList<TupleExpr> optimized = new ArrayList<TupleExpr>(joinArgs.size());
        LinkedList<TupleExpr> left = new LinkedList<TupleExpr>(joinArgs);
        HashSet<String> joinVars = new HashSet<String>();
        while (!left.isEmpty()) {
            TupleExpr item = (TupleExpr)left.get(0);
            double minCost = Double.MAX_VALUE;
            for (TupleExpr tmp : left) {
                double currentCost = JoinOrderOptimizer.estimateCost(tmp, joinVars);
                if (!(currentCost < minCost)) continue;
                item = tmp;
                minCost = currentCost;
            }
            joinVars.addAll(JoinOrderOptimizer.getFreeVars(item));
            if (log.isTraceEnabled()) {
                log.trace("Cost of " + item.getClass().getSimpleName() + " is determined as " + minCost);
            }
            optimized.add(item);
            left.remove(item);
        }
        return optimized;
    }

    public static List<ExclusiveStatement> optimizeGroupOrder(List<ExclusiveStatement> groupStmts) {
        if (groupStmts.size() == 1) {
            return groupStmts;
        }
        ArrayList<ExclusiveStatement> optimized = new ArrayList<ExclusiveStatement>(groupStmts.size());
        LinkedList<ExclusiveStatement> left = new LinkedList<ExclusiveStatement>(groupStmts);
        HashSet<String> joinVars = new HashSet<String>();
        while (!left.isEmpty()) {
            ExclusiveStatement item = (ExclusiveStatement)left.get(0);
            double minCost = Double.MAX_VALUE;
            for (ExclusiveStatement tmp : left) {
                double currentCost = JoinOrderOptimizer.estimateCost(tmp, joinVars);
                if (!(currentCost < minCost)) continue;
                item = tmp;
                minCost = currentCost;
            }
            joinVars.addAll(JoinOrderOptimizer.getFreeVars(item));
            optimized.add(item);
            left.remove(item);
        }
        return optimized;
    }

    public static Collection<String> getFreeVars(TupleExpr tupleExpr) {
        if (tupleExpr instanceof StatementTupleExpr) {
            return ((StatementTupleExpr)tupleExpr).getFreeVars();
        }
        if (tupleExpr instanceof NTuple) {
            HashSet<String> freeVars = new HashSet<String>();
            NTuple ntuple = (NTuple)tupleExpr;
            for (TupleExpr t : ntuple.getArgs()) {
                freeVars.addAll(JoinOrderOptimizer.getFreeVars(t));
            }
            return freeVars;
        }
        if (tupleExpr instanceof FedXService) {
            return ((FedXService)tupleExpr).getFreeVars();
        }
        if (tupleExpr instanceof Service) {
            return ((Service)tupleExpr).getServiceVars();
        }
        if (tupleExpr instanceof StatementPattern) {
            ArrayList<String> freeVars = new ArrayList<String>();
            StatementPattern st = (StatementPattern)tupleExpr;
            if (st.getSubjectVar().getValue() == null) {
                freeVars.add(st.getSubjectVar().getName());
            }
            if (st.getPredicateVar().getValue() == null) {
                freeVars.add(st.getPredicateVar().getName());
            }
            if (st.getObjectVar().getValue() == null) {
                freeVars.add(st.getObjectVar().getName());
            }
            return freeVars;
        }
        if (tupleExpr instanceof Projection) {
            Projection p = (Projection)tupleExpr;
            return new ArrayList<String>(p.getBindingNames());
        }
        if (tupleExpr instanceof BindingSetAssignment) {
            return new ArrayList<String>();
        }
        throw new FedXRuntimeException("Type " + tupleExpr.getClass().getSimpleName() + " not supported for cost estimation. If you run into this, please report a bug.");
    }

    protected static double estimateCost(TupleExpr tupleExpr, Set<String> joinVars) {
        if (tupleExpr instanceof StatementSourcePattern) {
            return JoinOrderOptimizer.estimateCost((StatementSourcePattern)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof ExclusiveStatement) {
            return JoinOrderOptimizer.estimateCost((ExclusiveStatement)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof ExclusiveGroup) {
            return JoinOrderOptimizer.estimateCost((ExclusiveGroup)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof NJoin) {
            return JoinOrderOptimizer.estimateCost((NJoin)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof NUnion) {
            return JoinOrderOptimizer.estimateCost((NUnion)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof FedXService) {
            return JoinOrderOptimizer.estimateCost((FedXService)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof Projection) {
            return JoinOrderOptimizer.estimateCost((Projection)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof BindingSetAssignment) {
            return 0.0;
        }
        log.warn("No cost estimation for " + tupleExpr.getClass().getSimpleName() + " available.");
        return 1000.0;
    }

    protected static double estimateCost(ExclusiveGroup group, Set<String> joinVars) {
        if (joinVars.size() > 0) {
            int count = 0;
            for (String var : group.getFreeVars()) {
                if (joinVars.contains(var)) continue;
                ++count;
            }
            return 100 + count / group.getStatements().size();
        }
        boolean hasSelectiveStatement = false;
        for (ExclusiveStatement stmt : group.getStatements()) {
            if (stmt.getFreeVarCount() > 1) continue;
            hasSelectiveStatement = true;
        }
        double additionalCost = 0.0;
        additionalCost += JoinOrderOptimizer.computeAdditionPatternCost(group.getStatements());
        if (!hasSelectiveStatement) {
            additionalCost += 4.0;
        }
        return 0.0 + additionalCost + (double)(group.getFreeVarCount() / group.getStatements().size());
    }

    private static double computeAdditionPatternCost(List<ExclusiveStatement> stmts) {
        String s = null;
        for (ExclusiveStatement st : stmts) {
            String currentVar = QueryStringUtil.toString(st.getSubjectVar());
            if (!currentVar.equals(s) && s != null) {
                return 0.5;
            }
            s = currentVar;
        }
        return 0.0;
    }

    protected static double estimateCost(ExclusiveStatement owned, Set<String> joinVars) {
        int count = 100;
        if (owned.getFreeVarCount() <= 1 && joinVars.isEmpty()) {
            count = 3;
        }
        for (String var : owned.getFreeVars()) {
            if (joinVars.contains(var)) continue;
            ++count;
        }
        return count;
    }

    protected static double estimateCost(FedXService service, Set<String> joinVars) {
        int additionalCost = 0;
        if (!service.getService().getServiceRef().hasValue()) {
            additionalCost += 1000;
        }
        if (service.getNumberOfTriplePatterns() <= 1) {
            additionalCost = joinVars.isEmpty() && service.getFreeVarCount() <= 1 ? 3 : (additionalCost += 100);
        }
        return 0 + additionalCost + service.getFreeVarCount();
    }

    protected static double estimateCost(Projection projection, Set<String> joinVars) {
        return 0 + projection.getBindingNames().size();
    }

    protected static double estimateCost(StatementSourcePattern stmt, Set<String> joinVars) {
        int count = 100;
        for (String var : stmt.getFreeVars()) {
            if (joinVars.contains(var)) continue;
            ++count;
        }
        return count;
    }

    protected static double estimateCost(NUnion nunion, Set<String> joinVars) {
        double min = Double.MAX_VALUE;
        for (TupleExpr t : nunion.getArgs()) {
            double cost = JoinOrderOptimizer.estimateCost(t, joinVars);
            if (!(cost < min)) continue;
            min = cost;
        }
        return min + (double)nunion.getNumberOfArguments() - 1.0;
    }

    protected static double estimateCost(NJoin join, Set<String> joinVars) {
        double cost = JoinOrderOptimizer.estimateCost(join.getArg(0), joinVars);
        return cost + (double)join.getNumberOfArguments() - 1.0;
    }
}

